/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.network.messages;

import com.hybridlab.hyve3d.core.FrameRect;
import com.hybridlab.hyve3d.network.messages.AbstractHisMessage;
import com.hybridlab.hyve3d.satellitecenter.SessionID;
import com.jme3.network.serializing.Serializable;

@Serializable
public class SatelliteSessionSetupMessage
extends AbstractHisMessage {
    SessionID sessionId;
    String satelliteDeviceId = null;
    String deviceName = "<UNKOWN>";
    FrameRect desiredFrameRect = null;
    String trackingIdentifier = null;
    String satelliteVersion = null;
    Boolean isTrackingEnabled = null;

    public FrameRect getDesiredFrameRect() throws NoFrameRectException {
        if (null == this.desiredFrameRect) {
            throw new NoFrameRectException();
        }
        return this.desiredFrameRect;
    }

    public void setDesiredFrameRect(FrameRect desiredFrameRect) {
        this.desiredFrameRect = desiredFrameRect;
    }

    public SatelliteSessionSetupMessage(SessionID id) {
        this.setSessionId(id);
    }

    public SatelliteSessionSetupMessage() {
    }

    public String getVersion() {
        return this.satelliteVersion;
    }

    public void setVersion(String satelliteVersion) {
        this.satelliteVersion = satelliteVersion;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    public boolean hasFrameRect() {
        return this.desiredFrameRect != null;
    }

    public boolean hasSatelliteDeviceId() {
        return this.satelliteDeviceId != null;
    }

    public boolean hasSessionId() {
        return this.sessionId != null;
    }

    public String getSatelliteDeviceId() throws NoSatelliteDeviceIdException {
        if (null == this.satelliteDeviceId) {
            throw new NoSatelliteDeviceIdException();
        }
        return this.satelliteDeviceId;
    }

    public void setSatelliteDeviceId(String satelliteDeviceId) {
        this.satelliteDeviceId = satelliteDeviceId;
    }

    public SessionID getSessionId() throws NoSessionIdException {
        if (this.sessionId == null) {
            throw new NoSessionIdException();
        }
        return this.sessionId;
    }

    public void setSessionId(SessionID id) {
        this.sessionId = id;
    }

    public String toString() {
        return super.toString() + String.format("sessionid: [%s], satelliteDeviceId: [%s], deviceName: [%s], framerect: [%s]", this.sessionId == null ? "no sessionid" : this.sessionId, this.satelliteDeviceId == null ? "no satelliteDeviceId" : this.satelliteDeviceId.toString(), this.deviceName == null ? "no deviceName" : this.deviceName.toString(), this.desiredFrameRect == null ? "no desiredFrameRect" : this.desiredFrameRect.toString());
    }

    public void setTrackingIdentifier(String tid) {
        this.trackingIdentifier = tid;
    }

    public void setIsTrackingEnabled(Boolean te) {
        this.isTrackingEnabled = te;
    }

    public Boolean getIsTrackingEnabled() {
        return this.isTrackingEnabled;
    }

    public boolean hasTrackingInfo() {
        return this.trackingIdentifier != null && this.isTrackingEnabled != null;
    }

    public String getTrackingIdentifier() {
        return this.trackingIdentifier;
    }

    public class NoFrameRectException
    extends Exception {
        private static final long serialVersionUID = 126774173846462056L;
    }

    public class NoSatelliteDeviceIdException
    extends Exception {
        private static final long serialVersionUID = -8453535757976184218L;
    }

    public class NoSessionIdException
    extends Exception {
        private static final long serialVersionUID = -8329768808376378108L;
    }
}

