/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.network.messages;

import com.hybridlab.hyve3d.core.Stroke2D;
import com.hybridlab.hyve3d.core.StrokeId;
import com.hybridlab.hyve3d.core.StrokeInk;
import com.hybridlab.hyve3d.network.messages.AbstractHisMessage;
import com.hybridlab.utils.Interpolation;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector2f;
import com.jme3.network.serializing.Serializable;
import java.util.ArrayList;
import java.util.Locale;
import java.util.UUID;

@Serializable
public class Stroke2DTransmissionPartMessage
extends AbstractHisMessage {
    private static final short defaultPressure = -1;
    private Vector2f[] points;
    private short[] pressures;
    private SubType type;
    private StrokeId strokeId;
    private StrokeInk ink;

    public Stroke2DTransmissionPartMessage() {
    }

    public Vector2f[] getPoints() {
        return this.points;
    }

    public Vector2f getFirstPoint() {
        return this.points[0];
    }

    public Vector2f getLastPoint() {
        return this.points[this.points.length - 1];
    }

    public short[] getPressures() {
        return this.pressures;
    }

    public void setPressures(short[] p) {
        this.pressures = p;
    }

    public SubType getType() {
        return this.type;
    }

    public Stroke2DTransmissionPartMessage(StrokeId id, Vector2f point, SubType type) {
        this(id, new Vector2f[]{point}, type);
    }

    public Stroke2DTransmissionPartMessage(StrokeId id, Vector2f[] points, SubType type) {
        short[] pressures = new short[points.length];
        for (int i = 0; i < points.length; ++i) {
            pressures[i] = -1;
        }
        this.strokeId = id;
        this.points = points;
        this.pressures = pressures;
        this.type = type;
    }

    public Stroke2DTransmissionPartMessage(StrokeId id, Vector2f[] points, short[] pressures, SubType type) {
        this.strokeId = id;
        this.points = points;
        this.pressures = pressures;
        this.type = type;
    }

    public Stroke2DTransmissionPartMessage(StrokeId sid, Vector2f[] points, short[] pressures, SubType subType, StrokeInk ink) {
        this.strokeId = sid;
        this.points = points;
        this.type = subType;
        this.ink = ink;
        this.pressures = pressures;
    }

    public Stroke2DTransmissionPartMessage(StrokeId sid, Vector2f[] points, SubType subType, StrokeInk ink) {
        this.strokeId = sid;
        this.points = points;
        this.type = subType;
        this.ink = ink;
        this.pressures = new short[points.length];
        for (int i = 0; i < points.length; ++i) {
            this.pressures[i] = -1;
        }
    }

    public String toString() {
        Object sss = "";
        for (int i = 0; i < this.points.length; ++i) {
            Vector2f p = this.points[i];
            short pressure = this.pressures[i];
            sss = (String)sss + String.format(Locale.ENGLISH, " (%.4f, %.4f - %d)", Float.valueOf(p.x), Float.valueOf(p.y), pressure) + " ";
        }
        String s = Stroke2DTransmissionPartMessage.class.getSimpleName() + " " + this.type.toString() + " " + (String)sss;
        return s;
    }

    public StrokeId getStrokeId() {
        return this.strokeId;
    }

    public StrokeInk getInk() {
        return this.ink;
    }

    public static Stroke2DTransmissionPartMessage createCompleteStrokeTestMessage(int testStrokeNumber) {
        return Stroke2DTransmissionPartMessage.createCompleteStrokeTestMessage(testStrokeNumber, 0, 1);
    }

    public Stroke2D createStroke2D() {
        Stroke2D s = new Stroke2D();
        s.setStrokeId(this.getStrokeId().duplicate());
        s.setInk(this.getInk());
        ArrayList<Vector2f> pointList = new ArrayList<Vector2f>();
        for (Vector2f p : this.points) {
            pointList.add(p);
        }
        s.addPoints(pointList);
        s.addPressures(this.pressures);
        return s;
    }

    public static Stroke2DTransmissionPartMessage createCompleteStrokeTestMessage(int testStrokeNumber, int numInGroup, int groupsize) {
        if (testStrokeNumber == 1) {
            StrokeId sid = new StrokeId(UUID.fromString("b43a8095-f09e-4414-86ff-5107f4a7f5d9"));
            Vector2f[] points = new Vector2f[]{new Vector2f(0.2f, 0.2f), new Vector2f(0.2f, 0.5f), new Vector2f(0.7f, 0.5f), new Vector2f(0.7f, 0.2f)};
            StrokeInk ink = new StrokeInk();
            ink.setThickness(2.0f);
            Stroke2DTransmissionPartMessage m1 = new Stroke2DTransmissionPartMessage(sid, points, SubType.COMPLETE, ink);
            System.out.println(m1.toString());
            return m1;
        }
        if (testStrokeNumber == 2) {
            StrokeId sid = new StrokeId(UUID.fromString("c5d237ab-1bae-4f3d-aa7f-fb310e53a27e"));
            int numpoints = 64;
            Vector2f[] points = new Vector2f[numpoints];
            double a = 0.0;
            double b = 0.0;
            double r = 0.5;
            for (int p = 0; p < numpoints; ++p) {
                double t = (float)Math.PI * 2 * (float)p / (float)numpoints;
                float x = (float)(a + r * Math.cos(t));
                float y = (float)(b + r * Math.sin(t));
                points[p] = new Vector2f(x, y);
            }
            StrokeInk ink = new StrokeInk();
            ink.setThickness(5.0f);
            ColorRGBA c = ColorRGBA.Pink.clone();
            c.a = 0.5f;
            ink.setColor(c);
            Stroke2DTransmissionPartMessage m1 = new Stroke2DTransmissionPartMessage(sid, points, SubType.COMPLETE, ink);
            System.out.println(m1.toString());
            return m1;
        }
        if (testStrokeNumber == 3) {
            StrokeId sid = new StrokeId(UUID.randomUUID());
            int primenumber = groupsize;
            float floatprime = primenumber;
            int numpoints = 2;
            Vector2f[] points = new Vector2f[numpoints];
            double angleshift = (float)Math.PI * 2 * (float)(numInGroup % primenumber) / floatprime;
            double a = 0.0;
            double b = 0.0;
            double r = 0.5;
            for (int p = 0; p < numpoints; ++p) {
                double t = (float)Math.PI * 2 * (float)p / (float)numpoints;
                float x = (float)(a + r * Math.cos(t += angleshift));
                float y = (float)(b + r * Math.sin(t));
                points[p] = new Vector2f(x, y);
            }
            StrokeInk ink = new StrokeInk();
            ink.setThickness(2.5f);
            ColorRGBA c = ColorRGBA.Green.clone();
            c.a = 0.5f;
            ink.setColor(c);
            Stroke2DTransmissionPartMessage m1 = new Stroke2DTransmissionPartMessage(sid, points, SubType.COMPLETE, ink);
            System.out.println(m1.toString());
            return m1;
        }
        if (testStrokeNumber == 4) {
            StrokeId sid = new StrokeId(UUID.randomUUID());
            int numpoints = groupsize;
            Vector2f[] points = new Vector2f[numpoints];
            double a = 0.0;
            double b = 0.0;
            double r = 0.5;
            int primenumber = numpoints / 41 - 1;
            float floatprime = primenumber;
            for (int p = 0; p < numpoints; ++p) {
                double t = (float)Math.PI * 2 * (float)p / (float)numpoints;
                r = 0.5;
                float x = (float)(a + (r += (double)Interpolation.inttrf(p % primenumber, 0.0f, floatprime, -0.1f, 0.7f)) * Math.cos(t));
                float y = (float)(b + r * Math.sin(t));
                points[p] = new Vector2f(x, y);
            }
            StrokeInk ink = new StrokeInk();
            ink.setThickness(3.0f);
            ColorRGBA c = ColorRGBA.Cyan.clone();
            c.a = 0.5f;
            ink.setColor(c);
            Stroke2DTransmissionPartMessage m1 = new Stroke2DTransmissionPartMessage(sid, points, SubType.COMPLETE, ink);
            System.out.println(m1.toString());
            return m1;
        }
        return Stroke2DTransmissionPartMessage.createCompleteStrokeTestMessage(1);
    }

    public static enum SubType {
        COMPLETE(0),
        BEGIN(1),
        ADD(17),
        END(16);

        private short code;

        private SubType(short c) {
            this.code = c;
        }

        public short getCode() {
            return this.code;
        }

        public static SubType getFromShort(short s) {
            if (s == SubType.BEGIN.code) {
                return BEGIN;
            }
            if (s == SubType.ADD.code) {
                return ADD;
            }
            if (s == SubType.END.code) {
                return END;
            }
            if (s == SubType.COMPLETE.code) {
                return COMPLETE;
            }
            return BEGIN;
        }
    }
}

