/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.network.messages;

import com.hybridlab.hyve3d.core.StrokeInk;
import com.hybridlab.hyve3d.network.messages.AbstractHisMessage;
import com.jme3.math.ColorRGBA;
import com.jme3.network.serializing.Serializable;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

@Serializable
public class StrokeInkMessage
extends AbstractHisMessage {
    public short subType = 0;
    public float red = 1.0f;
    public float green = 1.0f;
    public float blue = 1.0f;
    public float alpha = 1.0f;
    public float thickness = -1.0f;
    public float pressurefactor = 3.0f;
    public StrokeInk.StrokeStyle style = StrokeInk.StrokeStyle.Line;
    private static final String KEY_COLOR = "color";
    private static final String KEY_THICKNESS = "width";
    private static final String KEY_PRESSUREFACTOR = "pressurefactor";
    private static final String KEY_RED = "r";
    private static final String KEY_GREEN = "g";
    private static final String KEY_BLUE = "b";
    private static final String KEY_ALPHA = "a";
    private static final String KEY_STYLE = "style";

    public String toString() {
        String s = this.getClass().getName() + "@" + Integer.toHexString(this.hashCode());
        s = s + String.format(Locale.ENGLISH, " red %.2f, green %.2f, blue %.2f, alpha %.2f, thickness %.2f", Float.valueOf(this.red), Float.valueOf(this.green), Float.valueOf(this.blue), Float.valueOf(this.alpha), Float.valueOf(this.thickness));
        return s;
    }

    public static String toJSONString(StrokeInkMessage m) {
        try {
            JSONObject jo = new JSONObject();
            JSONObject c = new JSONObject();
            c.put(KEY_ALPHA, (double)m.alpha);
            c.put(KEY_RED, (double)m.red);
            c.put(KEY_GREEN, (double)m.green);
            c.put(KEY_BLUE, (double)m.blue);
            jo.put(KEY_COLOR, (Object)c);
            jo.put(KEY_THICKNESS, (double)m.thickness);
            jo.put(KEY_PRESSUREFACTOR, (double)m.pressurefactor);
            jo.put(KEY_STYLE, (Object)m.style.toString());
            return jo.toString();
        }
        catch (JSONException e) {
            e.printStackTrace();
            return "{}";
        }
    }

    public static StrokeInkMessage fromJSONString(String inkJson) {
        StrokeInkMessage m = new StrokeInkMessage();
        try {
            JSONObject jo = new JSONObject(inkJson);
            JSONObject c = jo.getJSONObject(KEY_COLOR);
            m.alpha = (float)c.getDouble(KEY_ALPHA);
            m.red = (float)c.getDouble(KEY_RED);
            m.green = (float)c.getDouble(KEY_GREEN);
            m.blue = (float)c.getDouble(KEY_BLUE);
            m.thickness = (float)jo.getDouble(KEY_THICKNESS);
            try {
                m.pressurefactor = (float)jo.getDouble(KEY_PRESSUREFACTOR);
            }
            catch (JSONException e) {
                m.pressurefactor = 1.0f;
            }
            m.style = StrokeInk.StrokeStyle.valueOf(jo.getString(KEY_STYLE));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return m;
    }

    public static StrokeInk toStrokeInk(StrokeInkMessage im) {
        StrokeInk ink = new StrokeInk();
        ink.setColor(new ColorRGBA(im.red, im.green, im.blue, im.alpha));
        ink.setStyle(im.style);
        ink.setThickness(im.thickness);
        ink.setPressureFactor(im.pressurefactor);
        return ink;
    }

    public static StrokeInkMessage fromStrokeInk(StrokeInk ink) {
        StrokeInkMessage m = new StrokeInkMessage();
        ColorRGBA c = ink.getColor();
        m.alpha = c.a;
        m.red = c.r;
        m.green = c.g;
        m.blue = c.b;
        m.thickness = ink.getThickness();
        m.style = ink.getStyle();
        m.pressurefactor = ink.getPressureFactor();
        return m;
    }
}

