/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.network.spacemouse;

import com.hybridlab.hyve3d.network.messages.SpaceMouseMessage;
import com.jme3.math.Vector3f;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class SpaceMouseValueTCPSocketConnection {
    private String host;
    private int port;
    InputStream inStreamFromServer;
    InputStreamReader inFromServer;
    DataOutputStream outToServer;
    Socket clientSocket;
    final int msgLength = 32;
    private boolean printSkippedToSystemOut = false;

    public SpaceMouseValueTCPSocketConnection(String host, int port) {
        this(host, port, false);
    }

    public SpaceMouseValueTCPSocketConnection(String host, int port, boolean printSkippedToSystemOut) {
        this.host = host;
        this.port = port;
        this.printSkippedToSystemOut = printSkippedToSystemOut;
    }

    public void disconnect() throws IOException {
        this.clientSocket.close();
    }

    public void connect() throws UnknownHostException, IOException {
        this.clientSocket = new Socket(this.host, this.port);
        this.inStreamFromServer = this.clientSocket.getInputStream();
        this.inFromServer = new InputStreamReader(this.inStreamFromServer);
        this.outToServer = new DataOutputStream(this.clientSocket.getOutputStream());
    }

    public void send(String msg) throws IOException {
        this.outToServer.writeBytes(msg);
    }

    public int getCountOfNextAvailableBytes() throws IOException {
        int x = this.inStreamFromServer.available();
        return x;
    }

    byte[] receive(int numbytes) throws IOException {
        byte[] buff = new byte[numbytes];
        int toread = numbytes;
        for (int index = 0; index < toread; index += this.inStreamFromServer.read(buff, index, toread - index)) {
        }
        return buff;
    }

    public String receiveStep() throws IOException {
        int availableBytes = this.getCountOfNextAvailableBytes();
        int numBytesToSkip = (availableBytes / 32 - 1) * 32;
        if (numBytesToSkip > 0) {
            long skippedBytes = this.inStreamFromServer.skip(numBytesToSkip);
            int skippedMessages = (int)skippedBytes / 32 - 1;
            if (this.printSkippedToSystemOut) {
                System.out.println(String.format("---- skipped %d bytes (%d messages) ---- ", skippedBytes, skippedMessages));
            }
        }
        Object s = "";
        byte[] bytes = this.receive(4);
        int msgID = ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).getInt();
        s = (String)s + String.format("Message %d\n", msgID);
        for (int i = 0; i < 6; ++i) {
            bytes = this.receive(4);
            float f = ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).getFloat();
            s = (String)s + String.format("  float %d: %.4f\n", i, Float.valueOf(f));
        }
        bytes = this.receive(4);
        int buttons = ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).getInt();
        s = (String)s + String.format("  Buttons: %d\n\n", buttons);
        return s;
    }

    public SpaceMouseMessage receiveNewestSpaceMouseMessage() throws Exception {
        byte[] bytes;
        int msgID;
        int availableBytes = this.getCountOfNextAvailableBytes();
        int numBytesToSkip = (availableBytes / 32 - 1) * 32;
        if (numBytesToSkip > 0) {
            long skippedBytes = this.inStreamFromServer.skip(numBytesToSkip);
            int skippedMessages = (int)skippedBytes / 32 - 1;
            if (this.printSkippedToSystemOut) {
                System.out.println(String.format("---- skipped %d bytes (%d messages) ---- ", skippedBytes, skippedMessages));
            }
        }
        if ((msgID = ByteBuffer.wrap(bytes = this.receive(4)).order(ByteOrder.LITTLE_ENDIAN).getInt()) == 1) {
            float[] values = new float[6];
            for (int i = 0; i < 6; ++i) {
                float f;
                bytes = this.receive(4);
                values[i] = f = ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).getFloat();
            }
            bytes = this.receive(4);
            int buttonstate = ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).getInt();
            Vector3f translation = new Vector3f(values[0], values[1], values[2]);
            Vector3f rotation = new Vector3f(values[3], values[4], values[5]);
            SpaceMouseMessage msg = new SpaceMouseMessage(translation, rotation, buttonstate);
            return msg;
        }
        throw new Exception("Spacemousemessage could not be created correctly!");
    }
}

