/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.network.transport.appCtrl;

import com.hybridlab.hyve3d.network.messages.ByteMessage;
import com.hybridlab.hyve3d.network.transport.appCtrl.AppCtrlClientConnectionListener;
import com.hybridlab.hyve3d.network.transport.appCtrl.AppCtrlMessageTransportConnection;
import com.hybridlab.hyve3d.network.transport.appCtrl.AppCtrl_MessageTranslator;
import com.hybridlab.hyve3d.network.transport.fab8.FrameReceiveErrorException;
import com.jme3.network.AbstractMessage;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AppCtrlTCPSocketConnection
implements Runnable,
AppCtrlMessageTransportConnection {
    private final Socket clientSocket;
    private final ServerSocket serverSocket;
    boolean connected = false;
    InputStream inStreamFromServer;
    InputStreamReader inFromServer;
    DataOutputStream outToServer;
    Logger logger = Logger.getLogger(AppCtrlTCPSocketConnection.class.getName());
    AppCtrlClientConnectionListener listener;
    private final AppCtrl_MessageTranslator messageTranslator;
    int sleepMilliseconds = 30;

    public AppCtrlTCPSocketConnection(ServerSocket serverSocket, Socket clientSocket, AppCtrlClientConnectionListener listener, AppCtrl_MessageTranslator messageTranslator) throws IOException {
        this.clientSocket = clientSocket;
        this.serverSocket = serverSocket;
        this.listener = listener;
        this.messageTranslator = messageTranslator;
        this.inStreamFromServer = clientSocket.getInputStream();
        this.inFromServer = new InputStreamReader(this.inStreamFromServer);
        this.outToServer = new DataOutputStream(clientSocket.getOutputStream());
        this.clientSocket.setKeepAlive(true);
    }

    void tryToReceiveFrame(boolean expectStartByte) throws Exception {
        try {
            byte startByte = AppCtrl_MessageTranslator.STOP;
            if (expectStartByte) {
                startByte = this.receiveSingleByte();
            } else {
                int scannedBytes;
                int bufSize = 65533;
                byte[] buffer = new byte[bufSize];
                for (scannedBytes = 0; startByte != AppCtrl_MessageTranslator.START && scannedBytes < bufSize; scannedBytes = (int)((short)(scannedBytes + 1))) {
                    startByte = this.receiveSingleByte();
                    int n = scannedBytes;
                    buffer[n] = startByte;
                }
                byte[] trashBytes = Arrays.copyOfRange(buffer, 0, scannedBytes);
                this.logger.log(Level.WARNING, "Found trash bytes before start byte: \n" + ByteMessage.bytesToHex(trashBytes));
            }
            if (startByte == AppCtrl_MessageTranslator.START) {
                int offset;
                byte[] unEscapedDataBytes;
                byte[] frameLengthByteArray = this.receive(2);
                if (frameLengthByteArray[1] == AppCtrl_MessageTranslator.SHIFT) {
                    byte escapedlower = this.receiveSingleByte();
                    frameLengthByteArray[1] = this.messageTranslator.getControlByteForEscapeByte(escapedlower);
                } else if (frameLengthByteArray[0] == AppCtrl_MessageTranslator.SHIFT) {
                    frameLengthByteArray[0] = this.messageTranslator.getControlByteForEscapeByte(frameLengthByteArray[1]);
                    byte lowerByteOrShift = this.receiveSingleByte();
                    frameLengthByteArray[1] = lowerByteOrShift == AppCtrl_MessageTranslator.SHIFT ? this.messageTranslator.getControlByteForEscapeByte(this.receiveSingleByte()) : lowerByteOrShift;
                }
                ByteBuffer frameLengthBytesBuffer = ByteBuffer.wrap(frameLengthByteArray).order(AppCtrl_MessageTranslator.BYTE_ORDER_RECEIVING);
                short frameLength = frameLengthBytesBuffer.getShort();
                byte[] escapedDataBytes = this.receive(frameLength - 1);
                int numShiftBytes = 0;
                for (byte b : escapedDataBytes) {
                    if (b != AppCtrl_MessageTranslator.SHIFT) continue;
                    numShiftBytes = (short)(numShiftBytes + 1);
                }
                if (numShiftBytes == 0) {
                    unEscapedDataBytes = escapedDataBytes;
                } else {
                    unEscapedDataBytes = new byte[escapedDataBytes.length - numShiftBytes];
                    int insertIndex = 0;
                    for (int i = 0; i < escapedDataBytes.length; ++i) {
                        byte b;
                        b = escapedDataBytes[i];
                        unEscapedDataBytes[insertIndex++] = b != AppCtrl_MessageTranslator.SHIFT ? b : this.messageTranslator.getControlByteForEscapeByte(escapedDataBytes[++i]);
                    }
                }
                ByteBuffer msgBuffer = ByteBuffer.wrap(unEscapedDataBytes).order(AppCtrl_MessageTranslator.BYTE_ORDER_RECEIVING);
                short msgType = msgBuffer.getShort();
                byte[] unescapedMessageDataBytesWithOutTypeBytes = new byte[unEscapedDataBytes.length - 2];
                for (int i = offset = 2; i < unEscapedDataBytes.length; ++i) {
                    int dest = i - offset;
                    unescapedMessageDataBytesWithOutTypeBytes[dest] = unEscapedDataBytes[i];
                }
                if (this.receiveSingleByte() != AppCtrl_MessageTranslator.STOP) {
                    this.logger.log(Level.WARNING, "no stop byte at the end of frame with message: " + ByteMessage.bytesToHex(unEscapedDataBytes));
                }
                AbstractMessage message = this.messageTranslator.parseMessage(msgType, unescapedMessageDataBytesWithOutTypeBytes);
                switch (msgType) {
                    default: 
                }
                this.listener.onAbstractMessageReceived(message, this);
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, e.getClass() + " occured!\n" + e.getMessage());
            e.printStackTrace();
            throw new FrameReceiveErrorException(e);
        }
    }

    @Override
    public void run() {
        this.connected = true;
        this.listener.onConnectionEstablished(this);
        while (this.connected) {
            try {
                if (this.getCountOfNextAvailableBytes() > 0) {
                    boolean expectFrameStart;
                    try {
                        expectFrameStart = true;
                        this.tryToReceiveFrame(expectFrameStart);
                    }
                    catch (FrameReceiveErrorException e) {
                        expectFrameStart = false;
                        this.tryToReceiveFrame(expectFrameStart);
                    }
                    continue;
                }
                Thread.sleep(this.sleepMilliseconds);
                if (this.clientSocket.isBound() && this.clientSocket.isConnected() && !this.clientSocket.isClosed()) continue;
                throw new IOException("Socket has either been closed, disconnected or is no longer bound! " + this.clientSocket);
            }
            catch (IOException e) {
                this.logger.log(Level.SEVERE, e.getMessage(), e);
                this.connected = false;
            }
            catch (InterruptedException ex) {
                this.logger.log(Level.SEVERE, ex.getMessage(), ex);
                this.connected = false;
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, e.getMessage(), e);
                this.connected = false;
            }
        }
        this.listener.onConnectionLost(this);
    }

    @Override
    public void disconnect() throws IOException {
        this.connected = false;
        this.clientSocket.close();
    }

    public void send(byte[] frame) throws IOException {
        this.outToServer.write(frame);
    }

    public int getCountOfNextAvailableBytes() throws IOException {
        int x = this.inStreamFromServer.available();
        return x;
    }

    byte[] receive(int numbytes) throws IOException {
        int numRead;
        byte[] buff = new byte[numbytes];
        int toread = numbytes;
        for (int index = 0; index < toread; index += numRead) {
            numRead = this.inStreamFromServer.read(buff, index, toread - index);
            if (numRead != -1) continue;
            throw new IOException("Input stream from server ended");
        }
        return buff;
    }

    byte receiveSingleByte() throws IOException {
        return this.receive(1)[0];
    }

    @Override
    public void send(AbstractMessage message) throws AppCtrlMessageTransportConnection.SendFailedException {
        try {
            byte[] messagebytes = this.messageTranslator.getBytesForAbstractHisMessage(message);
            byte[] frame = this.messageTranslator.wrapBytesForAbstractHisMessageIntoFrame(messagebytes);
            this.send(frame);
        }
        catch (IOException e) {
            String error = "send of message failed: " + message + "\ndue to IOException: " + e.getMessage();
            this.logger.log(Level.SEVERE, error);
            this.connected = false;
            throw new AppCtrlMessageTransportConnection.SendFailedException(error, e);
        }
        catch (Exception e) {
            String error = "send of message failed: " + message + "\ndue to Exception: " + e.getMessage();
            this.logger.log(Level.SEVERE, error);
            this.connected = false;
            throw new AppCtrlMessageTransportConnection.SendFailedException(error, e);
        }
    }
}

