/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.network.transport.fab8;

import com.hybridlab.hyve3d.network.discovery.NetworkServiceManager;
import com.hybridlab.hyve3d.network.transport.fab8.FAB8TCPSocketConnection;
import com.hybridlab.hyve3d.network.transport.fab8.FAB8_MessageTranslator;
import com.hybridlab.hyve3d.network.transport.spidermonkey.SpiderMonkeyBasedSatteliteServer;
import com.hybridlab.hyve3d.satellitecenter.SatelliteServer;
import com.hybridlab.hyve3d.satellitecenter.SatelliteSession;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FAB8BasedSatelliteServer
implements SatelliteServer.SatelliteClientServerMessageChannel {
    public static final int DEFAULT_SATELLITE_SERVER_PORT = 5789;
    private NetworkServiceManager networkServiceManager;
    private Logger logger = Logger.getLogger(SpiderMonkeyBasedSatteliteServer.class.getName());
    private int port;
    boolean useCachedThreadPool = true;
    int poolSize = 12;
    final ExecutorService pool;
    ServerSocket serverSocket;
    SatelliteServer satelliteServer;

    public FAB8BasedSatelliteServer(SatelliteServer satelliteServer, NetworkServiceManager networkServiceManager) {
        this(satelliteServer, 5789, networkServiceManager);
    }

    public FAB8BasedSatelliteServer(SatelliteServer satelliteServer, int port, NetworkServiceManager networkServiceManager) {
        this.satelliteServer = satelliteServer;
        this.port = 5789;
        this.networkServiceManager = networkServiceManager;
        this.pool = this.useCachedThreadPool ? Executors.newCachedThreadPool() : Executors.newFixedThreadPool(this.poolSize);
    }

    @Override
    public void start() {
        try {
            this.port = this.networkServiceManager.registerService("satellite_fab8");
            this.logger.info(String.format("Start %s at port %d", FAB8BasedSatelliteServer.class.getSimpleName(), this.port));
            this.startListeningForFAB8Connections();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, null, e);
        }
    }

    private void startListeningForFAB8Connections() throws IOException {
        this.serverSocket = new ServerSocket(this.port);
        FAB8SatelliteSessionFactory f8sf = new FAB8SatelliteSessionFactory(this.pool, this.serverSocket);
        Thread t1 = new Thread((Runnable)f8sf, f8sf.getClass().getSimpleName() + " " + String.valueOf(f8sf.hashCode()));
        this.logger.log(Level.INFO, "start " + SatelliteServer.class.getSimpleName() + " | Port: " + String.valueOf(this.port) + " Thread: " + Thread.currentThread());
        t1.start();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                System.out.println("Strg+C, pool.shutdown");
                FAB8BasedSatelliteServer.this.stop();
            }
        });
    }

    @Override
    public void stop() {
        this.pool.shutdown();
        try {
            this.pool.awaitTermination(2L, TimeUnit.SECONDS);
            if (!this.serverSocket.isClosed()) {
                System.out.println("ServerSocket close");
                this.serverSocket.close();
            }
        }
        catch (IOException iOException) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    class FAB8SatelliteSessionFactory
    implements Runnable {
        private final ServerSocket serverSocket;
        private final ExecutorService pool;

        public FAB8SatelliteSessionFactory(ExecutorService pool, ServerSocket serverSocket) {
            this.serverSocket = serverSocket;
            this.pool = pool;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                try {
                    while (true) {
                        Socket clientSocket = this.serverSocket.accept();
                        SatelliteSession satSession = FAB8BasedSatelliteServer.this.satelliteServer.createSession();
                        FAB8TCPSocketConnection conn = new FAB8TCPSocketConnection(this.serverSocket, clientSocket, satSession, new FAB8_MessageTranslator());
                        this.pool.execute(conn);
                    }
                }
                catch (IOException ex) {
                    FAB8BasedSatelliteServer.this.logger.log(Level.SEVERE, "--- Interrupt NetworkService-run");
                    FAB8BasedSatelliteServer.this.logger.log(Level.INFO, "--- Ende NetworkService(pool.shutdown)");
                    this.pool.shutdown();
                    try {
                        this.pool.awaitTermination(4L, TimeUnit.SECONDS);
                        if (!this.serverSocket.isClosed()) {
                            FAB8BasedSatelliteServer.this.logger.log(Level.INFO, "--- Ende NetworkService:ServerSocket close");
                            this.serverSocket.close();
                        }
                    }
                    catch (IOException e) {
                        FAB8BasedSatelliteServer.this.logger.log(Level.SEVERE, "IOException while closing pool: " + e.getMessage());
                    }
                    catch (InterruptedException ei) {
                        FAB8BasedSatelliteServer.this.logger.log(Level.SEVERE, "InterruptedException while closing pool: " + ei.getMessage());
                    }
                }
            }
            catch (Throwable throwable) {
                FAB8BasedSatelliteServer.this.logger.log(Level.INFO, "--- Ende NetworkService(pool.shutdown)");
                this.pool.shutdown();
                try {
                    this.pool.awaitTermination(4L, TimeUnit.SECONDS);
                    if (!this.serverSocket.isClosed()) {
                        FAB8BasedSatelliteServer.this.logger.log(Level.INFO, "--- Ende NetworkService:ServerSocket close");
                        this.serverSocket.close();
                    }
                }
                catch (IOException e) {
                    FAB8BasedSatelliteServer.this.logger.log(Level.SEVERE, "IOException while closing pool: " + e.getMessage());
                }
                catch (InterruptedException ei) {
                    FAB8BasedSatelliteServer.this.logger.log(Level.SEVERE, "InterruptedException while closing pool: " + ei.getMessage());
                }
                throw throwable;
            }
        }
    }
}

