/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.network.transport.fab8;

import com.hybridlab.hyve3d.network.messages.AbstractHisMessage;
import com.hybridlab.hyve3d.network.messages.ByteMessage;
import com.hybridlab.hyve3d.network.messages.CommandMessage;
import com.hybridlab.hyve3d.network.messages.Move2DMessage;
import com.hybridlab.hyve3d.network.messages.Move3DMessage;
import com.hybridlab.hyve3d.network.messages.PinchPointsMessage;
import com.hybridlab.hyve3d.network.messages.Pointing2DTransmissionPartMessage;
import com.hybridlab.hyve3d.network.messages.SatelliteSessionSetupMessage;
import com.hybridlab.hyve3d.network.messages.Stroke2DTransmissionPartMessage;
import com.hybridlab.hyve3d.network.messages.StrokeInkMessage;
import com.hybridlab.hyve3d.network.messages.TransformMessage;
import com.hybridlab.hyve3d.network.messages.ZoomMessage;
import com.hybridlab.hyve3d.network.transport.MessageTransportConnection;
import com.hybridlab.hyve3d.network.transport.fab8.FAB8_MessageTranslator;
import com.hybridlab.hyve3d.network.transport.fab8.FrameReceiveErrorException;
import com.hybridlab.hyve3d.satellitecenter.SatelliteClientConnectionListener;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FAB8TCPSocketConnection
implements Runnable,
MessageTransportConnection {
    private final Socket clientSocket;
    private final ServerSocket serverSocket;
    boolean connected = false;
    InputStream inStreamFromServer;
    InputStreamReader inFromServer;
    DataOutputStream outToServer;
    Logger logger = Logger.getLogger(FAB8TCPSocketConnection.class.getName());
    SatelliteClientConnectionListener listener;
    private final FAB8_MessageTranslator messageTranslator;
    int sleepMilliseconds = 30;

    public FAB8TCPSocketConnection(ServerSocket serverSocket, Socket clientSocket, SatelliteClientConnectionListener listener, FAB8_MessageTranslator messageTranslator) throws IOException {
        this.clientSocket = clientSocket;
        this.serverSocket = serverSocket;
        this.listener = listener;
        this.messageTranslator = messageTranslator;
        this.inStreamFromServer = clientSocket.getInputStream();
        this.inFromServer = new InputStreamReader(this.inStreamFromServer);
        this.outToServer = new DataOutputStream(clientSocket.getOutputStream());
        this.clientSocket.setKeepAlive(true);
    }

    void tryToReceiveFrame(boolean expectStartByte) throws Exception {
        try {
            byte startByte = FAB8_MessageTranslator.STOP;
            if (expectStartByte) {
                startByte = this.receiveSingleByte();
            } else {
                int scannedBytes;
                int bufSize = 65533;
                byte[] buffer = new byte[bufSize];
                for (scannedBytes = 0; startByte != FAB8_MessageTranslator.START && scannedBytes < bufSize; scannedBytes = (int)((short)(scannedBytes + 1))) {
                    startByte = this.receiveSingleByte();
                    int n = scannedBytes;
                    buffer[n] = startByte;
                }
                byte[] trashBytes = Arrays.copyOfRange(buffer, 0, scannedBytes);
                this.logger.log(Level.WARNING, "Found trash bytes before start byte: \n" + ByteMessage.bytesToHex(trashBytes));
            }
            if (startByte == FAB8_MessageTranslator.START) {
                int offset;
                byte[] unEscapedDataBytes;
                byte[] frameLengthByteArray = this.receive(2);
                if (frameLengthByteArray[1] == FAB8_MessageTranslator.SHIFT) {
                    byte escapedlower = this.receiveSingleByte();
                    frameLengthByteArray[1] = this.messageTranslator.getControlByteForEscapeByte(escapedlower);
                } else if (frameLengthByteArray[0] == FAB8_MessageTranslator.SHIFT) {
                    frameLengthByteArray[0] = this.messageTranslator.getControlByteForEscapeByte(frameLengthByteArray[1]);
                    byte lowerByteOrShift = this.receiveSingleByte();
                    frameLengthByteArray[1] = lowerByteOrShift == FAB8_MessageTranslator.SHIFT ? this.messageTranslator.getControlByteForEscapeByte(this.receiveSingleByte()) : lowerByteOrShift;
                }
                ByteBuffer frameLengthBytesBuffer = ByteBuffer.wrap(frameLengthByteArray).order(FAB8_MessageTranslator.BYTE_ORDER_RECEIVING);
                short frameLength = frameLengthBytesBuffer.getShort();
                byte[] escapedDataBytes = this.receive(frameLength - 1);
                int numShiftBytes = 0;
                for (byte b : escapedDataBytes) {
                    if (b != FAB8_MessageTranslator.SHIFT) continue;
                    numShiftBytes = (short)(numShiftBytes + 1);
                }
                if (numShiftBytes == 0) {
                    unEscapedDataBytes = escapedDataBytes;
                } else {
                    unEscapedDataBytes = new byte[escapedDataBytes.length - numShiftBytes];
                    int insertIndex = 0;
                    for (int i = 0; i < escapedDataBytes.length; ++i) {
                        byte b;
                        b = escapedDataBytes[i];
                        unEscapedDataBytes[insertIndex++] = b != FAB8_MessageTranslator.SHIFT ? b : this.messageTranslator.getControlByteForEscapeByte(escapedDataBytes[++i]);
                    }
                }
                ByteBuffer msgBuffer = ByteBuffer.wrap(unEscapedDataBytes).order(FAB8_MessageTranslator.BYTE_ORDER_RECEIVING);
                short msgType = msgBuffer.getShort();
                byte[] unescapedMessageDataBytesWithOutTypeBytes = new byte[unEscapedDataBytes.length - 2];
                for (int i = offset = 2; i < unEscapedDataBytes.length; ++i) {
                    int dest = i - offset;
                    unescapedMessageDataBytesWithOutTypeBytes[dest] = unEscapedDataBytes[i];
                }
                if (this.receiveSingleByte() != FAB8_MessageTranslator.STOP) {
                    this.logger.log(Level.WARNING, "no stop byte at the end of frame with message: " + ByteMessage.bytesToHex(unEscapedDataBytes));
                }
                AbstractHisMessage message = this.messageTranslator.parseMessage(msgType, unescapedMessageDataBytesWithOutTypeBytes);
                switch (msgType) {
                    case 17: {
                        TransformMessage m = (TransformMessage)message;
                        this.listener.onMessageReceived(m);
                        break;
                    }
                    case 2: {
                        this.listener.onMessageReceived((SatelliteSessionSetupMessage)message);
                        break;
                    }
                    case 16: {
                        this.listener.onMessageReceived((Stroke2DTransmissionPartMessage)message);
                        break;
                    }
                    case 9: {
                        this.listener.onMessageReceived((Pointing2DTransmissionPartMessage)message);
                        break;
                    }
                    case 6: {
                        this.listener.onMessageReceived((Move2DMessage)message);
                        break;
                    }
                    case 5: {
                        this.listener.onMessageReceived((Move3DMessage)message);
                        break;
                    }
                    case 7: {
                        this.listener.onMessageReceived((ZoomMessage)message);
                        break;
                    }
                    case 32: {
                        this.listener.onMessageReceived((StrokeInkMessage)message);
                        break;
                    }
                    case 256: {
                        this.listener.onMessageReceived((CommandMessage)message);
                        break;
                    }
                    case 291: {
                        this.listener.onMessageReceived((PinchPointsMessage)message);
                        break;
                    }
                    default: {
                        this.listener.onAbstractMessageReceived(message);
                    }
                }
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, e.getClass() + " occured!\n" + e.getMessage());
            e.printStackTrace();
            throw new FrameReceiveErrorException(e);
        }
    }

    @Override
    public void run() {
        this.connected = true;
        this.listener.onConnectionEstablished(this);
        while (this.connected) {
            try {
                if (this.getCountOfNextAvailableBytes() > 0) {
                    boolean expectFrameStart;
                    try {
                        expectFrameStart = true;
                        this.tryToReceiveFrame(expectFrameStart);
                    }
                    catch (FrameReceiveErrorException e) {
                        expectFrameStart = false;
                        this.tryToReceiveFrame(expectFrameStart);
                    }
                    continue;
                }
                Thread.sleep(this.sleepMilliseconds);
                if (this.clientSocket.isBound() && this.clientSocket.isConnected() && !this.clientSocket.isClosed()) continue;
                throw new IOException("Socket has either been closed, disconnected or is no longer bound! " + this.clientSocket);
            }
            catch (IOException e) {
                this.logger.log(Level.SEVERE, e.getMessage(), e);
                this.connected = false;
            }
            catch (InterruptedException ex) {
                this.logger.log(Level.SEVERE, ex.getMessage(), ex);
                this.connected = false;
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, e.getMessage(), e);
                this.connected = false;
            }
        }
        this.listener.onConnectionLost(this);
    }

    @Override
    public void disconnect() throws IOException {
        this.connected = false;
        this.clientSocket.close();
    }

    public void send(byte[] frame) throws IOException {
        this.outToServer.write(frame);
    }

    public int getCountOfNextAvailableBytes() throws IOException {
        int x = this.inStreamFromServer.available();
        return x;
    }

    byte[] receive(int numbytes) throws IOException {
        int numRead;
        byte[] buff = new byte[numbytes];
        int toread = numbytes;
        for (int index = 0; index < toread; index += numRead) {
            numRead = this.inStreamFromServer.read(buff, index, toread - index);
            if (numRead != -1) continue;
            throw new IOException("Input stream from server ended");
        }
        return buff;
    }

    byte receiveSingleByte() throws IOException {
        return this.receive(1)[0];
    }

    @Override
    public void send(AbstractHisMessage message) throws MessageTransportConnection.SendFailedException {
        try {
            byte[] messagebytes = this.messageTranslator.getBytesForAbstractHisMessage(message);
            byte[] frame = this.messageTranslator.wrapBytesForAbstractHisMessageIntoFrame(messagebytes);
            this.send(frame);
        }
        catch (IOException e) {
            String error = "send of message failed: " + message + "\ndue to IOException: " + e.getMessage();
            this.logger.log(Level.SEVERE, error);
            this.connected = false;
            throw new MessageTransportConnection.SendFailedException(error, e);
        }
        catch (Exception e) {
            String error = "send of message failed: " + message + "\ndue to Exception: " + e.getMessage();
            this.logger.log(Level.SEVERE, error);
            this.connected = false;
            throw new MessageTransportConnection.SendFailedException(error, e);
        }
    }
}

