/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.nina;

import com.hybridlab.hyve3d.config.SimpleBeanSupport;
import com.hybridlab.hyve3d.rendering.spherical.ProjectionCalibrator;

public class CalibrationConfiguration
extends SimpleBeanSupport
implements ProjectionCalibrator.ProjectionCalibrationValueChangeListener {
    private Float sphereCamDistance;
    private Float SphereViewportRadius;
    private Float SphereScale;
    private Float SphereCamFieldOfView;
    private ProjectionCalibrator calibrator;
    private boolean hasChanges = false;

    public CalibrationConfiguration(float sphereCamFieldOfView, float sphereScale, float sphereViewportRadius, float sphereCamDistance) {
        this.sphereCamDistance = Float.valueOf(sphereCamDistance);
        this.SphereViewportRadius = Float.valueOf(sphereViewportRadius);
        this.SphereScale = Float.valueOf(sphereScale);
        this.SphereCamFieldOfView = Float.valueOf(sphereCamFieldOfView);
    }

    public ProjectionCalibrator getCalibrator() {
        return this.calibrator;
    }

    public void connect(ProjectionCalibrator c) {
        this.calibrator = c;
        this.calibrator.registerChangeListener(this);
        System.out.println(this.getClass().getSimpleName() + ".connect( ProjectionCalibrator = " + c + ") ...");
        System.out.println("   ... calling -> calibrator.setProjectionParameters(SphereScale=" + this.SphereScale + ", SphereViewportRadius=" + this.SphereViewportRadius + ", sphereCamDistance=" + this.sphereCamDistance + ", SphereCamFieldOfView=" + this.SphereCamFieldOfView + ", ) ...");
        this.calibrator.setProjectionParameters(this.SphereScale, this.SphereViewportRadius, this.sphereCamDistance, this.SphereCamFieldOfView);
    }

    @Override
    public void valueHasChanged(ProjectionCalibrator calibrator, ProjectionCalibrator.ProjectionCalibrationValue changed) {
        if (calibrator.equals(this.calibrator)) {
            switch (changed) {
                case SphereCamDistance: {
                    this.setSphereCamDistance(Float.valueOf(calibrator.getCameraDistance()));
                    break;
                }
                case SphereCamFieldOfView: {
                    this.setSphereCamFieldOfView(Float.valueOf(calibrator.getSpherecameraFieldOfViewAngleAlongYInDegrees()));
                    break;
                }
                case SphereScale: {
                    this.setSphereScale(Float.valueOf(calibrator.getSphereScale()));
                    break;
                }
                case SphereViewportRadius: {
                    this.setSphereViewportRadius(Float.valueOf(calibrator.getViewPortRadius()));
                    break;
                }
            }
        }
    }

    public Float getSphereCamDistance() {
        return this.sphereCamDistance;
    }

    public void setSphereCamDistance(Float sphereCamDistance) {
        if (!sphereCamDistance.equals(this.sphereCamDistance)) {
            float old = this.sphereCamDistance.floatValue();
            this.sphereCamDistance = sphereCamDistance;
            this.fireChange("SphereCamDistance", Float.valueOf(old), sphereCamDistance);
            this.setHasChanges(true);
        }
    }

    public Float getSphereViewportRadius() {
        return this.SphereViewportRadius;
    }

    public void setSphereViewportRadius(Float sphereViewportRadius) {
        if (!sphereViewportRadius.equals(this.SphereViewportRadius)) {
            float old = this.SphereViewportRadius.floatValue();
            this.SphereViewportRadius = sphereViewportRadius;
            this.fireChange("SphereViewportRadius", Float.valueOf(old), this.SphereViewportRadius);
            this.setHasChanges(true);
        }
    }

    public Float getSphereScale() {
        return this.SphereScale;
    }

    public void setSphereScale(Float sphereScale) {
        if (!sphereScale.equals(this.SphereScale)) {
            float old = this.SphereScale.floatValue();
            this.SphereScale = sphereScale;
            this.fireChange("SphereScale", Float.valueOf(old), this.SphereScale);
            this.setHasChanges(true);
        }
    }

    public Float getSphereCamFieldOfView() {
        return this.SphereCamFieldOfView;
    }

    public void setSphereCamFieldOfView(Float sphereCamFieldOfView) {
        if (!sphereCamFieldOfView.equals(this.SphereCamFieldOfView)) {
            float old = this.SphereCamFieldOfView.floatValue();
            this.SphereCamFieldOfView = sphereCamFieldOfView;
            this.fireChange("SphereCamFieldOfView", Float.valueOf(old), this.SphereCamFieldOfView);
            this.setHasChanges(true);
        }
    }

    public boolean hasChanges() {
        return this.hasChanges;
    }

    public void setSaved() {
        this.setHasChanges(false);
    }

    private void setHasChanges(boolean hasChanges) {
        this.hasChanges = hasChanges;
    }
}

