/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.nina;

import com.hybridlab.licensing.LicenseKey;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLEditorKit;

public class EnterLicenseKeyWindow
extends JFrame {
    private static final long serialVersionUID = 2821830054745787045L;
    public static final String CANCEL = "CANCEL";
    private boolean canceled = false;
    private JTextField txtLicensekey;
    private JTextField txtHardwareId;
    private JLabel lblEnterYourLincense;
    private JLabel lblYourHardwareIdentifier;
    private JPanel panel;
    private JButton btn_OK;
    private JButton btn_Cancel;
    private LicenseKey.LicenceValidator validator;
    private LicenseEnteredCallback callback;
    private int numberOfRequests;
    private String formerKey;
    private JLabel logoLabel;
    private JPanel panel_logo;
    private Color bgcolor = new Color(230, 144, 31);

    public EnterLicenseKeyWindow(String reason, String mac, int numberOfRequests, String okButtontext, LicenseKey.LicenceValidator validator, String key, LicenseEnteredCallback cb) {
        this.validator = validator;
        this.callback = cb;
        this.numberOfRequests = numberOfRequests;
        this.formerKey = key;
        this.setDefaultCloseOperation(0);
        this.setResizable(false);
        this.setAlwaysOnTop(true);
        this.setSize(750, 513);
        this.setTitle("License key");
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0};
        gridBagLayout.rowHeights = new int[]{200, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        gridBagLayout.columnWeights = new double[]{1.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        this.getContentPane().setLayout(gridBagLayout);
        InputStream is = this.getClass().getResourceAsStream("licencewindowlogo.png");
        try {
            BufferedImage myPicture = ImageIO.read(is);
            ImageIcon icon = new ImageIcon(myPicture);
            this.logoLabel = new JLabel();
            this.logoLabel.setAlignmentX(0.5f);
            this.logoLabel.setAlignmentY(0.5f);
            this.logoLabel.setBounds(25, 0, 700, 200);
            this.logoLabel.setIcon(icon);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        this.panel_logo = new JPanel();
        FlowLayout flowLayout = (FlowLayout)this.panel_logo.getLayout();
        flowLayout.setVgap(0);
        flowLayout.setHgap(0);
        this.panel_logo.setBackground(this.bgcolor);
        GridBagConstraints gbc_panel_logo = new GridBagConstraints();
        gbc_panel_logo.insets = new Insets(0, 0, 5, 0);
        gbc_panel_logo.fill = 1;
        gbc_panel_logo.gridx = 0;
        gbc_panel_logo.gridy = 0;
        this.getContentPane().add((Component)this.panel_logo, gbc_panel_logo);
        this.panel_logo.add(this.logoLabel);
        HTMLEditorKit kit = new HTMLEditorKit();
        Document doc = kit.createDefaultDocument();
        JLabel lblInfo = new JLabel(reason);
        GridBagConstraints gbc_lblInfo = new GridBagConstraints();
        gbc_lblInfo.insets = new Insets(0, 0, 5, 0);
        gbc_lblInfo.gridx = 0;
        gbc_lblInfo.gridy = 2;
        this.getContentPane().add((Component)lblInfo, gbc_lblInfo);
        this.lblYourHardwareIdentifier = new JLabel("Your hardware identifier is:");
        GridBagConstraints gbc_lblYourHardwareIdentifier = new GridBagConstraints();
        gbc_lblYourHardwareIdentifier.insets = new Insets(0, 0, 5, 0);
        gbc_lblYourHardwareIdentifier.gridx = 0;
        gbc_lblYourHardwareIdentifier.gridy = 4;
        this.getContentPane().add((Component)this.lblYourHardwareIdentifier, gbc_lblYourHardwareIdentifier);
        this.txtHardwareId = new JTextField();
        this.txtHardwareId.setText(mac);
        this.txtHardwareId.setEditable(false);
        this.txtHardwareId.setHorizontalAlignment(0);
        GridBagConstraints gbc_txtHardwareId = new GridBagConstraints();
        gbc_txtHardwareId.insets = new Insets(0, 0, 5, 0);
        gbc_txtHardwareId.fill = 2;
        gbc_txtHardwareId.gridx = 0;
        gbc_txtHardwareId.gridy = 5;
        this.getContentPane().add((Component)this.txtHardwareId, gbc_txtHardwareId);
        this.txtHardwareId.setColumns(10);
        this.lblEnterYourLincense = new JLabel("Enter your license key below:");
        GridBagConstraints gbc_lblEnterYourLincense = new GridBagConstraints();
        gbc_lblEnterYourLincense.insets = new Insets(0, 0, 5, 0);
        gbc_lblEnterYourLincense.gridx = 0;
        gbc_lblEnterYourLincense.gridy = 7;
        this.getContentPane().add((Component)this.lblEnterYourLincense, gbc_lblEnterYourLincense);
        this.txtLicensekey = new JTextField();
        this.txtLicensekey.setText(key);
        GridBagConstraints gbc_txtLicensekey = new GridBagConstraints();
        gbc_txtLicensekey.insets = new Insets(0, 0, 5, 0);
        gbc_txtLicensekey.fill = 2;
        gbc_txtLicensekey.gridx = 0;
        gbc_txtLicensekey.gridy = 8;
        this.getContentPane().add((Component)this.txtLicensekey, gbc_txtLicensekey);
        this.txtLicensekey.setColumns(10);
        this.txtLicensekey.setHorizontalAlignment(0);
        this.txtLicensekey.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.warn();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.warn();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.warn();
            }

            public void warn() {
                EnterLicenseKeyWindow.this.keyHasChanged();
            }
        });
        this.panel = new JPanel();
        GridBagConstraints gbc_panel = new GridBagConstraints();
        gbc_panel.fill = 1;
        gbc_panel.gridx = 0;
        gbc_panel.gridy = 9;
        this.getContentPane().add((Component)this.panel, gbc_panel);
        GridBagLayout gbl_panel = new GridBagLayout();
        gbl_panel.columnWidths = new int[]{0, 0, 0, 0};
        gbl_panel.rowHeights = new int[]{0, 0, 0};
        gbl_panel.columnWeights = new double[]{1.0, 1.0, 1.0, Double.MIN_VALUE};
        gbl_panel.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        this.panel.setLayout(gbl_panel);
        this.btn_Cancel = new JButton("Cancel");
        this.btn_Cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EnterLicenseKeyWindow.this.cancelButtonClicked();
            }
        });
        GridBagConstraints gbc_btn_Cancel = new GridBagConstraints();
        gbc_btn_Cancel.insets = new Insets(0, 0, 0, 5);
        gbc_btn_Cancel.gridx = 0;
        gbc_btn_Cancel.gridy = 1;
        this.panel.add((Component)this.btn_Cancel, gbc_btn_Cancel);
        this.btn_OK = new JButton(okButtontext);
        this.btn_OK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                EnterLicenseKeyWindow.this.okButtonClicked();
            }
        });
        this.btn_OK.setEnabled(false);
        GridBagConstraints gbc_btn_OK = new GridBagConstraints();
        gbc_btn_OK.gridx = 2;
        gbc_btn_OK.gridy = 1;
        this.panel.add((Component)this.btn_OK, gbc_btn_OK);
    }

    protected void keyHasChanged() {
        boolean ok = false;
        System.out.println(this.getKeyString());
        ok = this.validator.isValidKey(this.getKey());
        this.btn_OK.setEnabled(ok);
    }

    protected void cancelButtonClicked() {
        this.canceled = true;
        this.setFinished();
        this.setVisible(false);
    }

    protected void okButtonClicked() {
        this.setFinished();
        this.setVisible(false);
    }

    private String getKeyString() {
        return this.canceled ? CANCEL : this.getKey();
    }

    private String getKey() {
        return this.txtLicensekey.getText();
    }

    private void setFinished() {
        this.setVisible(false);
        boolean savingNecessary = !this.formerKey.equals(this.getKey());
        try {
            this.callback.onLicenseKeyEntered(this.getKeyString(), this.numberOfRequests, savingNecessary);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static interface LicenseEnteredCallback {
        public void onLicenseKeyEntered(String var1, int var2, boolean var3) throws Exception;
    }
}

