/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.nina;

import com.hybridlab.hyve3d.files.ImportOptions;
import com.hybridlab.hyve3d.nina.ImportProcess;
import com.hybridlab.hyve3d.rendering.ErrorVisualizer;
import com.jme3.math.Quaternion;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ImportOptionsWindow
extends JFrame {
    private ImportProcess importProcess;
    private static final long serialVersionUID = -3253626827793826139L;
    private JTextField textField_scaleFloatValue;
    private JPanel panelScale;
    private JCheckBox chckbxScale;
    private JButton btnImport;
    private JButton button_scale_5;
    private JButton button_scale_4;
    private JButton button_scale_3;
    private JButton button_scale_1;
    private JButton button_scale_2;
    private JLabel lblScaleFactor;
    private JLabel lblErrorScale;
    private JCheckBox chckbxApplyRotation;
    private JPanel panelrotation;
    private JButton btnAllZero;
    private JLabel lblX;
    private JLabel lblY;
    private JLabel lblZ;
    private JTextField textFieldRotationX;
    private JTextField textFieldRotationY;
    private JTextField textFieldRotationZ;
    private JLabel lblerrorrotation;
    private JButton btnFaceUp;
    private JButton btnFaceDown;
    private JCheckBox checkBoxIsSelectable;
    private JPanel panel;
    private JRadioButton rdbtnInZeroPosition;
    private JLabel lblPlacement;
    private JRadioButton rdbtnInViewFront;
    private ErrorVisualizer errorVisualizer;
    private JPanel panel_1;
    private JCheckBox chckbxBackfaceCulling;

    public ImportOptionsWindow(ImportProcess p, ErrorVisualizer errorVisualizer) {
        this.errorVisualizer = errorVisualizer;
        this.importProcess = p;
        this.setTitle("Import Options");
        this.setSize(525, 457);
        JPanel panel_bottom = new JPanel();
        this.getContentPane().add((Component)panel_bottom, "South");
        panel_bottom.setLayout(new BorderLayout(0, 0));
        JButton btnCancel = new JButton("cancel");
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportOptionsWindow.this.cancel();
            }
        });
        panel_bottom.add((Component)btnCancel, "West");
        this.btnImport = new JButton("import");
        this.btnImport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ImportOptionsWindow.this.startTheProcess();
            }
        });
        panel_bottom.add(this.btnImport);
        JPanel panel_center = new JPanel();
        this.getContentPane().add((Component)panel_center, "Center");
        GridBagLayout gbl_panel_center = new GridBagLayout();
        gbl_panel_center.columnWidths = new int[]{0, 0, 0, 0, 0};
        gbl_panel_center.rowHeights = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        gbl_panel_center.columnWeights = new double[]{1.0, 0.0, 1.0, 1.0, Double.MIN_VALUE};
        gbl_panel_center.rowWeights = new double[]{1.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0, 1.0, Double.MIN_VALUE};
        panel_center.setLayout(gbl_panel_center);
        this.chckbxScale = new JCheckBox("apply scale factor");
        this.chckbxScale.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportOptionsWindow.this.scaleCheckBoxHit();
            }
        });
        GridBagConstraints gbc_chckbxScale = new GridBagConstraints();
        gbc_chckbxScale.anchor = 17;
        gbc_chckbxScale.insets = new Insets(0, 0, 5, 5);
        gbc_chckbxScale.gridx = 2;
        gbc_chckbxScale.gridy = 1;
        panel_center.add((Component)this.chckbxScale, gbc_chckbxScale);
        this.panelScale = new JPanel();
        GridBagConstraints gbc_panelScale = new GridBagConstraints();
        gbc_panelScale.insets = new Insets(0, 0, 5, 5);
        gbc_panelScale.fill = 1;
        gbc_panelScale.gridx = 2;
        gbc_panelScale.gridy = 2;
        panel_center.add((Component)this.panelScale, gbc_panelScale);
        GridBagLayout gbl_panelScale = new GridBagLayout();
        gbl_panelScale.columnWidths = new int[]{0, 0, 0, 0, 0, 0, 0};
        gbl_panelScale.rowHeights = new int[]{0, 0, 0};
        gbl_panelScale.columnWeights = new double[]{0.0, 0.0, 0.0, 1.0, 0.0, 0.0, Double.MIN_VALUE};
        gbl_panelScale.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        this.panelScale.setLayout(gbl_panelScale);
        this.lblScaleFactor = new JLabel("scale factor");
        GridBagConstraints gbc_lblScaleFactor = new GridBagConstraints();
        gbc_lblScaleFactor.anchor = 17;
        gbc_lblScaleFactor.insets = new Insets(0, 0, 5, 5);
        gbc_lblScaleFactor.gridx = 0;
        gbc_lblScaleFactor.gridy = 0;
        this.panelScale.add((Component)this.lblScaleFactor, gbc_lblScaleFactor);
        this.textField_scaleFloatValue = new JTextField();
        this.textField_scaleFloatValue.setHorizontalAlignment(4);
        this.textField_scaleFloatValue.setText("1.0");
        GridBagConstraints gbc_textFieldRotationX = new GridBagConstraints();
        gbc_textFieldRotationX.gridwidth = 3;
        gbc_textFieldRotationX.insets = new Insets(0, 0, 5, 5);
        gbc_textFieldRotationX.fill = 2;
        gbc_textFieldRotationX.gridx = 1;
        gbc_textFieldRotationX.gridy = 0;
        this.panelScale.add((Component)this.textField_scaleFloatValue, gbc_textFieldRotationX);
        this.textField_scaleFloatValue.setColumns(10);
        ActionListener scaleTextButtonActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportOptionsWindow.this.setScaleText(((JButton)e.getSource()).getText());
            }
        };
        this.button_scale_1 = new JButton("0.1");
        this.button_scale_1.addActionListener(scaleTextButtonActionListener);
        GridBagConstraints gbc_button_scale_1 = new GridBagConstraints();
        gbc_button_scale_1.fill = 2;
        gbc_button_scale_1.insets = new Insets(0, 0, 5, 5);
        gbc_button_scale_1.gridx = 4;
        gbc_button_scale_1.gridy = 0;
        this.panelScale.add((Component)this.button_scale_1, gbc_button_scale_1);
        this.button_scale_2 = new JButton("0.01");
        this.button_scale_2.addActionListener(scaleTextButtonActionListener);
        GridBagConstraints gbc_button_scale_2 = new GridBagConstraints();
        gbc_button_scale_2.fill = 2;
        gbc_button_scale_2.insets = new Insets(0, 0, 5, 0);
        gbc_button_scale_2.gridx = 5;
        gbc_button_scale_2.gridy = 0;
        this.panelScale.add((Component)this.button_scale_2, gbc_button_scale_2);
        this.button_scale_3 = new JButton("1.0");
        this.button_scale_3.addActionListener(scaleTextButtonActionListener);
        this.lblErrorScale = new JLabel("error");
        this.lblErrorScale.setForeground(Color.RED);
        this.lblErrorScale.setEnabled(false);
        GridBagConstraints gbc_lblErrorScale = new GridBagConstraints();
        gbc_lblErrorScale.gridwidth = 3;
        gbc_lblErrorScale.insets = new Insets(0, 0, 0, 5);
        gbc_lblErrorScale.gridx = 0;
        gbc_lblErrorScale.gridy = 1;
        this.panelScale.add((Component)this.lblErrorScale, gbc_lblErrorScale);
        GridBagConstraints gbc_button_scale_3 = new GridBagConstraints();
        gbc_button_scale_3.anchor = 13;
        gbc_button_scale_3.insets = new Insets(0, 0, 0, 5);
        gbc_button_scale_3.gridx = 3;
        gbc_button_scale_3.gridy = 1;
        this.panelScale.add((Component)this.button_scale_3, gbc_button_scale_3);
        this.button_scale_5 = new JButton("10.0");
        this.button_scale_5.addActionListener(scaleTextButtonActionListener);
        GridBagConstraints gbc_button_scale_5 = new GridBagConstraints();
        gbc_button_scale_5.fill = 2;
        gbc_button_scale_5.insets = new Insets(0, 0, 0, 5);
        gbc_button_scale_5.gridx = 4;
        gbc_button_scale_5.gridy = 1;
        this.panelScale.add((Component)this.button_scale_5, gbc_button_scale_5);
        this.button_scale_4 = new JButton("100.0");
        this.button_scale_4.addActionListener(scaleTextButtonActionListener);
        GridBagConstraints gbc_button_scale_4 = new GridBagConstraints();
        gbc_button_scale_4.fill = 2;
        gbc_button_scale_4.gridx = 5;
        gbc_button_scale_4.gridy = 1;
        this.panelScale.add((Component)this.button_scale_4, gbc_button_scale_4);
        DocumentListener documentChangeListener = new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent arg0) {
                ImportOptionsWindow.this.testValidValues();
            }

            @Override
            public void insertUpdate(DocumentEvent arg0) {
                ImportOptionsWindow.this.testValidValues();
            }

            @Override
            public void changedUpdate(DocumentEvent arg0) {
                ImportOptionsWindow.this.testValidValues();
            }
        };
        this.textField_scaleFloatValue.getDocument().addDocumentListener(documentChangeListener);
        this.setScalePanelEnabled(this.chckbxScale.isSelected());
        this.lblErrorScale.setText("");
        this.chckbxApplyRotation = new JCheckBox("apply rotation");
        this.chckbxApplyRotation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportOptionsWindow.this.rotationcheckboxHit();
            }
        });
        GridBagConstraints gbc_chckbxApplyRotation = new GridBagConstraints();
        gbc_chckbxApplyRotation.anchor = 17;
        gbc_chckbxApplyRotation.insets = new Insets(0, 0, 5, 5);
        gbc_chckbxApplyRotation.gridx = 2;
        gbc_chckbxApplyRotation.gridy = 3;
        panel_center.add((Component)this.chckbxApplyRotation, gbc_chckbxApplyRotation);
        this.panelrotation = new JPanel();
        GridBagConstraints gbc_panelrotation = new GridBagConstraints();
        gbc_panelrotation.insets = new Insets(0, 0, 5, 5);
        gbc_panelrotation.fill = 1;
        gbc_panelrotation.gridx = 2;
        gbc_panelrotation.gridy = 4;
        panel_center.add((Component)this.panelrotation, gbc_panelrotation);
        GridBagLayout gbl_panelrotation = new GridBagLayout();
        gbl_panelrotation.columnWidths = new int[]{0, 0, 0, 0, 0, 0};
        gbl_panelrotation.rowHeights = new int[]{0, 0, 0, 0};
        gbl_panelrotation.columnWeights = new double[]{1.0, 1.0, 1.0, 0.0, 0.0, Double.MIN_VALUE};
        gbl_panelrotation.rowWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};
        this.panelrotation.setLayout(gbl_panelrotation);
        this.lblX = new JLabel("X");
        GridBagConstraints gbc_lblX = new GridBagConstraints();
        gbc_lblX.insets = new Insets(0, 0, 5, 5);
        gbc_lblX.gridx = 0;
        gbc_lblX.gridy = 0;
        this.panelrotation.add((Component)this.lblX, gbc_lblX);
        this.lblY = new JLabel("Y");
        GridBagConstraints gbc_lblY = new GridBagConstraints();
        gbc_lblY.insets = new Insets(0, 0, 5, 5);
        gbc_lblY.gridx = 1;
        gbc_lblY.gridy = 0;
        this.panelrotation.add((Component)this.lblY, gbc_lblY);
        this.lblZ = new JLabel("Z");
        GridBagConstraints gbc_lblZ = new GridBagConstraints();
        gbc_lblZ.insets = new Insets(0, 0, 5, 5);
        gbc_lblZ.gridx = 2;
        gbc_lblZ.gridy = 0;
        this.panelrotation.add((Component)this.lblZ, gbc_lblZ);
        this.btnAllZero = new JButton("all zero");
        this.btnAllZero.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportOptionsWindow.this.setRotationTexts("0.0", "0.0", "0.0");
            }
        });
        GridBagConstraints gbc_btnAllZero = new GridBagConstraints();
        gbc_btnAllZero.fill = 2;
        gbc_btnAllZero.insets = new Insets(0, 0, 5, 0);
        gbc_btnAllZero.gridx = 4;
        gbc_btnAllZero.gridy = 0;
        this.panelrotation.add((Component)this.btnAllZero, gbc_btnAllZero);
        this.textFieldRotationX = new JTextField();
        this.textFieldRotationX.setText("0.0");
        this.textFieldRotationX.setHorizontalAlignment(4);
        this.textFieldRotationX.setEnabled(false);
        this.textFieldRotationX.setColumns(10);
        GridBagConstraints gbc_textFieldRotationX2 = new GridBagConstraints();
        gbc_textFieldRotationX2.insets = new Insets(0, 0, 5, 5);
        gbc_textFieldRotationX2.fill = 2;
        gbc_textFieldRotationX2.gridx = 0;
        gbc_textFieldRotationX2.gridy = 1;
        this.panelrotation.add((Component)this.textFieldRotationX, gbc_textFieldRotationX2);
        this.textFieldRotationY = new JTextField();
        this.textFieldRotationY.setText("0.0");
        this.textFieldRotationY.setHorizontalAlignment(4);
        this.textFieldRotationY.setEnabled(false);
        this.textFieldRotationY.setColumns(10);
        GridBagConstraints gbc_textFieldRotationY = new GridBagConstraints();
        gbc_textFieldRotationY.insets = new Insets(0, 0, 5, 5);
        gbc_textFieldRotationY.fill = 2;
        gbc_textFieldRotationY.gridx = 1;
        gbc_textFieldRotationY.gridy = 1;
        this.panelrotation.add((Component)this.textFieldRotationY, gbc_textFieldRotationY);
        this.textFieldRotationZ = new JTextField();
        this.textFieldRotationZ.setText("0.0");
        this.textFieldRotationZ.setHorizontalAlignment(4);
        this.textFieldRotationZ.setEnabled(false);
        this.textFieldRotationZ.setColumns(10);
        GridBagConstraints gbc_textFieldRotationZ = new GridBagConstraints();
        gbc_textFieldRotationZ.insets = new Insets(0, 0, 5, 5);
        gbc_textFieldRotationZ.fill = 2;
        gbc_textFieldRotationZ.gridx = 2;
        gbc_textFieldRotationZ.gridy = 1;
        this.panelrotation.add((Component)this.textFieldRotationZ, gbc_textFieldRotationZ);
        this.textFieldRotationZ.getDocument().addDocumentListener(documentChangeListener);
        this.textFieldRotationY.getDocument().addDocumentListener(documentChangeListener);
        this.textFieldRotationX.getDocument().addDocumentListener(documentChangeListener);
        this.btnFaceUp = new JButton("X = -90");
        this.btnFaceUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportOptionsWindow.this.setRotationTexts("-90.0", "0.0", "0.0");
            }
        });
        GridBagConstraints gbc_btnFaceUp = new GridBagConstraints();
        gbc_btnFaceUp.fill = 2;
        gbc_btnFaceUp.insets = new Insets(0, 0, 5, 0);
        gbc_btnFaceUp.gridx = 4;
        gbc_btnFaceUp.gridy = 1;
        this.panelrotation.add((Component)this.btnFaceUp, gbc_btnFaceUp);
        this.lblerrorrotation = new JLabel("");
        this.lblerrorrotation.setForeground(Color.RED);
        GridBagConstraints gbc_lblerrorrotation = new GridBagConstraints();
        gbc_lblerrorrotation.gridwidth = 3;
        gbc_lblerrorrotation.insets = new Insets(0, 0, 0, 5);
        gbc_lblerrorrotation.gridx = 0;
        gbc_lblerrorrotation.gridy = 2;
        this.panelrotation.add((Component)this.lblerrorrotation, gbc_lblerrorrotation);
        this.btnFaceDown = new JButton("X = +90");
        this.btnFaceDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportOptionsWindow.this.setRotationTexts("90.0", "0.0", "0.0");
            }
        });
        GridBagConstraints gbc_btnFaceDown = new GridBagConstraints();
        gbc_btnFaceDown.fill = 2;
        gbc_btnFaceDown.gridx = 4;
        gbc_btnFaceDown.gridy = 2;
        this.panelrotation.add((Component)this.btnFaceDown, gbc_btnFaceDown);
        boolean initiallySelected = this.importProcess.getOptions().getIsSelectable();
        boolean initiallyBackFaceCulling = this.importProcess.getOptions().getBackfaceCulling();
        this.panel_1 = new JPanel();
        FlowLayout flowLayout = (FlowLayout)this.panel_1.getLayout();
        flowLayout.setAlignment(0);
        GridBagConstraints gbc_panel_1 = new GridBagConstraints();
        gbc_panel_1.insets = new Insets(0, 0, 5, 5);
        gbc_panel_1.fill = 1;
        gbc_panel_1.gridx = 2;
        gbc_panel_1.gridy = 5;
        panel_center.add((Component)this.panel_1, gbc_panel_1);
        this.checkBoxIsSelectable = new JCheckBox("selectable", initiallySelected);
        this.panel_1.add(this.checkBoxIsSelectable);
        this.chckbxBackfaceCulling = new JCheckBox("backface culling", initiallyBackFaceCulling);
        this.chckbxBackfaceCulling.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ImportOptionsWindow.this.bfcCheckBoxHit();
            }
        });
        this.panel_1.add(this.chckbxBackfaceCulling);
        this.checkBoxIsSelectable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ImportOptionsWindow.this.selectableCheckBoxHit();
            }
        });
        this.panel = new JPanel();
        GridBagConstraints gbc_panel = new GridBagConstraints();
        gbc_panel.insets = new Insets(0, 0, 5, 5);
        gbc_panel.fill = 1;
        gbc_panel.gridx = 2;
        gbc_panel.gridy = 7;
        panel_center.add((Component)this.panel, gbc_panel);
        GridBagLayout gbl_panel = new GridBagLayout();
        gbl_panel.columnWidths = new int[]{0, 0, 0, 0, 0, 0};
        gbl_panel.rowHeights = new int[]{0, 0};
        gbl_panel.columnWeights = new double[]{0.0, 1.0, 0.0, 1.0, 0.0, Double.MIN_VALUE};
        gbl_panel.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.panel.setLayout(gbl_panel);
        this.lblPlacement = new JLabel("Placement");
        GridBagConstraints gbc_lblPlacement = new GridBagConstraints();
        gbc_lblPlacement.insets = new Insets(0, 0, 0, 5);
        gbc_lblPlacement.gridx = 0;
        gbc_lblPlacement.gridy = 0;
        this.panel.add((Component)this.lblPlacement, gbc_lblPlacement);
        initiallySelected = this.importProcess.getOptions().getPlacement().equals((Object)ImportOptions.Placement.VIEW_FRONT);
        this.rdbtnInViewFront = new JRadioButton("in view front ", initiallySelected);
        this.rdbtnInViewFront.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ImportOptionsWindow.this.RadioButtonClicked(ImportOptionsWindow.this.rdbtnInViewFront);
            }
        });
        GridBagConstraints gbc_rdbtnInViewFront = new GridBagConstraints();
        gbc_rdbtnInViewFront.insets = new Insets(0, 0, 0, 5);
        gbc_rdbtnInViewFront.gridx = 2;
        gbc_rdbtnInViewFront.gridy = 0;
        this.panel.add((Component)this.rdbtnInViewFront, gbc_rdbtnInViewFront);
        initiallySelected = this.importProcess.getOptions().getPlacement().equals((Object)ImportOptions.Placement.ZERO_POSITION);
        this.rdbtnInZeroPosition = new JRadioButton("in root position", initiallySelected);
        this.rdbtnInZeroPosition.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportOptionsWindow.this.RadioButtonClicked(ImportOptionsWindow.this.rdbtnInZeroPosition);
            }
        });
        GridBagConstraints gbc_rdbtnInZeroPosition = new GridBagConstraints();
        gbc_rdbtnInZeroPosition.gridx = 4;
        gbc_rdbtnInZeroPosition.gridy = 0;
        this.panel.add((Component)this.rdbtnInZeroPosition, gbc_rdbtnInZeroPosition);
        this.setRotationPanelEnabled(this.chckbxApplyRotation.isSelected());
    }

    protected void RadioButtonClicked(JRadioButton which) {
        if (which == this.rdbtnInViewFront) {
            this.rdbtnInZeroPosition.setSelected(!this.rdbtnInViewFront.isSelected());
        } else if (which == this.rdbtnInZeroPosition) {
            this.rdbtnInViewFront.setSelected(!this.rdbtnInZeroPosition.isSelected());
        }
        this.importProcess.getOptions().setPlacement(this.rdbtnInViewFront.isSelected() ? ImportOptions.Placement.VIEW_FRONT : ImportOptions.Placement.ZERO_POSITION);
    }

    protected void selectableCheckBoxHit() {
        boolean selectable = this.checkBoxIsSelectable.isSelected();
        this.importProcess.getOptions().setIsSelectable(selectable);
    }

    protected void bfcCheckBoxHit() {
        boolean bfc = this.chckbxBackfaceCulling.isSelected();
        this.importProcess.getOptions().setBackfaceCulling(bfc);
    }

    protected void setRotationTexts(String string, String string2, String string3) {
        this.textFieldRotationX.setText(string);
        this.textFieldRotationY.setText(string2);
        this.textFieldRotationZ.setText(string3);
    }

    protected void rotationcheckboxHit() {
        this.setRotationPanelEnabled(this.chckbxApplyRotation.isSelected());
        this.testValidValues();
    }

    private void setRotationPanelEnabled(boolean enabled) {
        this.panelrotation.setEnabled(enabled);
        this.textFieldRotationX.setEnabled(enabled);
        this.textFieldRotationY.setEnabled(enabled);
        this.textFieldRotationZ.setEnabled(enabled);
        this.lblerrorrotation.setEnabled(enabled);
        this.btnFaceDown.setEnabled(enabled);
        this.btnFaceUp.setEnabled(enabled);
        this.btnAllZero.setEnabled(enabled);
        this.lblX.setEnabled(enabled);
        this.lblY.setEnabled(enabled);
        this.lblZ.setEnabled(enabled);
    }

    private void setScalePanelEnabled(boolean enabled) {
        this.panelScale.setEnabled(enabled);
        this.textField_scaleFloatValue.setEnabled(enabled);
        this.lblScaleFactor.setEnabled(enabled);
        this.button_scale_5.setEnabled(enabled);
        this.button_scale_1.setEnabled(enabled);
        this.button_scale_2.setEnabled(enabled);
        this.button_scale_3.setEnabled(enabled);
        this.button_scale_4.setEnabled(enabled);
        this.lblErrorScale.setEnabled(enabled);
    }

    protected void setScaleText(String text) {
        this.textField_scaleFloatValue.setText(text);
    }

    protected void scaleCheckBoxHit() {
        this.setScalePanelEnabled(this.chckbxScale.isSelected());
        this.testValidValues();
    }

    private void testValidValues() {
        boolean isValid;
        block12: {
            isValid = true;
            boolean scaleEnabled = this.chckbxScale.isSelected();
            if (scaleEnabled) {
                try {
                    Float f = Float.valueOf(Float.parseFloat(this.textField_scaleFloatValue.getText().trim()));
                    if (f.floatValue() <= 0.0f) {
                        this.lblErrorScale.setText("must be > 0");
                        isValid = false;
                        break block12;
                    }
                    this.setScale(f);
                    this.lblErrorScale.setText("");
                }
                catch (NumberFormatException nfe) {
                    this.lblErrorScale.setText("no valid number");
                    isValid = false;
                }
            } else {
                this.setScale(null);
            }
        }
        boolean rotationEnabled = this.chckbxApplyRotation.isSelected();
        if (rotationEnabled) {
            try {
                float fx = Float.parseFloat(this.textFieldRotationX.getText().trim());
                float fy = Float.parseFloat(this.textFieldRotationY.getText().trim());
                float fz = Float.parseFloat(this.textFieldRotationZ.getText().trim());
                float[] angles = new float[]{(float)Math.PI / 180 * fx, (float)Math.PI / 180 * fy, (float)Math.PI / 180 * fz};
                Quaternion rot = new Quaternion(angles);
                this.setRotation(rot);
                this.lblerrorrotation.setText("");
            }
            catch (NumberFormatException nfe) {
                this.lblerrorrotation.setText("no valid number");
                isValid = false;
            }
            catch (Exception e) {
                this.lblerrorrotation.setText("error");
                isValid = false;
            }
        } else {
            this.setRotation(null);
        }
        if (isValid) {
            this.btnImport.setEnabled(true);
        } else {
            this.btnImport.setEnabled(false);
        }
    }

    private void setRotation(Quaternion r) {
        this.importProcess.getOptions().setRotation(r);
    }

    private void cancel() {
        this.setVisible(false);
        this.cleanup();
    }

    private void cleanup() {
        this.dispose();
        this.importProcess = null;
    }

    private void setScale(Float scale) {
        this.importProcess.getOptions().setScaleFactor(scale);
    }

    private void startTheProcess() {
        try {
            Thread importThread = new Thread((Runnable)this.importProcess, "importing " + this.importProcess.describeMe());
            importThread.start();
            this.cleanup();
        }
        catch (Exception e) {
            this.errorVisualizer.showReasonOfException(e);
            e.printStackTrace();
        }
    }
}

