/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.nina;

import com.hybridlab.hyve3d.config.MaskProperties;
import com.hybridlab.hyve3d.config.RingMaskProperties;
import com.hybridlab.hyve3d.config.ShiftHVProperties;
import com.hybridlab.hyve3d.core.HisSphericalRendererApplication;
import com.hybridlab.hyve3d.core.Transformable;
import com.hybridlab.hyve3d.core.animation.AnimationTrigger;
import com.hybridlab.hyve3d.hyve.Hyve;
import com.hybridlab.hyve3d.hyve.HyveApplication;
import com.hybridlab.hyve3d.hyve.OrthoShooter;
import com.hybridlab.hyve3d.hyve.SessionVisualizer;
import com.hybridlab.hyve3d.nina.BackGroundWindow;
import com.hybridlab.hyve3d.nina.CalibrationConfiguration;
import com.hybridlab.hyve3d.nina.FeatureValidator;
import com.hybridlab.hyve3d.nina.ImmersionMode;
import com.hybridlab.hyve3d.nina.Jme3DualViewPortRenderer;
import com.hybridlab.hyve3d.nina.NScreenshotAppState;
import com.hybridlab.hyve3d.nina.Nina;
import com.hybridlab.hyve3d.nina.QuitHandler;
import com.hybridlab.hyve3d.rendering.ErrorVisualizer;
import com.hybridlab.hyve3d.rendering.Jme3HyveSceneManager;
import com.hybridlab.hyve3d.rendering.Jme3SessionVisualizer;
import com.hybridlab.hyve3d.rendering.Jme3ThreadingHelper;
import com.hybridlab.hyve3d.rendering.ProgressVisualizer;
import com.hybridlab.hyve3d.rendering.spherical.ProjectionCalibrator;
import com.hybridlab.licensing.Feature;
import com.hybridlab.licensing.LicenseKey;
import com.jme3.app.Application;
import com.jme3.app.SimpleApplication;
import com.jme3.app.state.AppState;
import com.jme3.input.controls.InputListener;
import com.jme3.input.controls.KeyTrigger;
import com.jme3.input.controls.Trigger;
import com.jme3.renderer.Camera;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Spatial;
import com.jme3.system.AppSettings;
import com.jme3.system.JmeSystem;
import com.jme3.texture.FrameBuffer;
import com.jme3.texture.Image;
import com.jme3.texture.TextureCubeMap;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.apache.commons.io.FileUtils;

@Deprecated
public class Jme3ApplicationWindow
extends SimpleApplication
implements Jme3ThreadingHelper {
    private String windowTitle = "Jme3Window";
    private Dimension dimensionsOfDefaultScreen;
    private Dimension windowSize = new Dimension(800, 600);
    private Dimension windowSizeNonFullscreen = new Dimension(800, 600);
    private boolean fullscreen = true;
    private Point windowPosition = new Point(0, 0);
    private Point windowPositionNonFullScreen = new Point(100, 100);
    private BackGroundWindow backWin;
    private JFrame viewerWindow;
    private QuitHandler quitHandler;
    private HyveApplication app;
    private Jme3HyveSceneManager sceneManager;
    private Jme3SessionVisualizer sessionVisualizer;
    private Thread renderThread;
    private Jme3DualViewPortRenderer dvRenderer;
    private CalibrationConfiguration calibrationConfiguration;
    private boolean moreThanOneScreenAvailable = false;
    private JmeUpdateFrameTrigger animationTrigger;
    private Set<Feature> features = Collections.emptySet();
    private ProgressVisualizer progVis = new ProgressVisualizer(){

        @Override
        public void setProgressText(String id, String txt) {
            System.out.println(txt);
        }

        @Override
        public void setProgressComplete(String id) {
        }
    };
    private ErrorVisualizer errorVisualizer = new ErrorVisualizer(){

        @Override
        public void showReasonOfException(Exception e) {
            Throwable t = e.getCause();
            Jme3ApplicationWindow.this.msgbox(e.toString() + (String)(t != null ? "\n" + t.toString() : ""));
        }

        @Override
        public void showReasonOfExceptionWithoutExceptionName(Exception e) {
            Throwable t = e.getCause();
            Jme3ApplicationWindow.this.msgbox(e.getLocalizedMessage() + (String)(t != null ? "\n" + t.getLocalizedMessage() : ""));
        }
    };
    private boolean enabled = false;
    private MaskProperties maskProperties;
    private final Integer cubeTextureResolution;
    private Map<TextureCubeMap.Face, Boolean> enabledFaces;
    private RingMaskProperties ringMaskProperties;
    private boolean startInSphericalMode = false;
    private ShiftHVProperties shiftProperties;
    private Nina.BeginAdapter beginAdapter;
    protected JFrame dialogParentWindow;
    final Runnable clickSimulator = new Runnable(){

        @Override
        public void run() {
            JButton b = Jme3ApplicationWindow.this.backWin.getForeGroundButton();
            b.doClick();
        }
    };
    private Point centerOfDefaultScreen;
    private JPanel canvasPanel;
    private Canvas canvas;

    public ErrorVisualizer getErrorVisualizer() {
        return this.errorVisualizer;
    }

    private void msgbox(String s) {
        JOptionPane.showMessageDialog(null, s);
    }

    public void setLicense(LicenseKey license) {
        if (license == null) {
            this.setDisabled();
        } else if (license.hasBeenMarkedValid()) {
            this.setEnabled();
        } else {
            this.setDisabled();
        }
    }

    private void setFeatures(Set<Feature> features) {
        this.features = features;
    }

    public boolean isStartInSphericalMode() {
        return this.startInSphericalMode;
    }

    private void setDisabled() {
        this.enabled = false;
        this.enabledChanged();
    }

    private void enabledChanged() {
        if (this.dvRenderer != null) {
            this.dvRenderer.setEnabled(this.isEnabled());
        }
    }

    private void setEnabled() {
        this.enabled = true;
        this.enabledChanged();
    }

    private boolean isEnabled() {
        return this.enabled;
    }

    public Jme3ApplicationWindow(String windowTitle, boolean fullscreen, int sizeNonFullscreen, CalibrationConfiguration calibrationConfiguration, ShiftHVProperties shiftProperties, MaskProperties maskProperties, RingMaskProperties ringmaskproperties, QuitHandler quitHandler, HyveApplication app, Integer cubeTextureResolution, Map<TextureCubeMap.Face, Boolean> enabledFaces, Set<Feature> featuresLicensed, Nina.BeginAdapter beginAdapter) throws Exception {
        JmeSystem.setLowPermissions((boolean)false);
        this.setFeatures(featuresLicensed);
        this.beginAdapter = beginAdapter;
        this.cubeTextureResolution = cubeTextureResolution;
        this.animationTrigger = new JmeUpdateFrameTrigger();
        this.enabledFaces = enabledFaces;
        this.app = app;
        this.quitHandler = quitHandler;
        this.fullscreen = fullscreen;
        this.windowTitle = windowTitle;
        this.windowSizeNonFullscreen.setSize(sizeNonFullscreen, sizeNonFullscreen);
        this.calibrationConfiguration = calibrationConfiguration;
        this.maskProperties = maskProperties;
        this.shiftProperties = shiftProperties;
        this.ringMaskProperties = ringmaskproperties;
        this.obtainScreenSizeInformations();
        if (!this.moreThanOneScreenAvailable) {
            this.fullscreen = false;
        }
        this.startInSphericalMode = this.features.contains((Object)Feature.IMMERSIVE) && this.moreThanOneScreenAvailable;
        AppSettings settings = new AppSettings(true);
        settings.setBitsPerPixel(32);
        settings.setVSync(true);
        settings.setTitle(this.windowTitle);
        settings.setResolution(this.windowSize.width, this.windowSize.height);
        settings.setResolution(this.windowSize.width, this.windowSize.height);
        settings.setSamples(1);
        settings.setRenderer("LWJGL-OpenGL33");
        this.setShowSettings(false);
        this.settings = settings;
        for (Map.Entry ks : settings.entrySet()) {
            System.out.println((String)ks.getKey() + " = " + ks.getValue().toString());
        }
        boolean checkFeatures = true;
        boolean featuresvalid = false;
        if (checkFeatures) {
            if (!this.moreThanOneScreenAvailable && FeatureValidator.mayActivateImmersive(this.features) && !FeatureValidator.mayActivateNonImmersive(this.features)) {
                this.quitAfterMessage("You have to connect a projector to run Hyve-3D immersive.");
            }
            featuresvalid = true;
        }
        if (featuresvalid || !checkFeatures) {
            this.createBackGroundWindow();
            this.createViewerWindow();
        } else {
            this.quitAfterMessage("Application quit due to insufficient license key.");
        }
    }

    private void quitAfterMessage(String string) throws Exception {
        Exception e = new Exception(string);
        this.errorVisualizer.showReasonOfExceptionWithoutExceptionName(e);
        this.systemExitDelayed(1000);
        throw e;
    }

    private void systemExitDelayed(int millis) {
        Timer timer = new Timer();
        long delay = millis;
        if (millis > 0) {
            System.out.println("sheduling 'System.exit(0))' to be called in " + String.valueOf(millis) + " Milliseconds ...");
        }
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                System.out.println("calling 'System.exit(0))' from within " + Jme3ApplicationWindow.class.getName() + " now!");
                System.exit(0);
            }
        }, delay);
    }

    public void enableImmersiveMode() {
        this.dvRenderer.enableImmersiveMode();
        if (!this.fullscreen) {
            this.setFullscreen(true);
        }
    }

    public void enableNonImmersiveMode() {
        this.dvRenderer.enableNonImmersiveMode();
    }

    public void toggleAppMode() {
        this.dvRenderer.toggleAppMode();
    }

    public void toggleFullScreen() {
        this.setFullscreen(!this.fullscreen);
    }

    public boolean isFullScreen() {
        return this.fullscreen;
    }

    public void setFullscreen(boolean full) {
        this.fullscreen = full;
        this.setBackGroundWindowVisibility(this.fullscreen && this.moreThanOneScreenAvailable);
        if (!this.viewerWindow.isUndecorated()) {
            this.viewerWindow.setUndecorated(this.fullscreen);
        }
        this.placeViewerWindow();
    }

    public void setFlyCamInteractionEnabled(final boolean enabled) {
        this.enqueue(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                Jme3ApplicationWindow.this.flyCam.setEnabled(enabled);
                Jme3ApplicationWindow.this.flyCam.setDragToRotate(enabled);
                return null;
            }
        });
    }

    public void start() {
        super.start();
    }

    public void stop() {
        this.backWin.setVisible(false);
        this.backWin.dispose();
        this.viewerWindow.setVisible(false);
        this.viewerWindow.dispose();
        super.stop();
    }

    public void simpleInitApp() {
        this.renderThread = Thread.currentThread();
        NScreenshotAppState screenShotState = new NScreenshotAppState();
        this.stateManager.attach((AppState)screenShotState);
        this.inputManager.addMapping("ScreenShot", new Trigger[]{new KeyTrigger(57)});
        this.inputManager.addListener((InputListener)screenShotState, new String[]{"ScreenShot"});
        this.setPauseOnLostFocus(false);
        boolean showBackGroundWindowInAnyCaseForDebugPurposes = false;
        this.setBackGroundWindowVisibility(this.fullscreen && this.moreThanOneScreenAvailable || showBackGroundWindowInAnyCaseForDebugPurposes);
        this.setDisplayStatView(false);
        this.setDisplayFps(true);
        this.flyCam.setEnabled(false);
        this.inputManager.setCursorVisible(true);
        String tempFolder = "/tmp/hyvesession-" + this.app.getLocalSessionId().toString() + "/";
        try {
            FileUtils.forceMkdir(new File(tempFolder));
        }
        catch (IOException e1) {
            this.errorVisualizer.showReasonOfException(e1);
            e1.printStackTrace();
        }
        this.sceneManager = new Jme3HyveSceneManager(this.assetManager, this, this.errorVisualizer, tempFolder);
        this.sessionVisualizer = new Jme3SessionVisualizer((Application)this, this.app, this.sceneManager, this.progVis);
        this.sessionVisualizer.simpleInit();
        this.sceneManager.getSceneNode().attachChild((Spatial)this.sessionVisualizer.getSessionVisualizationRootNode());
        System.out.println("viewerWindow.getSize(): " + this.viewerWindow.getSize().toString());
        this.dvRenderer = new Jme3DualViewPortRenderer(this.assetManager, this.renderManager, this.rootNode, this.sceneManager.getSceneNode(), this.flyCam, this.cam, this.sceneManager, this, this.calibrationConfiguration, this.shiftProperties, this.maskProperties, this.ringMaskProperties, this.viewerWindow.getSize(), this.startInSphericalMode ? HisSphericalRendererApplication.AppMode.SPHERICAL : HisSphericalRendererApplication.AppMode.FRUSTUM, this.cubeTextureResolution, this.enabledFaces);
        this.dvRenderer.simpleInit();
        this.viewerWindow.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Jme3ApplicationWindow.this.dvRenderer.onWindowResized(Jme3ApplicationWindow.this.viewerWindow.getSize());
            }
        });
        this.dvRenderer.setEnabled(this.isEnabled());
        this.shiftProperties.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (e.getSource() == Jme3ApplicationWindow.this.shiftProperties && (e.getPropertyName().equals("shiftH") || e.getPropertyName().equals("shiftV"))) {
                    Jme3ApplicationWindow.this.placeCanvas();
                }
            }
        });
        this.vpinfo();
    }

    public void vpinfo() {
        System.out.println("--------------------\nViewport info\n--------------------");
        ArrayList allvps = new ArrayList();
        allvps.addAll(this.renderManager.getMainViews());
        allvps.addAll(this.renderManager.getPreViews());
        allvps.addAll(this.renderManager.getPostViews());
        for (ViewPort vp : allvps) {
            FrameBuffer.RenderBuffer cb;
            String n = vp.getName();
            Camera c = vp.getCamera();
            FrameBuffer fb = vp.getOutputFrameBuffer();
            Image.Format f = null;
            if (fb != null && (cb = fb.getColorBuffer()) != null) {
                f = cb.getFormat();
            }
            System.out.println(String.format("vp: %s, cam: %s, format=%s", n, c, f));
        }
    }

    public Jme3HyveSceneManager getSceneManager() {
        return this.sceneManager;
    }

    public Transformable getCameraRig() {
        if (this.dvRenderer == null) {
            throw new RuntimeException("Unallowed Access before correct initialization!");
        }
        return this.dvRenderer.getCameraRig();
    }

    public void simpleUpdate(float tpf) {
        this.animationTrigger.update(tpf);
        this.sessionVisualizer.simpleUpdate(tpf);
        this.dvRenderer.simpleUpdate(tpf);
        super.simpleUpdate(tpf);
    }

    BackGroundWindow getBackgroundWindow() {
        return this.backWin;
    }

    private void setBackGroundWindowVisibility(final boolean visible) {
        Runnable createBackgroundRunner = new Runnable(){

            @Override
            public void run() {
                Jme3ApplicationWindow.this.backWin.setVisible(visible);
                Jme3ApplicationWindow.this.dialogParentWindow = visible ? Jme3ApplicationWindow.this.backWin : Jme3ApplicationWindow.this.viewerWindow;
                SwingUtilities.invokeLater(Jme3ApplicationWindow.this.clickSimulator);
            }
        };
        SwingUtilities.invokeLater(createBackgroundRunner);
    }

    private void createBackGroundWindow() {
        Runnable createBackgroundRunner = new Runnable(){

            @Override
            public void run() {
                Jme3ApplicationWindow.this.backWin = new BackGroundWindow(new BackGroundWindow.BeginClickCallback(){

                    @Override
                    public void beginWasClicked() {
                        System.out.println("begin was clicked ...");
                        Jme3ApplicationWindow.this.beginAdapter.beginWasclicked();
                    }
                }, Jme3ApplicationWindow.this.isFullScreen());
                Jme3ApplicationWindow.this.backWin.setBackground(Color.DARK_GRAY);
                Jme3ApplicationWindow.this.backWin.setDefaultCloseOperation(0);
                Jme3ApplicationWindow.this.backWin.setUndecorated(true);
                Jme3ApplicationWindow.this.backWin.setSize(Jme3ApplicationWindow.this.dimensionsOfDefaultScreen.width, Jme3ApplicationWindow.this.dimensionsOfDefaultScreen.height);
                Jme3ApplicationWindow.this.backWin.setLocation(new Point(0, 0));
                Jme3ApplicationWindow.this.progVis = Jme3ApplicationWindow.this.backWin;
                System.out.println("setting progVis to:" + Jme3ApplicationWindow.this.progVis);
                if (Jme3ApplicationWindow.this.sessionVisualizer != null) {
                    Jme3ApplicationWindow.this.sessionVisualizer.setProgressVisualizer(Jme3ApplicationWindow.this.progVis);
                }
                SwingUtilities.invokeLater(Jme3ApplicationWindow.this.clickSimulator);
            }
        };
        SwingUtilities.invokeLater(createBackgroundRunner);
    }

    public ProgressVisualizer getProgressVisualizer() {
        return this.progVis;
    }

    public Jme3DualViewPortRenderer.MaskModifier getMaskModifier() {
        return this.dvRenderer.getMaskModifier();
    }

    public ProjectionCalibrator getProjectionCalibrator() {
        return this.dvRenderer.getProjectionCalibrator();
    }

    private void obtainScreenSizeInformations() {
        GraphicsDevice defaultScreenDevice;
        GraphicsEnvironment environment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] screens = environment.getScreenDevices();
        int numScreens = screens.length;
        GraphicsDevice displayDevice = defaultScreenDevice = environment.getDefaultScreenDevice();
        for (int i = 0; i < numScreens; ++i) {
            GraphicsDevice screen = screens[i];
            System.out.println("screenid=" + i + " idString=" + screen.getIDstring());
            DisplayMode mode = screen.getDisplayMode();
            int screenWidth = mode.getWidth();
            int screenHeight = mode.getHeight();
            if (defaultScreenDevice != screen) {
                displayDevice = screen;
                this.moreThanOneScreenAvailable = true;
            }
            if (defaultScreenDevice != screen) continue;
            this.dimensionsOfDefaultScreen = new Dimension(screenWidth, screenHeight);
        }
        Rectangle gcBounds = displayDevice.getDefaultConfiguration().getBounds();
        this.windowPosition = new Point(gcBounds.x, gcBounds.y);
        Rectangle defaultScreenBounds = defaultScreenDevice.getDefaultConfiguration().getBounds();
        this.centerOfDefaultScreen = new Point(defaultScreenBounds.x + defaultScreenBounds.width / 2, defaultScreenBounds.y + defaultScreenBounds.height / 2);
    }

    public Point getCenterOfDefaultScreen() {
        return this.centerOfDefaultScreen;
    }

    private void createViewerWindow() {
        this.start();
        this.viewerWindow = new JFrame(this.windowTitle);
        this.viewerWindow.setBackground(Color.BLACK);
        this.viewerWindow.setBackground(Color.MAGENTA);
        this.viewerWindow.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
                System.out.println("calling 'quitHandler.quit()' from within " + Jme3ApplicationWindow.class.getName());
                Jme3ApplicationWindow.this.quitHandler.quit(QuitHandler.Source.Window);
            }
        });
        this.viewerWindow.setDefaultCloseOperation(0);
        this.canvasPanel = new JPanel();
        this.canvasPanel.setLayout(null);
        this.viewerWindow.add(this.canvasPanel);
        this.viewerWindow.addComponentListener(new ResizeListener());
        this.viewerWindow.setUndecorated(this.fullscreen);
    }

    public JFrame getDialogParentWindow() {
        if (this.dialogParentWindow != null) {
            return this.dialogParentWindow;
        }
        if (this.backWin.isVisible()) {
            return this.backWin;
        }
        return this.viewerWindow;
    }

    private void placeCanvas() {
        int canvasHeight;
        int canvasWidth;
        this.debugOutput("---- placeCanvas was called ... ");
        this.debugOutput("----   fullscreen = " + String.valueOf(this.fullscreen));
        Point canvasShift = new Point((int)this.shiftProperties.getShiftH(), (int)this.shiftProperties.getShiftV());
        int canvasX = canvasShift.x;
        int canvasY = canvasShift.y;
        if (this.fullscreen) {
            this.debugOutput("----    windowSize = " + this.windowSize.toString());
            canvasWidth = this.windowSize.width + canvasShift.x;
            canvasHeight = this.windowSize.height + canvasShift.y;
        } else {
            Dimension dim = this.viewerWindow.getSize();
            this.debugOutput("----    dim = " + dim.toString());
            canvasWidth = dim.width + canvasShift.x;
            canvasHeight = dim.height + canvasShift.y;
        }
        if (this.canvas != null) {
            this.canvas.setBounds(canvasX, canvasY, canvasWidth, canvasHeight);
        }
        this.debugOutput("----    canvasX = " + String.valueOf(canvasX));
        this.debugOutput("----    canvasY = " + String.valueOf(canvasY));
        this.debugOutput("----    canvasWidth = " + String.valueOf(canvasWidth));
        this.debugOutput("----    canvasHeight = " + String.valueOf(canvasHeight));
    }

    private void debugOutput(String s) {
        System.out.println(s);
    }

    private void placeViewerWindow() {
        this.debugOutput("---- placeViewerWindow was called ... ");
        this.debugOutput("----   fullscreen = " + String.valueOf(this.fullscreen));
        if (this.fullscreen) {
            this.debugOutput("----   windowSize = " + this.windowSize.toString());
            this.debugOutput("----   windowPosition = " + this.windowPosition.toString());
            this.viewerWindow.setSize(this.windowSize.width, this.windowSize.height);
            this.viewerWindow.setLocation(this.windowPosition);
            this.placeCanvas();
        } else {
            this.debugOutput("----   windowSizeNonFullscreen = " + this.windowSizeNonFullscreen.toString());
            this.debugOutput("----   windowPositionNonFullScreen = " + this.windowPositionNonFullScreen.toString());
            this.viewerWindow.setSize(this.windowSizeNonFullscreen.width, this.windowSizeNonFullscreen.height);
            this.viewerWindow.setLocation(this.windowPositionNonFullScreen);
            this.placeCanvas();
        }
        this.viewerWindow.setVisible(true);
    }

    public SessionVisualizer getSessionVisualizer() {
        return this.sessionVisualizer;
    }

    @Override
    public boolean isThreadEqualToRenderThread(Thread currentThread) {
        return this.renderThread.equals(currentThread);
    }

    public void updateFPSVisualization() {
        this.backWin.setFPSText(String.format("frames per second: %1f", Float.valueOf(this.timer.getFrameRate())));
    }

    public void updateProgressVisualization() {
        this.backWin.updateProgressVisualization();
    }

    public void connectCameraAdapter(Hyve.CameraAdapter camAdapter) {
        this.dvRenderer.connectCameraAdapter(camAdapter);
    }

    public OrthoShooter getOrthoShooter() {
        return this.dvRenderer;
    }

    public AnimationTrigger getAnimationTrigger() {
        return this.animationTrigger;
    }

    public ImmersionMode getMode() {
        return this.dvRenderer.getImmersionMode();
    }

    public void showHello() {
        this.enqueue(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                Jme3ApplicationWindow.this.dvRenderer.setHelloVisibility(true);
                return null;
            }
        });
    }

    public void hideHello() {
        this.enqueue(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                Jme3ApplicationWindow.this.dvRenderer.setHelloVisibility(false);
                return null;
            }
        });
    }

    private class JmeUpdateFrameTrigger
    implements AnimationTrigger {
        private Set<AnimationTrigger.TriggerListener> listener = new HashSet<AnimationTrigger.TriggerListener>();

        private JmeUpdateFrameTrigger() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void update(float tpf) {
            Set<AnimationTrigger.TriggerListener> set = this.listener;
            synchronized (set) {
                for (AnimationTrigger.TriggerListener l : this.listener) {
                    l.onUpdate(tpf);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addTriggerListener(AnimationTrigger.TriggerListener l) {
            Set<AnimationTrigger.TriggerListener> set = this.listener;
            synchronized (set) {
                this.listener.add(l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeTriggerListener(AnimationTrigger.TriggerListener l) {
            Set<AnimationTrigger.TriggerListener> set = this.listener;
            synchronized (set) {
                this.listener.remove(l);
            }
        }
    }

    private class ResizeListener
    extends ComponentAdapter {
        private ResizeListener() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            Jme3ApplicationWindow.this.placeCanvas();
        }
    }
}

