/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.nina;

import com.hybridlab.hyve3d.config.MaskProperties;
import com.hybridlab.hyve3d.config.RingMaskProperties;
import com.hybridlab.hyve3d.config.ShiftHVProperties;
import com.hybridlab.hyve3d.core.FrameRect;
import com.hybridlab.hyve3d.core.HisSphericalRendererApplication;
import com.hybridlab.hyve3d.core.Transformable;
import com.hybridlab.hyve3d.data.valueobjects.Transformation;
import com.hybridlab.hyve3d.hyve.Hyve;
import com.hybridlab.hyve3d.hyve.OrthoShooter;
import com.hybridlab.hyve3d.hyveclient.HyveClientProjectionCalibrator;
import com.hybridlab.hyve3d.nina.CalibrationConfiguration;
import com.hybridlab.hyve3d.nina.ImmersionMode;
import com.hybridlab.hyve3d.nina.NinaConfiguration;
import com.hybridlab.hyve3d.nina.ProcessorOrthoShooter;
import com.hybridlab.hyve3d.rendering.Jme3HyveSceneManager;
import com.hybridlab.hyve3d.rendering.Jme3ThreadingHelper;
import com.hybridlab.hyve3d.rendering.projection.SixCameraRig;
import com.hybridlab.hyve3d.rendering.spherical.ProjectionCalibrator;
import com.hybridlab.hyveclient.HyveClientApplication;
import com.jme3.asset.AssetManager;
import com.jme3.input.FlyByCamera;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.FastMath;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.post.SceneProcessor;
import com.jme3.renderer.Camera;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.debug.WireFrustum;
import com.jme3.scene.shape.Box;
import com.jme3.scene.shape.Sphere;
import com.jme3.shadow.BasicShadowRenderer;
import com.jme3.shadow.ShadowUtil;
import com.jme3.texture.FrameBuffer;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.texture.TextureCubeMap;
import com.jme3.util.BufferUtils;
import java.awt.Dimension;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;

public class Jme3DualViewPortRenderer
implements OrthoShooter {
    private Node rootNode;
    private Node sceneNode;
    private AssetManager assetManager;
    private RenderManager renderManager;
    private final int textureSize;
    private final int sphereSamples = 256;
    private final float sphereRadius = 1.0f;
    public Node sphereScene;
    private HisSphericalRendererApplication.AppMode mode = HisSphericalRendererApplication.AppMode.SPHERICAL;
    private FlyByCamera flyCam;
    public Camera cam;
    private TextureCubeMap cubeMapTexture;
    private SixCameraRig camRig;
    private Vector3f frustumCamPosition = new Vector3f(0.0f, 2.5f, 0.0f);
    private Vector3f frustumCamDirection = new Vector3f(0.0f, 0.0f, -1.0f);
    public Jme3HyveSceneManager sceneManager;
    public Jme3ThreadingHelper threadingHelper;
    private ProjectionCalibrator calibrator;
    public Dimension windowDimensions;
    private ProcessorOrthoShooter shooter;
    private MaskFactory maskFactory;
    private Map<TextureCubeMap.Face, Boolean> enabledFaces;
    private CalibrationConfiguration calibrationConfiguration;
    boolean basicShadowTest = false;
    BasicShadowRenderer bsr;
    Geometry frustumMdl;
    WireFrustum frustum;
    private Vector3f[] points = new Vector3f[8];
    private static Quaternion frustumCamRotationFix;
    private FrustumCamTransformationAdapter fcAdapter;
    private CameraRigFollower rigFollower;
    private Timer frustumCamTraceTimer;
    private Hyve.CameraAdapter camAdapter;
    private float frustumSize;
    private Camera orthoCam;
    private FrameBuffer offBuffer;
    private static final int width = 1024;
    private static final int height = 768;
    private float aspect;
    private boolean enabled;
    private Node helloVisualization;

    public Jme3DualViewPortRenderer(AssetManager assetManager, RenderManager renderManager, Node rootNode, Node sceneNode, FlyByCamera flyCam, Camera cam, Jme3HyveSceneManager sceneManager, Jme3ThreadingHelper threadingHelper, CalibrationConfiguration calibrationConfiguration, ShiftHVProperties shiftProperties, MaskProperties maskProperties, RingMaskProperties ringmaskproperties, Dimension initialWindowDimensions, HisSphericalRendererApplication.AppMode initialAppmode, Integer cubeTextureResolution, Map<TextureCubeMap.Face, Boolean> enabledFaces) {
        for (int i = 0; i < this.points.length; ++i) {
            this.points[i] = new Vector3f();
        }
        Quaternion q = new Quaternion();
        q.fromAngleAxis((float)Math.PI, Vector3f.UNIT_Y);
        frustumCamRotationFix = q;
        this.fcAdapter = new FrustumCamTransformationAdapter();
        this.rigFollower = new CameraRigFollower();
        this.frustumSize = 1.0f;
        this.aspect = 1.3333334f;
        this.enabled = false;
        this.assetManager = assetManager;
        this.renderManager = renderManager;
        this.rootNode = rootNode;
        this.sceneNode = sceneNode;
        this.flyCam = flyCam;
        this.cam = cam;
        this.sceneManager = sceneManager;
        this.threadingHelper = threadingHelper;
        this.windowDimensions = initialWindowDimensions;
        this.mode = initialAppmode;
        this.textureSize = cubeTextureResolution;
        this.enabledFaces = enabledFaces;
        System.out.println("Jme3DualViewPortRenderer - enabledFaces: " + enabledFaces.toString());
        this.calibrator = new HyveClientProjectionCalibrator(this);
        this.calibrationConfiguration = calibrationConfiguration;
        calibrationConfiguration.connect(this.calibrator);
        this.maskFactory = new MaskFactory(maskProperties, ringmaskproperties, shiftProperties);
    }

    public Transformable getCameraRig() {
        if (this.camRig == null) {
            throw new RuntimeException("Unallowed Access before correct initialization!");
        }
        return this.camRig;
    }

    public void simpleUpdate(float tpf) {
        if (this.basicShadowTest) {
            Camera shadowCam = this.bsr.getShadowCamera();
            ShadowUtil.updateFrustumPoints2((Camera)shadowCam, (Vector3f[])this.points);
            this.frustum.update(this.points);
        }
        this.sceneManager.update(tpf);
    }

    public void simpleInit() {
        boolean mirrored = true;
        this.camRig = new SixCameraRig(this.textureSize, mirrored, this.threadingHelper, this.enabledFaces);
        Quaternion r = new Quaternion();
        r = r.fromAngles(0.0f, 0.0f, 0.0f);
        this.camRig.setLocalRotation(r);
        this.camRig.move(0.0f, 2.5f, 0.0f);
        Node blackScene = new Node("black");
        blackScene.updateGeometricState();
        blackScene.updateModelBound();
        this.setupCameraRigToBuildOffscreenViewCubeMap(this.sceneNode, blackScene, this.camRig);
        this.sceneManager.getCamerRigGroupNode().attachChild((Spatial)this.camRig);
        TextureCubeMap cubeMap = this.getCubeMapTexture();
        this.sphereScene = this.getSphere((Texture)cubeMap);
        this.setAppMode(this.mode);
        this.setupOffscreenOrthoViewPort(this.sceneNode);
        this.enabledChanged();
    }

    private void initViewPort() {
        Callable<Object> c = new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                switch (Jme3DualViewPortRenderer.this.mode) {
                    case FRUSTUM: {
                        Jme3DualViewPortRenderer.this.rootNode.detachAllChildren();
                        Jme3DualViewPortRenderer.this.rootNode.attachChild((Spatial)Jme3DualViewPortRenderer.this.sceneNode);
                        Jme3DualViewPortRenderer.this.flyCam.setEnabled(true);
                        Jme3DualViewPortRenderer.this.flyCam.setMoveSpeed(3.0f);
                        Jme3DualViewPortRenderer.this.flyCam.setDragToRotate(true);
                        Jme3DualViewPortRenderer.this.cam.setLocation(Jme3DualViewPortRenderer.this.frustumCamPosition);
                        Vector3f frustumCamLookAt = Jme3DualViewPortRenderer.this.frustumCamPosition.add(Jme3DualViewPortRenderer.this.frustumCamDirection);
                        Jme3DualViewPortRenderer.this.cam.lookAt(frustumCamLookAt, Vector3f.UNIT_Y);
                        Jme3DualViewPortRenderer.this.calibrator.setMode(Jme3DualViewPortRenderer.this.mode);
                        break;
                    }
                    default: {
                        Jme3DualViewPortRenderer.this.rootNode.detachAllChildren();
                        Jme3DualViewPortRenderer.this.rootNode.attachChild((Spatial)Jme3DualViewPortRenderer.this.sphereScene);
                        Jme3DualViewPortRenderer.this.flyCam.setEnabled(false);
                        Jme3DualViewPortRenderer.this.calibrator.setMode(Jme3DualViewPortRenderer.this.mode);
                        Jme3DualViewPortRenderer.this.setCameraRigPosition(Jme3DualViewPortRenderer.this.frustumCamPosition);
                    }
                }
                return null;
            }
        };
        if (this.threadingHelper.isThreadEqualToRenderThread(Thread.currentThread())) {
            try {
                c.call();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.threadingHelper.enqueue(c);
        }
    }

    protected void setCameraRigPosition(Vector3f newcamRigPosition) {
        if (this.camRig != null) {
            Transformation t = this.camRig.getTransformation();
            this.camRig.setTransformation(new Transformation(newcamRigPosition, t.getRotation()));
        }
    }

    private void setupCameraRigToBuildOffscreenViewCubeMap(Node sceneRootNode, Node blackScene, SixCameraRig camRig) {
        ViewPort blackvp = new ViewPort("black", camRig.getCam(TextureCubeMap.Face.NegativeX));
        blackvp.setClearFlags(false, false, false);
        blackvp.setBackgroundColor(ColorRGBA.Red);
        if (this.basicShadowTest) {
            this.bsr = new BasicShadowRenderer(this.assetManager, 512);
            this.bsr.setDirection(new Vector3f(-1.0f, -1.0f, -1.0f).normalizeLocal());
        }
        ViewPort[] offViews = new ViewPort[6];
        TextureCubeMap offTex = new TextureCubeMap(this.textureSize, this.textureSize, Image.Format.RGBA8);
        int i = 0;
        for (TextureCubeMap.Face face : TextureCubeMap.Face.values()) {
            Camera offCamera = camRig.getCam(face);
            offViews[i] = this.renderManager.createPreView("Offscreen View " + i, offCamera);
            offViews[i].setClearFlags(true, true, true);
            offViews[i].setBackgroundColor(ColorRGBA.Black);
            if (this.basicShadowTest && i == 4) {
                offViews[i].addProcessor((SceneProcessor)this.bsr);
                this.frustum = new WireFrustum(this.bsr.getPoints());
                this.frustumMdl = new Geometry("f", (Mesh)this.frustum);
                this.frustumMdl.setCullHint(Spatial.CullHint.Never);
                this.frustumMdl.setShadowMode(RenderQueue.ShadowMode.Off);
                this.frustumMdl.setMaterial(new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md"));
                this.frustumMdl.getMaterial().getAdditionalRenderState().setWireframe(true);
                this.frustumMdl.getMaterial().setColor("Color", ColorRGBA.Red);
                this.rootNode.attachChild((Spatial)this.frustumMdl);
            }
            FrameBuffer offBuffer = new FrameBuffer(this.textureSize, this.textureSize, 1);
            offBuffer.setDepthBuffer(Image.Format.Depth);
            offBuffer.setMultiTarget(true);
            offBuffer.addColorTexture(offTex, face);
            offViews[i].setOutputFrameBuffer(offBuffer);
            offViews[i].attachScene((Spatial)(camRig.isFaceEnabled(face) ? sceneRootNode : blackScene));
            ++i;
        }
        this.cubeMapTexture = offTex;
    }

    private TextureCubeMap getCubeMapTexture() {
        return this.cubeMapTexture;
    }

    private Node getSphere(Texture envtex) {
        Node parent = new Node("sphere");
        Sphere s = new Sphere(256, 256, 1.0f);
        Geometry g = new Geometry("geo sphere", (Mesh)s);
        g.rotate(0.0f, 0.0f, 0.0f);
        Material m = new Material(this.assetManager, switch (HyveClientApplication.openglVersion) {
            case "LWJGL-OpenGL2" -> "Materials/CubeTexture.j3md";
            case "LWJGL-OpenGL33" -> "Materials/CubeTextureGLSL330.j3md";
            case "LWJGL-OpenGL4" -> "Materials/CubeTextureGLSL4.j3md";
            default -> "Materials/CubeTexture.j3md";
        });
        m.setTexture("Texture", envtex);
        g.setMaterial(m);
        parent.attachChild((Spatial)g);
        Node masks = this.maskFactory.getMasksNode();
        return parent;
    }

    public MaskModifier getMaskModifier() {
        return this.maskFactory;
    }

    public ProjectionCalibrator getProjectionCalibrator() {
        return this.calibrator;
    }

    public void toggleAppMode() {
        switch (this.mode) {
            case FRUSTUM: {
                this.setAppMode(HisSphericalRendererApplication.AppMode.SPHERICAL);
                break;
            }
            case SPHERICAL: {
                this.setAppMode(HisSphericalRendererApplication.AppMode.FRUSTUM);
            }
        }
    }

    private void setAppMode(HisSphericalRendererApplication.AppMode newMode) {
        switch (newMode) {
            case SPHERICAL: {
                this.frustumCamPosition = this.cam.getLocation().clone();
                this.frustumCamDirection = this.cam.getDirection();
                this.getCameraRig().removeChangeListener(this.fcAdapter);
                this.getCameraRig().addChangeListener(this.rigFollower);
                break;
            }
            case FRUSTUM: {
                this.frustumCamPosition = this.camRig.getPosition();
                this.getCameraRig().addChangeListener(this.fcAdapter);
                this.getCameraRig().removeChangeListener(this.rigFollower);
            }
        }
        this.mode = newMode;
        this.initViewPort();
    }

    public void addCameraPositionObserver(Transformable.TransformationChangedListener obs) {
        this.getCameraRig().addChangeListener(obs);
    }

    public void removeCameraPositionObserver(Transformable.TransformationChangedListener obs) {
        this.getCameraRig().removeChangeListener(obs);
    }

    private void enableFrustumCamTracer() {
        if (this.frustumCamTraceTimer != null) {
            this.disableFrustumCamTracer();
        }
        this.frustumCamTraceTimer = new Timer();
        this.frustumCamTraceTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                Jme3DualViewPortRenderer.this.synchCamToCamRig();
            }
        }, 100L, 40L);
    }

    protected void synchCamToCamRig() {
        Vector3f frustumCamPos = this.cam.getLocation().clone();
        Quaternion frustumCamRot = this.cam.getRotation().clone();
        if (this.camAdapter != null) {
            this.camAdapter.setConnectedSpaceTransformation(new Transformation(frustumCamPos, frustumCamRot));
        }
    }

    private void disableFrustumCamTracer() {
        if (this.frustumCamTraceTimer != null) {
            this.frustumCamTraceTimer.cancel();
            this.frustumCamTraceTimer = null;
        }
    }

    public void enableImmersiveMode() {
        this.setAppMode(HisSphericalRendererApplication.AppMode.SPHERICAL);
    }

    public void enableNonImmersiveMode() {
        this.setAppMode(HisSphericalRendererApplication.AppMode.FRUSTUM);
    }

    public void onWindowResized(Dimension size) {
        this.windowDimensions = size;
    }

    public void connectCameraAdapter(Hyve.CameraAdapter camAdapter) {
        this.camAdapter = camAdapter;
    }

    private void setupOffscreenOrthoViewPort(Node viewNode) {
        this.orthoCam = new Camera(1024, 768);
        this.orthoCam.setViewPort(0.0f, 1.0f, 0.0f, 1.0f);
        this.orthoCam.setLocation(new Vector3f(0.0f, 0.0f, 1.0f));
        this.orthoCam.setRotation(new Quaternion().fromAngleAxis(0.5235988f, new Vector3f(1.0f, 0.0f, 0.0f)));
        this.orthoCam.setParallelProjection(true);
        this.orthoCam.setFrustum(-1000.0f, 1000.0f, -this.aspect * this.frustumSize, this.aspect * this.frustumSize, this.frustumSize, -this.frustumSize);
        ViewPort vp = this.renderManager.createPreView("ortho viewport", this.orthoCam);
        vp.setClearFlags(true, true, true);
        vp.setBackgroundColor(ColorRGBA.Black);
        boolean useAntialias = true;
        this.offBuffer = new FrameBuffer(1024, 768, 1);
        this.offBuffer.setDepthTarget(FrameBuffer.FrameBufferTarget.newTarget((Image.Format)Image.Format.Depth));
        this.offBuffer.addColorTarget(FrameBuffer.FrameBufferTarget.newTarget((Image.Format)ProcessorOrthoShooter.UsedImageFormat));
        vp.setOutputFrameBuffer(this.offBuffer);
        vp.attachScene((Spatial)viewNode);
        FrameBuffer.RenderBuffer c = this.offBuffer.getColorTarget();
        System.out.println("offBuffer.getColorBuffer().getFormat() = " + c.getFormat());
        this.shooter = new ProcessorOrthoShooter(vp, this.orthoCam, useAntialias);
    }

    @Override
    public String shootAt(final Transformation transformation, final FrameRect frame, final OrthoShooter.FinishCallback callback) {
        final String shootid = String.valueOf(System.currentTimeMillis());
        this.threadingHelper.enqueue(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                Jme3DualViewPortRenderer.this.shooter.shoot(callback, shootid, frame, transformation);
                return null;
            }
        });
        return shootid;
    }

    public void setEnabled(boolean enabled) {
        if (this.enabled != enabled) {
            this.enabled = enabled;
            this.enabledChanged();
        }
    }

    private boolean isEnabled() {
        return this.enabled;
    }

    private void enabledChanged() {
    }

    public ImmersionMode getImmersionMode() {
        switch (this.mode) {
            case FRUSTUM: {
                return ImmersionMode.NONIMMERSIVE;
            }
            case SPHERICAL: {
                return ImmersionMode.IMMERSIVE;
            }
        }
        throw new RuntimeException("Unnkown mapping of Appmode to ImmersionMode");
    }

    private void callInRenderThread(Callable<Object> c) {
        if (this.threadingHelper.isThreadEqualToRenderThread(Thread.currentThread())) {
            try {
                c.call();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.threadingHelper.enqueue(c);
        }
    }

    public void setHelloTranslation(final Vector3f position) {
        this.callInRenderThread(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                if (Jme3DualViewPortRenderer.this.helloVisualization == null) {
                    Jme3DualViewPortRenderer.this.helloVisualization.setLocalTranslation(position);
                }
                return null;
            }
        });
    }

    public void setHelloVisibility(final boolean visible) {
        this.callInRenderThread(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                if (Jme3DualViewPortRenderer.this.helloVisualization == null) {
                    Jme3DualViewPortRenderer.this.helloVisualization = new Node("helloVisualization");
                    Jme3DualViewPortRenderer.this.helloVisualization.setLocalTranslation(Jme3DualViewPortRenderer.this.camRig.getLocalTranslation());
                    Box box = new Box(1.0f, 1.0f, 1.0f);
                    Geometry boxGeo = new Geometry("Blackbox", (Mesh)box);
                    Jme3DualViewPortRenderer.this.helloVisualization.attachChild((Spatial)boxGeo);
                    Material material = new Material(Jme3DualViewPortRenderer.this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
                    material.setColor("Color", ColorRGBA.Gray);
                    material.getAdditionalRenderState().setFaceCullMode(RenderState.FaceCullMode.Off);
                    boxGeo.setMaterial(material);
                }
                if (visible) {
                    // empty if block
                }
                return null;
            }
        });
    }

    private class FrustumCamTransformationAdapter
    implements Transformable.TransformationChangedListener {
        private FrustumCamTransformationAdapter() {
        }

        @Override
        public void hasChanged(Transformable transformable) {
            Jme3DualViewPortRenderer.this.cam.setLocation(transformable.getTransformation().getPosition());
            Quaternion tilt = new Quaternion();
            tilt.fromAngleAxis(transformable.getTiltAngle(), Vector3f.UNIT_X.negate());
            Jme3DualViewPortRenderer.this.cam.setRotation(transformable.getTransformation().getRotation().mult(frustumCamRotationFix).mult(tilt));
        }
    }

    private class CameraRigFollower
    implements Transformable.TransformationChangedListener {
        private CameraRigFollower() {
        }

        @Override
        public void hasChanged(Transformable transformable) {
            if (Jme3DualViewPortRenderer.this.helloVisualization != null) {
                Jme3DualViewPortRenderer.this.setHelloTranslation(transformable.getTransformation().getPosition());
            }
        }
    }

    private class MaskFactory
    implements MaskModifier {
        private Node maskRootNode;
        private ColorRGBA colorEllipse;
        private ColorRGBA currentColorEllipse;
        private ColorRGBA colorRing;
        private ColorRGBA currentRingColor;
        private Material ellipseMaskMaterial;
        private Geometry ellipsemask;
        private Material ringMaskMaterial;
        private Geometry ringmask;
        private MaskProperties maskProperties;
        private RingMaskProperties ringMaskProperties;
        private ShiftHVProperties shiftHVproperties;

        public MaskFactory(MaskProperties maskProperties, RingMaskProperties ringMaskProperties, ShiftHVProperties shiftHVproperties) {
            this.currentColorEllipse = this.colorEllipse = ColorRGBA.Black;
            this.currentRingColor = this.colorRing = ColorRGBA.Black;
            this.maskProperties = maskProperties;
            this.ringMaskProperties = ringMaskProperties;
            this.shiftHVproperties = shiftHVproperties;
            this.maskRootNode = new Node("mask root");
            Mesh circle = this.createCircleMesh();
            this.ellipsemask = new Geometry("mask1", circle);
            float w = maskProperties.getWidth();
            float h = maskProperties.getHeight();
            this.ellipsemask.setLocalScale(w, 1.0f, h);
            this.setEllipsePosition(maskProperties.getPlacement());
            this.ellipseMaskMaterial = new Material(Jme3DualViewPortRenderer.this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
            this.ellipseMaskMaterial.setColor("Color", this.colorEllipse);
            this.currentColorEllipse = this.colorEllipse;
            this.ellipsemask.setMaterial(this.ellipseMaskMaterial);
            this.maskRootNode.attachChild((Spatial)this.ellipsemask);
            this.ellipsemask.setCullHint(maskProperties.getEllipseMaskEnabled() ? Spatial.CullHint.Inherit : Spatial.CullHint.Always);
            Mesh ring = this.createRingMesh();
            this.ringmask = new Geometry("ring", ring);
            float r = ringMaskProperties.getInnerRadius();
            this.ringmask.setLocalScale(r, 1.0f, r);
            this.setRingPosition();
            this.ringMaskMaterial = new Material(Jme3DualViewPortRenderer.this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
            this.ringMaskMaterial.setColor("Color", this.colorRing);
            this.currentRingColor = this.colorRing;
            this.ringmask.setMaterial(this.ringMaskMaterial);
            this.maskRootNode.attachChild((Spatial)this.ringmask);
            this.ringmask.setCullHint(ringMaskProperties.getRingMaskEnabled() ? Spatial.CullHint.Inherit : Spatial.CullHint.Always);
        }

        @Override
        public void setEllipseWidth(float width) {
            this.maskProperties.setWidth(width);
            Callable<Object> c = new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    float w = MaskFactory.this.maskProperties.getWidth();
                    float h = MaskFactory.this.maskProperties.getHeight();
                    MaskFactory.this.ellipsemask.setLocalScale(w, 1.0f, h);
                    return null;
                }
            };
            if (Jme3DualViewPortRenderer.this.threadingHelper.isThreadEqualToRenderThread(Thread.currentThread())) {
                try {
                    c.call();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                Jme3DualViewPortRenderer.this.threadingHelper.enqueue(c);
            }
        }

        @Override
        public void setEllipseHeight(float height) {
            this.maskProperties.setHeight(height);
            Callable<Object> c = new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    float w = MaskFactory.this.maskProperties.getWidth();
                    float h = MaskFactory.this.maskProperties.getHeight();
                    MaskFactory.this.ellipsemask.setLocalScale(w, 1.0f, h);
                    return null;
                }
            };
            if (Jme3DualViewPortRenderer.this.threadingHelper.isThreadEqualToRenderThread(Thread.currentThread())) {
                try {
                    c.call();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                Jme3DualViewPortRenderer.this.threadingHelper.enqueue(c);
            }
        }

        @Override
        public void setEllipsePosition(float p) {
            this.maskProperties.setPlacement(p);
            Callable<Object> c = new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    float inbetween = Jme3DualViewPortRenderer.this.calibrator.getCameraDistance() * 0.5f;
                    float shiftZ = MaskFactory.this.maskProperties.getPlacement();
                    MaskFactory.this.ellipsemask.setLocalTranslation(0.0f, inbetween, shiftZ);
                    return null;
                }
            };
            if (Jme3DualViewPortRenderer.this.threadingHelper.isThreadEqualToRenderThread(Thread.currentThread())) {
                try {
                    c.call();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                Jme3DualViewPortRenderer.this.threadingHelper.enqueue(c);
            }
        }

        public void setRingPosition() {
            Callable<Object> c = new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    float inbetween = Jme3DualViewPortRenderer.this.calibrator.getCameraDistance() * 0.5f;
                    float shiftZ = 0.0f;
                    MaskFactory.this.ringmask.setLocalTranslation(0.0f, inbetween, shiftZ);
                    return null;
                }
            };
            if (Jme3DualViewPortRenderer.this.threadingHelper.isThreadEqualToRenderThread(Thread.currentThread())) {
                try {
                    c.call();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                Jme3DualViewPortRenderer.this.threadingHelper.enqueue(c);
            }
        }

        @Override
        public void setEllipseBlend(float alpha) {
        }

        @Override
        public void setEllipseColor(ColorRGBA c) {
            this.ellipseMaskMaterial.setColor("Color", c);
            this.currentColorEllipse = c;
        }

        private Mesh createCircleMesh() {
            int numpieces = 64;
            Vector3f[] vertices = new Vector3f[numpieces + 1];
            int[] indexes = new int[numpieces * 3];
            vertices[0] = new Vector3f(0.0f, 0.0f, 0.0f);
            float r = 1.0f;
            for (int a = 0; a < numpieces; ++a) {
                Vector3f p;
                float angleRad = (float)Math.PI * 2 * ((float)a / (float)numpieces);
                float x = FastMath.sin((float)angleRad) * r;
                float z = FastMath.cos((float)angleRad) * r;
                vertices[a + 1] = p = new Vector3f(x, 0.0f, z);
                indexes[a * 3] = 0;
                indexes[a * 3 + 1] = a + 1;
                indexes[a * 3 + 2] = a + 2 <= numpieces ? a + 2 : 1;
            }
            Mesh mesh = new Mesh();
            mesh.setBuffer(VertexBuffer.Type.Position, 3, BufferUtils.createFloatBuffer((Vector3f[])vertices));
            mesh.setBuffer(VertexBuffer.Type.Index, 3, BufferUtils.createIntBuffer((int[])indexes));
            mesh.updateBound();
            mesh.setStatic();
            return mesh;
        }

        private Mesh createRingMesh() {
            int numsections = 64;
            Vector3f[] vertices = new Vector3f[2 * numsections];
            int[] indexes = new int[numsections * 3 * 2];
            float r_inner = 0.5f;
            float r_outer = 10.0f;
            for (int i = 0; i < numsections; ++i) {
                int c;
                Vector3f p_outer;
                float angleRad = (float)Math.PI * 2 * ((float)i / (float)numsections);
                float x_inner = FastMath.sin((float)angleRad) * r_inner;
                float z_inner = FastMath.cos((float)angleRad) * r_inner;
                float x_outer = FastMath.sin((float)angleRad) * r_outer;
                float z_outer = FastMath.cos((float)angleRad) * r_outer;
                Vector3f p_inner = new Vector3f(x_inner, 0.0f, z_inner);
                vertices[i] = p_outer = new Vector3f(x_outer, 0.0f, z_outer);
                vertices[i + numsections] = p_inner;
                int a = i;
                int b = (i + 1) % numsections;
                int d = c = i + numsections;
                int e = b;
                int f = b + numsections;
                int ixa = 6 * i;
                int ixb = ixa + 1;
                int ixc = ixa + 2;
                int ixd = ixa + 3;
                int ixe = ixa + 4;
                int ixf = ixa + 5;
                indexes[ixa] = a;
                indexes[ixb] = b;
                indexes[ixc] = c;
                indexes[ixd] = d;
                indexes[ixe] = e;
                indexes[ixf] = f;
            }
            Mesh mesh = new Mesh();
            mesh.setBuffer(VertexBuffer.Type.Position, 3, BufferUtils.createFloatBuffer((Vector3f[])vertices));
            mesh.setBuffer(VertexBuffer.Type.Index, 3, BufferUtils.createIntBuffer((int[])indexes));
            mesh.updateBound();
            mesh.setStatic();
            return mesh;
        }

        public Node getMasksNode() {
            return this.maskRootNode;
        }

        @Override
        public void setMaskVisibility(boolean visible) {
            this.maskProperties.setEllipseMaskEnabled(visible);
            this.ellipsemask.setCullHint(this.maskProperties.getEllipseMaskEnabled() ? Spatial.CullHint.Inherit : Spatial.CullHint.Always);
        }

        @Override
        public boolean getMaskVisibility() {
            return this.maskProperties.getEllipseMaskEnabled();
        }

        @Override
        public boolean colorIsCalibrationColor() {
            return this.currentColorEllipse.equals((Object)NinaConfiguration.CalibrationColor);
        }

        @Override
        public boolean colorIsBlack() {
            return this.currentColorEllipse.equals((Object)ColorRGBA.Black);
        }

        @Override
        public float getEllipseWidth() {
            return this.maskProperties.getWidth();
        }

        @Override
        public float getEllipseHeight() {
            return this.maskProperties.getHeight();
        }

        @Override
        public float getEllipsePosition() {
            return this.maskProperties.getPlacement();
        }

        @Override
        public float getRingRadius() {
            return this.ringMaskProperties.getInnerRadius();
        }

        @Override
        public void setRingRadius(float r) {
            this.ringMaskProperties.setInnerRadius(r);
            Callable<Object> c = new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    float s = MaskFactory.this.ringMaskProperties.getInnerRadius();
                    MaskFactory.this.ringmask.setLocalScale(s, 1.0f, s);
                    return null;
                }
            };
            if (Jme3DualViewPortRenderer.this.threadingHelper.isThreadEqualToRenderThread(Thread.currentThread())) {
                try {
                    c.call();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                Jme3DualViewPortRenderer.this.threadingHelper.enqueue(c);
            }
        }

        @Override
        public void setRingColor(ColorRGBA c) {
            this.ringMaskMaterial.setColor("Color", c);
            this.currentRingColor = c;
        }

        @Override
        public void setRingMaskVisibility(boolean visible) {
            this.ringMaskProperties.setRingMaskEnabled(visible);
            this.ringmask.setCullHint(this.ringMaskProperties.getRingMaskEnabled() ? Spatial.CullHint.Inherit : Spatial.CullHint.Always);
        }

        @Override
        public boolean getRingMaskVisibility() {
            return this.ringMaskProperties.getRingMaskEnabled();
        }

        @Override
        public boolean ringColorIsCalibrationColor() {
            return !this.ringColorIsBlack();
        }

        @Override
        public boolean ringColorIsBlack() {
            return this.colorEllipse.equals((Object)ColorRGBA.Black);
        }

        @Override
        public float getShiftHorizontal() {
            return this.shiftHVproperties.getShiftH();
        }

        @Override
        public float getShiftVertical() {
            return this.shiftHVproperties.getShiftV();
        }

        @Override
        public void setShiftVertical(float value) {
            this.shiftHVproperties.setShiftV(value);
        }

        @Override
        public void setShiftHorizontal(float value) {
            this.shiftHVproperties.setShiftH(value);
        }
    }

    public static interface MaskModifier {
        public float getRingRadius();

        public void setRingRadius(float var1);

        public void setRingColor(ColorRGBA var1);

        public void setRingMaskVisibility(boolean var1);

        public boolean getRingMaskVisibility();

        public boolean ringColorIsCalibrationColor();

        public boolean ringColorIsBlack();

        public float getEllipseWidth();

        public float getEllipseHeight();

        public float getEllipsePosition();

        public void setEllipseWidth(float var1);

        public void setEllipseHeight(float var1);

        public void setEllipsePosition(float var1);

        public void setEllipseBlend(float var1);

        public void setEllipseColor(ColorRGBA var1);

        public void setMaskVisibility(boolean var1);

        public boolean getMaskVisibility();

        public boolean colorIsCalibrationColor();

        public boolean colorIsBlack();

        public float getShiftHorizontal();

        public float getShiftVertical();

        public void setShiftVertical(float var1);

        public void setShiftHorizontal(float var1);
    }
}

