/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.nina;

import com.hybridlab.hyve3d.hyve.CoolJTextField;
import com.hybridlab.hyve3d.hyve.HyveApplication;
import com.hybridlab.hyve3d.hyve.HyveNetworking;
import com.hybridlab.hyve3d.hyve.SessionInfo;
import com.hybridlab.hyve3d.network.interconnection.HubConnection;
import com.hybridlab.hyve3d.network.interconnection.HubNodeHost;
import com.hybridlab.hyve3d.network.interconnection.implementations.adressing.HubNodeAddress;
import com.hybridlab.hyve3d.nina.ConnectionTemplate;
import com.hybridlab.hyve3d.nina.ConnectionTemplateData;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.LineBorder;
import javax.swing.event.ListDataListener;
import org.apache.commons.io.FileUtils;

public class NetworkingWindow
extends JFrame {
    private static final long serialVersionUID = -3230902281811241975L;
    private HyveNetworking networking;
    private JTextField txtHostingPort;
    private JLabel lblStatusText;
    private JTextField txtHost;
    private JTextField txtPort;
    private JLabel lblHost;
    private JLabel lblPort;
    private JButton btnConnect;
    private HyveNetworking.ConnectionEstablishListener connListener = new HyveNetworking.ConnectionEstablishListener(){

        @Override
        public void onConnectionFailed(String message, String targetNodeInfo) {
            final String msg = "Failed to connect to " + targetNodeInfo + "!\nReason: " + message;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    NetworkingWindow.this.showConnectionError(msg);
                }
            });
        }

        @Override
        public void onConnectionEstablished(HubNodeAddress targetHubNodeAdress) {
            final String msg = "Connection to " + targetHubNodeAdress.describe() + " established.";
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    NetworkingWindow.this.showConnectionMessage(msg);
                    NetworkingWindow.this.rdbtnHostSession.setEnabled(false);
                    NetworkingWindow.this.btnConnect.setEnabled(false);
                    NetworkingWindow.this.btnDisconnect.setEnabled(true);
                    NetworkingWindow.this.btnAttend.setEnabled(true);
                    NetworkingWindow.this.btnVisualize.setEnabled(true);
                    NetworkingWindow.this.btnJoin.setEnabled(true);
                    NetworkingWindow.this.lblHost.setEnabled(false);
                    NetworkingWindow.this.lblPort.setEnabled(false);
                    NetworkingWindow.this.txtHost.setEnabled(false);
                    NetworkingWindow.this.txtPort.setEnabled(false);
                    NetworkingWindow.this.comboBoxConnectionTemplates.setEnabled(false);
                    NetworkingWindow.this.buttonAddConnectionTemplate.setEnabled(false);
                }
            });
        }

        @Override
        public void onConnectionLost(HubConnection lostConnection) {
            final String msg = "Connection to " + lostConnection.describe() + " lost.";
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    NetworkingWindow.this.showConnectionError(msg);
                    NetworkingWindow.this.rdbtnHostSession.setEnabled(true);
                    NetworkingWindow.this.btnConnect.setEnabled(true);
                    NetworkingWindow.this.btnDisconnect.setEnabled(false);
                    DefaultListModel listModel = new DefaultListModel();
                    NetworkingWindow.this.sessionlist.setModel(listModel);
                    NetworkingWindow.this.btnAttend.setEnabled(false);
                    NetworkingWindow.this.btnVisualize.setEnabled(false);
                    NetworkingWindow.this.btnJoin.setEnabled(false);
                    NetworkingWindow.this.lblHost.setEnabled(true);
                    NetworkingWindow.this.lblPort.setEnabled(true);
                    NetworkingWindow.this.txtHost.setEnabled(true);
                    NetworkingWindow.this.txtPort.setEnabled(true);
                    NetworkingWindow.this.comboBoxConnectionTemplates.setEnabled(true);
                    NetworkingWindow.this.buttonAddConnectionTemplate.setEnabled(true);
                }
            });
        }
    };
    private HyveApplication app;
    private JButton btnAttend;
    private JTextPane textPane;
    private JPanel panel_connectiondata_remotehost;
    private JPanel panel_connectiondata_localhost;
    private JPanel panel_sessions_in_remotehost;
    private JList sessionlist;
    private JButton btnVisualize;
    private JButton btnJoin;
    private SessionInfo lastSelected;
    private CoolJTextField textField_hyvename;
    private JLabel lblNewLabel;
    private String hyveName = "";
    private WindowMode currentWindowMode;
    private HyveNetworking.HostingEstablishListener hostingListener = new HyveNetworking.HostingEstablishListener(){

        @Override
        public void onHostCreationFailed(Exception e) {
            NetworkingWindow.this.showHostingError(e.getLocalizedMessage());
        }

        @Override
        public void onHostCreated(HubNodeHost hnh) {
            NetworkingWindow.this.showHostingMessage("Hosting local Session at " + hnh.getAddress().describe());
            NetworkingWindow.this.rdbtnConnectToHost.setEnabled(false);
            NetworkingWindow.this.btnHostingStart.setEnabled(false);
            NetworkingWindow.this.btnHostingStop.setEnabled(true);
            NetworkingWindow.this.txtHostingPort.setEnabled(false);
            NetworkingWindow.this.lblHostingPort.setEnabled(false);
        }

        @Override
        public void onHostShutdown() {
            NetworkingWindow.this.showHostingMessage("Host shutdown.");
            NetworkingWindow.this.rdbtnConnectToHost.setEnabled(true);
            NetworkingWindow.this.btnHostingStart.setEnabled(true);
            NetworkingWindow.this.btnHostingStop.setEnabled(false);
            NetworkingWindow.this.txtHostingPort.setEnabled(true);
            NetworkingWindow.this.lblHostingPort.setEnabled(true);
        }
    };
    Timer attendtimer;
    private JPanel panel_name;
    private JPanel panel_ALL;
    private JLabel lblConnectionInfo;
    private JRadioButton rdbtnHostSession;
    private JRadioButton rdbtnConnectToHost;
    private JLabel lblHostingPort;
    private JButton btnHostingStart;
    private JButton btnHostingStop;
    private JLabel lblHostingInfo;
    private JButton btnDisconnect;
    private JLabel lblAvailablesessions;
    private JComboBox comboBoxConnectionTemplates;
    private ConnectionTemplateData templatedata;
    private File templateFile = new File("connectiontemplates.conf");
    private JButton buttonAddConnectionTemplate;
    private JButton buttonRemoveConnectionTemplate;

    public NetworkingWindow() {
        this.setAlwaysOnTop(true);
        this.setTitle("Hyve-3D Networking");
        this.setResizable(false);
        this.getContentPane().setLayout(null);
        this.panel_ALL = new JPanel();
        this.panel_ALL.setBounds(6, 6, 514, 641);
        this.panel_ALL.setLayout(null);
        this.getContentPane().add(this.panel_ALL);
        this.panel_name = new JPanel();
        this.panel_name.setBorder(new LineBorder(new Color(0, 0, 0)));
        this.panel_name.setBounds(6, 6, 500, 36);
        this.panel_ALL.add(this.panel_name);
        this.panel_name.setLayout(null);
        this.lblNewLabel = new JLabel("Displayed name");
        this.lblNewLabel.setBounds(6, 10, 133, 16);
        this.panel_name.add(this.lblNewLabel);
        this.textField_hyvename = new CoolJTextField();
        this.textField_hyvename.setHorizontalAlignment(0);
        this.textField_hyvename.setBounds(114, 4, 380, 28);
        this.panel_name.add(this.textField_hyvename);
        this.textField_hyvename.setColumns(10);
        JPanel panel_host = new JPanel();
        panel_host.setBorder(new LineBorder(new Color(0, 0, 0)));
        panel_host.setBounds(6, 50, 500, 131);
        this.panel_ALL.add(panel_host);
        panel_host.setLayout(null);
        this.rdbtnHostSession = new JRadioButton("Host a Session");
        this.rdbtnHostSession.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                NetworkingWindow.this.radioButtonHostOrConnectClicked(NetworkingWindow.this.rdbtnHostSession);
            }
        });
        this.rdbtnHostSession.setBounds(6, 6, 141, 23);
        panel_host.add(this.rdbtnHostSession);
        this.panel_connectiondata_localhost = new JPanel();
        this.panel_connectiondata_localhost.setBounds(6, 30, 488, 93);
        panel_host.add(this.panel_connectiondata_localhost);
        this.panel_connectiondata_localhost.setBorder(null);
        this.panel_connectiondata_localhost.setLayout(null);
        this.lblHostingPort = new JLabel("Hosting port");
        this.lblHostingPort.setBounds(6, 20, 100, 20);
        this.panel_connectiondata_localhost.add(this.lblHostingPort);
        this.txtHostingPort = new JTextField();
        this.txtHostingPort.setHorizontalAlignment(0);
        this.txtHostingPort.setBounds(94, 20, 98, 20);
        this.panel_connectiondata_localhost.add(this.txtHostingPort);
        this.txtHostingPort.setText("8779");
        this.txtHostingPort.setColumns(10);
        this.btnHostingStart = new JButton("Start");
        this.btnHostingStart.setBounds(204, 16, 176, 30);
        this.panel_connectiondata_localhost.add(this.btnHostingStart);
        this.lblHostingInfo = new JLabel("xxx.yyy.zzz.www");
        this.lblHostingInfo.setHorizontalAlignment(0);
        this.lblHostingInfo.setBounds(6, 52, 476, 35);
        this.panel_connectiondata_localhost.add(this.lblHostingInfo);
        this.btnHostingStop = new JButton("Stop");
        this.btnHostingStop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NetworkingWindow.this.stopHostingButtonClicked();
            }
        });
        this.btnHostingStop.setEnabled(false);
        this.btnHostingStop.setBounds(375, 16, 107, 30);
        this.panel_connectiondata_localhost.add(this.btnHostingStop);
        this.lblStatusText = new JLabel("");
        this.lblStatusText.setBounds(6, 573, 500, 62);
        this.panel_ALL.add(this.lblStatusText);
        this.lblStatusText.setBackground(Color.LIGHT_GRAY);
        this.lblStatusText.setForeground(Color.RED);
        JPanel panel_connect = new JPanel();
        panel_connect.setBorder(new LineBorder(new Color(0, 0, 0)));
        panel_connect.setBounds(6, 190, 500, 355);
        this.panel_ALL.add(panel_connect);
        panel_connect.setLayout(null);
        this.rdbtnConnectToHost = new JRadioButton("Connect to a host");
        this.rdbtnConnectToHost.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NetworkingWindow.this.radioButtonHostOrConnectClicked(NetworkingWindow.this.rdbtnConnectToHost);
            }
        });
        this.rdbtnConnectToHost.setBounds(6, 6, 153, 23);
        panel_connect.add(this.rdbtnConnectToHost);
        this.panel_connectiondata_remotehost = new JPanel();
        this.panel_connectiondata_remotehost.setBounds(6, 31, 488, 96);
        panel_connect.add(this.panel_connectiondata_remotehost);
        this.panel_connectiondata_remotehost.setBorder(null);
        this.panel_connectiondata_remotehost.setLayout(null);
        this.lblHost = new JLabel("Host");
        this.lblHost.setBounds(6, 30, 39, 16);
        this.panel_connectiondata_remotehost.add(this.lblHost);
        this.txtHost = new JTextField();
        this.txtHost.setHorizontalAlignment(0);
        this.txtHost.setBounds(39, 24, 134, 28);
        this.panel_connectiondata_remotehost.add(this.txtHost);
        this.txtHost.setText("132.207.191.249");
        this.txtHost.setColumns(10);
        this.lblPort = new JLabel("Port");
        this.lblPort.setBounds(180, 30, 26, 16);
        this.panel_connectiondata_remotehost.add(this.lblPort);
        this.txtPort = new JTextField();
        this.txtPort.setHorizontalAlignment(0);
        this.txtPort.setBounds(209, 24, 66, 28);
        this.panel_connectiondata_remotehost.add(this.txtPort);
        this.txtPort.setText("8779");
        this.txtPort.setColumns(10);
        this.btnConnect = new JButton("Connect");
        this.btnConnect.setBounds(277, 25, 114, 29);
        this.panel_connectiondata_remotehost.add(this.btnConnect);
        this.lblConnectionInfo = new JLabel("xxx.yyy.zzz.www");
        this.lblConnectionInfo.setHorizontalAlignment(0);
        this.lblConnectionInfo.setBounds(6, 52, 476, 35);
        this.panel_connectiondata_remotehost.add(this.lblConnectionInfo);
        this.btnDisconnect = new JButton("Disconnect");
        this.btnDisconnect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NetworkingWindow.this.disconnectButtonClicked();
            }
        });
        this.btnDisconnect.setEnabled(false);
        this.btnDisconnect.setBounds(386, 25, 96, 29);
        this.panel_connectiondata_remotehost.add(this.btnDisconnect);
        this.panel_sessions_in_remotehost = new JPanel();
        this.panel_sessions_in_remotehost.setBounds(6, 169, 488, 170);
        panel_connect.add(this.panel_sessions_in_remotehost);
        this.panel_sessions_in_remotehost.setBorder(null);
        GridBagLayout gbl_panel_sessions_in_remotehost = new GridBagLayout();
        gbl_panel_sessions_in_remotehost.columnWidths = new int[]{0, 0, 0, 0, 0};
        gbl_panel_sessions_in_remotehost.rowHeights = new int[]{0, 0, 0};
        gbl_panel_sessions_in_remotehost.columnWeights = new double[]{0.0, 1.0, 0.0, 0.0, Double.MIN_VALUE};
        gbl_panel_sessions_in_remotehost.rowWeights = new double[]{1.0, 0.0, Double.MIN_VALUE};
        this.panel_sessions_in_remotehost.setLayout(gbl_panel_sessions_in_remotehost);
        this.sessionlist = new JList();
        this.sessionlist.setSelectionMode(0);
        GridBagConstraints gbc_sessionlist = new GridBagConstraints();
        gbc_sessionlist.gridwidth = 4;
        gbc_sessionlist.insets = new Insets(0, 0, 5, 0);
        gbc_sessionlist.fill = 1;
        gbc_sessionlist.gridx = 0;
        gbc_sessionlist.gridy = 0;
        this.panel_sessions_in_remotehost.add((Component)this.sessionlist, gbc_sessionlist);
        this.btnAttend = new JButton("attend");
        GridBagConstraints gbc_btnAttend = new GridBagConstraints();
        gbc_btnAttend.anchor = 13;
        gbc_btnAttend.insets = new Insets(0, 0, 0, 5);
        gbc_btnAttend.gridx = 1;
        gbc_btnAttend.gridy = 1;
        this.panel_sessions_in_remotehost.add((Component)this.btnAttend, gbc_btnAttend);
        this.btnVisualize = new JButton("visualize");
        this.btnVisualize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                NetworkingWindow.this.visualizeSelected();
            }
        });
        GridBagConstraints gbc_btnVisualize = new GridBagConstraints();
        gbc_btnVisualize.insets = new Insets(0, 0, 0, 5);
        gbc_btnVisualize.gridx = 2;
        gbc_btnVisualize.gridy = 1;
        this.panel_sessions_in_remotehost.add((Component)this.btnVisualize, gbc_btnVisualize);
        this.btnJoin = new JButton("join");
        this.btnJoin.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NetworkingWindow.this.joinSelected();
            }
        });
        GridBagConstraints gbc_btnJoin = new GridBagConstraints();
        gbc_btnJoin.gridx = 3;
        gbc_btnJoin.gridy = 1;
        this.panel_sessions_in_remotehost.add((Component)this.btnJoin, gbc_btnJoin);
        this.lblAvailablesessions = new JLabel("Available sessions");
        this.lblAvailablesessions.setBounds(16, 150, 153, 16);
        panel_connect.add(this.lblAvailablesessions);
        this.comboBoxConnectionTemplates = new JComboBox();
        this.comboBoxConnectionTemplates.setBounds(170, 5, 268, 28);
        panel_connect.add(this.comboBoxConnectionTemplates);
        this.buttonAddConnectionTemplate = new JButton("+");
        this.buttonAddConnectionTemplate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NetworkingWindow.this.addConnectionTemplate();
            }
        });
        this.buttonAddConnectionTemplate.setEnabled(false);
        this.buttonAddConnectionTemplate.setFont(new Font("Lucida Grande", 0, 10));
        this.buttonAddConnectionTemplate.setBounds(440, 8, 20, 20);
        panel_connect.add(this.buttonAddConnectionTemplate);
        this.buttonRemoveConnectionTemplate = new JButton("-");
        this.buttonRemoveConnectionTemplate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NetworkingWindow.this.removeConnectionTemplate();
            }
        });
        this.buttonRemoveConnectionTemplate.setEnabled(false);
        this.buttonRemoveConnectionTemplate.setFont(new Font("Lucida Grande", 0, 10));
        this.buttonRemoveConnectionTemplate.setBounds(465, 8, 20, 20);
        panel_connect.add(this.buttonRemoveConnectionTemplate);
        this.btnAttend.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                NetworkingWindow.this.attendSelectedSession();
            }
        });
        this.btnConnect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (NetworkingWindow.this.networking != null) {
                    try {
                        int port = Integer.parseInt(NetworkingWindow.this.txtPort.getText());
                        String host = NetworkingWindow.this.txtHost.getText();
                        NetworkingWindow.this.networking.asynchConnectToHubNode(host, port, NetworkingWindow.this.connListener);
                    }
                    catch (NumberFormatException nfe) {
                        NetworkingWindow.this.showHostingError("No valid Port number!");
                    }
                }
            }
        });
        this.btnHostingStart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                NetworkingWindow.this.startHostingButtonWasClicked();
            }
        });
        this.textField_hyvename.addPropertyChangeListener("text", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent pce) {
                String txt = (String)pce.getNewValue();
                if (!NetworkingWindow.this.hyveName.equals(txt)) {
                    NetworkingWindow.this.hyveName = txt;
                    NetworkingWindow.this.app.getLocalHyve().setLocalSpaceName(NetworkingWindow.this.hyveName);
                }
            }
        });
        this.showHostingMessage(" ");
    }

    protected void removeConnectionTemplate() {
        if (this.templatedata.templateEntries.isEmpty()) {
            return;
        }
        int result = JOptionPane.showConfirmDialog(this, "Do you really want to remove this connection address?\n" + this.templatedata.templateEntries.get(this.templatedata.selectedindex).toString(), "Please confirm", 0);
        if (result == 0) {
            this.templatedata.templateEntries.remove(this.templatedata.selectedindex);
            --this.templatedata.selectedindex;
            if (this.templatedata.selectedindex > -1) {
                this.useTemplateData(this.templatedata.templateEntries.get(this.templatedata.selectedindex));
            } else if (!this.templatedata.templateEntries.isEmpty()) {
                this.templatedata.selectedindex = 0;
                this.useTemplateData(this.templatedata.templateEntries.get(this.templatedata.selectedindex));
            } else {
                this.useTemplateData(new ConnectionTemplate("", "", 8779));
            }
            this.pushToCombobox(this.templatedata);
            this.writeConnectionTemplateData(this.templatedata);
        }
    }

    protected void addConnectionTemplate() {
        String host = this.txtHost.getText().trim();
        String sport = this.txtPort.getText().trim();
        try {
            if (sport.length() == 0) {
                throw new Exception("Please enter a port number!");
            }
            int port = Integer.parseInt(sport);
            if (host.length() == 0) {
                throw new Exception("Please enter a host value!");
            }
            if (!this.templatedata.hasEntryLike(host, port)) {
                String x = "untitled";
                String title = JOptionPane.showInputDialog(this, "Please enter a title for this new connection template.", x);
                if (title == null) {
                    return;
                }
                if ((title = title.trim()).length() == 0) {
                    throw new Exception("You have to enter a title for a connection.");
                }
                this.templatedata.templateEntries.add(new ConnectionTemplate(title, host, port));
                this.templatedata.selectedindex = this.templatedata.templateEntries.size() - 1;
                this.pushToCombobox(this.templatedata);
                this.writeConnectionTemplateData(this.templatedata);
            } else {
                JOptionPane.showMessageDialog(this, String.format("There is already a connection template for %s:%d.", host, port), "Alert", 1);
            }
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, "Unable tp parse port number (" + sport + ").", "Alert", 0);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, String.format(e.getLocalizedMessage(), new Object[0]), "Alert", 0);
        }
    }

    protected void startHostingButtonWasClicked() {
        if (this.networking != null) {
            try {
                int port = Integer.parseInt(this.txtHostingPort.getText());
                boolean success = this.networking.createHost(port, this.hostingListener);
                if (success) {
                    UUID sid = this.app.getLocalSessionId();
                    boolean mustbeConnected = false;
                    this.app.getNetworking().shareSession(sid, mustbeConnected);
                }
            }
            catch (NumberFormatException e) {
                this.showHostingError("No valid Port number!");
            }
        }
    }

    protected void disconnectButtonClicked() {
        if (this.networking != null) {
            this.networking.disconnectFromHubNode(this.connListener);
        }
    }

    protected void stopHostingButtonClicked() {
        this.networking.closeHost(this.hostingListener);
    }

    protected void radioButtonHostOrConnectClicked(JRadioButton which) {
        if (which.equals(this.rdbtnConnectToHost)) {
            WindowMode newMode = WindowMode.connecting;
            if (this.modeIsPossibleAndUserReallyWantsToChange(newMode)) {
                this.setWindowToMode(newMode);
            } else if (newMode.equals((Object)this.currentWindowMode)) {
                this.rdbtnConnectToHost.setSelected(true);
            }
        } else if (which.equals(this.rdbtnHostSession)) {
            WindowMode newMode = WindowMode.hosting;
            if (this.modeIsPossibleAndUserReallyWantsToChange(newMode)) {
                this.setWindowToMode(newMode);
            } else if (newMode.equals((Object)this.currentWindowMode)) {
                this.rdbtnHostSession.setSelected(true);
            }
        }
    }

    private void setWindowToMode(WindowMode mode) {
        switch (mode) {
            default: 
        }
        this.currentWindowMode = mode;
        boolean enableInHostingMode = WindowMode.hosting.equals((Object)mode);
        boolean enableInConnectMode = WindowMode.connecting.equals((Object)mode);
        this.rdbtnHostSession.setSelected(enableInHostingMode);
        this.rdbtnConnectToHost.setSelected(enableInConnectMode);
        this.lblHostingPort.setEnabled(enableInHostingMode);
        JComponent[] hostingComponents_enabledInMode = new JComponent[]{this.panel_connectiondata_localhost, this.lblHostingPort, this.txtHostingPort, this.btnHostingStart, this.lblHostingInfo};
        JComponent[] hostingComponents_disabledAtBeginOfMode = new JComponent[]{this.btnHostingStop};
        JComponent[] connectComponents_enabledInMode = new JComponent[]{this.panel_connectiondata_remotehost, this.lblHost, this.txtHost, this.lblPort, this.txtPort, this.btnConnect, this.lblConnectionInfo, this.panel_sessions_in_remotehost, this.lblAvailablesessions, this.sessionlist, this.comboBoxConnectionTemplates, this.buttonAddConnectionTemplate, this.buttonRemoveConnectionTemplate};
        JComponent[] connectComponents_disabledAtBeginOfMode = new JComponent[]{this.btnDisconnect, this.btnAttend, this.btnVisualize, this.btnJoin};
        for (JComponent jc : hostingComponents_enabledInMode) {
            jc.setEnabled(enableInHostingMode);
        }
        for (JComponent jc : hostingComponents_disabledAtBeginOfMode) {
            jc.setEnabled(false);
        }
        for (JComponent jc : connectComponents_enabledInMode) {
            jc.setEnabled(enableInConnectMode);
        }
        for (JComponent jc : connectComponents_disabledAtBeginOfMode) {
            jc.setEnabled(false);
        }
        this.lblHostingInfo.setText("");
        this.lblConnectionInfo.setText("");
    }

    private boolean modeIsPossibleAndUserReallyWantsToChange(WindowMode mode) {
        if (mode.equals((Object)this.currentWindowMode)) {
            return false;
        }
        System.out.println("modeIsPossibleAndUserReallyWantsToChange returns true");
        return true;
    }

    protected void joinSelected() {
        SessionInfo i = (SessionInfo)this.sessionlist.getSelectedValue();
        if (i != null) {
            this.app.joinSession(i.id);
        }
    }

    protected void visualizeSelected() {
        SessionInfo i = (SessionInfo)this.sessionlist.getSelectedValue();
        if (i != null) {
            this.app.visualizeSession(i.id);
        }
    }

    private void attendSelectedSession() {
        SessionInfo i = (SessionInfo)this.sessionlist.getSelectedValue();
        if (i != null) {
            this.lastSelected = i;
            if (this.attendtimer != null) {
                this.attendtimer.stop();
                this.attendtimer = null;
            }
            this.attendtimer = new Timer(1000, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ListModel mdl = NetworkingWindow.this.sessionlist.getModel();
                    for (int i = 0; i < mdl.getSize(); ++i) {
                        SessionInfo item = (SessionInfo)mdl.getElementAt(i);
                        if (!item.id.equals(NetworkingWindow.this.lastSelected.id)) continue;
                        NetworkingWindow.this.sessionlist.setSelectedValue(item, true);
                    }
                    NetworkingWindow.this.attendtimer.stop();
                    NetworkingWindow.this.attendtimer = null;
                }
            });
            this.attendtimer.start();
            this.app.synchSession(i.id);
        }
    }

    protected void showHostingError(final String msg) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NetworkingWindow.this.lblHostingInfo.setText(msg);
                NetworkingWindow.this.lblHostingInfo.setForeground(Color.RED);
            }
        });
    }

    protected void showHostingMessage(final String msg) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NetworkingWindow.this.lblHostingInfo.setText(msg);
                NetworkingWindow.this.lblHostingInfo.setForeground(Color.BLUE);
            }
        });
    }

    protected void showConnectionError(final String msg) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NetworkingWindow.this.lblConnectionInfo.setText(msg);
                NetworkingWindow.this.lblConnectionInfo.setForeground(Color.RED);
            }
        });
    }

    protected void showConnectionMessage(final String msg) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NetworkingWindow.this.lblConnectionInfo.setText(msg);
                NetworkingWindow.this.lblConnectionInfo.setForeground(Color.BLUE);
            }
        });
    }

    public void connectAdapter(HyveNetworking n, HyveApplication app) {
        this.networking = n;
        this.app = app;
        this.hyveName = this.app.getLocalHyve().getLocalSpaceName();
        this.textField_hyvename.setText(this.hyveName);
        this.setWindowToMode(WindowMode.undefined);
        this.populateConnecionTemplates();
    }

    private void pushToCombobox(ConnectionTemplateData templatedata) {
        ConnectionTemplateModel connectionTemplateModel = new ConnectionTemplateModel(templatedata);
        this.comboBoxConnectionTemplates.setModel(connectionTemplateModel);
        this.buttonRemoveConnectionTemplate.setEnabled(!templatedata.templateEntries.isEmpty());
    }

    private void populateConnecionTemplates() {
        this.templatedata = this.getConnectionTemplateData();
        this.pushToCombobox(this.templatedata);
        if (this.templatedata.selectedindex > -1) {
            this.useTemplateData(this.templatedata.getTemplates().get(this.templatedata.selectedindex));
        }
        this.comboBoxConnectionTemplates.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ie) {
                Object selected;
                if (ie.getSource() == NetworkingWindow.this.comboBoxConnectionTemplates && ie.getStateChange() == 1 && (selected = ie.getItem()) instanceof ConnectionTemplate) {
                    ConnectionTemplate ctd = (ConnectionTemplate)selected;
                    NetworkingWindow.this.useTemplateData(ctd);
                }
            }
        });
    }

    protected void useTemplateData(ConnectionTemplate ct) {
        this.txtHost.setText(ct.getHost().trim());
        this.txtPort.setText(String.valueOf(ct.getPort()).trim());
        this.templatedata.selectedindex = this.templatedata.getIndexOf(ct);
    }

    private ConnectionTemplateData getConnectionTemplateData() {
        ConnectionTemplateData d = this.readConnectionTemplateData();
        return d;
    }

    private void writeConnectionTemplateData(ConnectionTemplateData d) {
        try {
            String data = ConnectionTemplateData.toJSONString(d);
            FileUtils.write(this.templateFile, (CharSequence)data, Charset.forName("UTF-8"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private ConnectionTemplateData readConnectionTemplateData() {
        ConnectionTemplateData d = null;
        try {
            String json = FileUtils.readFileToString(this.templateFile, Charset.forName("UTF-8"));
            d = ConnectionTemplateData.fromJSONString(json);
        }
        catch (Exception e) {
            d = ConnectionTemplateData.Default;
            this.writeConnectionTemplateData(d);
        }
        return d;
    }

    public JList getSessionList() {
        return this.sessionlist;
    }

    public JTextPane getInterConnectivityTextField() {
        return this.textPane;
    }

    public static enum WindowMode {
        hosting,
        connecting,
        undefined;

    }

    class ConnectionTemplateModel
    implements ComboBoxModel {
        private List<ConnectionTemplate> list = new ArrayList<ConnectionTemplate>();
        private Set<ListDataListener> listeners = new HashSet<ListDataListener>();
        private int selectedIndex = -1;

        public ConnectionTemplateModel(ConnectionTemplateData templatedata) {
            this.list.addAll(templatedata.getTemplates());
            this.selectedIndex = templatedata.selectedindex;
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
            this.listeners.remove(l);
        }

        @Override
        public int getSize() {
            return this.list.size();
        }

        @Override
        public Object getElementAt(int index) {
            return this.list.get(index);
        }

        @Override
        public void addListDataListener(ListDataListener l) {
            this.listeners.add(l);
        }

        @Override
        public void setSelectedItem(Object item) {
            this.selectedIndex = this.list.indexOf(item);
        }

        @Override
        public Object getSelectedItem() {
            return this.selectedIndex > -1 && this.selectedIndex < this.list.size() ? this.list.get(this.selectedIndex) : null;
        }
    }
}

