/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.nina;

import com.hybridlab.hyve3d.config.JSonConfiguration;
import com.hybridlab.hyve3d.config.MaskProperties;
import com.hybridlab.hyve3d.config.NamedAngle;
import com.hybridlab.hyve3d.config.NamedString;
import com.hybridlab.hyve3d.config.RingMaskProperties;
import com.hybridlab.hyve3d.config.ShiftHVProperties;
import com.hybridlab.hyve3d.nina.CalibrationConfiguration;
import com.hybridlab.hyve3d.nina.ConfIds;
import com.hybridlab.hyve3d.satellitecenter.SatelliteClientConfiguration;
import com.hybridlab.hyve3d.satellitecenter.SatelliteClientConfigurationSet;
import com.hybridlab.utils.JsonConversion;
import com.jme3.math.ColorRGBA;
import com.jme3.texture.TextureCubeMap;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;

public class NinaConfiguration
implements PropertyChangeListener,
SatelliteClientConfigurationSet.ChangeListener {
    private static final String NinaConfigurationFile = "hyve.config";
    public static ColorRGBA CalibrationColor = new ColorRGBA(0.9019608f, 0.5647059f, 0.12941176f, 1.0f);
    private CalibrationConfiguration calibrationConfig;
    private SatelliteClientConfigurationSet satellites;
    private NamedAngle north;
    private NamedAngle hydraControllerAttachmentAngle;
    private NamedString rotationSensor;
    private File file = new File("hyve.config");
    private JSonConfiguration jsonConf;
    private MaskProperties ellipseMaskProps;
    private ShiftHVProperties shiftHVProps;
    private RingMaskProperties ringMaskProps;

    @Deprecated
    public NinaConfiguration() {
        JSONObject jsonRoot = JSonConfiguration.readFile(this.file, new JSonConfiguration.KeyReplacer(){

            @Override
            public String replaceOldKeyToNewKeys(String s) {
                Class<ConfIds.ConfValueIds> c = ConfIds.ConfValueIds.class;
                Class<ConfIds.ConfValueIdsShort> d = ConfIds.ConfValueIdsShort.class;
                Field[] fields = c.getDeclaredFields();
                ConfIds.ConfValueIds oc = new ConfIds.ConfValueIds();
                ConfIds.ConfValueIdsShort od = new ConfIds.ConfValueIdsShort();
                for (Field f : fields) {
                    String fname = f.getName();
                    try {
                        String search = String.valueOf(f.get(oc));
                        String replace = String.valueOf(d.getDeclaredField(fname).get(od));
                        s = s.replace(search, replace);
                    }
                    catch (IllegalArgumentException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    catch (SecurityException e) {
                        e.printStackTrace();
                    }
                    catch (NoSuchFieldException e) {
                        e.printStackTrace();
                    }
                }
                return s;
            }
        });
        this.jsonConf = new JSonConfiguration(jsonRoot);
        this.initialize();
    }

    private void initialize() {
        for (Method m : this.getClass().getMethods()) {
            if (m.getName().equals("getClass") || !m.getName().startsWith("get")) continue;
            try {
                m.invoke((Object)this, new Object[0]);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    public void saveIfChanged() {
        if (this.hasChanges()) {
            this.save();
        }
    }

    private boolean hasChanges() {
        return this.jsonConf.hasChanges();
    }

    public void save() {
        JSonConfiguration.writeFile(this.file, this.jsonConf.getJSonRootObject());
        this.jsonConf.changesGotSaved();
        try {
            System.out.println("saved configuration: \n" + this.jsonConf.getJSonRootObject().toString(2));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public String getAppId() {
        String alternativeAppId = UUID.randomUUID().toString();
        String appid = this.jsonConf.getString(ConfIds.ConfValueIdsShort.LocalHyveAppID, alternativeAppId);
        return appid;
    }

    public String getHubNodeUUID() {
        String uuid = this.jsonConf.getString(ConfIds.ConfValueIdsShort.LocalHyveNodeUUID, UUID.randomUUID().toString());
        return uuid;
    }

    public String getHyveUuid() {
        String uuid = this.jsonConf.getString(ConfIds.ConfValueIdsShort.LocalHyveHyveUUID, UUID.randomUUID().toString());
        return uuid;
    }

    public Integer getTextureResolution() {
        Integer res = this.jsonConf.getInteger(ConfIds.ConfValueIdsShort.SphericalTextureResolutionOfEachCubeFace, 1024);
        return res;
    }

    public void setTextureResolution(int ts) {
        this.jsonConf.putInteger(ConfIds.ConfValueIdsShort.SphericalTextureResolutionOfEachCubeFace, ts);
    }

    public String getHyveName() {
        String name = this.jsonConf.getString(ConfIds.ConfValueIdsShort.LocalHyveName, "Unnamed Hyve");
        return name;
    }

    public void setHyveName(String name) {
        if (name == null) {
            name = "Unnamed Hyve";
        }
        this.jsonConf.putString(ConfIds.ConfValueIdsShort.LocalHyveName, name);
    }

    public void setFullScreen(boolean fullScreen) {
        this.jsonConf.putBoolean(ConfIds.ConfValueIdsShort.RenderWindowFullScreen, fullScreen);
    }

    public boolean getFullScreen() {
        boolean fullscreen = this.jsonConf.getBoolean(ConfIds.ConfValueIdsShort.RenderWindowFullScreen, true);
        return fullscreen;
    }

    public int getWindowSizeNonFullScreen() {
        int wSize = this.jsonConf.getInteger(ConfIds.ConfValueIdsShort.RenderWindowSize, 600);
        return wSize;
    }

    public CalibrationConfiguration getProjectionCalibration() {
        if (this.calibrationConfig == null) {
            float v = 50.0f;
            try {
                v = Float.parseFloat(this.jsonConf.getString(ConfIds.ConfValueIdsShort.ProjectionCalibrationSphereCamFieldOfView, String.valueOf(v)));
            }
            catch (Exception exception) {
                // empty catch block
            }
            float SphereCamFieldOfView = v;
            v = 1.0f;
            try {
                v = Float.parseFloat(this.jsonConf.getString(ConfIds.ConfValueIdsShort.ProjectionCalibrationSphereScale, String.valueOf(v)));
            }
            catch (Exception exception) {
                // empty catch block
            }
            float SphereScale = v;
            v = 30.0f;
            try {
                v = Float.parseFloat(this.jsonConf.getString(ConfIds.ConfValueIdsShort.ProjectionCalibrationSphereCamDistance, String.valueOf(v)));
            }
            catch (Exception exception) {
                // empty catch block
            }
            float SphereCamDistance = v;
            v = 1.0f;
            try {
                v = Float.parseFloat(this.jsonConf.getString(ConfIds.ConfValueIdsShort.ProjectionCalibrationSphereViewportRadius, String.valueOf(v)));
            }
            catch (Exception exception) {
                // empty catch block
            }
            float SphereViewportRadius = v;
            this.calibrationConfig = new CalibrationConfiguration(SphereCamFieldOfView, SphereScale, SphereViewportRadius, SphereCamDistance);
            this.calibrationConfig.addPropertyChangeListener(this);
        }
        return this.calibrationConfig;
    }

    public SatelliteClientConfigurationSet getSatelliteConfigurationSet() {
        if (this.satellites == null) {
            String satelliteConfigPath = "satellites";
            JSONObject satelliteConfs = this.jsonConf.getJSonObject(satelliteConfigPath);
            HashSet<SatelliteClientConfiguration> confs = new HashSet<SatelliteClientConfiguration>();
            Iterator keyIterator = satelliteConfs.keys();
            while (keyIterator.hasNext()) {
                try {
                    String key = (String)keyIterator.next();
                    JSONObject satconf = satelliteConfs.getJSONObject(key);
                    SatelliteClientConfiguration c = this.toSatConf(satconf);
                    confs.add(c);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            this.satellites = new SatelliteClientConfigurationSet(confs);
            this.satellites.addChangeListener(this);
        }
        return this.satellites;
    }

    private SatelliteClientConfiguration toSatConf(JSONObject satjson) {
        SatelliteClientConfiguration satconfig = new SatelliteClientConfiguration();
        try {
            satconfig.setSatelliteId(satjson.getString("SatelliteId"));
            satconfig.setPairedHydraControllerIndex(satjson.optInt(ConfIds.ConfValueIdsShort.PairedHydraControllerIndex));
            satconfig.setSatelliteName(satjson.optString("SatelliteName"));
            JSONObject c = satjson.optJSONObject("RegularFrameColor");
            if (c != null) {
                satconfig.setRegularFrameColor(JsonConversion.JSON2ColorRGBA(c));
            }
            return satconfig;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    private JSONObject SatConfigToJSon(SatelliteClientConfiguration satconfig) {
        JSONObject json = new JSONObject();
        try {
            json.put("SatelliteId", (Object)satconfig.getSatelliteId());
            json.put(ConfIds.ConfValueIdsShort.PairedHydraControllerIndex, (Object)satconfig.getPairedHydraControllerIndex());
            json.put("SatelliteName", (Object)satconfig.getSatelliteName());
            json.put("RegularFrameColor", (Object)JsonConversion.ColorRGBAtoJSON(satconfig.getRegularFrameColor()));
            return json;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean getInitDefaultDevices() {
        return this.jsonConf.getBoolean(ConfIds.ConfValueIdsShort.InitDefaultDevices, true);
    }

    public NamedString getUsedRotationSensor() {
        if (this.rotationSensor == null) {
            String v = "Hydra";
            try {
                v = this.jsonConf.getString(ConfIds.ConfValueIdsShort.UsedRotationSensor, "HYDRA");
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.rotationSensor = new NamedString("UsedRotationSensor", v);
            this.rotationSensor.addPropertyChangeListener(this);
        }
        return this.rotationSensor;
    }

    public NamedAngle getNorthHeading() {
        if (this.north == null) {
            float n = 0.0f;
            try {
                n = Float.parseFloat(this.jsonConf.getString(ConfIds.ConfValueIdsShort.HeadingsNorth, "45"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.north = new NamedAngle("NorthHeading", n);
            this.north.addPropertyChangeListener(this);
        }
        return this.north;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        float v;
        if (e.getSource() == this.north && e.getPropertyName().equals("angle")) {
            v = ((Float)e.getNewValue()).floatValue();
            this.jsonConf.putString(ConfIds.ConfValueIdsShort.HeadingsNorth, String.valueOf(v));
        }
        if (e.getSource() == this.hydraControllerAttachmentAngle) {
            if (e.getPropertyName().equals("angle")) {
                v = ((Float)e.getNewValue()).floatValue();
                this.jsonConf.putString(ConfIds.ConfValueIdsShort.HydraControllerAttachmentAngle, String.valueOf(v));
            }
        } else if (e.getSource() == this.rotationSensor) {
            if (e.getPropertyName().equals("string")) {
                String v2 = (String)e.getNewValue();
                this.jsonConf.putString(ConfIds.ConfValueIdsShort.UsedRotationSensor, v2);
            }
        } else if (e.getSource() == this.ellipseMaskProps) {
            if (e.getPropertyName().equals("width")) {
                v = ((Float)e.getNewValue()).floatValue();
                this.jsonConf.putString(ConfIds.ConfValueIdsShort.MaskEllipseWidth, String.valueOf(v));
            } else if (e.getPropertyName().equals("height")) {
                v = ((Float)e.getNewValue()).floatValue();
                this.jsonConf.putString(ConfIds.ConfValueIdsShort.MaskEllipseHeight, String.valueOf(v));
            } else if (e.getPropertyName().equals("placement")) {
                v = ((Float)e.getNewValue()).floatValue();
                this.jsonConf.putString(ConfIds.ConfValueIdsShort.MaskEllipsePlacement, String.valueOf(v));
            } else if (e.getPropertyName().equals("ellipseMaskEnabled")) {
                boolean v3 = (Boolean)e.getNewValue();
                this.jsonConf.putBoolean(ConfIds.ConfValueIdsShort.MaskEllipseEnabled, v3);
            }
        } else if (e.getSource() == this.shiftHVProps) {
            if (e.getPropertyName().equals("shiftH")) {
                v = ((Float)e.getNewValue()).floatValue();
                this.jsonConf.putString(ConfIds.ConfValueIdsShort.ShiftH, String.valueOf(v));
            } else if (e.getPropertyName().equals("shiftV")) {
                v = ((Float)e.getNewValue()).floatValue();
                this.jsonConf.putString(ConfIds.ConfValueIdsShort.ShiftV, String.valueOf(v));
            }
        } else if (e.getSource() == this.ringMaskProps) {
            if (e.getPropertyName().equals("innerRadius")) {
                v = ((Float)e.getNewValue()).floatValue();
                this.jsonConf.putString(ConfIds.ConfValueIdsShort.MaskRingInnerradius, String.valueOf(v));
            } else if (e.getPropertyName().equals("ringMaskEnabled")) {
                boolean v4 = (Boolean)e.getNewValue();
                this.jsonConf.putBoolean(ConfIds.ConfValueIdsShort.MaskRingEnabled, v4);
            }
        } else if (e.getPropertyName().equals("SphereCamFieldOfView")) {
            v = ((Float)e.getNewValue()).floatValue();
            this.jsonConf.putString(ConfIds.ConfValueIdsShort.ProjectionCalibrationSphereCamFieldOfView, String.valueOf(v));
        } else if (e.getPropertyName().equals("SphereScale")) {
            v = ((Float)e.getNewValue()).floatValue();
            this.jsonConf.putString(ConfIds.ConfValueIdsShort.ProjectionCalibrationSphereScale, String.valueOf(v));
        } else if (e.getPropertyName().equals("SphereViewportRadius")) {
            v = ((Float)e.getNewValue()).floatValue();
            this.jsonConf.putString(ConfIds.ConfValueIdsShort.ProjectionCalibrationSphereViewportRadius, String.valueOf(v));
        } else if (e.getPropertyName().equals("SphereCamDistance")) {
            v = ((Float)e.getNewValue()).floatValue();
            this.jsonConf.putString(ConfIds.ConfValueIdsShort.ProjectionCalibrationSphereCamDistance, String.valueOf(v));
        }
    }

    @Override
    public void hasChanged(SatelliteClientConfigurationSet set, String satID, SatelliteClientConfiguration satelliteConfig) {
        if (this.satellites == set) {
            String satelliteConfigPath = "satellites";
            JSONObject j = this.SatConfigToJSon(satelliteConfig);
            this.jsonConf.putJsonObject(j, satelliteConfigPath, satID);
        }
    }

    public NamedAngle getHydraControllerAttachmentAngle() {
        if (this.hydraControllerAttachmentAngle == null) {
            float n = 0.0f;
            try {
                n = Float.parseFloat(this.jsonConf.getString(ConfIds.ConfValueIdsShort.HydraControllerAttachmentAngle, "0"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.hydraControllerAttachmentAngle = new NamedAngle("HydraControllerAttachmentAngle", n);
            this.hydraControllerAttachmentAngle.addPropertyChangeListener(this);
        }
        return this.hydraControllerAttachmentAngle;
    }

    public RingMaskProperties getRingMaskProperties() {
        if (this.ringMaskProps == null) {
            this.ringMaskProps = new RingMaskProperties("Ring Mask Properties");
            try {
                boolean b = this.jsonConf.getBoolean(ConfIds.ConfValueIdsShort.MaskRingEnabled, true);
                this.ringMaskProps.setRingMaskEnabled(b);
                float w = Float.parseFloat(this.jsonConf.getString(ConfIds.ConfValueIdsShort.MaskRingInnerradius, "0.95"));
                this.ringMaskProps.setInnerRadius(w);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.ringMaskProps.addPropertyChangeListener(this);
        }
        return this.ringMaskProps;
    }

    public MaskProperties getEllipseMaskProperties() {
        if (this.ellipseMaskProps == null) {
            this.ellipseMaskProps = new MaskProperties("Ellipse Mask Properties");
            try {
                boolean b = this.jsonConf.getBoolean(ConfIds.ConfValueIdsShort.MaskEllipseEnabled, true);
                this.ellipseMaskProps.setEllipseMaskEnabled(b);
                float w = Float.parseFloat(this.jsonConf.getString(ConfIds.ConfValueIdsShort.MaskEllipseWidth, "0.345"));
                this.ellipseMaskProps.setWidth(w);
                float h = Float.parseFloat(this.jsonConf.getString(ConfIds.ConfValueIdsShort.MaskEllipseHeight, "0.214"));
                this.ellipseMaskProps.setHeight(h);
                float p = Float.parseFloat(this.jsonConf.getString(ConfIds.ConfValueIdsShort.MaskEllipsePlacement, "0.287"));
                this.ellipseMaskProps.setPlacement(p);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.ellipseMaskProps.addPropertyChangeListener(this);
        }
        return this.ellipseMaskProps;
    }

    public ShiftHVProperties getShiftHVProperties() {
        if (this.shiftHVProps == null) {
            this.shiftHVProps = new ShiftHVProperties("ShiftHV Properties");
            try {
                float h = Float.parseFloat(this.jsonConf.getString(ConfIds.ConfValueIdsShort.ShiftH, "0.0"));
                this.shiftHVProps.setShiftH(h);
                float v = Float.parseFloat(this.jsonConf.getString(ConfIds.ConfValueIdsShort.ShiftV, "0.0"));
                this.shiftHVProps.setShiftV(v);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.shiftHVProps.addPropertyChangeListener(this);
        }
        return this.shiftHVProps;
    }

    public void setEnabledFaces(Map<TextureCubeMap.Face, Boolean> faces) {
        if (faces == null) {
            faces = EnabledFacesConversion.getDefaultFaces();
        }
        this.jsonConf.putInteger(ConfIds.ConfValueIdsShort.LocalHyveEnabledFaces, EnabledFacesConversion.toInteger(faces));
    }

    public Map<TextureCubeMap.Face, Boolean> getEnabledFaces() {
        int faces = this.jsonConf.getInteger(ConfIds.ConfValueIdsShort.LocalHyveEnabledFaces, EnabledFacesConversion.getDefault());
        return EnabledFacesConversion.fromInteger(faces);
    }

    public static class EnabledFacesConversion {
        private static int salt = 23;

        private static Map<TextureCubeMap.Face, Boolean> getDefaultFaces() {
            HashMap<TextureCubeMap.Face, Boolean> enabledFaces = new HashMap<TextureCubeMap.Face, Boolean>(6);
            enabledFaces.put(ProjectionFacesHelper.convert(ProjectionFacesHelper.HumanReadableFaces.Bottom), true);
            enabledFaces.put(ProjectionFacesHelper.convert(ProjectionFacesHelper.HumanReadableFaces.Top), true);
            enabledFaces.put(ProjectionFacesHelper.convert(ProjectionFacesHelper.HumanReadableFaces.Left), true);
            enabledFaces.put(ProjectionFacesHelper.convert(ProjectionFacesHelper.HumanReadableFaces.Right), true);
            enabledFaces.put(ProjectionFacesHelper.convert(ProjectionFacesHelper.HumanReadableFaces.Back), true);
            enabledFaces.put(ProjectionFacesHelper.convert(ProjectionFacesHelper.HumanReadableFaces.Front), true);
            return enabledFaces;
        }

        private static int getDefault() {
            return EnabledFacesConversion.toInteger(EnabledFacesConversion.getDefaultFaces());
        }

        public static int toInteger(Map<TextureCubeMap.Face, Boolean> enabledFaces) {
            boolean[] flags = new boolean[]{enabledFaces.get(TextureCubeMap.Face.NegativeX), enabledFaces.get(TextureCubeMap.Face.NegativeY), enabledFaces.get(TextureCubeMap.Face.NegativeZ), enabledFaces.get(TextureCubeMap.Face.PositiveX), enabledFaces.get(TextureCubeMap.Face.PositiveY), enabledFaces.get(TextureCubeMap.Face.PositiveZ)};
            int b = 0;
            for (int i = 0; i < 6; ++i) {
                if (!flags[i]) continue;
                b = (byte)(b | 1 << i);
            }
            return b + salt;
        }

        public static Map<TextureCubeMap.Face, Boolean> fromInteger(int number) {
            HashMap<TextureCubeMap.Face, Boolean> enabledFaces = new HashMap<TextureCubeMap.Face, Boolean>(6);
            byte b = (byte)(number - salt);
            boolean[] flags = new boolean[6];
            for (int i = 0; i < 6; ++i) {
                flags[i] = (b & 1 << i) != 0;
            }
            enabledFaces.put(TextureCubeMap.Face.NegativeX, flags[0]);
            enabledFaces.put(TextureCubeMap.Face.NegativeY, flags[1]);
            enabledFaces.put(TextureCubeMap.Face.NegativeZ, flags[2]);
            enabledFaces.put(TextureCubeMap.Face.PositiveX, flags[3]);
            enabledFaces.put(TextureCubeMap.Face.PositiveY, flags[4]);
            enabledFaces.put(TextureCubeMap.Face.PositiveZ, flags[5]);
            return enabledFaces;
        }
    }

    public static class ProjectionFacesHelper {
        public static TextureCubeMap.Face convert(HumanReadableFaces f) {
            switch (f) {
                case Top: {
                    return TextureCubeMap.Face.PositiveY;
                }
                case Bottom: {
                    return TextureCubeMap.Face.NegativeY;
                }
                case Back: {
                    return TextureCubeMap.Face.NegativeZ;
                }
                case Front: {
                    return TextureCubeMap.Face.PositiveZ;
                }
                case Right: {
                    return TextureCubeMap.Face.NegativeX;
                }
                case Left: {
                    return TextureCubeMap.Face.PositiveX;
                }
            }
            return null;
        }

        public static enum HumanReadableFaces {
            Bottom,
            Top,
            Left,
            Right,
            Front,
            Back;

        }
    }
}

