/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.nina;

import com.hybridlab.hyve3d.core.HisSphericalRendererApplication;
import com.hybridlab.hyve3d.nina.Jme3DualViewPortRenderer;
import com.hybridlab.hyve3d.rendering.spherical.ProjectionCalibrator;
import com.jme3.math.FastMath;
import com.jme3.math.Vector3f;
import java.util.HashSet;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;

class NinaProjectionCalibrator
implements ProjectionCalibrator {
    private Jme3DualViewPortRenderer jme3DualViewPortRenderer;
    private float halfFOVangleRad;
    private float sphereViewportRadius = 1.0f;
    private float SphereCamDistance = 30.0f;
    private float SphereScale = 1.0f;
    private Set<ProjectionCalibrator.ProjectionCalibrationValueChangeListener> valueChangeListeners = new HashSet<ProjectionCalibrator.ProjectionCalibrationValueChangeListener>();
    private boolean doNothingIfEquals = true;
    private boolean connectFOVandDistance = true;

    @Deprecated
    NinaProjectionCalibrator(Jme3DualViewPortRenderer jme3DualViewPortRenderer) {
        this.jme3DualViewPortRenderer = jme3DualViewPortRenderer;
    }

    void setDoNothingIfValueAlreadyEquals(boolean b) {
        this.doNothingIfEquals = b;
    }

    private void setCameraDistanceAndCorrectFOVToFitViewportRadius(float distance) {
        System.out.println(this.getClass().getSimpleName() + ".setCameraDistanceAndCorrectFOVToFitViewportRadius(" + distance + ")");
        this.setCameraDistance(distance, false);
        System.out.println("   ... calculating fov with distance=" + distance + " and sphereViewportRadius=" + this.sphereViewportRadius + " ...");
        float fov = this.calculateFullFOVangleInDegrees(distance, this.sphereViewportRadius);
        System.out.println("   ... fov has been calculated: " + fov);
        this.setSpherecameraFieldOfViewAngleAlongYInDegrees(fov);
    }

    @Override
    public void setMode(HisSphericalRendererApplication.AppMode mode) {
        this.setDoNothingIfValueAlreadyEquals(false);
        this.setCameraDistanceAndCorrectFOVToFitViewportRadius(this.SphereCamDistance);
        this.setSphereScale(this.SphereScale);
        this.setDoNothingIfValueAlreadyEquals(true);
    }

    @Override
    public void changeSpherecamViewPortRadius(float keyPressed) {
        this.setViewPortRadius(this.sphereViewportRadius + keyPressed * 0.05f);
    }

    @Override
    public void setProjectionParameters(Float sphereScale, Float sphereViewportRadius, Float sphereCamDistance, Float sphereCamFieldOfView) {
    }

    @Override
    public void changeSpherecamDistance(float keyPressed) {
        float d = this.getCameraDistance();
        float diff = d * 0.25f;
        this.setCameraDistance(d += keyPressed * diff, true);
    }

    @Override
    public void changeSpherecamScale(float f) {
        float s = this.jme3DualViewPortRenderer.sphereScene.getLocalScale().getY() + f * 0.05f;
        this.setSphereScale(s);
    }

    @Override
    public float getCameraDistance() {
        return this.SphereCamDistance;
    }

    @Override
    public void setCameraDistance(float distance) {
        this.setCameraDistance(distance, false);
    }

    private float calculateRadius(float halfFOVangleRad, float distance) {
        float radius = distance * FastMath.tan((float)halfFOVangleRad);
        return distance;
    }

    private float calculateDistance(float halfFOVangleRad, float radius) {
        float distance = radius / FastMath.tan((float)halfFOVangleRad);
        return distance;
    }

    private float calculateFullFOVangleInDegrees(float distance, float radius) {
        float halfFOVangleRad = this.calculateHalfFOVangleInRadians(distance, radius);
        float fovdeg = 2.0f * halfFOVangleRad * 57.295776f;
        return fovdeg;
    }

    private float calculateHalfFOVangleInRadians(float distance, float radius) {
        float p = radius * radius / distance;
        float q = distance - p;
        float h = FastMath.sqrt((float)(p * q));
        float halfFOVangleRad = FastMath.atan2((float)h, (float)q);
        return halfFOVangleRad;
    }

    @Override
    public void setCameraDistance(final float distance, final boolean correctFOV) {
        if (this.SphereCamDistance == distance && this.doNothingIfEquals) {
            return;
        }
        System.out.println(this.getClass().getSimpleName() + ".setCameraDistance(distance=" + distance + ", correctFOV=" + correctFOV + ")");
        this.SphereCamDistance = distance;
        this.fireChange(ProjectionCalibrator.ProjectionCalibrationValue.SphereCamDistance);
        if (correctFOV) {
            float fov = this.calculateFullFOVangleInDegrees(distance, this.sphereViewportRadius);
            this.setSpherecameraFieldOfViewAngleAlongYInDegrees(fov, false);
        }
        this.callInRenderThread(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                if (NinaProjectionCalibrator.this.jme3DualViewPortRenderer.sphereScene == null) {
                    System.out.println(Thread.currentThread().toString());
                } else if (NinaProjectionCalibrator.this.jme3DualViewPortRenderer.sphereScene.getWorldTranslation() == null) {
                    System.out.println(Thread.currentThread().toString());
                }
                Jme3DualViewPortRenderer jm33DVPR = NinaProjectionCalibrator.this.jme3DualViewPortRenderer;
                if (jm33DVPR.sphereScene != null) {
                    Vector3f posSphere = jm33DVPR.sphereScene.getWorldTranslation().clone();
                    posSphere.y += NinaProjectionCalibrator.this.SphereCamDistance;
                    NinaProjectionCalibrator.this.jme3DualViewPortRenderer.cam.setLocation(posSphere);
                    NinaProjectionCalibrator.this.jme3DualViewPortRenderer.cam.lookAt(NinaProjectionCalibrator.this.jme3DualViewPortRenderer.sphereScene.getWorldTranslation(), Vector3f.UNIT_Z.mult(-1.0f));
                } else {
                    System.out.println("jm33DVPR.sphereScene was null !!!!!!!!!! for setCameraDistance(distance: " + distance + ", correctFOV: " + correctFOV + ")");
                }
                return null;
            }
        });
    }

    private void callInRenderThread(Callable<Object> c) {
        if (this.jme3DualViewPortRenderer.threadingHelper.isThreadEqualToRenderThread(Thread.currentThread())) {
            try {
                c.call();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.jme3DualViewPortRenderer.threadingHelper.enqueue(c);
        }
    }

    @Override
    public float getSphereScale() {
        return this.SphereScale;
    }

    @Override
    public void setSphereScale(float scale) {
        if (this.getSphereScale() == scale && this.doNothingIfEquals) {
            return;
        }
        this.SphereScale = scale;
        this.fireChange(ProjectionCalibrator.ProjectionCalibrationValue.SphereScale);
        final Callable<Object> actualCall = new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                NinaProjectionCalibrator.this.jme3DualViewPortRenderer.sphereScene.setLocalScale(1.0f, NinaProjectionCalibrator.this.SphereScale, 1.0f);
                return null;
            }
        };
        this.callInRenderThread(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                if (NinaProjectionCalibrator.this.jme3DualViewPortRenderer.sphereScene != null) {
                    NinaProjectionCalibrator.this.callInRenderThread(actualCall);
                } else {
                    System.out.println("sphereScene != null --> scheduling call for later ");
                    TimerTask task = new TimerTask(){

                        @Override
                        public void run() {
                            System.out.println("Task performed on Thread " + Thread.currentThread().getName());
                            NinaProjectionCalibrator.this.callInRenderThread(actualCall);
                        }
                    };
                    Timer timer = new Timer("sphereScene setLocalScale Timer");
                    long delay = 2000L;
                    timer.schedule(task, delay);
                }
                return null;
            }
        });
    }

    @Override
    public float getSpherecameraFieldOfViewAngleAlongYInDegrees() {
        return 2.0f * this.halfFOVangleRad * 57.295776f;
    }

    @Override
    public void setSpherecameraFieldOfViewAngleAlongYInDegrees(float fovYDeg) {
        System.out.println(this.getClass().getSimpleName() + ".setSpherecameraFieldOfViewAngleAlongYInDegrees(fovYDeg=" + fovYDeg + ")");
        this.setSpherecameraFieldOfViewAngleAlongYInDegrees(fovYDeg, false);
    }

    @Override
    public void setSpherecameraFieldOfViewAngleAlongYInDegrees(final float fovYDeg, boolean correctDistance) {
        System.out.println(this.getClass().getSimpleName() + ".setSpherecameraFieldOfViewAngleAlongYInDegrees(fovYDeg=" + fovYDeg + ", correctDistance=" + correctDistance + ")");
        if (this.getSpherecameraFieldOfViewAngleAlongYInDegrees() == fovYDeg && this.doNothingIfEquals) {
            return;
        }
        this.halfFOVangleRad = 0.5f * fovYDeg * ((float)Math.PI / 180);
        System.out.println("   ... halfFOVangleRad = " + this.halfFOVangleRad + " ...");
        System.out.println("   ... fireChange(ProjectionCalibrationValue.SphereCamFieldOfView); ...");
        this.fireChange(ProjectionCalibrator.ProjectionCalibrationValue.SphereCamFieldOfView);
        if (correctDistance) {
            float distance = this.sphereViewportRadius / FastMath.tan((float)this.halfFOVangleRad);
            this.setCameraDistance(distance, false);
        }
        this.callInRenderThread(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                int w = NinaProjectionCalibrator.this.jme3DualViewPortRenderer.windowDimensions.width;
                int h = NinaProjectionCalibrator.this.jme3DualViewPortRenderer.windowDimensions.height;
                System.out.println("### setSpherecameraFieldOfViewAngleAlongYInDegrees is attemting to call jme3DualViewPortRenderer.cam.setFrustumPerspective(... params ...)!!!");
                System.out.println("###   w = " + String.valueOf(w) + ", h = " + String.valueOf(h));
                NinaProjectionCalibrator.this.jme3DualViewPortRenderer.cam.setFrustumPerspective(fovYDeg, (float)w / (float)h, 0.01f, 10000.0f);
                return null;
            }
        });
    }

    @Override
    public float getViewPortRadius() {
        return this.sphereViewportRadius;
    }

    @Override
    public void setViewPortRadius(float r) {
        if (this.getViewPortRadius() == r && this.doNothingIfEquals) {
            return;
        }
        this.sphereViewportRadius = r;
        this.fireChange(ProjectionCalibrator.ProjectionCalibrationValue.SphereViewportRadius);
        System.out.println(this.getClass().getSimpleName() + ".setViewPortRadius(" + r + ") ...");
        System.out.println("   ... calculating distance with halfFOVangleRad=" + this.halfFOVangleRad + " and sphereViewportRadius=" + this.sphereViewportRadius + " ...");
        float distance = this.calculateDistance(this.halfFOVangleRad, this.sphereViewportRadius);
        System.out.println("   ... distance has been calculated: " + distance);
        System.out.println("   ... setCameraDistanceAndCorrectFOVToFitViewportRadius(" + distance + ")");
        this.setCameraDistanceAndCorrectFOVToFitViewportRadius(distance);
    }

    @Override
    public void registerChangeListener(ProjectionCalibrator.ProjectionCalibrationValueChangeListener l) {
        this.valueChangeListeners.add(l);
    }

    private void fireChange(ProjectionCalibrator.ProjectionCalibrationValue v) {
        for (ProjectionCalibrator.ProjectionCalibrationValueChangeListener pl : this.valueChangeListeners) {
            if (pl == null) continue;
            pl.valueHasChanged(this, v);
        }
    }

    @Override
    public void setFOVandDistanceAreConnected(boolean connected) {
        this.connectFOVandDistance = connected;
        if (this.connectFOVandDistance) {
            this.setCameraDistance(this.SphereCamDistance, true);
        }
    }

    @Override
    public boolean isFOVconnectedToDistance() {
        return this.connectFOVandDistance;
    }
}

