/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.nina;

import com.hybridlab.hyve3d.LocalFileScene;
import com.hybridlab.hyve3d.config.NamedFloat;
import com.hybridlab.hyve3d.data.domainobjects.Space;
import com.hybridlab.hyve3d.data.valueobjects.Transformation;
import com.hybridlab.hyve3d.files.ImportOptions;
import com.hybridlab.hyve3d.hyve.FileTypes;
import com.hybridlab.hyve3d.hyve.GlobalSettings;
import com.hybridlab.hyve3d.hyve.Hyve;
import com.hybridlab.hyve3d.hyve.HyveApplication;
import com.hybridlab.hyve3d.nina.Pano;
import com.hybridlab.utils.FileAndFolderUtils;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PanoramaControlWindow
extends JFrame {
    private static final long serialVersionUID = -3988608386265811714L;
    private Hyve localhyve;
    private JSlider tiltAngleSimulationSlider;
    private JLabel tiltLabel;
    private NamedFloat height;
    private HyveApplication hyveApp;
    private HeightSliderAdapter tiltAngleAdapter;

    public PanoramaControlWindow() {
        this.setTitle("Panorama Settings");
        this.setSize(519, 385);
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{30, 0, 0, 0};
        gridBagLayout.rowHeights = new int[]{30, 0, 30, 0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, 1.0, 0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 1.0, 0.0, 0.0, Double.MIN_VALUE};
        this.getContentPane().setLayout(gridBagLayout);
        JButton btnNewButton = new JButton("New button");
        btnNewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanoramaControlWindow.this.activatePano();
            }
        });
        GridBagConstraints gbc_btnNewButton = new GridBagConstraints();
        gbc_btnNewButton.insets = new Insets(0, 0, 5, 5);
        gbc_btnNewButton.gridx = 1;
        gbc_btnNewButton.gridy = 1;
        this.getContentPane().add((Component)btnNewButton, gbc_btnNewButton);
        this.tiltAngleSimulationSlider = new JSlider();
        this.tiltAngleSimulationSlider.setMaximum(500);
        this.tiltAngleSimulationSlider.setOrientation(1);
        this.tiltAngleSimulationSlider.setValue(0);
        this.tiltAngleSimulationSlider.setMinimum(-500);
        GridBagConstraints gbc_tiltAngleSimulationSlider = new GridBagConstraints();
        gbc_tiltAngleSimulationSlider.insets = new Insets(0, 0, 5, 0);
        gbc_tiltAngleSimulationSlider.fill = 2;
        gbc_tiltAngleSimulationSlider.gridx = 2;
        gbc_tiltAngleSimulationSlider.gridy = 1;
        this.getContentPane().add((Component)this.tiltAngleSimulationSlider, gbc_tiltAngleSimulationSlider);
        this.tiltLabel = new JLabel("height: 1.0");
        GridBagConstraints gbc_tiltLabel = new GridBagConstraints();
        gbc_tiltLabel.insets = new Insets(0, 0, 5, 0);
        gbc_tiltLabel.gridx = 2;
        gbc_tiltLabel.gridy = 2;
        this.getContentPane().add((Component)this.tiltLabel, gbc_tiltLabel);
    }

    private List<Pano> getAvailablePanos() {
        ArrayList<Pano> panos = new ArrayList<Pano>();
        File panoFolder = new File(this.hyveApp.getApplicationFolder(), "panos");
        List<File> panosDirs = FileAndFolderUtils.getSubDirectories(panoFolder);
        ArrayList<CallSite> errors = new ArrayList<CallSite>();
        for (File d : panosDirs) {
            try {
                Pano p = Pano.create(d);
                panos.add(p);
            }
            catch (Exception e) {
                e.printStackTrace();
                errors.add((CallSite)((Object)(d.getName() + " > " + e.getLocalizedMessage())));
            }
        }
        return panos;
    }

    protected void activatePano() {
        if (this.localhyve == null) {
            return;
        }
        this.localhyve.currentSession().eraseAll();
        LocalFileScene storage = new LocalFileScene();
        ImportOptions options = ImportOptions.createDefaultOptions();
        options.setPlacement(ImportOptions.Placement.ZERO_POSITION);
        storage.filename = "CanonG10Crop.obj";
        storage.directory = new File(this.hyveApp.getApplicationFolder(), "panos/Canon/").getAbsolutePath();
        FileTypes type = FileTypes.OBJ;
        this.hyveApp.importFile(storage, type, options.toImportOptionsString());
        GlobalSettings.panoramaMode = true;
        Space ls = this.localhyve.getLocalSpace();
        ls.setTransformation(new Transformation(Vector3f.UNIT_Y, new Quaternion()));
    }

    public void setApp(HyveApplication app) {
        this.hyveApp = app;
        this.localhyve = this.hyveApp.getLocalHyve();
    }

    public void connect(NamedFloat panoHeight) {
        this.height = panoHeight;
        this.tiltAngleAdapter = new HeightSliderAdapter(this.height, this.tiltAngleSimulationSlider, this.tiltLabel);
        panoHeight.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                float newValueDeg = ((Float)evt.getNewValue()).floatValue();
                System.out.println(String.format("%s %.2f", evt.getSource(), Float.valueOf(newValueDeg)));
                Space ls = PanoramaControlWindow.this.localhyve.getLocalSpace();
                Quaternion spacerot = ls.getTransformation().getRotation();
                ls.setTransformation(new Transformation(new Vector3f(0.0f, newValueDeg, 0.0f), spacerot));
            }
        });
    }

    private class HeightSliderAdapter
    implements PropertyChangeListener {
        private NamedFloat height;
        private JSlider slider;
        private JLabel labelHeight;

        public HeightSliderAdapter(NamedFloat value, JSlider slider, JLabel labelDegrees) {
            this.slider = slider;
            this.height = value;
            this.labelHeight = labelDegrees;
            slider.setValue(this.toSlider(value.getValue()));
            labelDegrees.setText(String.format("tilt angle: %.1f\u00b0", Float.valueOf(value.getValue())));
            this.height.addPropertyChangeListener(this);
            this.slider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    JSlider source = (JSlider)e.getSource();
                    float v = HeightSliderAdapter.this.fromSlider(source.getValue());
                    HeightSliderAdapter.this.labelHeight.setText(String.format("%.1f \u00b0", Float.valueOf(v)));
                    if (HeightSliderAdapter.this.height.getValue() != v) {
                        System.out.println(String.format("%s %.2f", e.getSource(), Float.valueOf(v)));
                        HeightSliderAdapter.this.height.setValue(v);
                    }
                }
            });
        }

        private int toSlider(float angle) {
            return (int)(angle * 100.0f);
        }

        private float fromSlider(int value) {
            return (float)value / 100.0f;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() == this.height && evt.getPropertyName().equals("value")) {
                if (this.slider.getValueIsAdjusting()) {
                    return;
                }
                float newValueDeg = ((Float)evt.getNewValue()).floatValue();
                this.slider.setValue(this.toSlider(newValueDeg));
                this.labelHeight.setText(String.format("%.2f ", Float.valueOf(newValueDeg)));
            }
        }
    }
}

