/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.nina;

import com.hybridlab.hyve3d.nina.CalibrationConfiguration;
import com.hybridlab.hyve3d.nina.Jme3DualViewPortRenderer;
import com.hybridlab.hyve3d.nina.Nina;
import com.hybridlab.hyve3d.nina.NinaConfiguration;
import com.hybridlab.hyve3d.rendering.spherical.ProjectionCalibrator;
import com.hybridlab.utils.Interpolation;
import com.jme3.math.ColorRGBA;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PreferencesWindow
extends JFrame {
    private static final long serialVersionUID = -3988608386265811714L;
    private NinaConfiguration config;
    private MaskAdapter maskAdapter;
    private RingMaskAdapter ringMaskAdapter;
    private ProjCalibAdapter projectionCalibrationAdapter;
    private Nina app;
    private JLabel lblVal_F1;
    private JLabel lblVal_F2;
    private JSlider slider_F2;
    private JSlider slider_F1;
    private JButton btnF1_Default;
    private JButton btnF2_Default;
    private JSpinner spinner_placement_new;
    private JSpinner spinner_width_new;
    private JSpinner spinner_height_new;
    private JSpinner spinner_Dimension;
    private JCheckBox chckbxCommunicationLight;
    private JCheckBox chckbx_Top;
    private JCheckBox chckbx_Entrance;
    private JLabel lblShift;
    private JSpinner spinner_shiftH;
    private JSpinner spinner_shiftV;
    private JPanel panel;

    public PreferencesWindow(Nina app) {
        this.app = app;
        this.setSize(500, 400);
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        JTabbedPane tabbedPane = new JTabbedPane(1);
        this.getContentPane().add((Component)tabbedPane, "Center");
        JPanel panel_Brightness = new JPanel();
        tabbedPane.addTab("Brightness", null, panel_Brightness, null);
        panel_Brightness.setLayout(null);
        this.chckbx_Entrance = new JCheckBox("Entrance");
        this.chckbx_Entrance.setBounds(47, 37, 86, 23);
        this.chckbx_Entrance.setEnabled(false);
        panel_Brightness.add(this.chckbx_Entrance);
        this.chckbx_Top = new JCheckBox("Top");
        this.chckbx_Top.setEnabled(false);
        this.chckbx_Top.setBounds(337, 37, 86, 23);
        panel_Brightness.add(this.chckbx_Top);
        this.spinner_placement_new = new JSpinner();
        this.spinner_placement_new.setBounds(47, 112, 86, 28);
        panel_Brightness.add(this.spinner_placement_new);
        this.spinner_width_new = new JSpinner();
        this.spinner_width_new.setBounds(47, 183, 86, 28);
        panel_Brightness.add(this.spinner_width_new);
        JLabel lblWidth = new JLabel("Width");
        lblWidth.setBounds(57, 155, 61, 16);
        panel_Brightness.add(lblWidth);
        JLabel lblPlacement = new JLabel("Placement");
        lblPlacement.setBounds(54, 84, 96, 16);
        panel_Brightness.add(lblPlacement);
        JLabel lblHeight = new JLabel("Height");
        lblHeight.setBounds(57, 235, 61, 16);
        panel_Brightness.add(lblHeight);
        this.spinner_height_new = new JSpinner();
        this.spinner_height_new.setBounds(47, 263, 86, 28);
        panel_Brightness.add(this.spinner_height_new);
        this.spinner_Dimension = new JSpinner();
        this.spinner_Dimension.setBounds(337, 112, 86, 28);
        panel_Brightness.add(this.spinner_Dimension);
        JLabel lblDimension = new JLabel("Dimension");
        lblDimension.setBounds(344, 84, 96, 16);
        panel_Brightness.add(lblDimension);
        this.chckbxCommunicationLight = new JCheckBox("Communication\nlight");
        this.chckbxCommunicationLight.setBounds(251, 248, 171, 43);
        panel_Brightness.add(this.chckbxCommunicationLight);
        tabbedPane.setEnabledAt(0, true);
        JPanel panel_Calibration = new JPanel();
        tabbedPane.addTab("Calibration", null, panel_Calibration, null);
        panel_Calibration.setLayout(new BorderLayout(0, 0));
        JPanel panel_CalibRows = new JPanel();
        panel_Calibration.add((Component)panel_CalibRows, "Center");
        GridBagLayout gbl_panel_CalibRows = new GridBagLayout();
        gbl_panel_CalibRows.columnWidths = new int[]{80, 0, 0, 0};
        gbl_panel_CalibRows.rowHeights = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        gbl_panel_CalibRows.columnWeights = new double[]{0.0, 1.0, 0.0, Double.MIN_VALUE};
        gbl_panel_CalibRows.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, Double.MIN_VALUE};
        panel_CalibRows.setLayout(gbl_panel_CalibRows);
        JLabel lblNewLabel_2 = new JLabel("Factor 1");
        lblNewLabel_2.setHorizontalAlignment(0);
        GridBagConstraints gbc_lblNewLabel_2 = new GridBagConstraints();
        gbc_lblNewLabel_2.anchor = 17;
        gbc_lblNewLabel_2.gridwidth = 2;
        gbc_lblNewLabel_2.insets = new Insets(0, 0, 5, 5);
        gbc_lblNewLabel_2.gridx = 0;
        gbc_lblNewLabel_2.gridy = 0;
        panel_CalibRows.add((Component)lblNewLabel_2, gbc_lblNewLabel_2);
        this.lblVal_F1 = new JLabel("val");
        GridBagConstraints gbc_lblVal_F1 = new GridBagConstraints();
        gbc_lblVal_F1.insets = new Insets(0, 0, 5, 5);
        gbc_lblVal_F1.gridx = 0;
        gbc_lblVal_F1.gridy = 1;
        panel_CalibRows.add((Component)this.lblVal_F1, gbc_lblVal_F1);
        this.slider_F1 = new JSlider();
        GridBagConstraints gbc_slider_F1 = new GridBagConstraints();
        gbc_slider_F1.fill = 2;
        gbc_slider_F1.insets = new Insets(0, 0, 5, 5);
        gbc_slider_F1.gridx = 1;
        gbc_slider_F1.gridy = 1;
        panel_CalibRows.add((Component)this.slider_F1, gbc_slider_F1);
        this.slider_F1.setValue(0);
        this.slider_F1.setMinorTickSpacing(1);
        this.slider_F1.setMaximum(1000);
        this.slider_F1.setMajorTickSpacing(10);
        this.btnF1_Default = new JButton("Default");
        GridBagConstraints gbc_btnF1_Default = new GridBagConstraints();
        gbc_btnF1_Default.insets = new Insets(0, 0, 5, 0);
        gbc_btnF1_Default.gridx = 2;
        gbc_btnF1_Default.gridy = 1;
        panel_CalibRows.add((Component)this.btnF1_Default, gbc_btnF1_Default);
        JLabel lblFactor = new JLabel("Factor 2");
        GridBagConstraints gbc_lblFactor = new GridBagConstraints();
        gbc_lblFactor.anchor = 17;
        gbc_lblFactor.insets = new Insets(0, 0, 5, 5);
        gbc_lblFactor.gridx = 0;
        gbc_lblFactor.gridy = 3;
        panel_CalibRows.add((Component)lblFactor, gbc_lblFactor);
        this.lblVal_F2 = new JLabel("val");
        GridBagConstraints gbc_lblVal_F2 = new GridBagConstraints();
        gbc_lblVal_F2.insets = new Insets(0, 0, 5, 5);
        gbc_lblVal_F2.gridx = 0;
        gbc_lblVal_F2.gridy = 4;
        panel_CalibRows.add((Component)this.lblVal_F2, gbc_lblVal_F2);
        this.slider_F2 = new JSlider();
        GridBagConstraints gbc_slider_F2 = new GridBagConstraints();
        gbc_slider_F2.fill = 2;
        gbc_slider_F2.insets = new Insets(0, 0, 5, 5);
        gbc_slider_F2.gridx = 1;
        gbc_slider_F2.gridy = 4;
        panel_CalibRows.add((Component)this.slider_F2, gbc_slider_F2);
        this.slider_F2.setValue(0);
        this.slider_F2.setMinorTickSpacing(1);
        this.slider_F2.setMaximum(1000);
        this.slider_F2.setMajorTickSpacing(10);
        this.btnF2_Default = new JButton("Default");
        GridBagConstraints gbc_btnF2_Default = new GridBagConstraints();
        gbc_btnF2_Default.insets = new Insets(0, 0, 5, 0);
        gbc_btnF2_Default.gridx = 2;
        gbc_btnF2_Default.gridy = 4;
        panel_CalibRows.add((Component)this.btnF2_Default, gbc_btnF2_Default);
        this.lblShift = new JLabel("Shift");
        GridBagConstraints gbc_lblShift = new GridBagConstraints();
        gbc_lblShift.anchor = 18;
        gbc_lblShift.insets = new Insets(0, 0, 5, 5);
        gbc_lblShift.gridx = 0;
        gbc_lblShift.gridy = 6;
        panel_CalibRows.add((Component)this.lblShift, gbc_lblShift);
        this.panel = new JPanel();
        this.panel.setLayout(null);
        GridBagConstraints gbc_panel = new GridBagConstraints();
        gbc_panel.insets = new Insets(0, 0, 5, 5);
        gbc_panel.fill = 1;
        gbc_panel.gridx = 1;
        gbc_panel.gridy = 6;
        panel_CalibRows.add((Component)this.panel, gbc_panel);
        this.spinner_shiftH = new JSpinner();
        this.spinner_shiftH.setBounds(133, 14, 75, 28);
        this.panel.add(this.spinner_shiftH);
        this.spinner_shiftV = new JSpinner();
        this.spinner_shiftV.setBounds(133, 54, 75, 28);
        this.panel.add(this.spinner_shiftV);
        JLabel lblHorizontal = new JLabel("horizontal");
        lblHorizontal.setBounds(50, 20, 75, 16);
        this.panel.add(lblHorizontal);
        JLabel lblVertical = new JLabel("vertical");
        lblVertical.setBounds(50, 60, 75, 16);
        this.panel.add(lblVertical);
        tabbedPane.setEnabledAt(1, true);
    }

    public void connectConfig(NinaConfiguration cfg) {
        this.config = cfg;
    }

    public void connect(Jme3DualViewPortRenderer.MaskModifier maskModifier) {
        this.maskAdapter = new MaskAdapter(maskModifier);
        this.maskAdapter.setUIElements(this.chckbxCommunicationLight, this.chckbx_Entrance, this.spinner_height_new, this.spinner_placement_new, this.spinner_width_new, this.spinner_shiftH, this.spinner_shiftV);
        this.maskAdapter.updateUI();
        this.ringMaskAdapter = new RingMaskAdapter(maskModifier);
        this.ringMaskAdapter.setUIElements(this.chckbx_Top, this.spinner_Dimension);
        this.ringMaskAdapter.updateUI();
    }

    public void connect(ProjectionCalibrator projectionCalibrator) {
        CalibrationConfiguration projcalibconf = this.config.getProjectionCalibration();
        this.projectionCalibrationAdapter = new ProjCalibAdapter(projectionCalibrator, projcalibconf, this.config);
        this.projectionCalibrationAdapter.setUIElementsForProjectionCalibration(this.slider_F2, this.slider_F1, this.lblVal_F2, this.lblVal_F1, this.btnF2_Default, this.btnF1_Default);
        this.projectionCalibrationAdapter.updateUIForProjectionCalibration();
    }

    private class MaskAdapter {
        private Jme3DualViewPortRenderer.MaskModifier maskModifier;
        private JSpinner spinner_height;
        private JSpinner spinner_placement;
        private JSpinner spinner_width;
        private JSpinner spinner_shiftH;
        private JSpinner spinner_shiftV;
        private JCheckBox chckbxEllipticalMask;
        private JCheckBox chckbxCommunicationLight;

        public MaskAdapter(Jme3DualViewPortRenderer.MaskModifier maskModifier) {
            this.maskModifier = maskModifier;
        }

        public void setUIElements(JCheckBox chckbxCommunicationLight, JCheckBox chckbxEllipticalMask, JSpinner spinner_height, JSpinner spinner_placement, JSpinner spinner_width, JSpinner spinner_shiftH, JSpinner spinner_shiftV) {
            this.chckbxCommunicationLight = chckbxCommunicationLight;
            this.chckbxEllipticalMask = chckbxEllipticalMask;
            this.spinner_height = spinner_height;
            this.spinner_placement = spinner_placement;
            this.spinner_width = spinner_width;
            this.spinner_shiftH = spinner_shiftH;
            this.spinner_shiftV = spinner_shiftV;
            chckbxEllipticalMask.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    if (MaskAdapter.this.chckbxEllipticalMask.isSelected()) {
                        MaskAdapter.this.maskModifier.setMaskVisibility(true);
                    } else {
                        MaskAdapter.this.maskModifier.setMaskVisibility(false);
                    }
                }
            });
            chckbxCommunicationLight.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    if (MaskAdapter.this.chckbxCommunicationLight.isSelected()) {
                        MaskAdapter.this.maskModifier.setEllipseColor(NinaConfiguration.CalibrationColor);
                    } else {
                        MaskAdapter.this.maskModifier.setEllipseColor(ColorRGBA.Black);
                    }
                }
            });
            ChangeListener changelistener = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (e.getSource() == MaskAdapter.this.spinner_height) {
                        float value = ((Double)MaskAdapter.this.spinner_height.getValue()).floatValue();
                        MaskAdapter.this.maskModifier.setEllipseHeight(value);
                    } else if (e.getSource() == MaskAdapter.this.spinner_width) {
                        float value = ((Double)MaskAdapter.this.spinner_width.getValue()).floatValue();
                        MaskAdapter.this.maskModifier.setEllipseWidth(value);
                    } else if (e.getSource() == MaskAdapter.this.spinner_placement) {
                        float value = ((Double)MaskAdapter.this.spinner_placement.getValue()).floatValue();
                        MaskAdapter.this.maskModifier.setEllipsePosition(value);
                    } else if (e.getSource() == MaskAdapter.this.spinner_shiftH) {
                        float value = ((Double)MaskAdapter.this.spinner_shiftH.getValue()).floatValue();
                        MaskAdapter.this.maskModifier.setShiftHorizontal(value);
                    } else if (e.getSource() == MaskAdapter.this.spinner_shiftV) {
                        float value = ((Double)MaskAdapter.this.spinner_shiftV.getValue()).floatValue();
                        MaskAdapter.this.maskModifier.setShiftVertical(value);
                    }
                }
            };
            double step = 0.001;
            double max = 3.0;
            double min = -3.0;
            double value = this.maskModifier.getEllipseHeight();
            SpinnerNumberModel mdl_height = new SpinnerNumberModel(value, min, max, step);
            this.spinner_height.setModel(mdl_height);
            this.spinner_height.addChangeListener(changelistener);
            value = this.maskModifier.getEllipseWidth();
            SpinnerNumberModel mdl_width = new SpinnerNumberModel(value, min, max, step);
            this.spinner_width.setModel(mdl_width);
            this.spinner_width.addChangeListener(changelistener);
            value = this.maskModifier.getEllipsePosition();
            SpinnerNumberModel mdl_placement = new SpinnerNumberModel(value, min, max, step);
            this.spinner_placement.setModel(mdl_placement);
            this.spinner_placement.addChangeListener(changelistener);
            step = 1.0;
            max = 50.0;
            min = -50.0;
            value = this.maskModifier.getShiftHorizontal();
            SpinnerNumberModel mdl_ShiftH = new SpinnerNumberModel(value, min, max, step);
            this.spinner_shiftH.setModel(mdl_ShiftH);
            this.spinner_shiftH.addChangeListener(changelistener);
            value = this.maskModifier.getShiftVertical();
            SpinnerNumberModel mdl_ShiftV = new SpinnerNumberModel(value, min, max, step);
            this.spinner_shiftV.setModel(mdl_ShiftV);
            this.spinner_shiftV.addChangeListener(changelistener);
        }

        public void updateUI() {
            this.chckbxEllipticalMask.setSelected(this.maskModifier.getMaskVisibility());
        }
    }

    private class RingMaskAdapter {
        private Jme3DualViewPortRenderer.MaskModifier maskModifier;
        private JSpinner spinner_radius;
        private JCheckBox chckbxRingMask;

        public RingMaskAdapter(Jme3DualViewPortRenderer.MaskModifier maskModifier) {
            this.maskModifier = maskModifier;
        }

        public void setUIElements(JCheckBox chckbxRingMask, JSpinner spinner_radius) {
            this.chckbxRingMask = chckbxRingMask;
            this.spinner_radius = spinner_radius;
            chckbxRingMask.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    if (RingMaskAdapter.this.chckbxRingMask.isSelected()) {
                        RingMaskAdapter.this.maskModifier.setRingMaskVisibility(true);
                    } else {
                        RingMaskAdapter.this.maskModifier.setRingMaskVisibility(false);
                    }
                }
            });
            ChangeListener changelistener = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (e.getSource() == RingMaskAdapter.this.spinner_radius) {
                        float value = ((Double)RingMaskAdapter.this.spinner_radius.getValue()).floatValue();
                        RingMaskAdapter.this.maskModifier.setRingRadius(value);
                    }
                }
            };
            double step = 0.002;
            double max = 1.0;
            double min = 0.5;
            double value = this.maskModifier.getRingRadius();
            SpinnerNumberModel mdl_radius = new SpinnerNumberModel(value, min, max, step);
            this.spinner_radius.setModel(mdl_radius);
            this.spinner_radius.addChangeListener(changelistener);
        }

        public void updateUI() {
            this.chckbxRingMask.setSelected(this.maskModifier.getRingMaskVisibility());
        }
    }

    private class ProjCalibAdapter {
        private CalibrationConfiguration projectionCalibrationConfig;
        private NinaConfiguration conf;
        private ProjectionCalibrator calibrator;
        private JSlider slider_ssf;
        private JSlider slider_svpr;
        private JLabel label_ssf;
        private JLabel label_svpr;

        public ProjCalibAdapter(ProjectionCalibrator projectionCalibrator, CalibrationConfiguration projectionCalibration, NinaConfiguration config) {
            this.calibrator = projectionCalibrator;
            this.projectionCalibrationConfig = projectionCalibration;
            this.conf = config;
            this.calibrator.registerChangeListener(this.projectionCalibrationConfig);
        }

        public void setUIElementsForProjectionCalibration(JSlider slider_ssf, JSlider slider_svpr, JLabel label_ssf, JLabel label_svpr, JButton button_default_ssf, JButton button_default_svpr) {
            this.slider_ssf = slider_ssf;
            this.slider_svpr = slider_svpr;
            this.label_ssf = label_ssf;
            this.label_svpr = label_svpr;
            button_default_ssf.setActionCommand("default ssf");
            button_default_svpr.setActionCommand("default svpr");
            ActionListener buttonActionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    ProjCalibAdapter.this.defaultPressed(arg0.getActionCommand());
                }
            };
            for (JButton b : new JButton[]{button_default_ssf, button_default_svpr}) {
                b.addActionListener(buttonActionListener);
            }
        }

        protected void defaultPressed(String actionCommand) {
            if (actionCommand.equals("default ssf")) {
                this.calibrator.setSphereScale(1.0f);
                this.label_ssf.setText(String.format("%.1f ", Float.valueOf(1.0f)));
            } else if (actionCommand.equals("default svpr")) {
                this.calibrator.setViewPortRadius(1.0f);
                this.label_svpr.setText(String.format("%.1f ", Float.valueOf(1.0f)));
            }
        }

        public void updateUIForProjectionCalibration() {
            float cd = this.calibrator.getSphereScale();
            this.slider_ssf.setValue(this.toSlider(cd, ProjCalibValue.ssf));
            this.label_ssf.setText(String.format("%.1f ", Float.valueOf(cd)));
            this.slider_ssf.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    JSlider source = (JSlider)e.getSource();
                    float v = ProjCalibAdapter.this.fromSlider(source.getValue(), ProjCalibValue.ssf);
                    ProjCalibAdapter.this.label_ssf.setText(String.format("%.1f ", Float.valueOf(v)));
                    if (ProjCalibAdapter.this.calibrator.getSphereScale() != v) {
                        ProjCalibAdapter.this.calibrator.setSphereScale(v);
                    }
                }
            });
            cd = this.calibrator.getViewPortRadius();
            this.slider_svpr.setValue(this.toSlider(cd, ProjCalibValue.svpr));
            this.label_svpr.setText(String.format("%.1f ", Float.valueOf(cd)));
            this.slider_svpr.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    JSlider source = (JSlider)e.getSource();
                    float v = ProjCalibAdapter.this.fromSlider(source.getValue(), ProjCalibValue.svpr);
                    ProjCalibAdapter.this.label_svpr.setText(String.format("%.1f ", Float.valueOf(v)));
                    if (ProjCalibAdapter.this.calibrator.getViewPortRadius() != v) {
                        ProjCalibAdapter.this.calibrator.setViewPortRadius(v);
                    }
                }
            });
        }

        private int toSlider(float value, ProjCalibValue v) {
            float min;
            float max = switch (v) {
                case ProjCalibValue.ssf -> {
                    min = 0.01f;
                    yield 2.0f;
                }
                default -> {
                    min = -2.0f;
                    yield 2.0f;
                }
            };
            float slidermin = 0.0f;
            float slidermax = 1000.0f;
            return (int)Interpolation.inttrf(value, min, max, slidermin, slidermax);
        }

        private float fromSlider(int value, ProjCalibValue v) {
            float min;
            float max = switch (v) {
                case ProjCalibValue.ssf -> {
                    min = 0.01f;
                    yield 2.0f;
                }
                default -> {
                    min = -2.0f;
                    yield 2.0f;
                }
            };
            float slidermin = 0.0f;
            float slidermax = 1000.0f;
            return Interpolation.inttrf(value, slidermin, slidermax, min, max);
        }
    }

    private static enum ProjCalibValue {
        ssf,
        svpr;

    }
}

