/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.nina;

import com.hybridlab.hyve3d.network.ResourceProvider;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.DefaultListModel;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ResourceProviderWatcherWindow
extends JFrame
implements ResourceProvider.ResourceProviderListener {
    private ResourceProvider resourceProvider;
    private DefaultListModel listModel;
    private ImagePanel imgpanel;
    private static final long serialVersionUID = 6763116822187089381L;
    private JPanel panel;
    private JList list;
    private JPanel panel_1;
    private JTextField textField;

    public ResourceProviderWatcherWindow(ResourceProvider resourceProvider) {
        this.setSize(1100, 1000);
        this.resourceProvider = resourceProvider;
        this.resourceProvider.addListener(this);
        this.setTitle("Rendered Resources Debug Window");
        JSplitPane splitPane = new JSplitPane();
        splitPane.setOrientation(0);
        splitPane.setResizeWeight(0.15);
        this.getContentPane().add((Component)splitPane, "Center");
        this.listModel = new DefaultListModel();
        this.panel_1 = new JPanel();
        splitPane.setLeftComponent(this.panel_1);
        GridBagLayout gbl_panel_1 = new GridBagLayout();
        gbl_panel_1.columnWidths = new int[]{0};
        gbl_panel_1.rowHeights = new int[]{0, 0};
        gbl_panel_1.columnWeights = new double[]{1.0};
        gbl_panel_1.rowWeights = new double[]{Double.MIN_VALUE, 0.0};
        this.panel_1.setLayout(gbl_panel_1);
        this.panel = new JPanel();
        splitPane.setRightComponent(this.panel);
        this.imgpanel = new ImagePanel(null);
        this.panel.add(this.imgpanel);
        this.list = new JList(this.listModel);
        GridBagConstraints gbc_list = new GridBagConstraints();
        gbc_list.fill = 1;
        gbc_list.insets = new Insets(0, 0, 5, 0);
        gbc_list.gridx = 0;
        gbc_list.gridy = 0;
        this.panel_1.add((Component)this.list, gbc_list);
        this.list.setSelectionMode(0);
        this.textField = new JTextField();
        GridBagConstraints gbc_textField = new GridBagConstraints();
        gbc_textField.fill = 2;
        gbc_textField.gridx = 0;
        gbc_textField.gridy = 1;
        this.panel_1.add((Component)this.textField, gbc_textField);
        this.textField.setColumns(10);
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ResourceProviderWatcherWindow.this.p("valueChanged");
                if (!e.getValueIsAdjusting()) {
                    ResourceProviderWatcherWindow.this.p("valueChanged && e.getValueIsAdjusting() == false");
                    if (ResourceProviderWatcherWindow.this.list.getSelectedIndex() == -1) {
                        ResourceProviderWatcherWindow.this.p("list.getSelectedIndex() == -1");
                    } else {
                        String url = (String)ResourceProviderWatcherWindow.this.list.getSelectedValue();
                        ResourceProviderWatcherWindow.this.p("url" + url);
                        ResourceProviderWatcherWindow.this.showImage(url);
                    }
                }
            }
        });
    }

    @Override
    public void onResourcesRemoved(ResourceProvider rp, final String[] resourceids) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (String s : resourceids) {
                    String url = ResourceProviderWatcherWindow.this.resourceProvider.getUrlForResource(s);
                    ResourceProviderWatcherWindow.this.listModel.removeElement(url);
                }
            }
        });
    }

    @Override
    public void onResourceAdded(ResourceProvider resourceProvider, String name) {
        if (resourceProvider == this.resourceProvider) {
            String url = resourceProvider.getUrlForResource(name);
            this.listModel.addElement(url);
        }
    }

    private void showImage(String surl) {
        BufferedImage image = null;
        try {
            byte[] data = this.resourceProvider.getResourceForURL(surl);
            image = ImageIO.read(new ByteArrayInputStream(data));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.imgpanel.setImg(image);
        this.textField.setText(surl);
    }

    private void p(String s) {
    }

    class ImagePanel
    extends JPanel {
        private static final long serialVersionUID = -1523327996535329433L;
        private Image img;

        ImagePanel(Image img) {
            this.img = img;
        }

        public void setImg(Image img) {
            this.img = img;
            this.repaint();
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(1024, 768);
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            g.clearRect(0, 0, this.getWidth(), this.getHeight());
            if (this.img != null) {
                g.drawImage(this.img, 0, 0, this);
            }
        }
    }
}

