/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.nina;

import com.hybridlab.hyve3d.hyve.Rotations;
import com.hybridlab.utils.math.MathUtils;
import com.jme3.math.Quaternion;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public class RotationControlWindow
extends JFrame
implements Rotations.RotationsListener {
    private static final long serialVersionUID = -290790773401783845L;
    private JLabel label_iPadRaw;
    private JLabel label_iPad;
    private JLabel lblDrawingarea;
    private JLabel label_drawingarea;

    public RotationControlWindow() {
        this.setSize(500, 400);
        this.setTitle("RotationControlWindow");
        Rotations.addListener(this);
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        gridBagLayout.columnWeights = new double[]{1.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        this.getContentPane().setLayout(gridBagLayout);
        JLabel lblIpadRaw = new JLabel("iPad raw");
        GridBagConstraints gbc_lblIpadRaw = new GridBagConstraints();
        gbc_lblIpadRaw.insets = new Insets(0, 0, 5, 0);
        gbc_lblIpadRaw.gridx = 0;
        gbc_lblIpadRaw.gridy = 1;
        this.getContentPane().add((Component)lblIpadRaw, gbc_lblIpadRaw);
        this.label_iPadRaw = new JLabel("x");
        GridBagConstraints gbc_lblX = new GridBagConstraints();
        gbc_lblX.insets = new Insets(0, 0, 5, 0);
        gbc_lblX.gridx = 0;
        gbc_lblX.gridy = 2;
        this.getContentPane().add((Component)this.label_iPadRaw, gbc_lblX);
        JLabel lblIpad = new JLabel("iPad");
        GridBagConstraints gbc_lblIpad = new GridBagConstraints();
        gbc_lblIpad.insets = new Insets(0, 0, 5, 0);
        gbc_lblIpad.gridx = 0;
        gbc_lblIpad.gridy = 4;
        this.getContentPane().add((Component)lblIpad, gbc_lblIpad);
        this.label_iPad = new JLabel("x");
        GridBagConstraints gbc_label_iPad = new GridBagConstraints();
        gbc_label_iPad.insets = new Insets(0, 0, 5, 0);
        gbc_label_iPad.gridx = 0;
        gbc_label_iPad.gridy = 5;
        this.getContentPane().add((Component)this.label_iPad, gbc_label_iPad);
        this.lblDrawingarea = new JLabel("DrawingArea");
        GridBagConstraints gbc_lblDrawingarea = new GridBagConstraints();
        gbc_lblDrawingarea.insets = new Insets(0, 0, 5, 0);
        gbc_lblDrawingarea.gridx = 0;
        gbc_lblDrawingarea.gridy = 7;
        this.getContentPane().add((Component)this.lblDrawingarea, gbc_lblDrawingarea);
        this.label_drawingarea = new JLabel("rx=0.00 ry=0.00 rz=0.00");
        GridBagConstraints gbc_label_drawingarea = new GridBagConstraints();
        gbc_label_drawingarea.gridx = 0;
        gbc_label_drawingarea.gridy = 8;
        this.getContentPane().add((Component)this.label_drawingarea, gbc_label_drawingarea);
        this.update();
    }

    private void update() {
        this.label_iPad.setText(MathUtils.quaternionToAxisAngleInDegreesString(Rotations.get(Rotations.RotationIdentifier.iPad)));
        this.label_iPadRaw.setText(MathUtils.quaternionToAxisAngleInDegreesString(Rotations.get(Rotations.RotationIdentifier.iPadRaw)));
        this.label_drawingarea.setText(MathUtils.quaternionToAxisAngleInDegreesString(Rotations.get(Rotations.RotationIdentifier.DrawingArea)));
    }

    @Override
    public void onRotationChanged(Rotations.RotationIdentifier which, final Quaternion newValue) {
        JLabel label;
        switch (which) {
            case DrawingArea: {
                label = this.label_drawingarea;
                break;
            }
            case iPad: {
                label = this.label_iPad;
                break;
            }
            case iPadRaw: {
                label = this.label_iPadRaw;
                break;
            }
            default: {
                return;
            }
        }
        if (label != null && newValue != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    label.setText(MathUtils.quaternionToAxisAngleInDegreesString(newValue));
                }
            });
        }
    }
}

