/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.nina;

import com.hybridlab.hyve3d.config.NamedAngle;
import com.hybridlab.hyve3d.hyve.Hyve;
import com.hybridlab.hyveswingapp.TrackPanel;
import com.jme3.math.FastMath;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TrackPadImitationWindow
extends JFrame
implements TrackPanel.TrackValueReceiver {
    private static final long serialVersionUID = -3988608386265811714L;
    private Hyve localhyve;
    private JSlider sliderY;
    private JSlider tiltAngleSimulationSlider;
    private JLabel tiltLabel;
    private AngleSliderAdapter tiltAngleAdapter;

    public TrackPadImitationWindow() {
        this.setTitle("Trackpad-Imitation");
        this.setSize(519, 385);
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{30, 0, 0, 0};
        gridBagLayout.rowHeights = new int[]{30, 0, 30, 0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, 1.0, 0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 1.0, 0.0, 0.0, Double.MIN_VALUE};
        this.getContentPane().setLayout(gridBagLayout);
        TrackPanel panel = new TrackPanel();
        panel.setReceiver(this);
        panel.setBackground(Color.LIGHT_GRAY);
        GridBagConstraints gbc_panel = new GridBagConstraints();
        gbc_panel.insets = new Insets(0, 0, 5, 5);
        gbc_panel.fill = 1;
        gbc_panel.gridx = 1;
        gbc_panel.gridy = 1;
        this.getContentPane().add((Component)panel, gbc_panel);
        this.sliderY = new JSlider();
        this.sliderY.setSnapToTicks(true);
        this.sliderY.setValue(0);
        this.sliderY.setPaintTrack(false);
        this.sliderY.setMajorTickSpacing(90);
        this.sliderY.setMinorTickSpacing(30);
        this.sliderY.setPaintTicks(true);
        this.sliderY.setMinimum(-90);
        this.sliderY.setMaximum(90);
        this.sliderY.setOrientation(1);
        GridBagConstraints gbc_sliderY = new GridBagConstraints();
        gbc_sliderY.insets = new Insets(0, 0, 5, 0);
        gbc_sliderY.gridx = 2;
        gbc_sliderY.gridy = 1;
        this.getContentPane().add((Component)this.sliderY, gbc_sliderY);
        this.tiltLabel = new JLabel("tilt angle: 0\u00b0");
        GridBagConstraints gbc_tiltLabel = new GridBagConstraints();
        gbc_tiltLabel.insets = new Insets(0, 0, 5, 5);
        gbc_tiltLabel.gridx = 1;
        gbc_tiltLabel.gridy = 2;
        this.getContentPane().add((Component)this.tiltLabel, gbc_tiltLabel);
        this.tiltAngleSimulationSlider = new JSlider();
        this.tiltAngleSimulationSlider.setValue(0);
        this.tiltAngleSimulationSlider.setMaximum(90);
        this.tiltAngleSimulationSlider.setMinimum(-90);
        GridBagConstraints gbc_tiltAngleSimulationSlider = new GridBagConstraints();
        gbc_tiltAngleSimulationSlider.fill = 2;
        gbc_tiltAngleSimulationSlider.insets = new Insets(0, 0, 0, 5);
        gbc_tiltAngleSimulationSlider.gridx = 1;
        gbc_tiltAngleSimulationSlider.gridy = 3;
        this.getContentPane().add((Component)this.tiltAngleSimulationSlider, gbc_tiltAngleSimulationSlider);
    }

    public void setLocalHyve(Hyve localhyve) {
        this.localhyve = localhyve;
        this.connectTiltAngle(localhyve.getTiltAngle());
    }

    private void connectTiltAngle(NamedAngle tiltAngle) {
        this.tiltAngleAdapter = new AngleSliderAdapter(tiltAngle, this.tiltAngleSimulationSlider, this.tiltLabel);
    }

    @Override
    public void feedToTrack(Vector2f move) {
        float y;
        if (this.localhyve == null) {
            return;
        }
        Vector3f direction = new Vector3f();
        direction.x = move.x;
        direction.z = move.y;
        float angleDeg = this.sliderY.getValue();
        direction.y = y = FastMath.sin((float)(angleDeg * ((float)Math.PI / 180))) * direction.length();
        this.localhyve.onNavigationRequest(this, direction);
    }

    private class AngleSliderAdapter
    implements PropertyChangeListener {
        private NamedAngle angle;
        private JSlider slider;
        private JLabel labelDegrees;

        public AngleSliderAdapter(NamedAngle angle, JSlider slider, JLabel labelDegrees) {
            this.slider = slider;
            this.angle = angle;
            this.labelDegrees = labelDegrees;
            slider.setValue(this.toSlider(angle.getAngleInDegrees()));
            labelDegrees.setText(String.format("tilt angle: %.1f\u00b0", Float.valueOf(angle.getAngleInDegrees())));
            this.angle.addPropertyChangeListener(this);
            this.slider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    JSlider source = (JSlider)e.getSource();
                    float v = AngleSliderAdapter.this.fromSlider(source.getValue());
                    AngleSliderAdapter.this.labelDegrees.setText(String.format("%.1f \u00b0", Float.valueOf(v)));
                    if (AngleSliderAdapter.this.angle.getAngleInDegrees() != v) {
                        AngleSliderAdapter.this.angle.setAngleInDegrees(v);
                    }
                }
            });
        }

        private int toSlider(float angle) {
            return (int)angle;
        }

        private float fromSlider(int value) {
            return value;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() == this.angle && evt.getPropertyName().equals("angle")) {
                if (this.slider.getValueIsAdjusting()) {
                    return;
                }
                float newValueDeg = ((Float)evt.getNewValue()).floatValue();
                this.slider.setValue(this.toSlider(newValueDeg));
                this.labelDegrees.setText(String.format("%.1f \u00b0", Float.valueOf(newValueDeg)));
            }
        }
    }
}

