/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.nina;

import com.hybridlab.hyve3d.LocalFileScene;
import com.hybridlab.hyve3d.data.domainobjects.CommandHistory;
import com.hybridlab.hyve3d.data.domainobjects.Space;
import com.hybridlab.hyve3d.files.ImportOptions;
import com.hybridlab.hyve3d.hyve.FileTypes;
import com.hybridlab.hyve3d.hyve.GlobalSettings;
import com.hybridlab.hyve3d.hyve.HyveApplication;
import com.hybridlab.hyve3d.hyve.SatelliteCenter;
import com.hybridlab.hyve3d.hyve.undoredo.HistoryController;
import com.hybridlab.hyve3d.inputdevice.InputDeviceManager;
import com.hybridlab.hyve3d.network.ResourceProvider;
import com.hybridlab.hyve3d.network.discovery.NetworkServiceManager;
import com.hybridlab.hyve3d.network.interconnection.messages.Registry;
import com.hybridlab.hyve3d.nina.EULAWindow;
import com.hybridlab.hyve3d.nina.EnterLicenseKeyWindow;
import com.hybridlab.hyve3d.nina.FileDialogParentWindow;
import com.hybridlab.hyve3d.nina.HyveApplicationImportProcess;
import com.hybridlab.hyve3d.nina.ImmersionMode;
import com.hybridlab.hyve3d.nina.ImportOptionsWindow;
import com.hybridlab.hyve3d.nina.Jme3ApplicationWindow;
import com.hybridlab.hyve3d.nina.Jme3DualViewPortRenderer;
import com.hybridlab.hyve3d.nina.NetworkingWindow;
import com.hybridlab.hyve3d.nina.NinaConfiguration;
import com.hybridlab.hyve3d.nina.PanoramaControlWindow;
import com.hybridlab.hyve3d.nina.PreferencesWindow;
import com.hybridlab.hyve3d.nina.QuitHandler;
import com.hybridlab.hyve3d.nina.ResourceProviderWatcherWindow;
import com.hybridlab.hyve3d.nina.RotationControlWindow;
import com.hybridlab.hyve3d.nina.SceneControlWindow;
import com.hybridlab.hyve3d.nina.SplashWindow;
import com.hybridlab.hyve3d.nina.TrackPadImitationWindow;
import com.hybridlab.licensing.Feature;
import com.hybridlab.licensing.LicenseKey;
import com.hybridlab.utils.Hardware4Mac;
import com.hybridlab.utils.logging.MessageBox;
import com.jme3.math.ColorRGBA;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.desktop.AboutEvent;
import java.awt.desktop.AboutHandler;
import java.awt.desktop.PreferencesEvent;
import java.awt.desktop.PreferencesHandler;
import java.awt.desktop.QuitEvent;
import java.awt.desktop.QuitResponse;
import java.awt.desktop.QuitStrategy;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

class WindowTestApp
implements QuitHandler {
    private boolean runFromJar;
    private MenuController menuController;
    private MenuUndoRedoAdapter undoRedoAdapter;
    private ResourceProviderWatcherWindow resourceWatcherWindow;
    private RotationControlWindow rotationWindow;
    private SceneControlWindow sceneWindow;
    private TrackPadImitationWindow trackPadImitationWindow;
    private PreferencesWindow preferencesWindow;
    private FileDialogParentWindow fileDialogParentWindow;
    private NinaConfiguration cfg;
    private Jme3ApplicationWindow mainWindow;
    private SplashWindow splashWindow;
    private HyveApplication app;
    private NetworkingWindow networkingViewWindow;
    private NetworkServiceManager networkServiceManager;
    private SatelliteCenter satCenter;
    private InputDeviceManager inputDeviceManager;
    private Desktop macApplication = Desktop.getDesktop();
    private OSXApplicationAdapter adapter = new OSXApplicationAdapter();
    private Runnable finalStepRunnable;
    private boolean finalStepCalled = false;
    private LicenseKey license;
    private EULAWindow eulaWindow;
    private EnterLicenseKeyWindow licensingWindow;
    private PanoramaControlWindow panoramaControlWindow;
    private Timer autoExportTimer;

    public static void main(String[] args) {
        Logger.getLogger("de.lessvoid").setLevel(Level.SEVERE);
        Logger.getLogger("com.jme3").setLevel(Level.SEVERE);
        WindowTestApp n = new WindowTestApp();
        n.start();
    }

    private WindowTestApp() {
        this.macApplication.setQuitHandler(this.adapter);
        this.macApplication.setAboutHandler(this.adapter);
        this.macApplication.setQuitStrategy(QuitStrategy.CLOSE_ALL_WINDOWS);
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        this.menuController = new MenuController(this.macApplication);
        try {
            System.setProperty("apple.awt.brushMetalLook", "true");
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "ABC123");
            System.setProperty("apple.awt.textantialiasing", "true");
            System.setProperty("apple.awt.graphics.EnableQ2DX", "true");
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        String impver = this.getImplementationVersionFromManifest();
        String versionInfo = String.format("%s", impver);
        this.createMenuRelatedWindows();
    }

    private void placeFileDialogToCenterOfFirstScreen(FileDialog fd) {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().clearGlobalFocusOwner();
    }

    private List<File> scanSkyFiles() {
        File skyFolder = new File(this.app.getHyveAssetFolder(), "sky");
        ArrayList<File> files = new ArrayList<File>(FileUtils.listFiles(skyFolder, new String[]{"dds"}, false));
        return files;
    }

    private void synchronizeHyvePositions(boolean b) {
        this.app.setSynchronizeHyvePositions(b);
    }

    private void eraseAll() {
        int dialogButton = 0;
        int dialogResult = JOptionPane.showConfirmDialog(null, "Do you like to erase all ?", "Warning", dialogButton);
        if (dialogResult == 0) {
            this.app.eraseAll();
        }
    }

    private void clearSky() {
        this.app.getLocalHyve().clearSkyInCurrentSession();
    }

    private void resetNavigation() {
        Space sp = this.app.getLocalHyve().getLocalSpace();
        sp.resetTransformationToDefault();
    }

    private void setOnlyUseTCP(boolean onlyusetcp) {
        this.app.getNetworking().getHubNode().setUseUDP(!onlyusetcp);
    }

    private void saveToLocalFile(String directory, String filename) {
        LocalFileScene storage = new LocalFileScene();
        storage.filename = filename;
        storage.directory = directory;
        this.app.saveFile(storage);
    }

    public void openLocalFile(String dir, String filename, FileTypes type) {
        LocalFileScene storage = new LocalFileScene();
        storage.filename = filename;
        storage.directory = dir;
        this.app.openFile(storage, type);
    }

    public void importLocalFile(String dir, String filename, FileTypes type) {
        LocalFileScene storage = new LocalFileScene();
        storage.filename = filename;
        storage.directory = dir;
        ImportOptions options = ImportOptions.createDefaultOptions();
        HyveApplicationImportProcess p = new HyveApplicationImportProcess(this.app, storage, type, options);
        if (switch (type) {
            case FileTypes.HYVE, FileTypes.OBJ, FileTypes.OBJ_ZIPPED, FileTypes.OGRE_ZIPPED, FileTypes.PLY_POINTCLOUD -> true;
            default -> false;
        }) {
            final ImportOptionsWindow w = new ImportOptionsWindow(p, this.mainWindow.getErrorVisualizer());
            Point location = this.getLocationOnFirstScreenForWindowSize(w.getWidth(), w.getHeight());
            w.setLocation(location);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    w.setVisible(true);
                }
            });
        } else {
            try {
                Thread importThread = new Thread((Runnable)p, "importing " + p.describeMe());
                importThread.start();
            }
            catch (Exception e) {
                this.mainWindow.getErrorVisualizer().showReasonOfException(e);
                e.printStackTrace();
            }
        }
    }

    private String getImplementationVersionFromManifest() {
        Class<WindowTestApp> clazz = WindowTestApp.class;
        String className = clazz.getSimpleName() + ".class";
        String classPath = clazz.getResource(className).toString();
        if (!classPath.startsWith("jar")) {
            this.runFromJar = false;
            return "run from eclipse";
        }
        this.runFromJar = true;
        String manifestPath = classPath.substring(0, classPath.lastIndexOf("!") + 1) + "/META-INF/MANIFEST.MF";
        try {
            Manifest manifest = new Manifest(new URL(manifestPath).openStream());
            Attributes attr = manifest.getMainAttributes();
            String value = attr.getValue("Implementation-Version");
            return value;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return "";
    }

    private void showTrackPadImitationWindow() {
        if (this.trackPadImitationWindow != null) {
            this.trackPadImitationWindow.setVisible(true);
        }
    }

    private void showResourceWatcherWindow() {
        if (this.resourceWatcherWindow != null) {
            this.resourceWatcherWindow.setVisible(true);
        }
    }

    private void showSceneWindow() {
        if (this.sceneWindow != null) {
            this.sceneWindow.setVisible(true);
        }
    }

    private void showRotationWindow() {
        if (this.rotationWindow != null) {
            this.rotationWindow.setVisible(true);
        }
    }

    private void showPreferencesWindow() {
        Set<Feature> features = this.getLicense().getEnabledFeatures();
        if (this.preferencesWindow != null && features.contains((Object)Feature.IMMERSIVE)) {
            this.preferencesWindow.setVisible(true);
        }
    }

    private void start() {
        Registry.registerMessageTypes();
        this.finalStepRunnable = new Runnable(){

            @Override
            public void run() {
                try {
                    System.out.println("Hello from WindowTest");
                    WindowTestApp.this.showRotationWindow();
                    GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
                    GraphicsDevice[] gs = ge.getScreenDevices();
                    for (int j = 0; j < gs.length; ++j) {
                        GraphicsDevice gd = gs[j];
                        GraphicsDevice defaultScreenDevice = ge.getDefaultScreenDevice();
                        GraphicsConfiguration[] gc = gd.getConfigurations();
                        for (int i = 0; i < gc.length; ++i) {
                            JFrame f = new JFrame(gs[j].getDefaultConfiguration());
                            Canvas c = new Canvas(gc[i]);
                            Rectangle gcBounds = gc[i].getBounds();
                            String info = "screenid=" + j + " idString=" + gd.getIDstring() + " gconf=" + i + "\n bounds=" + gcBounds + "\n scaleX=" + gc[i].getDefaultTransform().getScaleX() + "\n scaleY=" + gc[i].getDefaultTransform().getScaleY() + "\n" + (gd == defaultScreenDevice ? " defaultScreenDevice" : "") + "\n";
                            System.out.println(info);
                            int xoffs = gcBounds.x;
                            int yoffs = gcBounds.y;
                            f.getContentPane().add(c);
                            f.setLocation(i * 50 + xoffs, i * 60 + yoffs);
                            f.setSize(gcBounds.width, gcBounds.height);
                            JLabel label = new JLabel(info);
                            f.add(label);
                            f.setVisible(true);
                        }
                    }
                    JFrame frame = new JFrame("DMB");
                    JPanel dm = new JPanel(){

                        @Override
                        public Dimension getPreferredSize() {
                            return new Dimension(320, 240);
                        }
                    };
                    dm.setBorder(BorderFactory.createLineBorder(Color.blue, 10));
                    frame.setDefaultCloseOperation(3);
                    frame.add(dm);
                    frame.pack();
                    frame.setLocationByPlatform(true);
                    JMenuBar menuBar = new JMenuBar();
                    JMenu fileMenu = new JMenu("File");
                    menuBar.add(fileMenu);
                    frame.setJMenuBar(menuBar);
                    frame.setVisible(true);
                    JMenu menu_import = new JMenu("Import...");
                    JMenuItem mi_importObj = new JMenuItem("Wavefront (*.obj)");
                    menu_import.add(mi_importObj);
                    mi_importObj.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent arg0) {
                            String fileHint = " '*.obj' or '*.zip' ";
                            Object[] validTypes = new String[]{".obj", ".zip"};
                            FileDialog fd = new FileDialog((Frame)WindowTestApp.this.fileDialogParentWindow, "open a " + fileHint + "file", 0);
                            fd.setAlwaysOnTop(true);
                            WindowTestApp.this.placeFileDialogToCenterOfFirstScreen(fd);
                            fd.setVisible(true);
                            String filename = fd.getFile();
                            String dir = fd.getDirectory();
                            if (filename == null) {
                                System.out.println("You cancelled the choice");
                            } else {
                                System.out.println("You chose " + filename + " in " + dir);
                                boolean hasValidType = false;
                                for (String string : validTypes) {
                                    if (!filename.toLowerCase().endsWith(string)) continue;
                                    hasValidType = true;
                                    break;
                                }
                                if (hasValidType) {
                                    FileTypes ft = filename.toLowerCase().endsWith(".zip") ? FileTypes.OBJ_ZIPPED : FileTypes.OBJ;
                                    WindowTestApp.this.importLocalFile(dir, filename, ft);
                                } else {
                                    MessageBox.show("You have to select one of the following filetypes for this import type:\n" + StringUtils.join(validTypes, " "));
                                }
                            }
                        }
                    });
                    mi_importObj.setEnabled(true);
                    menuBar.add(menu_import);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        this.finalStep();
    }

    private void finalStep() {
        if (this.finalStepRunnable == null) {
            return;
        }
        if (this.finalStepCalled) {
            return;
        }
        this.finalStepCalled = true;
        try {
            SwingUtilities.invokeLater(this.finalStepRunnable);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setLicense(LicenseKey license) {
        this.license = license;
    }

    private LicenseKey getLicense() {
        return this.license;
    }

    private void checkLicense() {
        block8: {
            final String hardwareuuid = Hardware4Mac.getHardwareUUIDNumber();
            final LicenseKey.LicenceValidator val = new LicenseKey.LicenceValidator(){

                @Override
                public boolean isValidKey(String key) {
                    if (key == null) {
                        return false;
                    }
                    if (key.isEmpty()) {
                        return false;
                    }
                    String uppercaseTrimmedKey = key.trim().toUpperCase();
                    LicenseKey lk = new LicenseKey(uppercaseTrimmedKey);
                    try {
                        return lk.isValidForHardwareIDAtThisMoment(hardwareuuid);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return false;
                    }
                }
            };
            final EnterLicenseKeyWindow.LicenseEnteredCallback callback = new EnterLicenseKeyWindow.LicenseEnteredCallback(){

                @Override
                public void onLicenseKeyEntered(String licenskey, int numtrys, boolean savingNecessary) throws Exception {
                    String uppercaseTrimmedKey;
                    LicenseKey lk;
                    if (licenskey.equals("CANCEL")) {
                        System.out.println("CANCELED DUE TO NO VALID LICENSE");
                        System.exit(0);
                    }
                    if (!(lk = new LicenseKey(uppercaseTrimmedKey = licenskey.trim().toUpperCase())).isValidForHardwareIDAtThisMoment(hardwareuuid)) {
                        if (numtrys <= 10) {
                            WindowTestApp.this.askForLicenseKey("The license does not match your hardware. Please enter a valid license key!", hardwareuuid, numtrys + 1, val, "", this);
                        } else {
                            System.out.println("NO VALID LICENSE");
                            System.exit(0);
                        }
                    } else {
                        lk.setValid(true);
                        WindowTestApp.this.setLicense(lk);
                        WindowTestApp.this.finalStep();
                        if (savingNecessary) {
                            try {
                                System.out.println("Saving license file...");
                                File f = new File("license.txt");
                                f.delete();
                                IOUtils.write(lk.toLicenseKeyString(), (OutputStream)new FileOutputStream(f));
                            }
                            catch (FileNotFoundException e1) {
                                e1.printStackTrace();
                            }
                            catch (IOException e1) {
                                e1.printStackTrace();
                            }
                        }
                    }
                }
            };
            EULAWindow.EulaAcceptedCallback callbackEULA = new EULAWindow.EulaAcceptedCallback(){

                @Override
                public void onEulaAccepted() {
                    WindowTestApp.this.askForLicenseKey("Please enter your license key.", hardwareuuid, 1, val, "", callback);
                }

                @Override
                public void onCanceled() {
                    System.out.println("CANCELED DUE TO EULA NOT ACCEPTED");
                    System.exit(0);
                }
            };
            String key = null;
            try {
                List<String> lines = IOUtils.readLines(new FileInputStream("license.txt"));
                key = lines.get(0);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (key != null) {
                String uppercaseTrimmedKey = key.trim().toUpperCase();
                try {
                    LicenseKey lk = new LicenseKey(uppercaseTrimmedKey);
                    if (!lk.isValidForHardwareIDAtThisMoment(hardwareuuid)) {
                        this.showEula(callbackEULA);
                        break block8;
                    }
                    boolean saving = false;
                    callback.onLicenseKeyEntered(uppercaseTrimmedKey, 0, saving);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                this.showEula(callbackEULA);
            }
        }
    }

    private void showEula(final EULAWindow.EulaAcceptedCallback callbackEULA) {
        class MyRunnable
        implements Runnable {
            MyRunnable() {
            }

            @Override
            public void run() {
                if (WindowTestApp.this.eulaWindow != null) {
                    WindowTestApp.this.eulaWindow.dispose();
                    WindowTestApp.this.eulaWindow = null;
                }
                WindowTestApp.this.eulaWindow = new EULAWindow(callbackEULA, WindowTestApp.this.getEulaHTMLText());
                WindowTestApp.this.eulaWindow.setDefaultCloseOperation(0);
                int w = 750;
                int h = 750;
                WindowTestApp.this.eulaWindow.setSize(w, h);
                Point location = WindowTestApp.this.getLocationOnFirstScreenForWindowSize(w, h);
                WindowTestApp.this.eulaWindow.setLocation(location);
                WindowTestApp.this.eulaWindow.setVisible(true);
            }
        }
        MyRunnable r = new MyRunnable();
        SwingUtilities.invokeLater(r);
    }

    private void askForLicenseKey(final String reason, final String mac, final int numberOfRequests, final LicenseKey.LicenceValidator val, final String key, final EnterLicenseKeyWindow.LicenseEnteredCallback callback) {
        class MyRunnable
        implements Runnable {
            MyRunnable() {
            }

            @Override
            public void run() {
                if (WindowTestApp.this.licensingWindow != null) {
                    WindowTestApp.this.licensingWindow.dispose();
                    WindowTestApp.this.licensingWindow = null;
                }
                WindowTestApp.this.licensingWindow = new EnterLicenseKeyWindow(reason, mac, numberOfRequests, "continue", val, key, callback);
                WindowTestApp.this.licensingWindow.setDefaultCloseOperation(0);
                int w = 750;
                int h = 450;
                WindowTestApp.this.licensingWindow.setSize(w, h);
                Point location = WindowTestApp.this.getLocationOnFirstScreenForWindowSize(w, h);
                WindowTestApp.this.licensingWindow.setLocation(location);
                WindowTestApp.this.licensingWindow.setVisible(true);
            }
        }
        MyRunnable r = new MyRunnable();
        SwingUtilities.invokeLater(r);
    }

    public String getEulaHTMLText() {
        URL i1 = this.getClass().getResource("eula/imagetop.png");
        URL i2 = this.getClass().getResource("eula/imagebottom.png");
        InputStream is = this.getClass().getResourceAsStream("eula/eulanew.html");
        try {
            List<String> lines = IOUtils.readLines(is, Charset.forName("UTF8"));
            String eula = StringUtils.join(lines, "\n");
            eula = StringUtils.replace(eula, "imagetop.png", i1.toString());
            eula = StringUtils.replace(eula, "imagebottom.png", i2.toString());
            return eula;
        }
        catch (IOException e) {
            e.printStackTrace();
            return "<html><b>EULA</b><br/>eula text not readable.</html>";
        }
    }

    public void showFileInFinderFolder(String absolutepathandfile) {
        try {
            String mvnClean = "open -R " + absolutepathandfile;
            String OS = System.getProperty("os.name");
            System.out.println("OS is: " + OS);
            if (!OS.contains("Windows")) {
                Process process = Runtime.getRuntime().exec(mvnClean);
            }
        }
        catch (Exception e) {
            this.mainWindow.getErrorVisualizer().showReasonOfException(e);
        }
    }

    private void showSplashWindow() {
        if (this.splashWindow == null) {
            return;
        }
        this.splashWindow.setVisible(true);
    }

    private void hideSplashWindowDelayed(int millis) {
        if (this.splashWindow == null) {
            return;
        }
        Timer timer = new Timer();
        long delay = millis;
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                WindowTestApp.this.splashWindow.setVisible(false);
            }
        }, delay);
    }

    private void setupSketchLog(boolean enabled) {
        if (enabled) {
            String home = System.getProperty("user.home");
            File sessionLogFolder = new File(home + File.separator + "Desktop" + File.separator + "Hyve3DSketchLog");
            this.app.enableSessionLogging(sessionLogFolder);
        } else {
            this.app.disableSessionLogging();
        }
    }

    private boolean isSketchLogEnabled() {
        return this.app.isSessionLogEnabled();
    }

    private void setupAutoExportTimer(boolean enabled) {
        if (enabled) {
            this.setupAutoExportTimer(5000, 15000);
        } else {
            this.destroyAutoExportTimer();
        }
    }

    private boolean isAutoExportEnabled() {
        return this.autoExportTimer != null;
    }

    private void destroyAutoExportTimer() {
        if (this.autoExportTimer != null) {
            this.autoExportTimer.cancel();
            this.autoExportTimer = null;
        }
    }

    private void setupAutoExportTimer(int firstdelayMillis, int millisBetweenExportAttemps) {
        if (this.autoExportTimer == null) {
            this.autoExportTimer = new Timer();
            this.autoExportTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    WindowTestApp.this.tryAutoExport();
                }
            }, firstdelayMillis, (long)millisBetweenExportAttemps);
        }
    }

    protected void tryAutoExport() {
        String directoryAutoExport = null;
        String filenameAutoExport = "AutoExport.dxf";
        String home = System.getProperty("user.home");
        File desktop = new File(home + File.separator + "Desktop" + File.separator + "Hyve3DAutoExportDXF");
        directoryAutoExport = desktop.getAbsolutePath();
        this.saveToLocalFile(directoryAutoExport, filenameAutoExport);
    }

    private void setupFPSUpdateTimer(int firstdelayMillis, int millisBetweenFPSUpdate) {
        if (this.mainWindow == null) {
            return;
        }
        Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                WindowTestApp.this.mainWindow.updateFPSVisualization();
            }
        }, firstdelayMillis, (long)millisBetweenFPSUpdate);
    }

    private void setupProgressUpdateTimer(int firstdelayMillis, int millisBetweenUpdate) {
        if (this.mainWindow == null) {
            return;
        }
        Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                WindowTestApp.this.mainWindow.updateProgressVisualization();
            }
        }, firstdelayMillis, (long)millisBetweenUpdate);
    }

    private void systemExitDelayed(int millis) {
        Timer timer = new Timer();
        long delay = millis;
        if (millis > 0) {
            System.out.println("sheduling 'System.exit(0))' to be called in " + String.valueOf(millis) + " Milliseconds ...");
        }
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                System.out.println("calling 'System.exit(0))' from within " + WindowTestApp.class.getName() + " now!");
                System.exit(0);
            }
        }, delay);
    }

    @Override
    public void quit(QuitHandler.Source source) {
        System.out.println("calling 'mainWindow.stop()' from within " + WindowTestApp.class.getName() + "\n in Thread " + Thread.currentThread().toString());
        this.cfg.saveIfChanged();
        this.splashWindow.setVisible(false);
        this.splashWindow.dispose();
        this.mainWindow.stop();
        this.satCenter.stop();
        this.networkServiceManager.stop();
        if (source.equals((Object)QuitHandler.Source.Window)) {
            this.systemExitDelayed(150);
        }
    }

    private void createMenuRelatedWindows() {
        this.networkingViewWindow = new NetworkingWindow();
        this.networkingViewWindow.setSize(514, 651);
        this.trackPadImitationWindow = new TrackPadImitationWindow();
        this.trackPadImitationWindow.setSize(520, 380);
        this.rotationWindow = new RotationControlWindow();
        this.sceneWindow = new SceneControlWindow();
        this.panoramaControlWindow = new PanoramaControlWindow();
    }

    private void createResourceWatcherWindow(ResourceProvider resourceProvider) {
        this.resourceWatcherWindow = new ResourceProviderWatcherWindow(resourceProvider);
    }

    private Point getLocationOnFirstScreenForWindowSize(int w, int h) {
        GraphicsEnvironment environment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] screens = environment.getScreenDevices();
        GraphicsDevice screen = screens[0];
        DisplayMode mode = screen.getDisplayMode();
        int screenWidth = mode.getWidth();
        int screenHeight = mode.getHeight();
        Dimension dimensionsOfFirstScreen = new Dimension(screenWidth, screenHeight);
        return new Point(dimensionsOfFirstScreen.width / 2 - w / 2, dimensionsOfFirstScreen.height / 2 - h / 2);
    }

    void enableDeveloperMode() {
        this.menuController.setDevelopermode(!this.menuController.isDeveloperModeEnabled());
    }

    public boolean isDeveloperModeEnabled() {
        boolean b = false;
        if (this.menuController != null) {
            b = this.menuController.isDeveloperModeEnabled();
        }
        return b;
    }

    private class OSXApplicationAdapter
    implements java.awt.desktop.QuitHandler,
    PreferencesHandler,
    AboutHandler {
        private OSXApplicationAdapter() {
        }

        @Override
        public void handleAbout(AboutEvent e) {
            WindowTestApp.this.showSplashWindow();
        }

        @Override
        public void handlePreferences(PreferencesEvent e) {
            WindowTestApp.this.showPreferencesWindow();
        }

        @Override
        public void handleQuitRequestWith(QuitEvent e, QuitResponse response) {
            response.performQuit();
        }
    }

    private class MenuController {
        private Desktop macApplication;
        private NinaConfiguration config;
        private JMenu menuDeveloper;
        private JMenu menuMisc;
        private Set<Feature> enabledFeatures;
        private JCheckBoxMenuItem showFPS;
        private JSeparator modeSeparator;
        private JCheckBoxMenuItem menuItem_enableImmersiveMode;
        private JCheckBoxMenuItem menuItem_enableNonImmersiveMode;
        private JCheckBoxMenuItem toggleFullScreen;
        private JCheckBoxMenuItem highlightMask;
        private JMenu menuDisplay;
        private boolean useAlternativeSaveDialog = true;
        private File currentDirectory = null;

        public MenuController(Desktop macApplication) {
            this.macApplication = macApplication;
        }

        public void createMenu() {
            this.macApplication.setDefaultMenuBar(this.createMenuBar());
        }

        public void setDevelopermode(boolean enable) {
            this.menuDeveloper.setVisible(enable);
        }

        private void setAutoExportEnabled(boolean enabled) {
            WindowTestApp.this.setupAutoExportTimer(enabled);
        }

        private void setSketchLogEnabled(boolean enabled) {
            WindowTestApp.this.setupSketchLog(enabled);
        }

        private JMenuBar createMenuBar() {
            JMenuBar menubar = new JMenuBar();
            JMenu fileMenu = new JMenu("File");
            JMenu scaffoldMenu = new JMenu("Background geometry");
            String[] stringArray = new String[]{"Cube forest", "Training geometries"};
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String item;
                final String s = item = stringArray[i];
                final JMenuItem bgCity = new JMenuItem(s);
                scaffoldMenu.add(bgCity);
                bgCity.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                String menuEntry = WindowTestApp.this.app.toggleBackGround(s);
                                bgCity.setText(menuEntry);
                            }
                        });
                    }
                });
            }
            JMenu menu_import = new JMenu("Import...");
            JMenuItem mi_importObj = new JMenuItem("Wavefront (*.obj)");
            menu_import.add(mi_importObj);
            mi_importObj.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    String fileHint = " '*.obj' or '*.zip' ";
                    Object[] validTypes = new String[]{".obj", ".zip"};
                    FileDialog fd = new FileDialog((Frame)WindowTestApp.this.fileDialogParentWindow, "open a " + fileHint + "file", 0);
                    fd.setAlwaysOnTop(true);
                    WindowTestApp.this.placeFileDialogToCenterOfFirstScreen(fd);
                    fd.setVisible(true);
                    String filename = fd.getFile();
                    String dir = fd.getDirectory();
                    if (filename == null) {
                        System.out.println("You cancelled the choice");
                    } else {
                        System.out.println("You chose " + filename + " in " + dir);
                        boolean hasValidType = false;
                        for (String string : validTypes) {
                            if (!filename.toLowerCase().endsWith(string)) continue;
                            hasValidType = true;
                            break;
                        }
                        if (hasValidType) {
                            FileTypes ft = filename.toLowerCase().endsWith(".zip") ? FileTypes.OBJ_ZIPPED : FileTypes.OBJ;
                            WindowTestApp.this.importLocalFile(dir, filename, ft);
                        } else {
                            MessageBox.show("You have to select one of the following filetypes for this import type:\n" + StringUtils.join(validTypes, " "));
                        }
                    }
                }
            });
            mi_importObj.setEnabled(true);
            JMenuItem mi_importPointCloudFile = new JMenuItem("Pointcloud (*.ply)");
            menu_import.add(mi_importPointCloudFile);
            mi_importPointCloudFile.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    String fileHint = "'*.ply' ";
                    Object[] validTypes = new String[]{".ply"};
                    FileDialog fd = new FileDialog((Frame)WindowTestApp.this.fileDialogParentWindow, "open a " + fileHint + "file", 0);
                    fd.setAlwaysOnTop(true);
                    WindowTestApp.this.placeFileDialogToCenterOfFirstScreen(fd);
                    fd.setVisible(true);
                    String filename = fd.getFile();
                    String dir = fd.getDirectory();
                    if (filename == null) {
                        System.out.println("You cancelled the choice");
                    } else {
                        System.out.println("You chose " + filename + " in " + dir);
                        boolean hasValidType = false;
                        for (String string : validTypes) {
                            if (!filename.toLowerCase().endsWith(string)) continue;
                            hasValidType = true;
                            break;
                        }
                        if (hasValidType) {
                            FileTypes ft = filename.toLowerCase().endsWith(".ply") ? FileTypes.PLY_POINTCLOUD : FileTypes.UNKNOWN;
                            WindowTestApp.this.importLocalFile(dir, filename, ft);
                        } else {
                            MessageBox.show("You have to select one of the following filetypes for this import type:\n" + StringUtils.join(validTypes, " "));
                        }
                    }
                }
            });
            mi_importPointCloudFile.setEnabled(true);
            JMenuItem mi_importHyve = new JMenuItem("Hyve-3D (*.hyve)");
            menu_import.add(mi_importHyve);
            mi_importHyve.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    String fileHint = " '*.hyve' ";
                    Object[] validTypes = new String[]{".hyve"};
                    FileDialog fd = new FileDialog((Frame)WindowTestApp.this.fileDialogParentWindow, "open a " + fileHint + "file", 0);
                    WindowTestApp.this.placeFileDialogToCenterOfFirstScreen(fd);
                    fd.setAlwaysOnTop(true);
                    fd.setVisible(true);
                    String filename = fd.getFile();
                    String dir = fd.getDirectory();
                    if (filename == null) {
                        System.out.println("You cancelled the choice");
                    } else {
                        System.out.println("You chose " + filename + " in " + dir);
                        boolean hasValidType = false;
                        for (String string : validTypes) {
                            if (!filename.toLowerCase().endsWith(string)) continue;
                            hasValidType = true;
                            break;
                        }
                        if (hasValidType) {
                            WindowTestApp.this.importLocalFile(dir, filename, FileTypes.HYVE);
                        } else {
                            MessageBox.show("You have to select one of the following filetypes for this import type:\n" + StringUtils.join(validTypes, " "));
                        }
                    }
                }
            });
            mi_importHyve.setEnabled(true);
            JMenuItem mi_importOGRE = new JMenuItem("Asset (zip package)");
            mi_importOGRE.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    String fileHint = " '*.zip' ";
                    Object[] validTypes = new String[]{".zip"};
                    FileDialog fd = new FileDialog((Frame)WindowTestApp.this.fileDialogParentWindow, "open a " + fileHint + "file", 0);
                    fd.setAlwaysOnTop(true);
                    WindowTestApp.this.placeFileDialogToCenterOfFirstScreen(fd);
                    fd.setVisible(true);
                    String filename = fd.getFile();
                    String dir = fd.getDirectory();
                    if (filename == null) {
                        System.out.println("You cancelled the choice");
                    } else {
                        System.out.println("You chose " + filename + " in " + dir);
                        boolean hasValidType = false;
                        for (String string : validTypes) {
                            if (!filename.toLowerCase().endsWith(string)) continue;
                            hasValidType = true;
                            break;
                        }
                        if (hasValidType) {
                            WindowTestApp.this.importLocalFile(dir, filename, FileTypes.OGRE_ZIPPED);
                        } else {
                            MessageBox.show("You have to select one of the following filetypes for this import type:\n" + StringUtils.join(validTypes, " "));
                        }
                    }
                }
            });
            mi_importOGRE.setEnabled(true);
            JMenu menu_export = new JMenu("Export...");
            menu_export.add(new JSeparator());
            JMenuItem mi_exportSTL = new JMenuItem("3D Sketches to STL file");
            menu_export.add(mi_exportSTL);
            mi_exportSTL.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    Object filename;
                    System.out.println("Export STL...");
                    String directory = null;
                    Object[] validTypes = new String[]{".stl"};
                    if (MenuController.this.useAlternativeSaveDialog) {
                        JFileChooser fc = new JFileChooser();
                        fc.setFileSelectionMode(0);
                        fc.setAcceptAllFileFilterUsed(false);
                        if (MenuController.this.currentDirectory == null) {
                            String home = System.getProperty("user.home");
                            MenuController.this.currentDirectory = new File(home + File.separator + "Desktop");
                        }
                        File suggestedfile = new File(MenuController.this.currentDirectory, "Untitled.stl");
                        fc.setSelectedFile(suggestedfile);
                        fc.setFileFilter(new FileFilter(){

                            @Override
                            public String getDescription() {
                                return "*.stl";
                            }

                            @Override
                            public boolean accept(File f) {
                                if (f == null) {
                                    return false;
                                }
                                return f.isFile() && f.getName().toLowerCase().endsWith("stl");
                            }
                        });
                        int returnVal = fc.showDialog(WindowTestApp.this.fileDialogParentWindow, "Export");
                        if (returnVal == 0) {
                            File file = fc.getSelectedFile();
                            filename = file.getName();
                            if (!((String)filename).endsWith(".stl")) {
                                filename = (String)filename + ".stl";
                            }
                            directory = file.getParent();
                            MenuController.this.currentDirectory = new File(directory);
                        } else {
                            filename = null;
                            directory = null;
                        }
                    } else {
                        FileDialog fd2 = new FileDialog((Frame)WindowTestApp.this.fileDialogParentWindow, "Export STL", 1);
                        fd2.setFile("Untitled.stl");
                        fd2.setAlwaysOnTop(true);
                        WindowTestApp.this.placeFileDialogToCenterOfFirstScreen(fd2);
                        fd2.setVisible(true);
                        filename = fd2.getFile();
                        directory = fd2.getDirectory();
                    }
                    if (filename == null) {
                        System.out.println("You cancelled the choice");
                    } else {
                        boolean hasValidType = false;
                        for (String string : validTypes) {
                            if (!((String)filename).toLowerCase().endsWith(string)) continue;
                            hasValidType = true;
                            break;
                        }
                        if (hasValidType) {
                            WindowTestApp.this.saveToLocalFile(directory, (String)filename);
                        } else {
                            MessageBox.show("You have to chose a filename with the ending:\n" + StringUtils.join(validTypes, " "));
                        }
                    }
                }
            });
            JMenuItem mi_exportDXF = new JMenuItem("3D Sketches to DXF file");
            menu_export.add(mi_exportDXF);
            mi_exportDXF.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    Object filename;
                    System.out.println("Export DXF...");
                    String directory = null;
                    Object[] validTypes = new String[]{".dxf"};
                    if (MenuController.this.useAlternativeSaveDialog) {
                        JFileChooser fc = new JFileChooser();
                        fc.setFileSelectionMode(0);
                        fc.setAcceptAllFileFilterUsed(false);
                        if (MenuController.this.currentDirectory == null) {
                            String home = System.getProperty("user.home");
                            MenuController.this.currentDirectory = new File(home + File.separator + "Desktop");
                        }
                        File suggestedfile = new File(MenuController.this.currentDirectory, "Untitled.dxf");
                        fc.setSelectedFile(suggestedfile);
                        fc.setFileFilter(new FileFilter(){

                            @Override
                            public String getDescription() {
                                return "*.dxf";
                            }

                            @Override
                            public boolean accept(File f) {
                                if (f == null) {
                                    return false;
                                }
                                return f.isFile() && f.getName().toLowerCase().endsWith("dxf");
                            }
                        });
                        int returnVal = fc.showDialog(WindowTestApp.this.fileDialogParentWindow, "Export");
                        if (returnVal == 0) {
                            File file = fc.getSelectedFile();
                            filename = file.getName();
                            if (!((String)filename).endsWith(".dxf")) {
                                filename = (String)filename + ".dxf";
                            }
                            directory = file.getParent();
                            MenuController.this.currentDirectory = new File(directory);
                        } else {
                            filename = null;
                            directory = null;
                        }
                    } else {
                        FileDialog fd2 = new FileDialog((Frame)WindowTestApp.this.fileDialogParentWindow, "Export DXF", 1);
                        fd2.setFile("Untitled.dxf");
                        fd2.setAlwaysOnTop(true);
                        WindowTestApp.this.placeFileDialogToCenterOfFirstScreen(fd2);
                        fd2.setVisible(true);
                        filename = fd2.getFile();
                        directory = fd2.getDirectory();
                    }
                    if (filename == null) {
                        System.out.println("You cancelled the choice");
                    } else {
                        boolean hasValidType = false;
                        for (String string : validTypes) {
                            if (!((String)filename).toLowerCase().endsWith(string)) continue;
                            hasValidType = true;
                            break;
                        }
                        if (hasValidType) {
                            WindowTestApp.this.saveToLocalFile(directory, (String)filename);
                        } else {
                            MessageBox.show("You have to chose a filename with the ending:\n" + StringUtils.join(validTypes, " "));
                        }
                    }
                }
            });
            mi_exportDXF.setEnabled(true);
            menu_export.add(new JSeparator());
            String disableText = "Disable automatic export to dxf";
            String enableText = "Enable automatic export to dxf";
            final JMenuItem enableAutoExport = new JMenuItem("Enable automatic export to dxf");
            enableAutoExport.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    if (WindowTestApp.this.isAutoExportEnabled()) {
                        MenuController.this.setAutoExportEnabled(false);
                        enableAutoExport.setText("Enable automatic export to dxf");
                    } else {
                        MenuController.this.setAutoExportEnabled(true);
                        enableAutoExport.setText("Disable automatic export to dxf");
                    }
                }
            });
            menu_export.add(enableAutoExport);
            disableText = "Disable sketch log";
            enableText = "Enable sketch log";
            final JMenuItem enableSketchLog = new JMenuItem("Enable sketch log");
            enableSketchLog.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    if (WindowTestApp.this.isSketchLogEnabled()) {
                        MenuController.this.setSketchLogEnabled(false);
                        enableSketchLog.setText("Enable sketch log");
                    } else {
                        MenuController.this.setSketchLogEnabled(true);
                        enableSketchLog.setText("Disable sketch log");
                    }
                }
            });
            menu_export.add(enableSketchLog);
            JMenuItem open = new JMenuItem("Open (*.hyve) ...");
            open.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    String fileHint = " '*.hyve' ";
                    Object[] validTypes = new String[]{".hyve", ".xml"};
                    FileDialog fd = new FileDialog((Frame)WindowTestApp.this.fileDialogParentWindow, "open a " + fileHint + "file", 0);
                    fd.setAlwaysOnTop(true);
                    WindowTestApp.this.placeFileDialogToCenterOfFirstScreen(fd);
                    fd.setVisible(true);
                    String filename = fd.getFile();
                    String dir = fd.getDirectory();
                    if (filename == null) {
                        System.out.println("You cancelled the choice");
                    } else {
                        System.out.println("You chose " + filename + " in " + dir);
                        boolean hasValidType = false;
                        for (String string : validTypes) {
                            if (!filename.toLowerCase().endsWith(string)) continue;
                            hasValidType = true;
                            break;
                        }
                        if (hasValidType) {
                            WindowTestApp.this.openLocalFile(dir, filename, FileTypes.HYVE);
                        } else {
                            MessageBox.show("You have to select one of the following filetypes for this import type:\n" + StringUtils.join(validTypes, " "));
                        }
                    }
                }
            });
            open.setEnabled(true);
            JMenuItem saveAsItem = new JMenuItem("Save (*.hyve) ...");
            saveAsItem.setAccelerator(KeyStroke.getKeyStroke(83, 1 | Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            saveAsItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Object filename;
                    System.out.println("Save As...");
                    String directory = null;
                    if (MenuController.this.useAlternativeSaveDialog) {
                        JFileChooser fc = new JFileChooser();
                        fc.setFileSelectionMode(0);
                        fc.setAcceptAllFileFilterUsed(false);
                        if (MenuController.this.currentDirectory == null) {
                            String home = System.getProperty("user.home");
                            MenuController.this.currentDirectory = new File(home + File.separator + "Desktop");
                        }
                        File suggestedfile = new File(MenuController.this.currentDirectory, "Untitled.hyve");
                        fc.setSelectedFile(suggestedfile);
                        fc.setFileFilter(new FileFilter(){

                            @Override
                            public String getDescription() {
                                return "*.hyve";
                            }

                            @Override
                            public boolean accept(File f) {
                                if (f == null) {
                                    return false;
                                }
                                return f.isFile() && f.getName().toLowerCase().endsWith("hyve");
                            }
                        });
                        int returnVal = fc.showSaveDialog(WindowTestApp.this.fileDialogParentWindow);
                        if (returnVal == 0) {
                            File file = fc.getSelectedFile();
                            filename = file.getName();
                            if (!((String)filename).endsWith(".hyve")) {
                                filename = (String)filename + ".hyve";
                            }
                            directory = file.getParent();
                            MenuController.this.currentDirectory = new File(directory);
                        } else {
                            filename = null;
                            directory = null;
                        }
                    } else {
                        FileDialog fd2 = new FileDialog((Frame)WindowTestApp.this.fileDialogParentWindow, "Save", 1);
                        fd2.setFile("Untitled.hyve");
                        fd2.setAlwaysOnTop(true);
                        WindowTestApp.this.placeFileDialogToCenterOfFirstScreen(fd2);
                        fd2.setVisible(true);
                        filename = fd2.getFile();
                        directory = fd2.getDirectory();
                    }
                    if (filename != null) {
                        WindowTestApp.this.saveToLocalFile(directory, (String)filename);
                    }
                }
            });
            saveAsItem.setEnabled(true);
            fileMenu.add(open);
            fileMenu.add(saveAsItem);
            fileMenu.add(new JSeparator());
            fileMenu.add(menu_import);
            fileMenu.add(menu_export);
            fileMenu.add(new JSeparator());
            fileMenu.add(scaffoldMenu);
            final JMenu skySelectMenu = new JMenu("Sky");
            final JMenuItem noSky = new JMenuItem("Remove");
            noSky.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    WindowTestApp.this.clearSky();
                }
            });
            skySelectMenu.addMenuListener(new MenuListener(){

                @Override
                public void menuSelected(MenuEvent e) {
                    skySelectMenu.removeAll();
                    try {
                        List<File> skyFiles = WindowTestApp.this.scanSkyFiles();
                        for (final File f : skyFiles) {
                            JMenuItem item = new JMenuItem(StringUtils.remove(f.getName(), ".dds"));
                            skySelectMenu.add(item);
                            item.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent arg0) {
                                    String dir = f.getParent();
                                    FileTypes ft = f.getName().toLowerCase().endsWith(".dds") ? FileTypes.DDS_SKY : FileTypes.UNKNOWN;
                                    WindowTestApp.this.importLocalFile(dir, f.getName(), ft);
                                }
                            });
                        }
                    }
                    catch (Exception ex) {
                        JMenuItem item = new JMenuItem("No sky files found.");
                        skySelectMenu.add(item);
                    }
                    skySelectMenu.add(new JSeparator());
                    skySelectMenu.add(noSky);
                }

                @Override
                public void menuDeselected(MenuEvent e) {
                }

                @Override
                public void menuCanceled(MenuEvent e) {
                }
            });
            JMenu skyMenu = new JMenu("Sky");
            fileMenu.add(skySelectMenu);
            boolean showImportDDS = false;
            if (showImportDDS) {
                JMenuItem skydds = new JMenuItem("Import *.dds file");
                skyMenu.add(skydds);
                skydds.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent arg0) {
                        String fileHint = " '*.dds'";
                        Object[] validTypes = new String[]{".dds"};
                        FileDialog fd = new FileDialog((Frame)WindowTestApp.this.fileDialogParentWindow, "open a " + fileHint + "file", 0);
                        fd.setAlwaysOnTop(true);
                        WindowTestApp.this.placeFileDialogToCenterOfFirstScreen(fd);
                        fd.setVisible(true);
                        String filename = fd.getFile();
                        String dir = fd.getDirectory();
                        if (filename == null) {
                            System.out.println("You cancelled the choice");
                        } else {
                            System.out.println("You chose " + filename + " in " + dir);
                            boolean hasValidType = false;
                            for (String string : validTypes) {
                                if (!filename.toLowerCase().endsWith(string)) continue;
                                hasValidType = true;
                                break;
                            }
                            if (hasValidType) {
                                FileTypes ft = filename.toLowerCase().endsWith(".dds") ? FileTypes.DDS_SKY : FileTypes.UNKNOWN;
                                WindowTestApp.this.importLocalFile(dir, filename, ft);
                            } else {
                                MessageBox.show("You have to select one of the following filetypes for this import type:\n" + StringUtils.join(validTypes, " "));
                            }
                        }
                    }
                });
                skydds.setEnabled(true);
            }
            menubar.add(fileMenu);
            JMenu menuEdit = new JMenu("Edit");
            menubar.add(menuEdit);
            JMenuItem undo = new JMenuItem("Undo");
            undo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    WindowTestApp.this.undoRedoAdapter.undo();
                }
            });
            undo.setEnabled(false);
            JMenuItem redo = new JMenuItem("Redo");
            redo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    WindowTestApp.this.undoRedoAdapter.redo();
                }
            });
            redo.setEnabled(false);
            WindowTestApp.this.undoRedoAdapter = new MenuUndoRedoAdapter(undo, redo);
            boolean showUndoRedoInEditMenu = false;
            if (showUndoRedoInEditMenu) {
                menuEdit.add(undo);
                menuEdit.add(redo);
                menuEdit.add(new JSeparator());
            }
            JMenuItem eraseAll = new JMenuItem("Erase all");
            eraseAll.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    System.out.println("Erase all!");
                    WindowTestApp.this.eraseAll();
                }
            });
            eraseAll.setEnabled(true);
            menuEdit.add(eraseAll);
            JMenu networkingMenu = new JMenu("Network");
            menubar.add(networkingMenu);
            JMenuItem overview = new JMenuItem("Connection ...");
            overview.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (WindowTestApp.this.networkingViewWindow != null) {
                                WindowTestApp.this.networkingViewWindow.setVisible(true);
                            }
                        }
                    });
                }
            });
            networkingMenu.add(overview);
            networkingMenu.add(new JSeparator());
            final JCheckBoxMenuItem onlyusetcp = new JCheckBoxMenuItem("Only use TCP (no UDP)", false);
            onlyusetcp.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            boolean b = onlyusetcp.isSelected();
                            WindowTestApp.this.setOnlyUseTCP(b);
                        }
                    });
                }
            });
            networkingMenu.add(onlyusetcp);
            this.highlightMask = new JCheckBoxMenuItem("Communication light", false);
            networkingMenu.add(this.highlightMask);
            this.highlightMask.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Jme3DualViewPortRenderer.MaskModifier maskModifier = WindowTestApp.this.mainWindow.getMaskModifier();
                    boolean b = maskModifier.colorIsCalibrationColor();
                    if (b) {
                        maskModifier.setEllipseColor(ColorRGBA.Black);
                    } else {
                        maskModifier.setEllipseColor(NinaConfiguration.CalibrationColor);
                    }
                }
            });
            networkingMenu.addMenuListener(new MenuListener(){

                @Override
                public void menuSelected(MenuEvent e) {
                    Jme3DualViewPortRenderer.MaskModifier maskModifier = WindowTestApp.this.mainWindow.getMaskModifier();
                    boolean b = maskModifier.colorIsCalibrationColor();
                    MenuController.this.highlightMask.setState(b);
                }

                @Override
                public void menuDeselected(MenuEvent e) {
                }

                @Override
                public void menuCanceled(MenuEvent e) {
                }
            });
            this.menuDisplay = new JMenu("Display");
            menubar.add(this.menuDisplay);
            this.menuItem_enableImmersiveMode = new JCheckBoxMenuItem("Immersive");
            this.menuItem_enableNonImmersiveMode = new JCheckBoxMenuItem("Non-immersive");
            this.menuItem_enableImmersiveMode.setEnabled(false);
            this.menuItem_enableImmersiveMode.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            WindowTestApp.this.mainWindow.enableImmersiveMode();
                            MenuController.this.menuItem_enableImmersiveMode.setEnabled(false);
                            MenuController.this.menuItem_enableNonImmersiveMode.setEnabled(true);
                        }
                    });
                }
            });
            this.menuDisplay.add(this.menuItem_enableImmersiveMode);
            this.menuItem_enableNonImmersiveMode.setEnabled(true);
            this.menuItem_enableNonImmersiveMode.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            WindowTestApp.this.mainWindow.enableNonImmersiveMode();
                            MenuController.this.menuItem_enableImmersiveMode.setEnabled(true);
                            MenuController.this.menuItem_enableNonImmersiveMode.setEnabled(false);
                        }
                    });
                }
            });
            this.menuDisplay.add(this.menuItem_enableNonImmersiveMode);
            this.modeSeparator = new JSeparator();
            this.menuDisplay.add(this.modeSeparator);
            this.menuDisplay.addMenuListener(new MenuListener(){

                @Override
                public void menuSelected(MenuEvent e) {
                    ImmersionMode immersionmode = WindowTestApp.this.mainWindow.getMode();
                    MenuController.this.menuItem_enableImmersiveMode.setEnabled(!immersionmode.equals((Object)ImmersionMode.IMMERSIVE));
                    MenuController.this.menuItem_enableNonImmersiveMode.setEnabled(!immersionmode.equals((Object)ImmersionMode.NONIMMERSIVE));
                    MenuController.this.menuItem_enableImmersiveMode.setSelected(immersionmode.equals((Object)ImmersionMode.IMMERSIVE));
                    MenuController.this.menuItem_enableNonImmersiveMode.setSelected(immersionmode.equals((Object)ImmersionMode.NONIMMERSIVE));
                }

                @Override
                public void menuDeselected(MenuEvent e) {
                }

                @Override
                public void menuCanceled(MenuEvent e) {
                }
            });
            this.toggleFullScreen = new JCheckBoxMenuItem("Fullscreen", this.config.getFullScreen());
            this.toggleFullScreen.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            boolean b = MenuController.this.toggleFullScreen.isSelected();
                            WindowTestApp.this.mainWindow.setFullscreen(b);
                            MenuController.this.config.setFullScreen(b);
                        }
                    });
                }
            });
            this.menuDisplay.add(this.toggleFullScreen);
            this.menuDisplay.add(new JSeparator());
            this.showFPS = new JCheckBoxMenuItem("Show statistics and FPS", false);
            this.menuDisplay.add(this.showFPS);
            this.showFPS.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean b = MenuController.this.showFPS.isSelected();
                    WindowTestApp.this.mainWindow.setDisplayFps(b);
                    WindowTestApp.this.mainWindow.setDisplayStatView(b);
                }
            });
            this.menuMisc = new JMenu("Control");
            this.menuMisc.setVisible(true);
            menubar.add(this.menuMisc);
            JMenuItem sceneWindow = new JMenuItem("Light control ...");
            sceneWindow.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            WindowTestApp.this.showSceneWindow();
                        }
                    });
                }
            });
            this.menuMisc.add(sceneWindow);
            final JCheckBoxMenuItem pullSpaces = new JCheckBoxMenuItem("Control navigation of remote Hyve-3D");
            pullSpaces.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            boolean b = pullSpaces.isSelected();
                            WindowTestApp.this.synchronizeHyvePositions(b);
                        }
                    });
                }
            });
            this.menuMisc.add(pullSpaces);
            JMenuItem resetNav = new JMenuItem("Reset navigation to origin");
            resetNav.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            WindowTestApp.this.resetNavigation();
                        }
                    });
                }
            });
            this.menuMisc.add(resetNav);
            final JCheckBoxMenuItem cb = new JCheckBoxMenuItem("Inertia navigation", GlobalSettings.InertiaNavigationEnabled);
            cb.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GlobalSettings.InertiaNavigationEnabled = cb.isSelected();
                }
            });
            this.menuMisc.add(cb);
            this.menuDeveloper = new JMenu("Developer Tools");
            this.menuDeveloper.setVisible(false);
            menubar.add(this.menuDeveloper);
            JMenuItem resourceWindow = new JMenuItem("Rendered Resources Debug Window");
            resourceWindow.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            WindowTestApp.this.showResourceWatcherWindow();
                        }
                    });
                }
            });
            this.menuDeveloper.add(resourceWindow);
            JMenuItem rotWindow = new JMenuItem("Rotation Debug Window");
            rotWindow.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            WindowTestApp.this.showRotationWindow();
                        }
                    });
                }
            });
            this.menuDeveloper.add(rotWindow);
            JMenuItem trackpadWindow = new JMenuItem("TrackPad Imitation Window");
            trackpadWindow.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            WindowTestApp.this.showTrackPadImitationWindow();
                        }
                    });
                }
            });
            this.menuDeveloper.add(trackpadWindow);
            return menubar;
        }

        public void connectConfig(NinaConfiguration cfg) {
            this.config = cfg;
        }

        public boolean isDeveloperModeEnabled() {
            boolean b = false;
            if (this.menuDeveloper != null) {
                b = this.menuDeveloper.isVisible();
            }
            return b;
        }

        private void updateMenuToFitFeatures() {
            boolean nonimmersive = this.enabledFeatures.contains((Object)Feature.NONIMMERSIVE);
            this.showFPS.setVisible(nonimmersive);
            boolean immersiveAndNonImmersive = this.enabledFeatures.contains((Object)Feature.NONIMMERSIVE) && this.enabledFeatures.contains((Object)Feature.IMMERSIVE);
            this.modeSeparator.setVisible(immersiveAndNonImmersive);
            this.menuItem_enableImmersiveMode.setVisible(immersiveAndNonImmersive);
            this.menuItem_enableNonImmersiveMode.setVisible(immersiveAndNonImmersive);
            boolean nonimmersiveOnly = this.enabledFeatures.contains((Object)Feature.NONIMMERSIVE) && !this.enabledFeatures.contains((Object)Feature.IMMERSIVE);
            this.highlightMask.setVisible(this.enabledFeatures.contains((Object)Feature.IMMERSIVE));
            this.toggleFullScreen.setVisible(immersiveAndNonImmersive || nonimmersiveOnly);
            this.menuDisplay.setVisible(immersiveAndNonImmersive || nonimmersiveOnly);
            if (this.enabledFeatures.contains((Object)Feature.IMMERSIVE)) {
                this.macApplication.setPreferencesHandler(WindowTestApp.this.adapter);
            }
        }

        public void setFeatures(Set<Feature> enabledFeatures) {
            this.enabledFeatures = enabledFeatures;
            this.updateMenuToFitFeatures();
        }
    }

    private class MenuUndoRedoAdapter
    implements HistoryController,
    CommandHistory.StateListener {
        private JMenuItem undoMenutItem;
        private JMenuItem redoMenutItem;
        private CommandHistory history;
        private String regularUndoText;
        private String regularRedoText;

        public MenuUndoRedoAdapter(JMenuItem undo, JMenuItem redo) {
            this.undoMenutItem = undo;
            this.redoMenutItem = redo;
            this.regularUndoText = undo.getText();
            this.regularRedoText = redo.getText();
            this.onStateChanged(false, false);
        }

        public void undo() {
            if (this.history != null) {
                this.history.undo();
            }
        }

        public void redo() {
            if (this.history != null) {
                this.history.redo();
            }
        }

        @Override
        public void connect(CommandHistory history) {
            if (history == null) {
                if (this.history != null) {
                    this.history.removeStateListener(this);
                }
                this.history = null;
                this.onStateChanged(false, false);
            } else {
                this.history = history;
                this.history.addStateListener(this);
            }
        }

        @Override
        public void onStateChanged(final boolean hasUndos, final boolean hasRedos) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    MenuUndoRedoAdapter.this.undoMenutItem.setEnabled(hasUndos);
                    MenuUndoRedoAdapter.this.redoMenutItem.setEnabled(hasRedos);
                }
            };
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(r);
            } else {
                r.run();
            }
        }

        @Override
        public void onInfoAvailable(final String undoInfo, final String redoInfo) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    if (undoInfo != null) {
                        MenuUndoRedoAdapter.this.undoMenutItem.setText(MenuUndoRedoAdapter.this.regularUndoText + " " + undoInfo);
                    } else {
                        MenuUndoRedoAdapter.this.undoMenutItem.setText(MenuUndoRedoAdapter.this.regularUndoText);
                    }
                    if (redoInfo != null) {
                        MenuUndoRedoAdapter.this.redoMenutItem.setText(MenuUndoRedoAdapter.this.regularRedoText + " " + redoInfo);
                    } else {
                        MenuUndoRedoAdapter.this.redoMenutItem.setText(MenuUndoRedoAdapter.this.regularRedoText);
                    }
                }
            };
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(r);
            } else {
                r.run();
            }
        }
    }
}

