/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.pointcloud;

import com.hybridlab.hyve3d.pointcloud.PointCloudData;
import com.jme3.math.Vector3f;
import java.io.File;
import java.io.IOException;
import java.util.Random;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class PointCloudHelper {
    public static Vector3f MIN = new Vector3f(-4.675392f, -3.287754f, 0.0f);
    public static Vector3f MAX = new Vector3f(5.847956f, 2.126556f, 19.251f);
    public static Vector3f CENTER = MAX.add(MIN).mult(0.5f);
    public static Vector3f DELTA = MAX.subtract(CENTER);
    public static int NUMPOINTS = 2000000;

    public static float[] generatePoints(int numberOfPoints) {
        float[] result = new float[3 * numberOfPoints];
        Random random = new Random();
        for (int i = 0; i < numberOfPoints; ++i) {
            result[i * 3] = PointCloudHelper.CENTER.x + PointCloudHelper.DELTA.x * (random.nextFloat() - random.nextFloat());
            result[i * 3 + 1] = PointCloudHelper.CENTER.y + PointCloudHelper.DELTA.y * (random.nextFloat() - random.nextFloat());
            result[i * 3 + 2] = PointCloudHelper.CENTER.z + PointCloudHelper.DELTA.z * (random.nextFloat() - random.nextFloat());
        }
        return result;
    }

    public static float[] generateColors(int numberOfPoints) {
        float[] result = new float[4 * numberOfPoints];
        Random random = new Random();
        for (int i = 0; i < numberOfPoints; ++i) {
            result[i * 4] = random.nextFloat();
            result[i * 4 + 1] = 0.5f + 0.5f * random.nextFloat();
            result[i * 4 + 2] = random.nextFloat();
            result[i * 4 + 3] = 1.0f;
        }
        return result;
    }

    private static float[] RGBToOpenGL(int r1, int g1, int b1) {
        float[] tmp = new float[]{(float)r1 / 255.0f, (float)g1 / 255.0f, (float)b1 / 255.0f};
        return tmp;
    }

    private static int countOccurrences(String haystack, String needle) {
        int count = 0;
        int needlesize = needle.length();
        for (int i = 0; i < haystack.length(); ++i) {
            if (!haystack.substring(i, i + needlesize).equals(needle)) continue;
            ++count;
            i += needlesize - 1;
        }
        return count;
    }

    public static PointCloudData parsePlyFile(String path, String file) throws Exception {
        try {
            String filecontent = FileUtils.readFileToString(new File(path, file));
            String[] parts = StringUtils.splitByWholeSeparator(filecontent, "end_header\n");
            String head = parts[0];
            String body = parts[1];
            String cmd = "element vertex ";
            String numString = StringUtils.substringBetween(head, "element vertex ", "\n");
            int num = Integer.parseInt(numString.trim());
            int linesOfHead = PointCloudHelper.countOccurrences(head, System.getProperty("line.separator")) + 2;
            String[] lines = StringUtils.split(body.trim(), "\n");
            if (lines.length != num) {
                throw new Exception("Number of lines in 'element vertex' header field (" + num + ") does not match the number of lines containing data (" + lines.length + ").");
            }
            PointCloudData pcd = new PointCloudData(num);
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i];
                if (line.isEmpty() || line.equals("\n")) {
                    throw new Exception("Parse error in line " + (i + linesOfHead) + " of file " + file);
                }
                try {
                    String[] lineContents = StringUtils.split(line.trim(), " ");
                    pcd.addPointCoordinate(Float.parseFloat(lineContents[0].trim()));
                    pcd.addPointCoordinate(Float.parseFloat(lineContents[1].trim()));
                    pcd.addPointCoordinate(Float.parseFloat(lineContents[2].trim()));
                    float[] c = PointCloudHelper.RGBToOpenGL(Integer.parseInt(lineContents[6].trim()), Integer.parseInt(lineContents[7].trim()), Integer.parseInt(lineContents[8].trim()));
                    pcd.addColorCoordinate(c[0]);
                    pcd.addColorCoordinate(c[1]);
                    pcd.addColorCoordinate(c[2]);
                    pcd.addColorCoordinate(1.0f);
                    continue;
                }
                catch (Exception e) {
                    throw new Exception("Parse error in line " + (i + linesOfHead) + " of file " + file + ": " + e.getClass().getSimpleName() + " " + e.getLocalizedMessage());
                }
            }
            return pcd;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
    }
}

