/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.rendering;

import com.hybridlab.hyve3d.data.domainobjects.Asset;
import com.hybridlab.hyve3d.data.valueobjects.BoundingBoxInformation;
import com.hybridlab.hyve3d.data.valueobjects.Transformation;
import com.hybridlab.hyve3d.files.ImportOptions;
import com.hybridlab.hyve3d.rendering.Jme3HyveDataVisualization;
import com.hybridlab.hyve3d.rendering.Jme3HyveSceneManager;
import com.hybridlab.hyve3d.rendering.Jme3SessionVisualizer;
import com.hybridlab.hyve3d.rendering.ProgressVisualizer;
import com.jme3.asset.AssetManager;
import com.jme3.bounding.BoundingBox;
import com.jme3.bounding.BoundingVolume;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Node;
import com.jme3.scene.SceneGraphVisitor;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import com.jme3.scene.control.LodControl;
import com.jme3.scene.debug.WireBox;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import jme3tools.optimize.LodGenerator;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

public class Jme3AssetVisualization
extends Jme3HyveDataVisualization {
    private Asset asset;
    private ImportOptions importOptions;
    private Jme3HyveSceneManager sceneManager;
    private Geometry boundingGeo;
    private Node importTrfNode = new Node("importTransform");
    private static Material bboxMaterial;
    private boolean debug = false;

    public Jme3AssetVisualization(AssetManager assetManager, Jme3HyveSceneManager sceneManager, Jme3SessionVisualizer.Updater updater, Asset a, ProgressVisualizer progressVisiualizer) {
        super(assetManager, a, updater, progressVisiualizer);
        this.sceneManager = sceneManager;
        this.asset = a;
        if (bboxMaterial == null) {
            bboxMaterial = new Material(assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
            bboxMaterial.setColor("Color", ColorRGBA.Magenta);
        }
        this.importOptions = this.asset.getImportOptionsInstance();
        this.addTodo(new Runnable(){

            @Override
            public void run() {
                Jme3AssetVisualization.this.build();
            }
        });
    }

    protected void build() {
        File f = new File(this.asset.getPath(), this.asset.getFile());
        if (!f.exists() || this.debug) {
            this.debug = false;
            String targetFolder = this.sceneManager.getTempFolder() + this.asset.getId().toString() + "/";
            f = new File(targetFolder, this.asset.getFile());
            try {
                FileUtils.forceMkdir(new File(targetFolder));
                IOUtils.write(this.asset.getFileContent(), (OutputStream)new FileOutputStream(f));
                if (this.asset.isMultipleFileAsset()) {
                    String[] assetMultipleFileList = this.asset.getMultipleFileList();
                    for (int i = 0; i < assetMultipleFileList.length; ++i) {
                        String mf = assetMultipleFileList[i];
                        File ff = new File(targetFolder, mf);
                        IOUtils.write(this.asset.getMultipleFileContent(i), (OutputStream)new FileOutputStream(ff));
                    }
                }
                String path = targetFolder;
                this.asset.setPath(path);
                String fileName = FilenameUtils.getName(f.getName());
                this.asset.setFile(fileName);
                this.build();
                return;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (f.exists()) {
            switch (this.asset.getType()) {
                case PointCloud: {
                    Future<Spatial> futurepc = this.sceneManager.loadPointCloudReturnFuture(this.asset.getPath(), this.asset.getFile());
                    this.addTodo(new Check(futurepc));
                    break;
                }
                case OgreZip: {
                    Future<Spatial> future = this.sceneManager.loadOgreZipReturnFuture(this.asset.getPath(), this.asset.getFile());
                    this.addTodo(new Check(future));
                    break;
                }
                case FBX: {
                    Future<Spatial> futurefbx = this.sceneManager.loadFBXReturnFuture(this.asset.getPath(), this.asset.getFile(), this.asset.getType());
                    this.addTodo(new Check(futurefbx));
                    break;
                }
                case OBJ: 
                case OBJ_ZIPPED: {
                    Future<Spatial> future2 = this.sceneManager.loadObjReturnFuture(this.asset.getPath(), this.asset.getFile(), this.asset.getType());
                    this.addTodo(new Check(future2));
                    break;
                }
                default: {
                    Logger.getAnonymousLogger().severe("Unable to visualize Asset with type='" + this.asset.getType() + "' !");
                    break;
                }
            }
        } else {
            System.out.println("File does not exist: " + f.toString());
        }
    }

    public void applyBackFaceCullingOrNot(Spatial s) {
        GeometryFinder geoFinder = new GeometryFinder();
        s.breadthFirstTraversal((SceneGraphVisitor)geoFinder);
        List<Geometry> geos = geoFinder.getFoundGeometries();
        RenderState.FaceCullMode fcm = this.importOptions.getBackfaceCulling() ? RenderState.FaceCullMode.Back : RenderState.FaceCullMode.Off;
        for (Geometry g : geos) {
            try {
                Material m = g.getMaterial();
                if (m == null) continue;
                m.getAdditionalRenderState().setFaceCullMode(fcm);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        this.teardown();
    }

    public void teardown() {
        switch (this.asset.getType()) {
            case PointCloud: {
                this.sceneManager.teardownPointCloud(this.asset.getPath(), this.asset.getFile());
                break;
            }
            case OgreZip: {
                this.sceneManager.teardownOgreZip(this.asset.getPath(), this.asset.getFile());
                break;
            }
            case OBJ: 
            case OBJ_ZIPPED: {
                this.sceneManager.teardownObj(this.asset.getPath(), this.asset.getFile(), this.asset.getType());
                break;
            }
            default: {
                Logger.getAnonymousLogger().severe("Unable to tear down Asset with type='" + this.asset.getType() + "' !");
            }
        }
    }

    public void createBoundingBoxVisualization(BoundingBox bbox) {
        WireBox wbx = new WireBox();
        if (this.boundingGeo != null) {
            this.importTrfNode.detachChild((Spatial)this.boundingGeo);
        }
        this.boundingGeo = WireBox.makeGeometry((BoundingBox)bbox);
        this.boundingGeo.setMaterial(bboxMaterial);
        this.boundingGeo.setCullHint(this.asset.getSelected() ? Spatial.CullHint.Inherit : Spatial.CullHint.Always);
        this.importTrfNode.attachChild((Spatial)this.boundingGeo);
    }

    public void createLod(Spatial s) {
        GeometryFinder geoFinder = new GeometryFinder();
        s.breadthFirstTraversal((SceneGraphVisitor)geoFinder);
        List<Geometry> geos = geoFinder.getFoundGeometries();
        for (Geometry g : geos) {
            try {
                LodGenerator lod = new LodGenerator(g);
                lod.bakeLods(LodGenerator.TriangleReductionMethod.PROPORTIONAL, new float[]{0.5f});
                LodControl lc = new LodControl();
                g.addControl((Control)lc);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void applyAssetTransformationToRootNode() {
        Transformation t = this.asset.getTransformation();
        Node root = this.getRootNode();
        root.setLocalTranslation(t.getPosition());
        root.setLocalRotation(t.getRotation());
        root.setLocalScale(t.getScale());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == this.asset) {
            String prop = evt.getPropertyName();
            if (prop.endsWith("transformation")) {
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        Jme3AssetVisualization.this.applyAssetTransformationToRootNode();
                    }
                };
                this.addChange("transformation", r);
            } else if (prop.endsWith("originalAABBInformation")) {
                BoundingBoxInformation info = (BoundingBoxInformation)evt.getNewValue();
                final BoundingBox bbox = BoundingBoxInformation.toBoundingBoxInstance(info);
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        Jme3AssetVisualization.this.createBoundingBoxVisualization(bbox);
                    }
                };
                this.addTodo(r);
            } else if (prop.endsWith("selected")) {
                final Boolean b = (Boolean)evt.getNewValue();
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        if (Jme3AssetVisualization.this.boundingGeo != null) {
                            Jme3AssetVisualization.this.boundingGeo.setCullHint(b != false ? Spatial.CullHint.Inherit : Spatial.CullHint.Always);
                        }
                    }
                };
                this.addChange("selectedVisualization", r);
            }
        }
    }

    private class Check
    implements Runnable {
        private int checkNum;
        private long startmillisCheckZero;
        private Future<Spatial> future;

        public Check(Future<Spatial> future, int check, long starttime) {
            this.startmillisCheckZero = starttime;
            this.future = future;
            this.checkNum = check;
        }

        public Check(Future<Spatial> future) {
            this(future, 0, System.currentTimeMillis());
        }

        @Override
        public void run() {
            if (this.future.isDone()) {
                if (!this.future.isCancelled()) {
                    try {
                        Spatial s = this.future.get();
                        if (s != null) {
                            Node root = Jme3AssetVisualization.this.getRootNode();
                            float scale = Jme3AssetVisualization.this.importOptions.getScaleFactor();
                            Jme3AssetVisualization.this.importTrfNode.setLocalScale(scale);
                            BoundingVolume worldBound = s.getWorldBound();
                            switch (worldBound.getType()) {
                                case AABB: {
                                    BoundingBox bbox = (BoundingBox)worldBound;
                                    Jme3AssetVisualization.this.asset.setOriginalBoundingBoxInformation(BoundingBoxInformation.fromBBox(bbox));
                                    break;
                                }
                                default: {
                                    Logger.getAnonymousLogger().severe("Asset has unsupported BoundingVolume Type: " + worldBound.getType());
                                }
                            }
                            Quaternion rotation = Jme3AssetVisualization.this.importOptions.getRotation();
                            Jme3AssetVisualization.this.importTrfNode.setLocalRotation(rotation);
                            Jme3AssetVisualization.this.importTrfNode.attachChild(s);
                            s.setShadowMode(RenderQueue.ShadowMode.CastAndReceive);
                            root.attachChild((Spatial)Jme3AssetVisualization.this.importTrfNode);
                            Jme3AssetVisualization.this.applyBackFaceCullingOrNot(s);
                            Jme3AssetVisualization.this.applyAssetTransformationToRootNode();
                            Jme3AssetVisualization.this.getProgressVisualizer().setProgressText(Jme3AssetVisualization.this.asset.getId().toString() + "-loading", "loading " + Jme3AssetVisualization.this.asset.getFile() + " finished (" + this.getDuration() + ") !");
                            Jme3AssetVisualization.this.getProgressVisualizer().setProgressComplete(Jme3AssetVisualization.this.asset.getId().toString() + "-loading");
                        }
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    catch (ExecutionException e) {
                        e.printStackTrace();
                    }
                }
            } else {
                Jme3AssetVisualization.this.getProgressVisualizer().setProgressText(Jme3AssetVisualization.this.asset.getId().toString() + "-loading", "loading " + Jme3AssetVisualization.this.asset.getFile() + " (" + this.getDuration() + ") ...");
                Jme3AssetVisualization.this.addTodo(new Check(this.future, this.checkNum + 1, this.startmillisCheckZero));
            }
        }

        private String getDuration() {
            long duration = System.currentTimeMillis() - this.startmillisCheckZero;
            double dur = (double)duration * 0.001;
            return String.format(Locale.ENGLISH, "%.2f seconds", dur);
        }
    }

    private class GeometryFinder
    implements SceneGraphVisitor {
        private List<Geometry> geos = new ArrayList<Geometry>();

        private GeometryFinder() {
        }

        public void visit(Spatial spatial) {
            if (spatial instanceof Geometry) {
                this.geos.add((Geometry)spatial);
            }
        }

        public List<Geometry> getFoundGeometries() {
            return this.geos;
        }
    }
}

