/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.rendering;

import com.hybridlab.hyve3d.data.DataModelKey;
import com.hybridlab.hyve3d.data.DataModelObserver;
import com.hybridlab.hyve3d.data.HyveData;
import com.hybridlab.hyve3d.data.Session;
import com.hybridlab.hyve3d.data.domainobjects.Asset;
import com.hybridlab.hyve3d.data.domainobjects.BackGround;
import com.hybridlab.hyve3d.data.domainobjects.DrawingArea;
import com.hybridlab.hyve3d.data.domainobjects.Light;
import com.hybridlab.hyve3d.data.domainobjects.Sky;
import com.hybridlab.hyve3d.data.domainobjects.Space;
import com.hybridlab.hyve3d.data.domainobjects.Stroke;
import com.hybridlab.hyve3d.data.valueobjects.Transformation;
import com.hybridlab.hyve3d.hyve.HyveApplication;
import com.hybridlab.hyve3d.hyve.SessionVisualizer;
import com.hybridlab.hyve3d.rendering.Jme3AssetVisualization;
import com.hybridlab.hyve3d.rendering.Jme3DrawingAreaVisualization;
import com.hybridlab.hyve3d.rendering.Jme3HyveDataVisualization;
import com.hybridlab.hyve3d.rendering.Jme3HyveSceneManager;
import com.hybridlab.hyve3d.rendering.Jme3SkyVisualization;
import com.hybridlab.hyve3d.rendering.Jme3SpaceVisualization;
import com.hybridlab.hyve3d.rendering.Jme3StrokeVisualization;
import com.hybridlab.hyve3d.rendering.ProgressVisualizer;
import com.jme3.app.Application;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.logging.Logger;

public class Jme3SessionVisualizer
implements SessionVisualizer,
DataModelObserver {
    private static float lineWidthMultiplyFactor = 1.0f;
    private Application jme3AppInstance;
    private HyveApplication hyveAppInstance;
    private Session session;
    private Map<HyveData, Jme3HyveDataVisualization> visualizations = new HashMap<HyveData, Jme3HyveDataVisualization>();
    private Set<Jme3SpaceVisualization> remoteSpaceVisualizations = new HashSet<Jme3SpaceVisualization>();
    private Jme3SpaceVisualization localSpaceVisualization;
    private Node sessionRootNode;
    private SimpleVisualizationUpdater visUpdater = new SimpleVisualizationUpdater();
    private BackGroundManager bgManager;
    private Jme3HyveSceneManager sceneManager;
    private ProgressVisualizer progressVisualizer;
    private List<Callable<Object>> tasks = new ArrayList<Callable<Object>>();
    private final float hideDistanceSquared = 0.25f;

    public static void setLineWidthMultiplyFactor(float f) {
        lineWidthMultiplyFactor = f;
    }

    public static float getLineWidthMultiplyFactor() {
        return lineWidthMultiplyFactor;
    }

    public ProgressVisualizer getProgressVisualizer() {
        return this.progressVisualizer;
    }

    public void setProgressVisualizer(ProgressVisualizer progressVisiualizer) {
        this.progressVisualizer = progressVisiualizer;
    }

    public Jme3SessionVisualizer(Application jme3App, HyveApplication hyveApp, Jme3HyveSceneManager sceneManager, ProgressVisualizer progVis) {
        this.setProgressVisualizer(progVis);
        this.jme3AppInstance = jme3App;
        this.hyveAppInstance = hyveApp;
        this.sceneManager = sceneManager;
        this.bgManager = new BackGroundManager();
    }

    @Override
    public void visualize(Session session) {
        if (session == this.session || session == null) {
            Logger.getAnonymousLogger().info((String)(session == null ? "Session to visualize cannot be null!" : "Session is already visualized: " + session.getName()));
            return;
        }
        Logger.getAnonymousLogger().info("Session " + session.getName() + " " + session.getId());
        Logger.getAnonymousLogger().info("clear");
        if (this.session != null) {
            this.session.removeObserver(this);
            for (HyveData d : this.session.getEntities()) {
                this.onDataRemoved(d.getKey(), d);
            }
        }
        this.session = null;
        Logger.getAnonymousLogger().info("visualize");
        this.session = session;
        this.session.addObserver(this);
        Collection<HyveData> sent = this.session.getEntities();
        for (HyveData d : sent) {
            this.onDataAdded(d.getKey(), d);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDataAdded(DataModelKey key, HyveData data) {
        Jme3HyveDataVisualization v = null;
        if (data instanceof DrawingArea) {
            Jme3DrawingAreaVisualization dav;
            DrawingArea da = (DrawingArea)data;
            v = dav = new Jme3DrawingAreaVisualization(this.jme3AppInstance.getAssetManager(), da, (Updater)this.visUpdater, this.progressVisualizer);
            if (da.getSpaceId().equals(this.hyveAppInstance.getLocalHyve().getLocalSpace().getId())) {
                dav.setIsLocal();
            }
        } else if (data instanceof Space) {
            Space s = (Space)data;
            Jme3SpaceVisualization spacevis = new Jme3SpaceVisualization(this.jme3AppInstance.getAssetManager(), s, this.visUpdater, this, this.progressVisualizer);
            if (this.hyveAppInstance.getLocalHyve().isSpaceIdEqualToLocalSpace(s)) {
                spacevis.setIsLocal();
                this.localSpaceVisualization = spacevis;
            } else {
                Set<Jme3SpaceVisualization> set = this.remoteSpaceVisualizations;
                synchronized (set) {
                    this.remoteSpaceVisualizations.add(spacevis);
                }
            }
            v = spacevis;
        } else if (data instanceof Stroke) {
            v = new Jme3StrokeVisualization(this.jme3AppInstance.getAssetManager(), (Stroke)data, (Updater)this.visUpdater, this.progressVisualizer);
        } else if (data instanceof Sky) {
            a = (Sky)data;
            v = new Jme3SkyVisualization(this.jme3AppInstance.getAssetManager(), this.sceneManager, this.visUpdater, (Sky)a, this.progressVisualizer);
        } else if (data instanceof Asset) {
            a = (Asset)data;
            v = new Jme3AssetVisualization(this.jme3AppInstance.getAssetManager(), this.sceneManager, this.visUpdater, a, this.progressVisualizer);
        } else if (data instanceof Light) {
            this.sceneManager.addLight((Light)data);
        } else if (data instanceof BackGround) {
            this.bgManager.add((BackGround)data);
        }
        if (v != null) {
            Map<HyveData, Jme3HyveDataVisualization> map = this.visualizations;
            synchronized (map) {
                this.visualizations.put(data, v);
            }
            this.attach(v);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDataRemoved(DataModelKey key, HyveData data) {
        if (data instanceof BackGround) {
            BackGround bg = (BackGround)data;
            this.bgManager.remove(bg);
        } else if (data instanceof Light) {
            this.sceneManager.removeLight((Light)data);
        } else {
            Jme3HyveDataVisualization v;
            Object object = this.visualizations;
            synchronized (object) {
                v = this.visualizations.remove(data);
            }
            if (v != null) {
                if (v instanceof Jme3SpaceVisualization) {
                    object = this.remoteSpaceVisualizations;
                    synchronized (object) {
                        this.remoteSpaceVisualizations.remove(v);
                    }
                    if (this.localSpaceVisualization == v) {
                        this.localSpaceVisualization = null;
                    }
                } else if (v instanceof Jme3SkyVisualization) {
                    Jme3SkyVisualization sv = (Jme3SkyVisualization)v;
                    sv.detachHideQuickTestBugFix();
                }
                this.detach(v);
                v.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void attach(final Jme3HyveDataVisualization v) {
        Callable<Object> callable = new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                Jme3SessionVisualizer.this.sessionRootNode.attachChild((Spatial)v.getRootNode());
                return null;
            }
        };
        List<Callable<Object>> list = this.tasks;
        synchronized (list) {
            this.tasks.add(callable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void detach(final Jme3HyveDataVisualization v) {
        Callable<Object> callable = new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                Jme3SessionVisualizer.this.sessionRootNode.detachChild((Spatial)v.getRootNode());
                return null;
            }
        };
        List<Callable<Object>> list = this.tasks;
        synchronized (list) {
            this.tasks.add(callable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleUpdate(float tpf) {
        List<Callable<Object>> list = this.tasks;
        synchronized (list) {
            for (Callable<Object> t : this.tasks) {
                try {
                    t.call();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.tasks.clear();
        }
        this.visUpdater.update();
        if (this.bgManager.needsUpdate()) {
            this.bgManager.update();
        }
    }

    public void simpleInit() {
        this.sessionRootNode = new Node("Session Visualization Root Node");
    }

    public Node getSessionVisualizationRootNode() {
        return this.sessionRootNode;
    }

    @Override
    public UUID getIdOfCurrentShownSession() {
        if (this.session == null) {
            return null;
        }
        return this.session.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTransformationHasChangedInLocalVisualization(Jme3SpaceVisualization localSpaceVisualization, Transformation t) {
        Vector3f localvispos = t.getPosition();
        Set<Jme3SpaceVisualization> set = this.remoteSpaceVisualizations;
        synchronized (set) {
            for (Jme3SpaceVisualization remotevis : this.remoteSpaceVisualizations) {
                Vector3f remotepos = remotevis.getSpace().getTransformation().getPosition();
                if (remotepos.distanceSquared(localvispos) < 0.25f) {
                    remotevis.setVisible(false);
                    continue;
                }
                remotevis.setVisible(true);
            }
        }
    }

    public void onTransformationHasChangedInRemoteVisualization(Jme3SpaceVisualization remoteSpaceVisualization, Transformation t) {
        if (this.localSpaceVisualization != null) {
            Vector3f localvispos;
            Vector3f remotepos = t.getPosition();
            if (remotepos.distanceSquared(localvispos = this.localSpaceVisualization.getSpace().getTransformation().getPosition()) < 0.25f) {
                remoteSpaceVisualization.setVisible(false);
            } else {
                remoteSpaceVisualization.setVisible(true);
            }
        }
    }

    private class SimpleVisualizationUpdater
    implements Updater {
        Set<Jme3HyveDataVisualization> visualizationsNeedingUpdate = new HashSet<Jme3HyveDataVisualization>();

        private SimpleVisualizationUpdater() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void registerForUpdate(Jme3HyveDataVisualization vis) {
            Set<Jme3HyveDataVisualization> set = this.visualizationsNeedingUpdate;
            synchronized (set) {
                this.visualizationsNeedingUpdate.add(vis);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void update() {
            HashSet<Object> visualizationsNeedingUpdateCopy = new HashSet();
            Set<Jme3HyveDataVisualization> set = this.visualizationsNeedingUpdate;
            synchronized (set) {
                visualizationsNeedingUpdateCopy = new HashSet<Jme3HyveDataVisualization>(this.visualizationsNeedingUpdate);
                this.visualizationsNeedingUpdate.clear();
            }
            for (Jme3HyveDataVisualization jme3HyveDataVisualization : visualizationsNeedingUpdateCopy) {
                jme3HyveDataVisualization.processChangesAndTodos();
            }
        }
    }

    private class BackGroundManager
    implements PropertyChangeListener {
        private Set<BackGround> bgObjects = new HashSet<BackGround>();
        private Boolean needsUpdate = false;

        private BackGroundManager() {
        }

        public void add(BackGround bg) {
            if (this.bgObjects.add(bg)) {
                bg.addPropertyChangeListener(this);
                this.setNeedsUpdate();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void update() {
            Boolean bl = this.needsUpdate;
            synchronized (bl) {
                this.needsUpdate = false;
            }
            Set<String> allItems = this.collectAll();
            Jme3SessionVisualizer.this.sceneManager.setBackGrounds(allItems);
        }

        private Set<String> collectAll() {
            HashSet<String> all = new HashSet<String>();
            for (BackGround bg : this.bgObjects) {
                all.addAll(bg.getElements());
            }
            return all;
        }

        public void remove(BackGround bg) {
            if (this.bgObjects.remove(bg)) {
                bg.removePropertyChangeListener(this);
                this.setNeedsUpdate();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean needsUpdate() {
            boolean b = false;
            Boolean bl = this.needsUpdate;
            synchronized (bl) {
                b = this.needsUpdate;
            }
            return b;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setNeedsUpdate() {
            Boolean bl = this.needsUpdate;
            synchronized (bl) {
                this.needsUpdate = true;
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent arg0) {
            this.setNeedsUpdate();
        }
    }

    public static interface Updater {
        public void registerForUpdate(Jme3HyveDataVisualization var1);
    }
}

