/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.rendering.projection;

import com.hybridlab.hyve3d.core.Transformable;
import com.hybridlab.hyve3d.data.valueobjects.Transformation;
import com.hybridlab.hyve3d.rendering.Jme3ThreadingHelper;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.texture.TextureCubeMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;

public class SixCameraRig
extends Node
implements Transformable {
    private Map<TextureCubeMap.Face, Vector3f> camlooks;
    private Map<TextureCubeMap.Face, Vector3f> camUps;
    private Map<TextureCubeMap.Face, Quaternion> camRotations;
    private Map<TextureCubeMap.Face, Camera> cams;
    private Map<TextureCubeMap.Face, Boolean> enabled;
    private transient Set<Transformable.TransformationChangedListener> changeListeners = new HashSet<Transformable.TransformationChangedListener>();
    private Jme3ThreadingHelper threadingHelper;
    private Quaternion tiltRotation = Quaternion.IDENTITY;
    private float tiltAngle = 0.0f;

    public SixCameraRig(int textureSize, boolean mirrored, Jme3ThreadingHelper threadingHelper, Map<TextureCubeMap.Face, Boolean> enabled) {
        this.threadingHelper = threadingHelper;
        this.camlooks = new Hashtable<TextureCubeMap.Face, Vector3f>(6);
        this.camUps = new Hashtable<TextureCubeMap.Face, Vector3f>(6);
        this.camRotations = new Hashtable<TextureCubeMap.Face, Quaternion>(6);
        Vector3f Ypos = Vector3f.UNIT_Y;
        Vector3f Xpos = Vector3f.UNIT_X;
        Vector3f Zpos = Vector3f.UNIT_Z;
        Vector3f Yneg = new Vector3f(0.0f, -1.0f, 0.0f);
        Vector3f Xneg = new Vector3f(-1.0f, 0.0f, 0.0f);
        Vector3f Zneg = new Vector3f(0.0f, 0.0f, -1.0f);
        this.enabled = enabled;
        if (mirrored) {
            this.camlooks.put(TextureCubeMap.Face.PositiveX, Xneg);
            this.camlooks.put(TextureCubeMap.Face.NegativeX, Xpos);
            this.camlooks.put(TextureCubeMap.Face.PositiveY, Ypos);
            this.camlooks.put(TextureCubeMap.Face.NegativeY, Yneg);
            this.camlooks.put(TextureCubeMap.Face.PositiveZ, Zneg);
            this.camlooks.put(TextureCubeMap.Face.NegativeZ, Zpos);
            Vector3f up = Yneg;
            this.camUps.put(TextureCubeMap.Face.PositiveX, up);
            this.camUps.put(TextureCubeMap.Face.NegativeX, up);
            this.camUps.put(TextureCubeMap.Face.PositiveY, Zneg);
            this.camUps.put(TextureCubeMap.Face.NegativeY, Zpos);
            this.camUps.put(TextureCubeMap.Face.PositiveZ, up);
            this.camUps.put(TextureCubeMap.Face.NegativeZ, up);
        } else {
            this.camlooks.put(TextureCubeMap.Face.PositiveX, new Vector3f(-1.0f, 0.0f, 0.0f));
            this.camlooks.put(TextureCubeMap.Face.NegativeX, new Vector3f(1.0f, 0.0f, 0.0f));
            this.camlooks.put(TextureCubeMap.Face.PositiveY, new Vector3f(0.0f, -1.0f, 0.0f));
            this.camlooks.put(TextureCubeMap.Face.NegativeY, new Vector3f(0.0f, 1.0f, 0.0f));
            this.camlooks.put(TextureCubeMap.Face.PositiveZ, new Vector3f(0.0f, 0.0f, 1.0f));
            this.camlooks.put(TextureCubeMap.Face.NegativeZ, new Vector3f(0.0f, 0.0f, -1.0f));
            this.camUps.put(TextureCubeMap.Face.PositiveX, Vector3f.UNIT_Y);
            this.camUps.put(TextureCubeMap.Face.NegativeX, Vector3f.UNIT_Y);
            this.camUps.put(TextureCubeMap.Face.PositiveY, Vector3f.UNIT_Z);
            this.camUps.put(TextureCubeMap.Face.NegativeY, new Vector3f(0.0f, 0.0f, -1.0f));
            this.camUps.put(TextureCubeMap.Face.PositiveZ, Vector3f.UNIT_Y);
            this.camUps.put(TextureCubeMap.Face.NegativeZ, Vector3f.UNIT_Y);
        }
        this.cams = new HashMap<TextureCubeMap.Face, Camera>(6);
        for (TextureCubeMap.Face face : TextureCubeMap.Face.values()) {
            Camera neintyDegreeCam = new Camera(textureSize, textureSize);
            neintyDegreeCam.setName("6cam_" + face.toString());
            neintyDegreeCam.setFrustumPerspective(90.0f, 1.0f, 0.001f, 10000.0f);
            neintyDegreeCam.setLocation(new Vector3f(0.0f, 0.0f, 0.0f));
            neintyDegreeCam.lookAt(this.camlooks.get(face), this.camUps.get(face));
            this.cams.put(face, neintyDegreeCam);
            this.camRotations.put(face, neintyDegreeCam.getRotation().clone());
        }
    }

    public Camera getCam(TextureCubeMap.Face face) {
        return this.cams.get(face);
    }

    public void setLocalTranslation(final Vector3f localTranslation) {
        if (this.threadingHelper.isThreadEqualToRenderThread(Thread.currentThread())) {
            super.setLocalTranslation(localTranslation);
            for (Camera c : this.cams.values()) {
                c.setLocation(localTranslation);
            }
        } else {
            this.threadingHelper.enqueue(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    SixCameraRig.this.setLocalTranslation(localTranslation);
                    return null;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTiltAngle(float angleRad) {
        float old = this.tiltAngle;
        if (old != angleRad) {
            this.tiltAngle = angleRad;
            Quaternion quaternion = this.tiltRotation;
            synchronized (quaternion) {
                this.tiltRotation = this.tiltRotation.fromAngleAxis(angleRad, Vector3f.UNIT_X);
            }
            this.setLocalRotation(this.getLocalRotation());
            this.fireChanged();
        }
    }

    @Override
    public float getTiltAngle() {
        return this.tiltAngle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLocalRotation(final Quaternion quaternion) {
        if (this.threadingHelper.isThreadEqualToRenderThread(Thread.currentThread())) {
            for (Map.Entry<TextureCubeMap.Face, Camera> entry : this.cams.entrySet()) {
                TextureCubeMap.Face f = entry.getKey();
                Camera c = entry.getValue();
                Quaternion initialRotation = this.camRotations.get(f);
                Quaternion quaternion2 = this.tiltRotation;
                synchronized (quaternion2) {
                    Quaternion newRotation = quaternion.mult(this.tiltRotation.mult(initialRotation));
                    c.setRotation(newRotation);
                }
            }
            super.setLocalRotation(quaternion);
        } else {
            this.threadingHelper.enqueue(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    SixCameraRig.this.setLocalRotation(quaternion);
                    return null;
                }
            });
        }
    }

    public void setLocalTranslation(final float x, final float y, final float z) {
        if (this.threadingHelper.isThreadEqualToRenderThread(Thread.currentThread())) {
            super.setLocalTranslation(x, y, z);
            for (Camera c : this.cams.values()) {
                c.setLocation(new Vector3f(x, y, z));
            }
        } else {
            this.threadingHelper.enqueue(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    SixCameraRig.this.setLocalTranslation(x, y, z);
                    return null;
                }
            });
        }
    }

    public Spatial move(final Vector3f offset) {
        if (this.threadingHelper.isThreadEqualToRenderThread(Thread.currentThread())) {
            for (Camera c : this.cams.values()) {
                Vector3f v = c.getLocation();
                v.addLocal(offset);
                c.setLocation(v);
            }
            return super.move(offset);
        }
        try {
            return this.threadingHelper.enqueue(new Callable<Spatial>(){

                @Override
                public Spatial call() throws Exception {
                    SixCameraRig.this.move(offset);
                    return SixCameraRig.this;
                }
            }).get();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        return this;
    }

    public Spatial move(float x, float y, float z) {
        return this.move(new Vector3f(x, y, z));
    }

    public void rotateY(final float angleRad) {
        if (this.threadingHelper.isThreadEqualToRenderThread(Thread.currentThread())) {
            for (Map.Entry<TextureCubeMap.Face, Camera> entry : this.cams.entrySet()) {
                TextureCubeMap.Face f = entry.getKey();
                Camera c = entry.getValue();
                Quaternion qc = c.getRotation();
                Quaternion r = new Quaternion();
                if (f.equals((Object)TextureCubeMap.Face.PositiveY)) {
                    r.fromAngles(0.0f, 0.0f, -angleRad);
                } else if (f.equals((Object)TextureCubeMap.Face.NegativeY)) {
                    r.fromAngles(0.0f, 0.0f, angleRad);
                } else {
                    r.fromAngles(0.0f, angleRad, 0.0f);
                }
                c.setRotation(qc.mult(r));
            }
            Quaternion actualNodeRotation = this.getLocalRotation();
            Quaternion rotate = new Quaternion();
            rotate.fromAngles(0.0f, angleRad, 0.0f);
            this.setLocalRotation(actualNodeRotation.mult(rotate));
        } else {
            this.threadingHelper.enqueue(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    SixCameraRig.this.rotateY(angleRad);
                    return null;
                }
            });
        }
    }

    public Vector3f getLocalTranslationOfOneCam() {
        Camera c = this.cams.get(TextureCubeMap.Face.PositiveY);
        return c.getLocation();
    }

    public Vector3f getPosition() {
        return this.getLocalTranslationOfOneCam();
    }

    public Quaternion getRotation() {
        return this.getLocalRotation();
    }

    @Override
    public Transformation getTransformation() {
        return new Transformation(this.getPosition().clone(), this.getRotation().clone());
    }

    @Override
    public void setTransformation(Transformation t) {
        if (t != null) {
            boolean changed = false;
            if (!t.getPosition().equals((Object)this.getPosition())) {
                this.setLocalTranslation(t.getPosition());
                changed = true;
            }
            if (!t.getRotation().equals((Object)this.getRotation())) {
                this.setLocalRotation(t.getRotation());
                changed = true;
            }
            if (changed) {
                this.fireChanged();
            }
        }
    }

    private void fireChanged() {
        for (Transformable.TransformationChangedListener l : this.changeListeners) {
            l.hasChanged(this);
        }
    }

    @Override
    public void addChangeListener(Transformable.TransformationChangedListener l) {
        this.changeListeners.add(l);
    }

    @Override
    public void removeChangeListener(Transformable.TransformationChangedListener l) {
        this.changeListeners.remove(l);
    }

    public boolean isFaceEnabled(TextureCubeMap.Face face) {
        return this.enabled.get(face);
    }
}

