/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.satellitecenter;

import com.hybridlab.hyve3d.config.SimpleBeanSupport;
import com.hybridlab.utils.math.MathUtils;
import com.jme3.math.ColorRGBA;

public class SatelliteClientConfiguration
extends SimpleBeanSupport {
    private String satelliteId;
    private String satelliteName;
    private Integer controllerIndex;
    private ColorRGBA regularFrameColor;

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.controllerIndex == null ? 0 : this.controllerIndex.hashCode());
        result = 31 * result + (this.regularFrameColor == null ? 0 : this.regularFrameColor.hashCode());
        result = 31 * result + (this.satelliteId == null ? 0 : this.satelliteId.hashCode());
        result = 31 * result + (this.satelliteName == null ? 0 : this.satelliteName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SatelliteClientConfiguration other = (SatelliteClientConfiguration)obj;
        if (this.controllerIndex == null ? other.controllerIndex != null : !this.controllerIndex.equals(other.controllerIndex)) {
            return false;
        }
        if (this.regularFrameColor == null ? other.regularFrameColor != null : !this.regularFrameColor.equals((Object)other.regularFrameColor)) {
            return false;
        }
        if (this.satelliteId == null ? other.satelliteId != null : !this.satelliteId.equals(other.satelliteId)) {
            return false;
        }
        return !(this.satelliteName == null ? other.satelliteName != null : !this.satelliteName.equals(other.satelliteName));
    }

    public SatelliteClientConfiguration() {
        this.verbose = true;
    }

    public String getSatelliteName() {
        return this.satelliteName;
    }

    public void setSatelliteName(String satelliteName) {
        String old = this.satelliteName;
        this.satelliteName = satelliteName;
        this.fireChange("satelliteName", old, this.satelliteName);
    }

    public String getSatelliteId() {
        return this.satelliteId;
    }

    public void setSatelliteId(String satelliteId) {
        String old = this.satelliteId;
        this.satelliteId = satelliteId;
        this.fireChange("satelliteId", old, this.satelliteId);
    }

    public void setPairedHydraControllerIndex(Integer i) {
        Integer old = this.controllerIndex;
        this.controllerIndex = i;
        this.fireChange("pairedHydraControllerIndex", old, this.controllerIndex);
    }

    public Integer getPairedHydraControllerIndex() {
        return this.controllerIndex;
    }

    public ColorRGBA getRegularFrameColor() {
        if (this.regularFrameColor == null) {
            this.regularFrameColor = ColorRGBA.randomColor();
            this.regularFrameColor.a = 1.0f;
            this.regularFrameColor = MathUtils.ensureNotDarkerThan(0.6f, this.regularFrameColor);
        }
        return this.regularFrameColor;
    }

    public void setRegularFrameColor(ColorRGBA c) {
        ColorRGBA old = this.regularFrameColor;
        this.regularFrameColor = c;
        this.fireChange("regularFrameColor", old, this.regularFrameColor);
    }
}

