/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.satellitecenter;

import com.hybridlab.hyve3d.satellitecenter.SatelliteClientConfiguration;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SatelliteClientConfigurationSet
implements PropertyChangeListener {
    private Set<ChangeListener> listener = new HashSet<ChangeListener>();
    private Map<String, SatelliteClientConfiguration> confs = new HashMap<String, SatelliteClientConfiguration>();

    public SatelliteClientConfigurationSet(Set<SatelliteClientConfiguration> configs) {
        for (SatelliteClientConfiguration c : configs) {
            this.put(c.getSatelliteId(), c);
        }
    }

    public SatelliteClientConfiguration get(String satelliteId) {
        return this.confs.get(satelliteId);
    }

    public void put(String satelliteId, SatelliteClientConfiguration satelliteConfig) {
        SatelliteClientConfiguration previous = this.confs.put(satelliteId, satelliteConfig);
        if (previous == null) {
            satelliteConfig.addPropertyChangeListener(this);
        }
        for (ChangeListener l : this.listener) {
            l.hasChanged(this, satelliteId, satelliteConfig);
        }
    }

    public void addChangeListener(ChangeListener l) {
        this.listener.add(l);
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        SatelliteClientConfiguration conf;
        if (pce.getSource() instanceof SatelliteClientConfiguration && this.confs.containsValue(conf = (SatelliteClientConfiguration)pce.getSource())) {
            String satelliteId = conf.getSatelliteId();
            for (ChangeListener l : this.listener) {
                l.hasChanged(this, satelliteId, conf);
            }
        }
    }

    public static interface ChangeListener {
        public void hasChanged(SatelliteClientConfigurationSet var1, String var2, SatelliteClientConfiguration var3);
    }
}

