/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.satellitecenter;

import com.hybridlab.hyve3d.network.MessageRegistry;
import com.hybridlab.hyve3d.network.discovery.NetworkServiceManager;
import com.hybridlab.hyve3d.network.messages.SatelliteSessionSetupMessage;
import com.hybridlab.hyve3d.network.transport.fab8.FAB8BasedSatelliteServer;
import com.hybridlab.hyve3d.network.transport.spidermonkey.SpiderMonkeyBasedSatteliteServer;
import com.hybridlab.hyve3d.satellitecenter.SatelliteSession;
import com.hybridlab.hyve3d.satellitecenter.SatelliteSessionObserver;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SatelliteServer {
    private static final Logger logger = Logger.getLogger(SatelliteServer.class.getSimpleName());
    private ArrayList<SatelliteSession> activeSatelliteSessions = new ArrayList();
    private ArrayList<SatelliteSession> inActiveSatelliteSessions = new ArrayList();
    private List<SatelliteSessionObserver> sessionObserver = new ArrayList<SatelliteSessionObserver>();
    private SpiderMonkeyBasedSatteliteServer androidDeviceServer;
    private FAB8BasedSatelliteServer iOsDeviceServer;

    public SatelliteServer(NetworkServiceManager networkServiceManager) {
        this.androidDeviceServer = new SpiderMonkeyBasedSatteliteServer(this, networkServiceManager);
        this.iOsDeviceServer = new FAB8BasedSatelliteServer(this, networkServiceManager);
    }

    public void startListenForConnectionsAndServe() {
        this.iOsDeviceServer.start();
        if (!MessageRegistry.isRegistrationDone()) {
            throw new RuntimeException("no messages registered");
        }
        this.androidDeviceServer.start();
    }

    public void shutdown() {
        this.iOsDeviceServer.stop();
        this.androidDeviceServer.stop();
    }

    public void onSessionClosed(SatelliteSession satelliteSession) {
        logger.log(Level.INFO, "SatelliteSession has been closed: " + satelliteSession);
        this.markSessionAsInactive(satelliteSession);
        for (SatelliteSessionObserver obs : this.sessionObserver) {
            obs.onSatelliteSessionClosed(satelliteSession);
        }
    }

    public void onSessionLost(SatelliteSession satelliteSession) {
        logger.log(Level.WARNING, "SatelliteSession lost! : " + satelliteSession);
        this.markSessionAsInactive(satelliteSession);
        for (SatelliteSessionObserver obs : this.sessionObserver) {
            obs.onSatelliteSessionClosed(satelliteSession);
        }
    }

    public void registerSessionObserver(SatelliteSessionObserver obs) {
        this.sessionObserver.add(obs);
    }

    void addSession(SatelliteSession satelitteSession) {
        logger.log(Level.INFO, "added Session: " + satelitteSession);
        this.activeSatelliteSessions.add(satelitteSession);
        for (SatelliteSessionObserver obs : this.sessionObserver) {
            obs.onNewSatelliteSession(satelitteSession);
        }
    }

    void markSessionAsInactive(SatelliteSession satelitteSession) {
        logger.log(Level.INFO, "Session now inactive: " + satelitteSession);
        this.activeSatelliteSessions.remove(satelitteSession);
        this.inActiveSatelliteSessions.add(satelitteSession);
    }

    public SatelliteSession createSession() {
        SatelliteSession newSession = new SatelliteSession(this);
        this.addSession(newSession);
        return newSession;
    }

    public void sessionSetup(SatelliteSession satelliteSession, SatelliteSessionSetupMessage setup) {
        for (SatelliteSessionObserver obs : this.sessionObserver) {
            obs.onSessionSetup(satelliteSession, setup);
        }
    }

    public static interface SatelliteClientServerMessageChannel {
        public void start();

        public void stop();
    }
}

