/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.satellitecenter;

import com.hybridlab.hyve3d.core.Satellite;
import com.hybridlab.hyve3d.core.StrokeId;
import com.hybridlab.hyve3d.network.messages.AbstractHisMessage;
import com.hybridlab.hyve3d.network.messages.CommandMessage;
import com.hybridlab.hyve3d.network.messages.FrameRectDefinitionMessage;
import com.hybridlab.hyve3d.network.messages.Matrix3fMessage;
import com.hybridlab.hyve3d.network.messages.Move2DMessage;
import com.hybridlab.hyve3d.network.messages.Move3DMessage;
import com.hybridlab.hyve3d.network.messages.PinchPointsMessage;
import com.hybridlab.hyve3d.network.messages.Pointing2DTransmissionPartMessage;
import com.hybridlab.hyve3d.network.messages.PositionChangeVectorMessage;
import com.hybridlab.hyve3d.network.messages.SatelliteSessionSetupMessage;
import com.hybridlab.hyve3d.network.messages.Stroke2DTransmissionPartMessage;
import com.hybridlab.hyve3d.network.messages.StrokeInkMessage;
import com.hybridlab.hyve3d.network.messages.TouchEventMessage;
import com.hybridlab.hyve3d.network.messages.TransformMessage;
import com.hybridlab.hyve3d.network.messages.ZoomMessage;
import com.hybridlab.hyve3d.network.transport.MessageTransportConnection;
import com.hybridlab.hyve3d.satellitecenter.SatelliteClientConnectionListener;
import com.hybridlab.hyve3d.satellitecenter.SatelliteServer;
import com.hybridlab.hyve3d.satellitecenter.SessionID;
import com.hybridlab.hyve3d.satellitecenter.SessionMessageProcessor;
import com.jme3.math.Vector2f;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SatelliteSession
implements SatelliteClientConnectionListener {
    private Logger logger = Logger.getLogger(SatelliteSession.class.getSimpleName());
    private Satellite satellite;
    private SatelliteServer satelliteServer;
    private MessageTransportConnection connection;
    private SessionID id;
    List<SessionMessageProcessor> sessionMessageProcessors = new ArrayList<SessionMessageProcessor>();

    public SessionID getSessionId() {
        return this.id;
    }

    public SatelliteSession(SatelliteServer satelliteServer) {
        this.satelliteServer = satelliteServer;
        this.id = new SessionID();
    }

    @Override
    public void onConnectionClosed(MessageTransportConnection conn) {
        this.logger.log(Level.INFO, "connection closed !" + conn);
        this.Close();
    }

    public void Close() {
        this.connection = null;
        this.satelliteServer.onSessionClosed(this);
    }

    @Override
    public void onConnectionLost(MessageTransportConnection conn) {
        this.logger.log(Level.WARNING, "connection lost !" + conn);
        this.connection = null;
        this.satelliteServer.onSessionLost(this);
    }

    @Override
    public void onConnectionEstablished(MessageTransportConnection conn) {
        this.connection = conn;
        this.logger.log(Level.INFO, "connection established !");
        try {
            SatelliteSessionSetupMessage setup = new SatelliteSessionSetupMessage(this.id);
            this.connection.send(setup);
        }
        catch (MessageTransportConnection.SendFailedException e) {
            try {
                this.connection.disconnect();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            e.printStackTrace();
        }
    }

    public void registerMessageProcessor(SessionMessageProcessor p) {
        this.sessionMessageProcessors.add(p);
    }

    @Override
    @Deprecated
    public void onAbstractMessageReceived(AbstractHisMessage message) {
        this.logger.log(Level.INFO, "onMessageReceived: " + message.toString());
        for (SessionMessageProcessor proc : this.sessionMessageProcessors) {
            proc.processMessage(this, message);
        }
    }

    @Override
    public void onMessageReceived(Matrix3fMessage message) {
        try {
            TransformMessage tm = message.asTransformMessage();
            this.onMessageReceived(tm);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onMessageReceived(TransformMessage m) {
        try {
            if (this.satellite != null) {
                this.satellite.processMessage(m);
            } else {
                this.logger.log(Level.SEVERE, "\n satellite was null but message reveived: \n" + m.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onMessageReceived(SatelliteSessionSetupMessage m) {
        this.satelliteServer.sessionSetup(this, m);
    }

    public void setSessionHandlingSatelliteInstanceOnServer(Satellite satellite) {
        this.satellite = satellite;
    }

    @Override
    public void onMessageReceived(TouchEventMessage message) {
        try {
            Vector2f point = new Vector2f();
            point.x = message.getX();
            point.y = message.getY();
            StrokeId id = new StrokeId();
            Stroke2DTransmissionPartMessage.SubType type = Stroke2DTransmissionPartMessage.SubType.BEGIN;
            switch (message.getType()) {
                case UP: {
                    type = Stroke2DTransmissionPartMessage.SubType.END;
                    break;
                }
                case DOWN: {
                    type = Stroke2DTransmissionPartMessage.SubType.BEGIN;
                    break;
                }
                case MOVE: {
                    type = Stroke2DTransmissionPartMessage.SubType.ADD;
                    break;
                }
                default: {
                    throw new Exception("unswitched TouchEvent Type: " + message.getType().toString());
                }
            }
            Stroke2DTransmissionPartMessage m = new Stroke2DTransmissionPartMessage(id, point, type);
            this.onMessageReceived(m);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onMessageReceived(PositionChangeVectorMessage message) {
        this.logger.log(Level.INFO, message.toString());
    }

    @Override
    public void onMessageReceived(Stroke2DTransmissionPartMessage message) {
        this.satellite.processMessage(message);
    }

    @Override
    public void onMessageReceived(Move2DMessage message) {
        this.satellite.processMessage(message);
    }

    @Override
    public void onMessageReceived(Move3DMessage message) {
        this.satellite.processMessage(message);
    }

    @Override
    public void onMessageReceived(FrameRectDefinitionMessage message) {
        this.satellite.processMessage(message);
    }

    @Override
    public void onMessageReceived(ZoomMessage message) {
        this.satellite.processMessage(message);
    }

    @Override
    public void onMessageReceived(StrokeInkMessage message) {
        this.satellite.processMessage(message);
    }

    @Override
    public void onMessageReceived(Pointing2DTransmissionPartMessage message) {
        this.satellite.processMessage(message);
    }

    public void sendMessage(AbstractHisMessage message) {
        try {
            this.connection.send(message);
        }
        catch (NullPointerException e) {
            this.logger.log(Level.SEVERE, "Message couldnt not be sent: " + message.toString(), e);
        }
        catch (MessageTransportConnection.SendFailedException e) {
            this.logger.log(Level.SEVERE, "Message couldnt not be sent: " + message.toString(), e);
        }
    }

    @Override
    public void onMessageReceived(CommandMessage message) {
        this.satellite.processMessage(message);
    }

    @Override
    public void onMessageReceived(PinchPointsMessage message) {
        this.satellite.processMessage(message);
    }
}

