/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.satellitecenter;

import com.hybridlab.hyve3d.core.commands.Command;
import com.hybridlab.hyve3d.core.commands.CommandChangeMode;
import com.hybridlab.hyve3d.core.commands.CommandChangeModeRequest;
import com.hybridlab.hyve3d.network.messages.CommandMessage;
import com.hybridlab.hyve3d.satellitecenter.SatelliteSession;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SatelliteSessionCommandProcessor {
    private static final Logger logger = Logger.getLogger(SatelliteSessionCommandProcessor.class.getSimpleName());

    public static boolean processCommand(SatelliteSession session, Command cmd) {
        if (null == cmd.getCommandName()) {
            logger.log(Level.SEVERE, "Command is EMPTY");
            return false;
        }
        switch (cmd.getCommandName()) {
            case changeModeRequest: {
                return SatelliteSessionCommandProcessor.processChangeModeRequest(session, (CommandChangeModeRequest)cmd);
            }
        }
        logger.severe("Unkown Command" + cmd.getCommandName());
        return false;
    }

    private static boolean processChangeModeRequest(SatelliteSession session, CommandChangeModeRequest cmd) {
        switch (cmd.getMode()) {
            case Navigation: {
                SatelliteSessionCommandProcessor.sendChangeModeAnswer(session, cmd);
                break;
            }
            default: {
                SatelliteSessionCommandProcessor.sendChangeModeAnswer(session, cmd);
            }
        }
        return true;
    }

    private static void sendChangeModeAnswer(SatelliteSession session, CommandChangeModeRequest cmd) {
        CommandChangeMode answercmd = new CommandChangeMode();
        answercmd.setModeString(cmd.getModeString());
        CommandMessage answer = new CommandMessage(answercmd);
        session.sendMessage(answer);
    }
}

