/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.scenemanipulation;

import com.hybridlab.hyve3d.scenemanipulation.Brailer;
import com.hybridlab.hyve3d.scenemanipulation.ConvexBiRectangleVolume;
import com.hybridlab.hyve3d.scenemanipulation.RectangleBrailer;
import com.hybridlab.hyve3d.scenemanipulation.Volume;
import com.hybridlab.utils.math.MathUtils;
import com.hybridlab.utils.math.Rectangle3D;
import com.jme3.math.Vector3f;
import com.jogamp.opengl.math.geom.AABBox;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BrailedVolume
implements Volume {
    private List<Rectangle3D> rectangles = new ArrayList<Rectangle3D>();
    private AABBox bounds;
    private Set<VolumeObserver> observer = new HashSet<VolumeObserver>();
    private Map<Integer, Volume> subVolumes = new HashMap<Integer, Volume>();

    public BrailedVolume() {
    }

    public BrailedVolume(List<Rectangle3D> entrys) {
        this.rectangles = entrys;
        this.updateBounds();
    }

    private void updateBounds() {
        if (this.rectangles.isEmpty()) {
            this.bounds = null;
        } else {
            AABBox b = this.rectangles.get(0).getAABBox();
            this.bounds = new AABBox(b.getMinX(), b.getMinY(), b.getMinZ(), b.getMaxX(), b.getMaxY(), b.getMaxZ());
        }
        for (Rectangle3D e : this.rectangles) {
            this.bounds.resize(e.getAABBox());
        }
    }

    private int getNumberOfSubVolumes() {
        int numberOfSubvolumes = Math.max(0, this.rectangles.size() - 1);
        return numberOfSubvolumes;
    }

    private boolean testIfAnySubVolumeContains(Vector3f v) {
        for (int i = 1; i <= this.getNumberOfSubVolumes(); ++i) {
            Volume volume = this.getVolumeSubPart(i);
            if (!volume.contains(v)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean extendWithBrailer(Brailer brailer) {
        if (brailer instanceof RectangleBrailer) {
            int numberOfSubVolumes;
            RectangleBrailer rectBrailer = (RectangleBrailer)brailer;
            Rectangle3D e = new Rectangle3D(rectBrailer.getWidth(), rectBrailer.getHeight(), rectBrailer.getTransformation().position.clone(), rectBrailer.getTransformation().rotation.clone());
            List<Rectangle3D> list = this.rectangles;
            synchronized (list) {
                if (this.rectangles.size() == 0) {
                    System.out.println("adding to entrys as index number: " + this.rectangles.size() + " \n " + e);
                    this.rectangles.add(e);
                } else if (this.willCreateConvexVolumeIfAdded(e)) {
                    System.out.println("adding to entrys as index number: " + this.rectangles.size() + " \n " + e);
                    this.rectangles.add(e);
                } else {
                    return false;
                }
                numberOfSubVolumes = this.getNumberOfSubVolumes();
            }
            if (numberOfSubVolumes == 1) {
                this.updateBounds();
                this.hasEnlarged(numberOfSubVolumes);
            } else if (numberOfSubVolumes > 1) {
                this.bounds.resize(e.getAABBox());
                this.hasEnlarged(numberOfSubVolumes);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean willCreateConvexVolumeIfAdded(Rectangle3D extensionRect) {
        List<Rectangle3D> list = this.rectangles;
        synchronized (list) {
            if (this.rectangles.size() == 0) {
                return false;
            }
            Rectangle3D lastRect = this.rectangles.get(this.rectangles.size() - 1);
            boolean willBeConvex = MathUtils.isConvexVolumeIfConnected(lastRect, extensionRect);
            return willBeConvex;
        }
    }

    private void hasEnlarged(int newNumberOfVolumeParts) {
        for (VolumeObserver o : this.observer) {
            o.onVolumeExtended(this, newNumberOfVolumeParts);
        }
    }

    public void addVolumeObserver(VolumeObserver o) {
        this.observer.add(o);
    }

    public void removeVolumeObserver(VolumeObserver o) {
        this.observer.remove(o);
    }

    public Volume getVolumeSubPart(int volumeSubPartNumber) {
        Integer key = volumeSubPartNumber;
        Volume subvol = this.subVolumes.get(key);
        if (subvol != null) {
            return subvol;
        }
        try {
            subvol = new ConvexBiRectangleVolume(this.rectangles.get(volumeSubPartNumber - 1), this.rectangles.get(volumeSubPartNumber));
            this.subVolumes.put(key, subvol);
            return subvol;
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
            return null;
        }
    }

    public int getExtensionCount() {
        return this.rectangles.size();
    }

    @Override
    public AABBox getAABBox() {
        return this.bounds;
    }

    @Override
    public boolean contains(Vector3f v) {
        if (this.getNumberOfSubVolumes() == 0) {
            return false;
        }
        if (!this.getAABBox().contains(v.x, v.y, v.z)) {
            return false;
        }
        return this.testIfAnySubVolumeContains(v);
    }

    public static interface VolumeObserver {
        public void onVolumeExtended(BrailedVolume var1, int var2);

        public void onVolumeReduced(BrailedVolume var1);
    }
}

