/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.scenemanipulation;

import com.hybridlab.utils.math.MathUtils;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import java.util.HashSet;
import java.util.Set;

public abstract class Brailer {
    protected Set<BrailerObserver> observer = new HashSet<BrailerObserver>();
    protected BrailerTransformation transformation = new BrailerTransformation();

    public synchronized void addObserver(BrailerObserver o) {
        this.observer.add(o);
    }

    public synchronized void removeObserver(BrailerObserver o) {
        this.observer.remove(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTransformation(BrailerTransformation t) {
        if (t == null) {
            throw new IllegalArgumentException("BrailerTransformation must not be null");
        }
        if (!t.equals(this.transformation)) {
            this.transformation = t;
            Set<BrailerObserver> set = this.observer;
            synchronized (set) {
                for (BrailerObserver o : this.observer) {
                    o.onTransformationChanged(this);
                }
            }
        }
    }

    public BrailerTransformation getTransformation() {
        return this.transformation;
    }

    public class BrailerTransformation {
        public Quaternion rotation = new Quaternion();
        public Vector3f position = new Vector3f();

        public BrailerTransformation() {
        }

        public BrailerTransformation(Vector3f pos, Quaternion rot) {
            this.position = pos;
            this.rotation = rot;
        }

        public String toString() {
            return String.format("BrailerTransformation [ position=%s, rotation=%s ]", this.position, MathUtils.quaternionToAxisAngleInDegreesString(this.rotation));
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.position == null ? 0 : this.position.hashCode());
            result = 31 * result + (this.rotation == null ? 0 : this.rotation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BrailerTransformation other = (BrailerTransformation)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.position == null ? other.position != null : !this.position.equals((Object)other.position)) {
                return false;
            }
            return !(this.rotation == null ? other.rotation != null : !this.rotation.equals((Object)other.rotation));
        }

        public BrailerTransformation clone() {
            BrailerTransformation c = new BrailerTransformation();
            c.position = this.position.clone();
            c.rotation = this.rotation.clone();
            return c;
        }

        private Brailer getOuterType() {
            return Brailer.this;
        }
    }

    public static interface BrailerObserver {
        public void onTransformationChanged(Brailer var1);
    }
}

