/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.scenemanipulation;

import com.hybridlab.hyve3d.core.His3DScene;
import com.hybridlab.hyve3d.core.Stroke3D;
import com.hybridlab.hyve3d.core.Stroke3DPoint;
import com.hybridlab.hyve3d.scenemanipulation.BrailedVolume;
import com.hybridlab.hyve3d.scenemanipulation.Volume;
import com.hybridlab.hyve3d.scenemanipulation.VolumeSelectionProcessOld;
import com.hybridlab.utils.Shuffle;
import com.hybridlab.utils.math.MathUtils;
import com.jme3.math.Vector3f;
import com.jogamp.opengl.math.geom.AABBox;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

@Deprecated
public class StrokeSelector_OLD
implements BrailedVolume.VolumeObserver,
Runnable {
    private BrailedVolume volume;
    private Thread selectionCalculatorThread;
    private boolean calculating = false;
    private Set<Stroke3D> selectedStrokes = new HashSet<Stroke3D>();
    private Set<Stroke3D> notSelectedStrokes;
    private boolean needsUpdate = false;
    private Set<SelectorObserver> observer = new HashSet<SelectorObserver>();
    private VolumeSelectionProcessOld process;
    private Set<Integer> volumePartNumbersToCheck = new HashSet<Integer>();
    Map<Stroke3D, int[]> strokeIndiciesMap = new HashMap<Stroke3D, int[]>();

    public StrokeSelector_OLD(BrailedVolume v, His3DScene scene, VolumeSelectionProcessOld process) {
        this.process = process;
        this.notSelectedStrokes = new HashSet<Stroke3D>(scene.getAllStrokes());
        this.volume = v;
        this.volume.addVolumeObserver(this);
        this.selectionCalculatorThread = new Thread((Runnable)this, this.toString());
        this.selectionCalculatorThread.start();
    }

    public void finish() {
        this.observer.clear();
        this.volume.removeVolumeObserver(this);
        this.calculating = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onVolumeExtended(BrailedVolume brailedVolume, int newNumberOfVolumeParts) {
        if (brailedVolume.equals(this.volume)) {
            this.needsUpdate = true;
            Set<Integer> set = this.volumePartNumbersToCheck;
            synchronized (set) {
                this.volumePartNumbersToCheck.add(new Integer(newNumberOfVolumeParts));
            }
        }
    }

    @Override
    public void onVolumeReduced(BrailedVolume brailedVolume) {
        if (brailedVolume.equals(this.volume)) {
            Logger.getAnonymousLogger().severe("not implemented!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.calculating = true;
        while (this.calculating) {
            if (!this.needsUpdate) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            HashSet<Stroke3D> willBeSelected = new HashSet<Stroke3D>();
            Set<Integer> set = this.volumePartNumbersToCheck;
            synchronized (set) {
                this.needsUpdate = false;
                for (Integer volumePartNumber : this.volumePartNumbersToCheck) {
                    Volume volumePartToTestAgainst = this.volume.getVolumeSubPart(volumePartNumber);
                    for (Stroke3D s : this.notSelectedStrokes) {
                        if (!this.volumeContainsStroke(volumePartToTestAgainst, s)) continue;
                        willBeSelected.add(s);
                    }
                }
                this.volumePartNumbersToCheck.clear();
            }
            if (!willBeSelected.isEmpty()) {
                this.notSelectedStrokes.removeAll(willBeSelected);
                this.selectedStrokes.addAll(willBeSelected);
                this.strokeSelectionHasChanged(willBeSelected, this.notSelectedStrokes, this.selectedStrokes);
            }
            if (this.notSelectedStrokes.isEmpty()) {
                System.out.println("no more Strokes to select ");
                this.calculating = false;
            }
            System.out.println("selected: " + this.selectedStrokes.size());
        }
        System.out.println("finishing " + this.selectionCalculatorThread);
    }

    private void strokeSelectionHasChanged(Set<Stroke3D> newlySelected, Set<Stroke3D> notSelected, Set<Stroke3D> selected) {
        for (SelectorObserver o : this.observer) {
            o.onStrokeSelectionHasChanged(this, newlySelected, notSelected, selected);
        }
    }

    private boolean strokeAABoxIntersectsVolumeAABBox(Volume volumeToTestAgainst, Stroke3D s) {
        AABBox vbox = volumeToTestAgainst.getAABBox();
        AABBox sbox = s.getAABBox();
        return MathUtils.AABBoxesIntersect(vbox, sbox);
    }

    private boolean volumeContainsStroke(Volume volumeToTestAgainst, Stroke3D s) {
        boolean b = this.strokeAABoxIntersectsVolumeAABBox(volumeToTestAgainst, s);
        if (!b) {
            return b;
        }
        List<Stroke3DPoint> points = s.getPointsInSceneCoordinates();
        int numpoints = points.size();
        int[] inidicesToTest = this.strokeIndiciesMap.get(s);
        if (inidicesToTest == null) {
            inidicesToTest = Shuffle.getShuffledArrayOfAllIntegersBetween(0, numpoints - 1);
            this.strokeIndiciesMap.put(s, inidicesToTest);
        } else if (inidicesToTest.length != numpoints) {
            inidicesToTest = Shuffle.getShuffledArrayOfAllIntegersBetween(0, numpoints - 1);
            this.strokeIndiciesMap.put(s, inidicesToTest);
        }
        for (int pointIndex : inidicesToTest) {
            Stroke3DPoint p = s.getStrokePoint(pointIndex);
            Vector3f pWithAnchor = p.position.add(s.getPosition());
            if (!volumeToTestAgainst.contains(pWithAnchor)) continue;
            return true;
        }
        return false;
    }

    public void addSelectionObserver(SelectorObserver o) {
        this.observer.add(o);
    }

    public VolumeSelectionProcessOld getProcess() {
        return this.process;
    }

    public static interface SelectorObserver {
        public void onStrokeSelectionHasChanged(StrokeSelector_OLD var1, Set<Stroke3D> var2, Set<Stroke3D> var3, Set<Stroke3D> var4);
    }
}

