/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.scenes;

import com.hybridlab.hyve3d.core.HisClientRenderer;
import com.hybridlab.hyve3d.geometry.SceneCoordinateSystem;
import com.jme3.asset.AssetManager;
import com.jme3.asset.TextureKey;
import com.jme3.asset.plugins.ZipLocator;
import com.jme3.light.AmbientLight;
import com.jme3.light.DirectionalLight;
import com.jme3.light.Light;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.debug.Arrow;
import com.jme3.scene.debug.Grid;
import com.jme3.texture.Texture;
import com.jme3.util.SkyFactory;
import java.util.concurrent.Callable;
import javax.swing.JOptionPane;

public class HisSceneManager {
    private boolean grid = true;
    private boolean city = false;
    private boolean sky = false;
    private Spatial citySceneModel;
    private Spatial gokceTestSceneModel;
    private Spatial skySpatial;
    private Spatial cubes1000Model;
    private Spatial carModel;
    private AssetManager assetManager;
    private HisClientRenderer hisClientRenderer;
    private Node gridnode;
    private Node cameraRigRootNode;
    private Node subSceneNode;
    private Node importedGeometriesNode;

    public HisSceneManager(AssetManager assetManager, HisClientRenderer hisClientRenderer) {
        this.assetManager = assetManager;
        this.hisClientRenderer = hisClientRenderer;
        this.buildSceneComponents();
    }

    private void setUpLight(Node node) {
        AmbientLight al = new AmbientLight();
        al.setColor(ColorRGBA.White.mult(1.3f));
        node.addLight((Light)al);
        DirectionalLight dl = new DirectionalLight();
        dl.setColor(ColorRGBA.White);
        dl.setDirection(new Vector3f(2.8f, -2.8f, -2.8f).normalizeLocal());
        node.addLight((Light)dl);
    }

    public Node getCamerRigGroupNode() {
        return this.cameraRigRootNode;
    }

    public Node getSceneNode() {
        return this.subSceneNode;
    }

    private void buildSceneComponents() {
        this.subSceneNode = new Node("subSceneNode");
        this.importedGeometriesNode = new Node("importedGeometriesNode");
        this.subSceneNode.attachChild((Spatial)this.importedGeometriesNode);
        this.cameraRigRootNode = new Node("cameraRigRootNode");
        this.subSceneNode.attachChild((Spatial)this.cameraRigRootNode);
        this.setUpLight(this.subSceneNode);
        if (this.grid) {
            this.buildGrid();
        }
        if (this.city) {
            this.loadCityScene();
            this.showCityScene();
        }
        if (this.sky) {
            this.loadSky();
            this.showSky();
        }
    }

    private void buildGrid() {
        this.gridnode = new SceneCoordinateSystem(this.assetManager);
        this.subSceneNode.attachChild((Spatial)this.gridnode);
    }

    public void hideCar() {
        if (this.carModel != null) {
            this.subSceneNode.detachChild(this.carModel);
        }
    }

    public void showCar() {
        if (this.loadCar()) {
            this.subSceneNode.attachChild(this.carModel);
        }
    }

    public void showCubes1000() {
        if (this.loadCubes1000()) {
            this.subSceneNode.attachChild(this.cubes1000Model);
        }
    }

    public void hideCubes1000() {
        if (this.cubes1000Model != null) {
            this.subSceneNode.detachChild(this.cubes1000Model);
        }
    }

    public void showCityScene() {
        if (this.loadCityScene()) {
            this.subSceneNode.attachChild(this.citySceneModel);
        }
    }

    public void hideCityScene() {
        if (this.citySceneModel != null) {
            this.subSceneNode.detachChild(this.citySceneModel);
        }
    }

    public void showGokceTestScene() {
        if (this.loadGokceTestScene()) {
            this.subSceneNode.attachChild(this.gokceTestSceneModel);
        }
    }

    public void hideGokceTestScene() {
        if (this.gokceTestSceneModel != null) {
            this.subSceneNode.detachChild(this.gokceTestSceneModel);
        }
    }

    public void showSky() {
        this.loadSky();
        this.subSceneNode.attachChild(this.skySpatial);
    }

    public void hideSky() {
        this.subSceneNode.detachChild(this.skySpatial);
    }

    private boolean loadGokceTestScene() {
        if (this.gokceTestSceneModel == null) {
            try {
                this.assetManager.registerLocator("testfieldcolored.zip", ZipLocator.class);
                this.gokceTestSceneModel = this.assetManager.loadModel("testfieldcolored.scene");
                this.gokceTestSceneModel.setLocalTranslation(0.0f, -1.0f, 0.0f);
                this.gokceTestSceneModel.setLocalScale(2.0f);
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    private boolean loadCar() {
        if (this.carModel == null) {
            try {
                this.assetManager.registerLocator("fiat500.zip", ZipLocator.class);
                this.carModel = this.assetManager.loadModel("fiat500.scene");
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    private boolean loadCubes1000() {
        if (this.cubes1000Model == null) {
            try {
                this.assetManager.registerLocator("cubes1000.zip", ZipLocator.class);
                this.cubes1000Model = this.assetManager.loadModel("cubes1000.scene");
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    private boolean loadCityScene() {
        if (this.citySceneModel == null) {
            try {
                this.assetManager.registerLocator("town.zip", ZipLocator.class);
                this.citySceneModel = this.assetManager.loadModel("main.scene");
                this.citySceneModel.setLocalTranslation(0.0f, -1.0f, 0.0f);
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    public void loadSky() {
        if (this.skySpatial == null) {
            TextureKey key = new TextureKey("Textures/Sky/Bright/BrightSky.dds", true);
            key.setGenerateMips(true);
            Texture skyTex = this.assetManager.loadTexture(key);
            this.skySpatial = SkyFactory.createSky((AssetManager)this.assetManager, (Texture)skyTex, (SkyFactory.EnvMapType)SkyFactory.EnvMapType.CubeMap);
        }
    }

    private Node createCoordinateAxes(Vector3f pos) {
        Node node = new Node("axes");
        Arrow arrow = new Arrow(new Vector3f(10.0f, 0.0f, 0.0f));
        arrow.setLineWidth(4.0f);
        Geometry g = this.putShape((Mesh)arrow, ColorRGBA.Red);
        g.setLocalTranslation(pos);
        node.attachChild((Spatial)g);
        arrow = new Arrow(new Vector3f(0.0f, 10.0f, 0.0f));
        arrow.setLineWidth(4.0f);
        g = this.putShape((Mesh)arrow, ColorRGBA.Green);
        g.setLocalTranslation(pos);
        node.attachChild((Spatial)g);
        arrow = new Arrow(new Vector3f(0.0f, 0.0f, 10.0f));
        arrow.setLineWidth(4.0f);
        g = this.putShape((Mesh)arrow, ColorRGBA.Blue);
        g.setLocalTranslation(pos);
        node.attachChild((Spatial)g);
        return node;
    }

    private Geometry putShape(Mesh shape, ColorRGBA color) {
        Geometry g = new Geometry("coordinate axis", shape);
        Material mat = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        mat.getAdditionalRenderState().setWireframe(true);
        mat.setColor("Color", color);
        g.setMaterial(mat);
        return g;
    }

    private Geometry createGrid(Vector3f pos, int size, ColorRGBA color) {
        Geometry g = new Geometry("wireframe grid", (Mesh)new Grid(size, size, 0.2f));
        Material mat = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        mat.getAdditionalRenderState().setWireframe(true);
        mat.setColor("Color", color);
        g.setMaterial(mat);
        g.center().move(pos);
        return g;
    }

    public void update(float tpf) {
        this.subSceneNode.updateLogicalState(tpf);
        this.subSceneNode.updateGeometricState();
    }

    private void msgbox(String s) {
        JOptionPane.showMessageDialog(null, s);
    }

    public void loadOgreZip(final String path, final String file) {
        Callable<Object> loader = new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                try {
                    String scene = file.replace(".zip", ".scene");
                    HisSceneManager.this.assetManager.registerLocator(path + file, ZipLocator.class);
                    Spatial loadedSpatial = HisSceneManager.this.assetManager.loadModel(scene);
                    HisSceneManager.this.importedGeometriesNode.attachChild(loadedSpatial);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    HisSceneManager.this.msgbox("loadOgreZip:\n" + e.getMessage());
                }
                return null;
            }
        };
        if (this.hisClientRenderer.isThreadEqualToRenderThread(Thread.currentThread())) {
            try {
                loader.call();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.msgbox("loadOgreZip:\n" + e.getMessage());
            }
        } else {
            this.hisClientRenderer.enqueue(loader);
        }
    }

    public void clearAllImportedModels() {
        this.importedGeometriesNode.detachAllChildren();
    }
}

