/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.texture;

import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.texture.Texture2D;
import com.jme3.util.BufferUtils;
import java.nio.ByteBuffer;

public class PaintableTexture {
    protected byte[] data;
    protected Image image;
    protected Texture2D texture;
    int width;
    int height;

    public PaintableTexture(int width, int height) {
        this.width = width;
        this.height = height;
        this.data = new byte[width * height * 4];
        this.setBackground(0, 0, 0, 255);
        ByteBuffer buffer = BufferUtils.createByteBuffer((byte[])this.data);
        this.image = new Image(Image.Format.RGBA8, width, height, buffer);
        this.texture = new Texture2D(this.image);
        this.texture.setMagFilter(Texture.MagFilter.Nearest);
    }

    public Texture getTexture() {
        ByteBuffer buffer = BufferUtils.createByteBuffer((byte[])this.data);
        this.image.setData(buffer);
        return this.texture;
    }

    public void setPixel(int x, int y, int r, int g, int b, int a) {
        int i = (x + y * this.width) * 4;
        this.data[i] = (byte)r;
        this.data[i + 1] = (byte)g;
        this.data[i + 2] = (byte)b;
        this.data[i + 3] = (byte)a;
    }

    public void setBackground(int r, int g, int b, int a) {
        for (int i = 0; i < this.width * this.height * 4; i += 4) {
            this.data[i] = (byte)r;
            this.data[i + 1] = (byte)g;
            this.data[i + 2] = (byte)b;
            this.data[i + 3] = (byte)a;
        }
    }

    public void setMagFilter(Texture.MagFilter filter) {
        this.texture.setMagFilter(filter);
    }
}

