/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyveclient.ControlUI;

import com.hybridlab.hyve3d.core.HisSphericalRendererApplication;
import com.hybridlab.hyve3d.files.ImportOptions;
import com.hybridlab.hyve3d.hyve.FileTypes;
import com.hybridlab.hyve3d.hyve.HyveNetworking;
import com.hybridlab.hyve3d.nina.EULAWindow;
import com.hybridlab.hyve3d.nina.EnterLicenseKeyWindow;
import com.hybridlab.hyve3d.nina.ImmersionMode;
import com.hybridlab.hyve3d.nina.Jme3DualViewPortRenderer;
import com.hybridlab.hyve3d.rendering.ErrorVisualizer;
import com.hybridlab.hyve3d.rendering.spherical.ProjectionCalibrator;
import com.hybridlab.hyveclient.ControlUI.HyveClientControlUIMainWindow;
import com.hybridlab.hyveclient.ControlUI.MenuActionPerformer;
import com.hybridlab.hyveclient.ControlUI.MenuApplication;
import com.hybridlab.hyveclient.ControlUI.MenuController;
import com.hybridlab.hyveclient.ControlUI.OSXApplicationAdapter;
import com.hybridlab.hyveclient.SimpleAppControl.AppControlClientMessageListner;
import com.hybridlab.hyveclient.SimpleAppControl.AppControlWelcomeMessage;
import com.hybridlab.hyveclient.SimpleAppControl.CommandCode;
import com.hybridlab.hyveclient.SimpleAppControl.FileMessage;
import com.hybridlab.hyveclient.SimpleAppControl.HyveApplicationAdapter;
import com.hybridlab.hyveclient.SimpleAppControl.HyveNetworkingAdapter;
import com.hybridlab.hyveclient.SimpleAppControl.SimpleAppCtrlClient;
import com.hybridlab.hyveclient.SimpleAppControl.SimpleColorRGBAMessage;
import com.hybridlab.hyveclient.SimpleAppControl.SimpleCommandMessage;
import com.hybridlab.hyveclient.SimpleAppControl.SimpleCommandWithFloatAndBooleanArgumentMessage;
import com.hybridlab.hyveclient.SimpleAppControl.SimpleCommandWithFloatArgumentMessage;
import com.hybridlab.hyveclient.SimpleAppControl.SimpleCommandWithIntegerArgumentsMessage;
import com.hybridlab.hyveclient.SimpleAppControl.SimpleCommandWithStringAndBooleanArgumentMessage;
import com.hybridlab.hyveclient.SimpleAppControl.SimpleCommandWithStringAndIntegerArgumentMessage;
import com.hybridlab.hyveclient.SimpleAppControl.SimpleCommandWithStringArgumentMessage;
import com.hybridlab.licensing.Feature;
import com.hybridlab.licensing.LicenseKey;
import com.hybridlab.utils.Hardware4Mac;
import com.jme3.math.ColorRGBA;
import com.jme3.network.Message;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.desktop.AboutEvent;
import java.awt.desktop.AboutHandler;
import java.awt.desktop.OpenFilesEvent;
import java.awt.desktop.OpenFilesHandler;
import java.awt.desktop.PreferencesEvent;
import java.awt.desktop.PreferencesHandler;
import java.awt.desktop.QuitEvent;
import java.awt.desktop.QuitHandler;
import java.awt.desktop.QuitResponse;
import java.awt.desktop.QuitStrategy;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class HyveClientControlUI
implements MenuApplication,
QuitHandler,
PreferencesHandler,
AboutHandler {
    private HyveClientControlUIMainWindow mainWindow;
    private SimpleAppCtrlClient appCtrlClient;
    private MenuController menuCtrl;
    private OSXApplicationAdapter osxAdapter;
    private Rectangle targetRectangle;
    private Jme3DualViewPortRenderer.MaskModifier maskModifier;
    private JLabel framerateLabel;
    private JLabel licenseInfoLabel;
    private JButton button_immersive;
    private JButton button_nonimmersive;
    private JPanel panel;
    final String hardwareuuid = Hardware4Mac.getHardwareUUIDNumber();
    final LicenseKey.LicenceValidator licenseValidator = new LicenseKey.LicenceValidator(){

        @Override
        public boolean isValidKey(String key) {
            if (key == null) {
                return false;
            }
            if (key.isEmpty()) {
                return false;
            }
            if (key.equals(LicenseKey.DevelopmentKey)) {
                return true;
            }
            String uppercaseTrimmedKey = key.trim().toUpperCase();
            LicenseKey lk = new LicenseKey(uppercaseTrimmedKey);
            try {
                return lk.isValidForHardwareIDAtThisMoment(HyveClientControlUI.this.hardwareuuid);
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
    };
    private EnterLicenseKeyWindow licensingWindow;
    private EULAWindow eulaWindow;
    private UIHyveApplicationAdapter napp = new UIHyveApplicationAdapter();
    private UIHyveNetworkingAdapter nwa = new UIHyveNetworkingAdapter();

    public static void main(String[] args) {
        System.setProperty("com.apple.mrj.application.apple.menu.about.name", "Hyve-3D");
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        Logger.getLogger("de.lessvoid").setLevel(Level.SEVERE);
        Logger.getLogger("com.jme3").setLevel(Level.SEVERE);
        HyveClientControlUI uiApp = new HyveClientControlUI();
        uiApp.obtainScreenSizeInformations();
        uiApp.start();
    }

    private void start() {
        this.mainWindow = new HyveClientControlUIMainWindow("Hyve3D", this);
        this.mainWindow.setLocation(100, 400);
        this.mainWindow.setSize(800, 600);
        this.appCtrlClient = new SimpleAppCtrlClient();
        this.panel = new JPanel();
        this.mainWindow.add(this.panel);
        this.setupTestButton(this.panel);
        this.licenseInfoLabel = this.setupLicenseInfoLabel(this.panel);
        this.setupFrameRateLabel(this.panel);
        Desktop desktop = Desktop.getDesktop();
        this.osxAdapter = new OSXApplicationAdapter();
        desktop.setQuitHandler(this);
        desktop.setAboutHandler(this);
        desktop.setQuitStrategy(QuitStrategy.CLOSE_ALL_WINDOWS);
        desktop.setPreferencesHandler(this);
        desktop.setOpenFileHandler(new OpenFilesHandler(){

            @Override
            public void openFiles(OpenFilesEvent e) {
                System.out.println(e);
            }
        });
        PerformerAdapter performer = new PerformerAdapter(this.appCtrlClient);
        HyveClientControlUI menuApp = this;
        this.menuCtrl = new MenuController(desktop, performer, menuApp);
        this.appCtrlClient.addListener(this.menuCtrl);
        this.menuCtrl.createMenu();
        this.menuCtrl.createMenuRelatedWindows();
        final AppControlMaskModifier modifier = new AppControlMaskModifier();
        final AppControlProjectionCalibrator calibrator = new AppControlProjectionCalibrator();
        this.appCtrlClient.addListener(new AppControlClientMessageListner(){

            @Override
            public void receiveWelcomeMessage(AppControlWelcomeMessage message) {
                HyveClientControlUI.this.menuCtrl.connectCalibratorUI(modifier, calibrator);
                String key = message.licenseKey;
                LicenseKey lk = new LicenseKey(key);
                HyveClientControlUI.this.updateWithLicenseKey(lk);
                HyveClientControlUI.this.napp.localSessionID = UUID.fromString(message.localSessionIDString);
                HyveClientControlUI.this.napp.localSpaceName = message.localSpaceName;
                HyveClientControlUI.this.menuCtrl.connectNetworkingUIAdapters(HyveClientControlUI.this.nwa, HyveClientControlUI.this.napp);
            }

            @Override
            public void receiveFrameRate(float frameRate) {
            }
        });
        SwingUtilities.invokeLater(() -> {
            this.mainWindow.setVisible(true);
            this.appCtrlClient.connect();
        });
    }

    private JLabel setupLicenseInfoLabel(JPanel panel) {
        JLabel label = new JLabel("");
        panel.add(label);
        return label;
    }

    private void updateWithLicenseKey(LicenseKey lk) {
        String[] licenseInfo = new String[]{"no valid license"};
        try {
            if (lk.isValidForHardwareIDAtThisMoment(this.hardwareuuid)) {
                licenseInfo[0] = "License valid until " + lk.getValidUntil().toString() + "\n";
                licenseInfo[0] = licenseInfo[0] + "licensed features:";
                lk.getEnabledFeatures().forEach(feature -> {
                    licenseInfo[0] = licenseInfo[0] + " " + feature.name();
                });
                this.updateLicenseInfoLabel(licenseInfo[0]);
                this.button_immersive.setEnabled(lk.getEnabledFeatures().contains((Object)Feature.IMMERSIVE));
                this.button_nonimmersive.setEnabled(lk.getEnabledFeatures().contains((Object)Feature.NONIMMERSIVE));
                Set<Feature> features = lk.getEnabledFeatures();
                if (!features.contains((Object)Feature.IMMERSIVE) || !features.contains((Object)Feature.NONIMMERSIVE)) {
                    if (features.contains((Object)Feature.IMMERSIVE)) {
                        this.sendCmdMsg(CommandCode.Immersive);
                    } else if (features.contains((Object)Feature.NONIMMERSIVE)) {
                        this.sendCmdMsg(CommandCode.NonImmersive);
                    }
                }
            } else {
                final EnterLicenseKeyWindow.LicenseEnteredCallback callback = new EnterLicenseKeyWindow.LicenseEnteredCallback(){

                    @Override
                    public void onLicenseKeyEntered(String licenskey, int numtrys, boolean savingNecessary) throws Exception {
                        String uppercaseTrimmedKey;
                        LicenseKey lk;
                        if (licenskey.equals("CANCEL")) {
                            System.out.println("CANCELED DUE TO NO VALID LICENSE");
                            HyveClientControlUI.this.performQuit(true);
                        }
                        if (!(lk = new LicenseKey(uppercaseTrimmedKey = licenskey.trim().toUpperCase())).isValidForHardwareIDAtThisMoment(HyveClientControlUI.this.hardwareuuid)) {
                            if (numtrys <= 10) {
                                HyveClientControlUI.this.askForLicenseKey("The license does not match your hardware. Please enter a valid license key!", HyveClientControlUI.this.hardwareuuid, numtrys + 1, HyveClientControlUI.this.licenseValidator, "", this);
                            } else {
                                System.out.println("NO VALID LICENSE");
                                HyveClientControlUI.this.performQuit(true);
                            }
                        } else {
                            lk.setValid(true);
                            HyveClientControlUI.this.sendLicense(lk.toLicenseKeyString());
                            HyveClientControlUI.this.updateWithLicenseKey(lk);
                            if (savingNecessary) {
                                try {
                                    File path = LicenseKey.getStorageFolder();
                                    File f = new File(path.getAbsolutePath(), "license.txt");
                                    HyveClientControlUI.this.saveStringToFile(lk.toLicenseKeyString(), f);
                                }
                                catch (FileNotFoundException e1) {
                                    e1.printStackTrace();
                                }
                                catch (IOException e1) {
                                    e1.printStackTrace();
                                }
                            }
                        }
                    }
                };
                EULAWindow.EulaAcceptedCallback callbackEULA = new EULAWindow.EulaAcceptedCallback(){

                    @Override
                    public void onEulaAccepted() {
                        HyveClientControlUI.this.askForLicenseKey("Please enter your license key.", HyveClientControlUI.this.hardwareuuid, 1, HyveClientControlUI.this.licenseValidator, "", callback);
                    }

                    @Override
                    public void onCanceled() {
                        System.out.println("CANCELED DUE TO EULA NOT ACCEPTED");
                        HyveClientControlUI.this.performQuit(true);
                    }
                };
                this.showEula(callbackEULA);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void saveStringToFile(String s, File f) throws Exception {
        File path = f.getParentFile();
        if (!path.exists() && !path.mkdir()) {
            throw new Exception("Cannot create directory " + path.getAbsolutePath());
        }
        System.out.println("Saving " + s + " to " + f.getAbsolutePath() + "...");
        f.delete();
        FileUtils.write(f, s);
    }

    private void renewLicense() {
        EnterLicenseKeyWindow.LicenseEnteredCallback callback = new EnterLicenseKeyWindow.LicenseEnteredCallback(){

            @Override
            public void onLicenseKeyEntered(String licenskey, int numtrys, boolean savingNecessary) throws Exception {
                if (licenskey.equals("CANCEL")) {
                    System.out.println("CANCELED DUE TO NO VALID LICENSE");
                    return;
                }
                String uppercaseTrimmedKey = licenskey.trim().toUpperCase();
                LicenseKey lk = new LicenseKey(uppercaseTrimmedKey);
                if (!lk.isValidForHardwareIDAtThisMoment(HyveClientControlUI.this.hardwareuuid)) {
                    if (numtrys <= 10) {
                        HyveClientControlUI.this.askForLicenseKey("The license does not match your hardware. Please enter a valid license key!", HyveClientControlUI.this.hardwareuuid, numtrys + 1, HyveClientControlUI.this.licenseValidator, "", this);
                    } else {
                        System.out.println("NO VALID LICENSE");
                    }
                } else {
                    lk.setValid(true);
                    HyveClientControlUI.this.sendLicense(lk.toLicenseKeyString());
                    HyveClientControlUI.this.updateWithLicenseKey(lk);
                    if (savingNecessary) {
                        try {
                            File path = LicenseKey.getStorageFolder();
                            File f = new File(path.getAbsolutePath(), "license.txt");
                            HyveClientControlUI.this.saveStringToFile(lk.toLicenseKeyString(), f);
                        }
                        catch (FileNotFoundException e1) {
                            e1.printStackTrace();
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                    }
                }
            }
        };
        this.askForLicenseKey("Please enter your new license key.", this.hardwareuuid, 1, this.licenseValidator, "", callback);
    }

    private void updateLicenseInfoLabel(String licInfo) {
        this.licenseInfoLabel.setText(licInfo);
    }

    private void askForLicenseKey(final String reason, final String mac, final int numberOfRequests, final LicenseKey.LicenceValidator val, final String key, final EnterLicenseKeyWindow.LicenseEnteredCallback callback) {
        class MyRunnable
        implements Runnable {
            MyRunnable() {
            }

            @Override
            public void run() {
                if (HyveClientControlUI.this.licensingWindow != null) {
                    HyveClientControlUI.this.licensingWindow.dispose();
                    HyveClientControlUI.this.licensingWindow = null;
                }
                HyveClientControlUI.this.licensingWindow = new EnterLicenseKeyWindow(reason, mac, numberOfRequests, "continue", val, key, callback);
                HyveClientControlUI.this.licensingWindow.setDefaultCloseOperation(0);
                int w = 750;
                int h = 450;
                HyveClientControlUI.this.licensingWindow.setSize(w, h);
                Point location = HyveClientControlUI.this.getLocationOnFirstScreenForWindowSize(w, h);
                HyveClientControlUI.this.licensingWindow.setLocation(location);
                HyveClientControlUI.this.licensingWindow.setVisible(true);
            }
        }
        MyRunnable r = new MyRunnable();
        SwingUtilities.invokeLater(r);
    }

    private void showEula(final EULAWindow.EulaAcceptedCallback callbackEULA) {
        class MyRunnable
        implements Runnable {
            MyRunnable() {
            }

            @Override
            public void run() {
                if (HyveClientControlUI.this.eulaWindow != null) {
                    HyveClientControlUI.this.eulaWindow.dispose();
                    HyveClientControlUI.this.eulaWindow = null;
                }
                HyveClientControlUI.this.eulaWindow = new EULAWindow(callbackEULA, HyveClientControlUI.this.getEulaHTMLText());
                HyveClientControlUI.this.eulaWindow.setDefaultCloseOperation(0);
                int w = 750;
                int h = 750;
                HyveClientControlUI.this.eulaWindow.setSize(w, h);
                Point location = HyveClientControlUI.this.getLocationOnFirstScreenForWindowSize(w, h);
                HyveClientControlUI.this.eulaWindow.setLocation(location);
                HyveClientControlUI.this.eulaWindow.setVisible(true);
            }
        }
        MyRunnable r = new MyRunnable();
        SwingUtilities.invokeLater(r);
    }

    public String getEulaHTMLText() {
        URL i1 = this.getClass().getResource("eula/imagetop.png");
        URL i2 = this.getClass().getResource("eula/imagebottom.png");
        InputStream is = this.getClass().getResourceAsStream("eula/eulanew.html");
        try {
            List<String> lines = IOUtils.readLines(is, Charset.forName("UTF8"));
            String eula = StringUtils.join(lines, "\n");
            eula = StringUtils.replace(eula, "imagetop.png", i1.toString());
            eula = StringUtils.replace(eula, "imagebottom.png", i2.toString());
            return eula;
        }
        catch (IOException e) {
            e.printStackTrace();
            return "<html><b>EULA</b><br/>eula text not readable.</html>";
        }
    }

    private Point getLocationOnFirstScreenForWindowSize(int w, int h) {
        GraphicsEnvironment environment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] screens = environment.getScreenDevices();
        GraphicsDevice screen = screens[0];
        DisplayMode mode = screen.getDisplayMode();
        int screenWidth = mode.getWidth();
        int screenHeight = mode.getHeight();
        Dimension dimensionsOfFirstScreen = new Dimension(screenWidth, screenHeight);
        return new Point(dimensionsOfFirstScreen.width / 2 - w / 2, dimensionsOfFirstScreen.height / 2 - h / 2);
    }

    private void setupFrameRateLabel(JPanel panel) {
        this.framerateLabel = new JLabel("framerate = ");
        panel.add(this.framerateLabel);
    }

    @Override
    public void handleAbout(AboutEvent e) {
        this.menuCtrl.showSplashWindow();
    }

    @Override
    public void handlePreferences(PreferencesEvent e) {
        this.menuCtrl.showPreferencesWindow();
    }

    @Override
    public void handleQuitRequestWith(QuitEvent e, QuitResponse response) {
        this.performQuit(false);
        response.performQuit();
    }

    protected void performQuit(boolean callSystemExit) {
        SimpleCommandMessage m = SimpleCommandMessage.createWith(CommandCode.Quit);
        this.appCtrlClient.send((Message)m);
        if (callSystemExit) {
            System.exit(0);
        }
    }

    private void sendColorRGBA(CommandCode code, ColorRGBA color) {
        SimpleColorRGBAMessage m = SimpleColorRGBAMessage.createWith(code, color);
        this.appCtrlClient.send((Message)m);
    }

    private void sendFloat(CommandCode c, float f) {
        SimpleCommandWithFloatArgumentMessage m = SimpleCommandWithFloatArgumentMessage.createWith(c, f);
        this.appCtrlClient.send((Message)m);
    }

    private void sendFloatAndBool(CommandCode c, float f, boolean b) {
        SimpleCommandWithFloatAndBooleanArgumentMessage m = SimpleCommandWithFloatAndBooleanArgumentMessage.createWith(c, f, b);
        this.appCtrlClient.send((Message)m);
    }

    private void sendFileMessage(CommandCode code, String directory, String filename, FileTypes ft, String options) {
        FileMessage m = FileMessage.createWith(code, directory, filename, ft, options);
        this.appCtrlClient.send((Message)m);
    }

    private void sendFileMessage(CommandCode code, String directory, String filename) {
        FileMessage m = FileMessage.createWith(code, directory, filename);
        this.appCtrlClient.send((Message)m);
    }

    private void setupTestButton(JPanel panel) {
        JButton test2 = new JButton("Close");
        panel.add(test2);
        test2.addActionListener(e -> this.performQuit(true));
        panel.add(this.makeTestButton("get framerate", () -> this.sendCmdMsg(CommandCode.RequestFrameRate)));
        this.button_immersive = this.makeTestButton("immersive", () -> this.sendCmdMsg(CommandCode.Immersive));
        this.button_immersive.setEnabled(false);
        panel.add(this.button_immersive);
        this.button_nonimmersive = this.makeTestButton("non-immersive", () -> this.sendCmdMsg(CommandCode.NonImmersive));
        this.button_nonimmersive.setEnabled(false);
        panel.add(this.button_nonimmersive);
        panel.add(this.makeTestButton("send to second screen", () -> {
            int[] args = new int[]{this.targetRectangle.x, this.targetRectangle.y, this.targetRectangle.width, this.targetRectangle.height};
            this.sendCmdMsgWithIntArgs(CommandCode.SendToSecondScreen, args);
        }));
        panel.add(this.makeTestButton("renew license", () -> this.renewLicense()));
    }

    private void sendCmdMsg(CommandCode cmdString) {
        SimpleCommandMessage m = new SimpleCommandMessage(cmdString.code);
        this.appCtrlClient.send((Message)m);
    }

    private void sendLicense(String licenseKeyString) {
        SimpleCommandWithStringArgumentMessage m = new SimpleCommandWithStringArgumentMessage(CommandCode.License.code, licenseKeyString);
        this.appCtrlClient.send((Message)m);
    }

    private void sendCmdWithStringArgMsg(CommandCode cmd, String argument) {
        SimpleCommandWithStringArgumentMessage m = new SimpleCommandWithStringArgumentMessage(cmd.code, argument);
        this.appCtrlClient.send((Message)m);
    }

    private void sendCmdMsgWithIntArgs(CommandCode cmdString, int[] args) {
        SimpleCommandWithIntegerArgumentsMessage m = new SimpleCommandWithIntegerArgumentsMessage(cmdString.code, args[0], args[1], args[2], args[3]);
        this.appCtrlClient.send((Message)m);
    }

    private JButton makeTestButton(String text, Runnable r) {
        JButton test2 = new JButton(text);
        test2.addActionListener(e -> r.run());
        return test2;
    }

    @Override
    public Dialog getDialogParentWindow() {
        return null;
    }

    @Override
    public void showNetworkingWindow(MenuActionPerformer performer) {
        this.menuCtrl.showNetworkingWindow();
    }

    @Override
    public void showResourceWatcherWindow() {
    }

    @Override
    public void showSceneWindow() {
    }

    @Override
    public OSXApplicationAdapter getOSXApplicationAdapter() {
        return this.osxAdapter;
    }

    @Override
    public JFrame getMainWindow() {
        return this.mainWindow;
    }

    @Override
    public ErrorVisualizer getErrorVisualizer() {
        return this.mainWindow.getErrorVisualizer();
    }

    @Override
    public void showFrameRate(float frameRate) {
        this.framerateLabel.setText("framerate = " + frameRate);
    }

    private void obtainScreenSizeInformations() {
        GraphicsDevice defaultScreenDevice;
        boolean moreThanOneScreenAvailable = false;
        GraphicsEnvironment environment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] screens = environment.getScreenDevices();
        int numScreens = screens.length;
        GraphicsDevice displayDevice = defaultScreenDevice = environment.getDefaultScreenDevice();
        for (int i = 0; i < numScreens; ++i) {
            GraphicsDevice screen = screens[i];
            System.out.println("screenid=" + i + " idString=" + screen.getIDstring());
            DisplayMode mode = screen.getDisplayMode();
            int screenWidth = mode.getWidth();
            int screenHeight = mode.getHeight();
            if (defaultScreenDevice != screen) {
                displayDevice = screen;
                moreThanOneScreenAvailable = true;
            }
            if (defaultScreenDevice != screen) continue;
            Dimension dimension = new Dimension(screenWidth, screenHeight);
        }
        Rectangle gcBounds = displayDevice.getDefaultConfiguration().getBounds();
        Point windowPosition = new Point(gcBounds.x, gcBounds.y);
        Rectangle defaultScreenBounds = defaultScreenDevice.getDefaultConfiguration().getBounds();
        Point centerOfDefaultScreen = new Point(defaultScreenBounds.x + defaultScreenBounds.width / 2, defaultScreenBounds.y + defaultScreenBounds.height / 2);
        this.targetRectangle = gcBounds;
    }

    private class UIHyveApplicationAdapter
    implements HyveApplicationAdapter {
        public UUID localSessionID = null;
        public String localSpaceName = null;

        private UIHyveApplicationAdapter() {
        }

        @Override
        public void setLocalSpaceName(String hyveName) {
            System.out.println("setLocalSpaceName " + hyveName);
            HyveClientControlUI.this.appCtrlClient.send((Message)SimpleCommandWithStringArgumentMessage.createWith(CommandCode.LocalSpaceName, hyveName));
        }

        @Override
        public String getLocalSpaceName() {
            return this.localSpaceName;
        }

        @Override
        public UUID getLocalSessionId() {
            return this.localSessionID;
        }

        @Override
        public void joinSession(UUID id) {
            System.out.println("joinSession " + id.toString());
            HyveClientControlUI.this.appCtrlClient.send((Message)SimpleCommandWithStringArgumentMessage.createWith(CommandCode.JoinSession, id.toString()));
        }

        @Override
        public void visualizeSession(UUID id) {
            System.out.println("visualizeSession " + id.toString());
            HyveClientControlUI.this.appCtrlClient.send((Message)SimpleCommandWithStringArgumentMessage.createWith(CommandCode.VisualizeSession, id.toString()));
        }

        @Override
        public void synchSession(UUID id) {
            System.out.println("synchSession " + id.toString());
            HyveClientControlUI.this.appCtrlClient.send((Message)SimpleCommandWithStringArgumentMessage.createWith(CommandCode.SynchSession, id.toString()));
        }
    }

    private class UIHyveNetworkingAdapter
    implements HyveNetworkingAdapter {
        private HyveNetworking.HostingEstablishListener hostingListener;
        private HyveNetworking.ConnectionEstablishListener connListener;

        private UIHyveNetworkingAdapter() {
        }

        @Override
        public void asynchConnectToHubNode(String host, int port, HyveNetworking.ConnectionEstablishListener connListener) {
            System.out.println("asynchConnectToHubNode " + host.toString() + " " + port + " using " + connListener);
            HyveClientControlUI.this.appCtrlClient.send((Message)SimpleCommandWithStringAndIntegerArgumentMessage.createWith(CommandCode.AsynchConnectToHubNode, host, port));
        }

        @Override
        public boolean createHost(int port, HyveNetworking.HostingEstablishListener hostingListener) {
            this.hostingListener = hostingListener;
            System.out.println("createHost " + port + " using " + hostingListener);
            HyveClientControlUI.this.appCtrlClient.send((Message)SimpleCommandWithIntegerArgumentsMessage.createWith(CommandCode.CreateHost, new int[]{port, 0, 0, 0}));
            return false;
        }

        @Override
        public void shareSession(UUID sid, boolean mustbeConnected) {
            System.out.println("shareSession " + sid.toString() + " mustbeConnected=" + mustbeConnected);
            HyveClientControlUI.this.appCtrlClient.send((Message)SimpleCommandWithStringAndBooleanArgumentMessage.createWith(CommandCode.ShareSession, sid.toString(), mustbeConnected));
        }

        @Override
        public void disconnectFromHubNode(HyveNetworking.ConnectionEstablishListener connListener) {
            this.connListener = connListener;
            System.out.println("disconnectFromHubNode  using " + connListener);
            HyveClientControlUI.this.appCtrlClient.send((Message)SimpleCommandMessage.createWith(CommandCode.DisconnectFromHubNode));
        }

        @Override
        public void closeHost(HyveNetworking.HostingEstablishListener hostingListener) {
            System.out.println("closeHost  using " + hostingListener);
            HyveClientControlUI.this.appCtrlClient.send((Message)SimpleCommandMessage.createWith(CommandCode.CloseHost));
        }
    }

    class PerformerAdapter
    implements MenuActionPerformer {
        private final SimpleAppCtrlClient appCtrlClient;
        private AppControlWelcomeMessage lastMessage = AppControlWelcomeMessage.DefaultMessage;

        public PerformerAdapter(SimpleAppCtrlClient appCtrlClient) {
            this.appCtrlClient = appCtrlClient;
        }

        public void receiveWelcomeMessage(AppControlWelcomeMessage message) {
            this.lastMessage = message;
        }

        @Override
        public String toggleBackGround(String backgroundLabel) {
            HyveClientControlUI.this.sendCmdWithStringArgMsg(CommandCode.ToggleBackground, backgroundLabel);
            return "";
        }

        @Override
        public void setDisplayFps(boolean b) {
            if (b) {
                HyveClientControlUI.this.sendCmdMsg(CommandCode.EnableDisplayFps);
            } else {
                HyveClientControlUI.this.sendCmdMsg(CommandCode.DisbleDisplayFps);
            }
        }

        @Override
        public void setDisplayStatView(boolean b) {
            if (b) {
                HyveClientControlUI.this.sendCmdMsg(CommandCode.EnableDisplayStats);
            } else {
                HyveClientControlUI.this.sendCmdMsg(CommandCode.DisbleDisplayStats);
            }
        }

        @Override
        public void setupAutoExportTimer(boolean enabled) {
            if (enabled) {
                HyveClientControlUI.this.sendCmdMsg(CommandCode.EnableAutoExportTimer);
            } else {
                HyveClientControlUI.this.sendCmdMsg(CommandCode.DisbleAutoExportTimer);
            }
        }

        @Override
        public void setupSketchLog(boolean enabled) {
            if (enabled) {
                HyveClientControlUI.this.sendCmdMsg(CommandCode.EnableSketchLog);
            } else {
                HyveClientControlUI.this.sendCmdMsg(CommandCode.DisbleSketchLog);
            }
        }

        @Override
        public void importLocalFile(String directory, String filename, FileTypes ft, String options) {
            HyveClientControlUI.this.sendFileMessage(CommandCode.Import, directory, filename, ft, options);
        }

        @Override
        public void saveToLocalFile(String directory, String filename) {
            HyveClientControlUI.this.sendFileMessage(CommandCode.Save, directory, filename);
        }

        @Override
        public boolean isAutoExportEnabled() {
            return this.lastMessage.autoExport;
        }

        @Override
        public boolean isSketchLogEnabled() {
            return this.lastMessage.sketchLog;
        }

        @Override
        public void openLocalFile(String directory, String filename, FileTypes ft) {
            HyveClientControlUI.this.sendFileMessage(CommandCode.Open, directory, filename, ft, ImportOptions.createDefaultOptions().toImportOptionsString());
        }

        @Override
        public void clearSky() {
            HyveClientControlUI.this.sendCmdMsg(CommandCode.ClearSky);
        }

        @Override
        public List<File> scanSkyFiles() {
            return Collections.EMPTY_LIST;
        }

        @Override
        public void eraseAll() {
            HyveClientControlUI.this.sendCmdMsg(CommandCode.EraseAll);
        }

        @Override
        public void setOnlyUseTCP(boolean b) {
            if (b) {
                HyveClientControlUI.this.sendCmdMsg(CommandCode.EnableOnlyTCP);
            } else {
                HyveClientControlUI.this.sendCmdMsg(CommandCode.DisbleOnlyTCP);
            }
        }

        @Override
        public void resetNavigation() {
            HyveClientControlUI.this.sendCmdMsg(CommandCode.ResetNavigation);
        }

        @Override
        public void synchronizeHyvePositions(boolean b) {
            if (b) {
                HyveClientControlUI.this.sendCmdMsg(CommandCode.EnableHyvePositionSyncronization);
            } else {
                HyveClientControlUI.this.sendCmdMsg(CommandCode.DisableHyvePositionSyncronization);
            }
        }

        @Override
        public void setFullscreen(boolean b) {
            if (b) {
                HyveClientControlUI.this.sendCmdMsg(CommandCode.EnableFullscreen);
            } else {
                HyveClientControlUI.this.sendCmdMsg(CommandCode.DisableFullscreen);
            }
        }

        @Override
        public ImmersionMode getMode() {
            return ImmersionMode.valueOf(this.lastMessage.immersionMode);
        }

        @Override
        public void enableNonImmersiveMode() {
            HyveClientControlUI.this.sendCmdMsg(CommandCode.NonImmersive);
        }

        @Override
        public void enableImmersiveMode() {
            HyveClientControlUI.this.sendCmdMsg(CommandCode.Immersive);
        }

        @Override
        public boolean getFullScreen() {
            return this.lastMessage.fullscreen;
        }

        @Override
        public boolean isInertiaNavigationEnabled() {
            return this.lastMessage.inertiaNavigation;
        }

        @Override
        public void setInertiaNavigationEnabled(boolean selected) {
            if (selected) {
                HyveClientControlUI.this.sendCmdMsg(CommandCode.EnableInertiaNavigation);
            } else {
                HyveClientControlUI.this.sendCmdMsg(CommandCode.DisableInertiaNavigation);
            }
        }

        @Override
        public boolean getSnapDuringHinge() {
            return this.lastMessage.snapDuringHinge;
        }

        @Override
        public void setSnapDuringHinge(boolean selected) {
            if (selected) {
                HyveClientControlUI.this.sendCmdMsg(CommandCode.EnableSnapDuringHinge);
            } else {
                HyveClientControlUI.this.sendCmdMsg(CommandCode.DisableSnapDuringHinge);
            }
        }
    }

    class AppControlMaskModifier
    implements Jme3DualViewPortRenderer.MaskModifier {
        private AppControlWelcomeMessage lastMessage = AppControlWelcomeMessage.DefaultMessage;

        AppControlMaskModifier() {
        }

        @Override
        public float getRingRadius() {
            return this.lastMessage.ringRadius;
        }

        @Override
        public void setRingRadius(float r) {
            HyveClientControlUI.this.sendFloat(CommandCode.RingRadius, r);
        }

        @Override
        public void setRingColor(ColorRGBA c) {
            HyveClientControlUI.this.sendColorRGBA(CommandCode.RingColor, c);
        }

        @Override
        public void setRingMaskVisibility(boolean visible) {
            if (visible) {
                HyveClientControlUI.this.sendCmdMsg(CommandCode.ShowRingMask);
            } else {
                HyveClientControlUI.this.sendCmdMsg(CommandCode.HideRingMask);
            }
        }

        @Override
        public boolean getRingMaskVisibility() {
            return this.lastMessage.ringMaskVisibility;
        }

        @Override
        public boolean ringColorIsCalibrationColor() {
            return this.lastMessage.ringColorIsCalibrationColor;
        }

        @Override
        public boolean ringColorIsBlack() {
            return this.lastMessage.ringColorIsBlack;
        }

        @Override
        public float getEllipseWidth() {
            return this.lastMessage.ellipseWidth;
        }

        @Override
        public float getEllipseHeight() {
            return this.lastMessage.ellipseHeight;
        }

        @Override
        public float getEllipsePosition() {
            return this.lastMessage.ellipsePosition;
        }

        @Override
        public void setEllipseWidth(float w) {
            HyveClientControlUI.this.sendFloat(CommandCode.EllipseWidth, w);
        }

        @Override
        public void setEllipseHeight(float h) {
            HyveClientControlUI.this.sendFloat(CommandCode.EllipseHeight, h);
        }

        @Override
        public void setEllipsePosition(float p) {
            HyveClientControlUI.this.sendFloat(CommandCode.EllipsePosition, p);
        }

        @Override
        public void setEllipseBlend(float alpha) {
            HyveClientControlUI.this.sendFloat(CommandCode.EllipseBlend, alpha);
        }

        @Override
        public void setEllipseColor(ColorRGBA c) {
            HyveClientControlUI.this.sendColorRGBA(CommandCode.EllipseColor, c);
        }

        @Override
        public void setMaskVisibility(boolean visible) {
        }

        @Override
        public boolean getMaskVisibility() {
            return this.lastMessage.maskVisibility;
        }

        @Override
        public boolean colorIsCalibrationColor() {
            return this.lastMessage.maskColorIsCalibrationColor;
        }

        @Override
        public boolean colorIsBlack() {
            return this.lastMessage.maskColorIsBlack;
        }

        @Override
        public float getShiftHorizontal() {
            return this.lastMessage.shiftHorizontal;
        }

        @Override
        public float getShiftVertical() {
            return this.lastMessage.shiftVertical;
        }

        @Override
        public void setShiftVertical(float value) {
            HyveClientControlUI.this.sendFloat(CommandCode.ShiftVertical, value);
        }

        @Override
        public void setShiftHorizontal(float value) {
            HyveClientControlUI.this.sendFloat(CommandCode.ShiftHorizontal, value);
        }

        public void receiveWelcomeMessage(AppControlWelcomeMessage message) {
            this.lastMessage = message;
        }
    }

    public class AppControlProjectionCalibrator
    implements ProjectionCalibrator {
        private AppControlWelcomeMessage lastMessage = AppControlWelcomeMessage.DefaultMessage;

        @Override
        public void setProjectionParameters(Float sphereScale, Float sphereViewportRadius, Float sphereCamDistance, Float sphereCamFieldOfView) {
        }

        @Override
        public void changeSpherecamDistance(float changeAmount) {
            HyveClientControlUI.this.sendFloat(CommandCode.ChangeSpherecamDistance, changeAmount);
        }

        @Override
        public void setCameraDistance(float distance) {
            HyveClientControlUI.this.sendFloat(CommandCode.CameraDistance, distance);
        }

        @Override
        public void setCameraDistance(float distance, boolean correctFOV) {
            HyveClientControlUI.this.sendFloatAndBool(CommandCode.CameraDistance, distance, correctFOV);
        }

        @Override
        public float getCameraDistance() {
            return this.lastMessage.cameraDistance;
        }

        @Override
        public void changeSpherecamScale(float changeAmount) {
            HyveClientControlUI.this.sendFloat(CommandCode.ChangeSpherecamScale, changeAmount);
        }

        @Override
        public void setSphereScale(float scale) {
            HyveClientControlUI.this.sendFloat(CommandCode.SphereScale, scale);
        }

        @Override
        public float getSphereScale() {
            return this.lastMessage.sphereScale;
        }

        @Override
        public void changeSpherecamViewPortRadius(float changeAmount) {
            HyveClientControlUI.this.sendFloat(CommandCode.ChangeSpherecamViewPortRadius, changeAmount);
        }

        @Override
        public void setViewPortRadius(float r) {
            System.out.println("setViewPortRadius " + String.valueOf(r));
            HyveClientControlUI.this.sendFloat(CommandCode.ViewPortRadius, r);
        }

        @Override
        public float getViewPortRadius() {
            return this.lastMessage.viewPortRadius;
        }

        @Override
        public void setSpherecameraFieldOfViewAngleAlongYInDegrees(float fovY) {
            HyveClientControlUI.this.sendFloat(CommandCode.SpherecameraFieldOfViewAngleAlongYInDegrees, fovY);
        }

        @Override
        public void setSpherecameraFieldOfViewAngleAlongYInDegrees(float fovYDeg, boolean correctDistance) {
            HyveClientControlUI.this.sendFloatAndBool(CommandCode.SpherecameraFieldOfViewAngleAlongYInDegrees, fovYDeg, correctDistance);
        }

        @Override
        public float getSpherecameraFieldOfViewAngleAlongYInDegrees() {
            return this.lastMessage.spherecameraFieldOfViewAngleAlongYInDegrees;
        }

        @Override
        public void registerChangeListener(ProjectionCalibrator.ProjectionCalibrationValueChangeListener l) {
        }

        @Override
        public void setFOVandDistanceAreConnected(boolean booleanValue) {
        }

        @Override
        public boolean isFOVconnectedToDistance() {
            return this.lastMessage.isFOVconnectedToDistance;
        }

        @Override
        public void setMode(HisSphericalRendererApplication.AppMode mode) {
        }

        public void receiveWelcomeMessage(AppControlWelcomeMessage message) {
            this.lastMessage = message;
        }
    }
}

