/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyveclient.SimpleAppControl;

import com.hybridlab.hyve3d.network.interconnection.messages.Registry;
import com.hybridlab.hyveclient.SimpleAppControl.AppControlClientMessageListner;
import com.hybridlab.hyveclient.SimpleAppControl.AppControlWelcomeMessage;
import com.hybridlab.hyveclient.SimpleAppControl.SimpleAppCtrlServer;
import com.hybridlab.hyveclient.SimpleAppControl.SimpleCommandMessage;
import com.hybridlab.hyveclient.SimpleAppControl.SimpleCommandWithFloatArgumentMessage;
import com.hybridlab.hyveclient.SimpleAppControl.SimpleCommandWithIntegerArgumentsMessage;
import com.hybridlab.hyveclient.SimpleAppControl.SimpleCommandWithStringArgumentMessage;
import com.hybridlab.hyveclient.SimpleAppControl.SimpleWelcomeMessage;
import com.jme3.network.Client;
import com.jme3.network.Message;
import com.jme3.network.MessageListener;
import com.jme3.network.Network;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class SimpleAppCtrlClient {
    private Client appCtrlClientInstance;
    private String host = "localhost";
    private Set<AppControlClientMessageListner> listeners = new HashSet<AppControlClientMessageListner>();

    public void addListener(AppControlClientMessageListner listener) {
        this.listeners.add(listener);
    }

    public void connect() {
        if (this.appCtrlClientInstance != null && this.appCtrlClientInstance.isConnected()) {
            new Exception("appCtrlClientInstance already created and connected").printStackTrace();
            return;
        }
        try {
            this.appCtrlClientInstance = Network.connectToServer((String)SimpleAppCtrlServer.ServerName, (int)SimpleAppCtrlServer.Version, (String)this.host, (int)SimpleAppCtrlServer.DefaultTCPPort, (int)SimpleAppCtrlServer.DefaultUPDPort);
            Registry.registerMessageTypes();
            this.appCtrlClientInstance.addMessageListener((MessageListener)new SimpleClientListener(), new Class[]{SimpleCommandMessage.class, SimpleWelcomeMessage.class, SimpleCommandWithStringArgumentMessage.class, SimpleCommandWithFloatArgumentMessage.class, AppControlWelcomeMessage.class});
            this.appCtrlClientInstance.start();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void send(Message msg) {
        if (this.appCtrlClientInstance == null) {
            new Exception("appCtrlClientInstance was not created").printStackTrace();
            return;
        }
        if (!this.appCtrlClientInstance.isConnected()) {
            new Exception("appCtrlClientInstance is not connected\u00b0").printStackTrace();
            return;
        }
        System.out.println("sending message: " + msg.toString());
        this.appCtrlClientInstance.send(msg);
    }

    private class SimpleClientListener
    implements MessageListener<Client> {
        private SimpleClientListener() {
        }

        public void messageReceived(Client source, Message message) {
            if (message instanceof SimpleCommandMessage) {
                SimpleCommandMessage m = (SimpleCommandMessage)message;
                System.out.println("Client #" + source.getId() + " received: '" + m.getCommandCode() + "'");
            } else if (message instanceof SimpleWelcomeMessage) {
                SimpleWelcomeMessage m = (SimpleWelcomeMessage)message;
                System.out.println("Client #" + source.getId() + " received: '" + m.getMessageString() + "'");
            } else if (message instanceof AppControlWelcomeMessage) {
                AppControlWelcomeMessage m = (AppControlWelcomeMessage)message;
                SimpleAppCtrlClient.this.listeners.forEach(l -> l.receiveWelcomeMessage(m));
            } else if (message instanceof SimpleCommandWithIntegerArgumentsMessage) {
                SimpleCommandWithIntegerArgumentsMessage m = (SimpleCommandWithIntegerArgumentsMessage)message;
                System.out.println("Server received '" + m.getCommandCode() + "' from client #" + source.getId());
                switch (m.getCommandCode()) {
                    // Empty switch
                }
            } else if (message instanceof SimpleCommandWithFloatArgumentMessage) {
                SimpleCommandWithFloatArgumentMessage m = (SimpleCommandWithFloatArgumentMessage)message;
                System.out.println("Server received '" + m.getCommandCode() + "' from client #" + source.getId());
                switch (m.getCommandCode()) {
                    case RequestFrameRate: {
                        SimpleAppCtrlClient.this.listeners.forEach(l -> l.receiveFrameRate(m.getFloat()));
                    }
                }
            } else if (message instanceof SimpleCommandWithStringArgumentMessage) {
                SimpleCommandWithStringArgumentMessage m = (SimpleCommandWithStringArgumentMessage)message;
                System.out.println("Server received '" + m.getCommandCode() + "' from client #" + source.getId());
                switch (m.getCommandCode()) {
                    case ToggleBackground: {
                        System.out.println("Client #" + source.getId() + " received: '" + m.getArgumentString() + "'");
                    }
                }
            }
        }
    }
}

