/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyveswingapp;

import com.hybridlab.hyve3d.data.HyveData;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class HyveDataTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 2550866156235744866L;
    private String[] columnNames = new String[]{"DataKey", "HyveData"};
    private List<HyveData> data = new ArrayList<HyveData>();

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (col == 0) {
            return this.data.get(row).getKey();
        }
        if (col == 1) {
            return this.data.get(row);
        }
        return null;
    }

    public Class<Object> getColumnClass(int col) {
        if (col == 0) {
            return Object.class;
        }
        if (col == 1) {
            return Object.class;
        }
        return null;
    }

    public void clear() {
        int size = this.getRowCount();
        this.data.clear();
        this.fireTableRowsDeleted(0, size);
    }

    public void remove(HyveData d) {
        int index = this.data.indexOf(d);
        this.data.remove(d);
        this.fireTableRowsDeleted(index, index);
    }

    public void put(HyveData d) {
        this.data.add(d);
        int index = this.data.size() - 1;
        this.setValueAt(d, index, 1);
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (col == 1) {
            this.data.set(row, (HyveData)value);
            this.fireTableCellUpdated(row, col);
            this.fireTableCellUpdated(row, 0);
        }
    }
}

