/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyveswingapp;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;

public abstract class MovingPanel
extends JPanel {
    private static final long serialVersionUID = -5026348947562484385L;
    Point pPoint;
    MouseEvent pressed;
    private int sizeH = 150;
    private int sizeV = 75;
    private JTextPane txtPane;

    public MovingPanel() {
        this.setBackground(Color.cyan);
        this.setBorder(new LineBorder(Color.black));
        this.setSize(this.sizeH, this.sizeV);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Container parent;
                if (e.getButton() == 1) {
                    if (e.getSource() == MovingPanel.this) {
                        MovingPanel.this.pressed = e;
                    }
                } else if (e.getButton() != 2 && e.getButton() == 3 && (parent = MovingPanel.this.getParent()) instanceof JLayeredPane) {
                    JLayeredPane layerpane = (JLayeredPane)parent;
                    layerpane.moveToBack(MovingPanel.this);
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (e.getSource() == MovingPanel.this) {
                    MovingPanel.this.pPoint = MovingPanel.this.getLocation(MovingPanel.this.pPoint);
                    int x = MovingPanel.this.pPoint.x - MovingPanel.this.pressed.getX() + e.getX();
                    int y = MovingPanel.this.pPoint.y - MovingPanel.this.pressed.getY() + e.getY();
                    MovingPanel.this.requestNewLocation(x, y);
                }
            }
        });
        this.setBorder(new LineBorder(Color.black));
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{54, 0};
        gridBagLayout.rowHeights = new int[]{11, 0};
        gridBagLayout.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        this.txtPane = new JTextPane();
        this.txtPane.setEnabled(false);
        this.txtPane.setText("<empty>");
        this.txtPane.setFont(new Font("Lucida Grande", 0, 9));
        this.txtPane.setEditable(false);
        this.txtPane.setBackground(new Color(0, 0, 0, 0));
        GridBagConstraints gbc_txtPane = new GridBagConstraints();
        gbc_txtPane.anchor = 18;
        gbc_txtPane.gridx = 0;
        gbc_txtPane.gridy = 0;
        this.add((Component)this.txtPane, gbc_txtPane);
        this.setVisible(true);
    }

    protected abstract void requestNewLocation(int var1, int var2);

    public void setLabelText(final String txt) {
        System.out.println("MOVINGPANEL setLabelText (" + txt + ") from THREAD: " + Thread.currentThread().getName() + " " + Thread.currentThread().toString());
        Runnable r = new Runnable(){

            @Override
            public void run() {
                MovingPanel.this.txtPane.setText(txt);
            }
        };
        if (!"AWT-EventQueue-0".equals(Thread.currentThread().getName())) {
            SwingUtilities.invokeLater(r);
        } else {
            r.run();
        }
    }
}

