/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyveswingapp;

import com.hybridlab.hyve3d.data.domainobjects.DrawingArea;
import com.hybridlab.hyve3d.data.valueobjects.Transformation;
import com.hybridlab.hyveswingapp.MovingPanel;
import com.hybridlab.hyveswingapp.SwingRotationValueVisualizer;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SwingDrawingAreaVisualization
extends MovingPanel
implements PropertyChangeListener,
SwingRotationValueVisualizer.RotationChangeRequestor {
    private static final long serialVersionUID = -5670357697430506478L;
    private DrawingArea drawingarea;
    private float scaleFactor = 0.4f;
    private SwingRotationValueVisualizer rotationVis;
    private JSlider slider;
    ChangeListener sliderListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e) {
            JSlider source = (JSlider)e.getSource();
            int v = source.getValue();
            SwingDrawingAreaVisualization.this.requestNewLocation(v);
        }
    };

    public SwingDrawingAreaVisualization(DrawingArea da) {
        this.rotationVis = new SwingRotationValueVisualizer(this);
        GridBagConstraints gbc_rotationVis = new GridBagConstraints();
        gbc_rotationVis.fill = 2;
        gbc_rotationVis.gridwidth = 2;
        gbc_rotationVis.insets = new Insets(0, 0, 0, 5);
        gbc_rotationVis.gridx = 0;
        gbc_rotationVis.gridy = 1;
        this.rotationVis.addPropertyChangeListener("rotationquaternion", this);
        this.drawingarea = da;
        this.drawingarea.addPropertyChangeListener(this);
        this.setSize(200, 200);
        this.slider = new JSlider();
        this.slider.setOrientation(1);
        GridBagConstraints gbc_slider = new GridBagConstraints();
        gbc_slider.fill = 3;
        gbc_slider.gridx = 2;
        gbc_slider.gridy = 1;
        this.add((Component)this.slider, gbc_slider);
        this.slider.setMaximum(290);
        this.slider.setMinimum(-10);
        this.slider.setValue(0);
        this.slider.addChangeListener(this.sliderListener);
        this.update();
    }

    protected void requestNewLocation(int v) {
        Vector3f pos = this.drawingarea.getTransformation().getPosition().clone();
        float newPos = (float)v * this.scaleFactor;
        if (pos.y != newPos) {
            pos.y = newPos;
            Transformation t = new Transformation(pos, this.drawingarea.getTransformation().getRotation().clone());
            this.drawingarea.setTransformation(t);
        }
    }

    public void destroy() {
        this.drawingarea.removePropertyChangeListener(this);
    }

    public void update() {
        this.setLabelText("DrawingArea\n" + this.drawingarea.getId().toString());
        ColorRGBA jc = this.drawingarea.getRegularFrameColor();
        Color c = new Color(jc.r, jc.g, jc.b, jc.a);
        this.setBackground(c);
        Vector3f pos = this.drawingarea.getTransformation().getPosition();
        this.setLocation((int)(pos.x / this.scaleFactor), (int)(pos.z / this.scaleFactor));
        this.repaint();
    }

    @Override
    protected void requestNewLocation(int x, int y) {
        Vector3f pos = this.drawingarea.getTransformation().getPosition().clone();
        pos.x = (float)x * this.scaleFactor;
        pos.z = (float)y * this.scaleFactor;
        Transformation t = new Transformation(pos, this.drawingarea.getTransformation().getRotation().clone());
        this.drawingarea.setTransformation(t);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == this.drawingarea) {
            String prop = evt.getPropertyName();
            if (prop.endsWith("transformation")) {
                final Transformation t = (Transformation)evt.getNewValue();
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        SwingDrawingAreaVisualization.this.setLocation((int)(t.getPosition().x / SwingDrawingAreaVisualization.this.scaleFactor), (int)(t.getPosition().z / SwingDrawingAreaVisualization.this.scaleFactor));
                        SwingDrawingAreaVisualization.this.setSliderValueFromSpace((int)(t.getPosition().y / SwingDrawingAreaVisualization.this.scaleFactor));
                        SwingDrawingAreaVisualization.this.setRotation(t.getRotation());
                    }
                };
                if (!"AWT-EventQueue-0".equals(Thread.currentThread().getName())) {
                    SwingUtilities.invokeLater(r);
                } else {
                    r.run();
                }
            } else if (prop.endsWith("regularFrameColor")) {
                ColorRGBA jc = (ColorRGBA)evt.getNewValue();
                final Color c = new Color(jc.r, jc.g, jc.b, jc.a);
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        SwingDrawingAreaVisualization.this.setBackground(c);
                    }
                };
                if (!"AWT-EventQueue-0".equals(Thread.currentThread().getName())) {
                    SwingUtilities.invokeLater(r);
                } else {
                    r.run();
                }
            }
        }
    }

    private void setSliderValueFromSpace(int v) {
        this.slider.removeChangeListener(this.sliderListener);
        this.slider.setValue(v);
        this.slider.addChangeListener(this.sliderListener);
    }

    protected void setRotation(Quaternion rotation) {
        this.rotationVis.setRotation(rotation);
    }

    @Override
    public void requestNewValue(Quaternion newRot) {
        Transformation t = new Transformation(this.drawingarea.getTransformation().getPosition().clone(), newRot);
        this.drawingarea.setTransformation(t);
    }
}

