/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyveswingapp;

import com.hybridlab.hyve3d.data.DataModelKey;
import com.hybridlab.hyve3d.data.DataModelObserver;
import com.hybridlab.hyve3d.data.HyveData;
import com.hybridlab.hyve3d.data.Session;
import com.hybridlab.hyve3d.data.domainobjects.Asset;
import com.hybridlab.hyve3d.data.domainobjects.BackGround;
import com.hybridlab.hyve3d.data.domainobjects.DrawingArea;
import com.hybridlab.hyve3d.data.domainobjects.Node;
import com.hybridlab.hyve3d.data.domainobjects.Space;
import com.hybridlab.hyve3d.data.domainobjects.Stroke;
import com.hybridlab.hyve3d.hyve.Hyve;
import com.hybridlab.hyve3d.hyve.HyveApplication;
import com.hybridlab.hyve3d.hyve.SessionVisualizer;
import com.hybridlab.hyveswingapp.Canvas;
import com.hybridlab.hyveswingapp.HyveDataTableModel;
import com.hybridlab.hyveswingapp.SwingAssetVisualization;
import com.hybridlab.hyveswingapp.SwingBackGroundVisualization;
import com.hybridlab.hyveswingapp.SwingDrawingAreaVisualization;
import com.hybridlab.hyveswingapp.SwingSpaceVisualization;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public class SwingSessionVisualizer
implements DataModelObserver,
SessionVisualizer {
    private Canvas canvas;
    private JLabel sessionlabel;
    private Session session;
    private Map<DataModelKey, SwingAssetVisualization> assetVisualizations = new HashMap<DataModelKey, SwingAssetVisualization>();
    private Map<DataModelKey, SwingDrawingAreaVisualization> drawingAreaVisualizations = new HashMap<DataModelKey, SwingDrawingAreaVisualization>();
    private Map<DataModelKey, SwingSpaceVisualization> spaceVisualizations = new HashMap<DataModelKey, SwingSpaceVisualization>();
    private Map<DataModelKey, SwingBackGroundVisualization> bgVisualizations = new HashMap<DataModelKey, SwingBackGroundVisualization>();
    private Hyve localhyve;
    private HyveDataTableModel table;
    private HyveApplication app;
    private boolean useTable = true;

    public SwingSessionVisualizer(HyveApplication app, Canvas canvas, JLabel sessionlabel, HyveDataTableModel tm) {
        this.app = app;
        this.localhyve = app.getLocalHyve();
        this.canvas = canvas;
        this.sessionlabel = sessionlabel;
        if (this.useTable) {
            this.table = tm;
        }
    }

    private void clear() {
        Logger.getAnonymousLogger().info("clear");
        if (this.session != null) {
            this.session.removeObserver(this);
        }
        for (SwingBackGroundVisualization swingBackGroundVisualization : this.bgVisualizations.values()) {
            swingBackGroundVisualization.destroy();
        }
        this.bgVisualizations.clear();
        for (SwingDrawingAreaVisualization swingDrawingAreaVisualization : this.drawingAreaVisualizations.values()) {
            swingDrawingAreaVisualization.destroy();
        }
        this.drawingAreaVisualizations.clear();
        for (SwingSpaceVisualization swingSpaceVisualization : this.spaceVisualizations.values()) {
            swingSpaceVisualization.destroy();
        }
        this.spaceVisualizations.clear();
        for (SwingAssetVisualization swingAssetVisualization : this.assetVisualizations.values()) {
            swingAssetVisualization.destroy();
        }
        this.spaceVisualizations.clear();
        this.canvas.clear();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SwingSessionVisualizer.this.sessionlabel.setText("");
                SwingSessionVisualizer.this.canvas.removeAll();
                if (SwingSessionVisualizer.this.useTable) {
                    SwingSessionVisualizer.this.table.clear();
                }
                SwingSessionVisualizer.this.canvas.repaint();
            }
        });
    }

    @Override
    public void visualize(Session session) {
        Logger.getAnonymousLogger().info("Session " + session.getName() + " " + session.getId());
        this.clear();
        Logger.getAnonymousLogger().info("visualize");
        this.session = session;
        this.session.addObserver(this);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SwingSessionVisualizer.this.sessionlabel.setText(SwingSessionVisualizer.this.session.getId().toString());
            }
        });
        for (HyveData d : this.session.getEntities()) {
            this.onDataAdded(d.getKey(), d);
        }
    }

    @Override
    public void onDataAdded(DataModelKey key, HyveData data) {
        if (data instanceof DrawingArea) {
            this.visualize(key, (DrawingArea)data);
        } else if (data instanceof Space) {
            this.visualize(key, (Space)data);
        } else if (data instanceof Asset) {
            this.visualize(key, (Node)data);
        }
        if (data instanceof Stroke) {
            this.canvas.add((Stroke)data);
        }
        if (data instanceof BackGround) {
            this.visualize(key, (BackGround)data);
        }
        if (this.useTable) {
            this.table.put(data);
        }
    }

    private void visualize(DataModelKey key, BackGround data) {
        final SwingBackGroundVisualization spaceVis = new SwingBackGroundVisualization(data);
        this.bgVisualizations.put(key, spaceVis);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SwingSessionVisualizer.this.canvas.add(spaceVis);
                spaceVis.update();
                SwingSessionVisualizer.this.canvas.repaint();
            }
        });
    }

    private void visualize(DataModelKey key, Node asset) {
        final SwingAssetVisualization assetVis = new SwingAssetVisualization(asset);
        this.assetVisualizations.put(key, assetVis);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SwingSessionVisualizer.this.canvas.add(assetVis);
                assetVis.update();
                SwingSessionVisualizer.this.canvas.repaint();
            }
        });
    }

    private void visualize(DataModelKey key, Space space) {
        final SwingSpaceVisualization spaceVis = new SwingSpaceVisualization(space);
        this.spaceVisualizations.put(key, spaceVis);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SwingSessionVisualizer.this.canvas.add(spaceVis);
                spaceVis.update();
                SwingSessionVisualizer.this.canvas.repaint();
            }
        });
    }

    private void visualize(DataModelKey key, DrawingArea da) {
        final SwingDrawingAreaVisualization davis = new SwingDrawingAreaVisualization(da);
        this.drawingAreaVisualizations.put(key, davis);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SwingSessionVisualizer.this.canvas.add(davis);
                davis.update();
                SwingSessionVisualizer.this.canvas.repaint();
            }
        });
    }

    @Override
    public void onDataRemoved(DataModelKey key, HyveData data) {
        SwingBackGroundVisualization bgvis;
        SwingSpaceVisualization spacevis;
        SwingAssetVisualization assetVis;
        SwingDrawingAreaVisualization davis = this.drawingAreaVisualizations.get(key);
        if (davis != null) {
            this.canvas.remove(davis);
            davis.destroy();
            this.drawingAreaVisualizations.remove(key);
            this.canvas.repaint();
        }
        if ((assetVis = this.assetVisualizations.get(key)) != null) {
            this.canvas.remove(assetVis);
            assetVis.destroy();
            this.assetVisualizations.remove(key);
            this.canvas.repaint();
        }
        if ((spacevis = this.spaceVisualizations.get(key)) != null) {
            this.canvas.remove(spacevis);
            spacevis.destroy();
            this.spaceVisualizations.remove(key);
            this.canvas.repaint();
        }
        if ((bgvis = this.bgVisualizations.get(key)) != null) {
            this.canvas.remove(bgvis);
            bgvis.destroy();
            this.spaceVisualizations.remove(key);
            this.canvas.repaint();
        }
        if (data instanceof Stroke) {
            this.canvas.remove((Stroke)data);
        }
        if (this.useTable) {
            this.table.remove(data);
        }
    }

    @Override
    public UUID getIdOfCurrentShownSession() {
        if (this.session == null) {
            return null;
        }
        return this.session.getId();
    }
}

