/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyveswingapp;

import com.hybridlab.utils.Interpolation;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SwingSingleAxisRotationValueVisualizer
extends JPanel {
    private static final long serialVersionUID = 7371630043417435448L;
    private JTextField textField;
    private JLabel lblXaxis;
    private JSlider slider;
    ChangeListener sliderListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e) {
            JSlider source = (JSlider)e.getSource();
            float v = source.getValue();
            float sourceIntervalBorderA = source.getMinimum();
            float sourceIntervalBorderB = source.getMaximum();
            float targetIntervalBorderA = 0.0f;
            float targetIntervalBorderB = (float)Math.PI * 2;
            float angleRad = Interpolation.inttrf(v, sourceIntervalBorderA, sourceIntervalBorderB, targetIntervalBorderA, targetIntervalBorderB);
            SwingSingleAxisRotationValueVisualizer.this.requestNewValue(angleRad);
        }
    };
    private float angle = 0.0f;

    public SwingSingleAxisRotationValueVisualizer() {
        this("X-Axis", 0, 360);
    }

    public SwingSingleAxisRotationValueVisualizer(String desc, int min, int max) {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0, 0, 0};
        gridBagLayout.columnWeights = new double[]{1.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        this.lblXaxis = new JLabel(desc);
        GridBagConstraints gbc_lblXaxis = new GridBagConstraints();
        gbc_lblXaxis.insets = new Insets(0, 0, 5, 0);
        gbc_lblXaxis.gridx = 0;
        gbc_lblXaxis.gridy = 0;
        this.add((Component)this.lblXaxis, gbc_lblXaxis);
        this.textField = new JTextField();
        this.textField.setEditable(false);
        this.textField.setHorizontalAlignment(0);
        this.textField.setText("23,45\u00b0");
        GridBagConstraints gbc_textField = new GridBagConstraints();
        gbc_textField.insets = new Insets(0, 0, 5, 0);
        gbc_textField.fill = 2;
        gbc_textField.gridx = 0;
        gbc_textField.gridy = 1;
        this.add((Component)this.textField, gbc_textField);
        this.textField.setColumns(10);
        this.slider = new JSlider();
        this.slider.setEnabled(false);
        this.slider.addChangeListener(this.sliderListener);
        this.slider.setValue(0);
        this.slider.setMinimum(min);
        this.slider.setMaximum(max);
        GridBagConstraints gbc_slider = new GridBagConstraints();
        gbc_slider.fill = 2;
        gbc_slider.gridx = 0;
        gbc_slider.gridy = 2;
        this.add((Component)this.slider, gbc_slider);
        this.update();
    }

    public void addRotationListener(PropertyChangeListener listener) {
        this.addPropertyChangeListener("rotationangle", listener);
    }

    public void setAngle(float v) {
        float oldValue = this.angle;
        if (v != this.angle) {
            this.angle = v;
            this.firePropertyChange("rotationangle", oldValue, this.angle);
            this.update();
        }
    }

    private void update() {
        this.textField.setText(String.format(Locale.ENGLISH, "%.1f\u00b0", Float.valueOf(57.295776f * this.angle)));
        int v = (int)(57.295776f * this.angle);
        this.slider.setValue(v);
    }

    public float getAngle() {
        return this.angle;
    }

    protected void requestNewValue(float v) {
        this.setAngle(v);
    }
}

