/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyveswingapp;

import com.hybridlab.hyve3d.data.domainobjects.Space;
import com.hybridlab.hyve3d.data.valueobjects.Transformation;
import com.hybridlab.hyveswingapp.MovingPanel;
import com.jme3.math.Vector3f;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SwingSpaceVisualization
extends MovingPanel
implements PropertyChangeListener {
    private static final long serialVersionUID = -5670357697430506478L;
    private Space space;
    private float scaleFactor = 0.1f;
    private JSlider slider;
    ChangeListener sliderListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e) {
            JSlider source = (JSlider)e.getSource();
            int v = source.getValue();
            SwingSpaceVisualization.this.requestNewLocation(v);
        }
    };

    public SwingSpaceVisualization(Space s) {
        GridBagLayout gridBagLayout = (GridBagLayout)this.getLayout();
        gridBagLayout.rowWeights = new double[]{1.0};
        gridBagLayout.columnWeights = new double[]{1.0, 0.0};
        this.space = s;
        this.space.addPropertyChangeListener(this);
        this.setBackground(Color.magenta);
        int sizeH = 200;
        int sizeV = 200;
        this.setSize(272, 249);
        this.slider = new JSlider();
        this.slider.setOrientation(1);
        GridBagConstraints gbc_slider = new GridBagConstraints();
        gbc_slider.fill = 3;
        gbc_slider.gridx = 1;
        gbc_slider.gridy = 0;
        this.add((Component)this.slider, gbc_slider);
        this.slider.setMaximum(290);
        this.slider.setMinimum(-10);
        this.slider.setValue(0);
        this.slider.addChangeListener(this.sliderListener);
        this.update();
    }

    protected void requestNewLocation(int v) {
        Vector3f pos = this.space.getTransformation().getPosition().clone();
        float newPos = (float)v * this.scaleFactor;
        if (pos.y != newPos) {
            pos.y = newPos;
            Transformation t = new Transformation(pos, this.space.getTransformation().getRotation().clone());
            this.space.setTransformation(t);
        }
    }

    public void destroy() {
        this.space.removePropertyChangeListener(this);
    }

    public void update() {
        this.setLabelText("Space\n" + this.space.getId().toString() + "\n" + this.space.getName());
        Vector3f pos = this.space.getTransformation().getPosition();
        this.setLocation((int)(pos.x / this.scaleFactor), (int)(pos.z / this.scaleFactor));
        this.setSliderValueFromSpace((int)(pos.y / this.scaleFactor));
        this.repaint();
    }

    private void setSliderValueFromSpace(int v) {
        this.slider.removeChangeListener(this.sliderListener);
        this.slider.setValue(v);
        this.slider.addChangeListener(this.sliderListener);
    }

    @Override
    protected void requestNewLocation(int x, int y) {
        Vector3f pos = this.space.getTransformation().getPosition().clone();
        pos.x = (float)x * this.scaleFactor;
        pos.z = (float)y * this.scaleFactor;
        Transformation t = new Transformation(pos, this.space.getTransformation().getRotation().clone());
        this.space.setTransformation(t);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String prop;
        if (evt.getSource() == this.space && (prop = evt.getPropertyName()).endsWith("transformation")) {
            final Transformation t = (Transformation)evt.getNewValue();
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    SwingSpaceVisualization.this.setLocation((int)(t.getPosition().x / SwingSpaceVisualization.this.scaleFactor), (int)(t.getPosition().z / SwingSpaceVisualization.this.scaleFactor));
                    SwingSpaceVisualization.this.setSliderValueFromSpace((int)(t.getPosition().y / SwingSpaceVisualization.this.scaleFactor));
                }
            };
            if (!"AWT-EventQueue-0".equals(Thread.currentThread().getName())) {
                SwingUtilities.invokeLater(r);
            } else {
                r.run();
            }
        }
    }
}

