/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyveswingapp;

import com.jme3.math.Vector2f;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JPanel;

public class TrackPanel
extends JPanel {
    private static final long serialVersionUID = -2289594043735056424L;
    protected MouseEvent pressed;
    protected MouseEvent released;
    private TrackValueReceiver receiver;
    private Integer oldx;
    private Integer oldy;
    private float scale = 0.01f;

    public TrackPanel() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getSource() == TrackPanel.this) {
                    TrackPanel.this.pressed = e;
                    TrackPanel.this.startTracking();
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getSource() == TrackPanel.this) {
                    TrackPanel.this.released = e;
                    TrackPanel.this.stopTracking();
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (e.getSource() == TrackPanel.this) {
                    int x = e.getX();
                    int y = e.getY();
                    if (TrackPanel.this.oldx == null) {
                        TrackPanel.this.oldx = x;
                        TrackPanel.this.oldy = y;
                    } else {
                        TrackPanel.this.feedToTrack(x - TrackPanel.this.oldx, y - TrackPanel.this.oldy);
                        TrackPanel.this.oldx = x;
                        TrackPanel.this.oldy = y;
                    }
                }
            }
        });
    }

    private float fromUI(int value) {
        return value;
    }

    protected void startTracking() {
        this.oldx = null;
        this.oldy = null;
    }

    protected void feedToTrack(int x, int y) {
        if (this.receiver == null) {
            return;
        }
        float mx = this.fromUI(x);
        float mz = this.fromUI(y);
        Vector2f move = new Vector2f(mx, mz);
        move.multLocal(this.getscale());
        this.receiver.feedToTrack(move);
    }

    private float getscale() {
        return this.scale;
    }

    protected void stopTracking() {
        this.oldx = null;
        this.oldy = null;
    }

    public void setReceiver(TrackValueReceiver receiver) {
        this.receiver = receiver;
    }

    public static interface TrackValueReceiver {
        public void feedToTrack(Vector2f var1);
    }
}

