/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyveswingapp;

import com.hybridlab.hyve3d.hyve.Hyve;
import com.hybridlab.hyve3d.hyve.HyveApplication;
import com.hybridlab.hyve3d.hyve.HyveNetworking;
import com.hybridlab.hyve3d.hyve.SessionInfo;
import com.hybridlab.hyve3d.network.interconnection.HubConnection;
import com.hybridlab.hyve3d.network.interconnection.HubNodeHost;
import com.hybridlab.hyve3d.network.interconnection.SessionDescriptor;
import com.hybridlab.hyve3d.network.interconnection.SessionRepository;
import com.hybridlab.hyve3d.network.interconnection.implementations.adressing.HubNodeAddress;
import com.hybridlab.hyveswingapp.Canvas;
import com.hybridlab.hyveswingapp.HyveDataTableModel;
import com.hybridlab.utils.logging.MessageBox;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.UUID;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTextPane;

public class XUIWindow
extends JFrame {
    private Canvas canvas;
    private static final long serialVersionUID = 378242457210838306L;
    private JTable table;
    private final Hyve hyve;
    private JLabel lblSession;
    private HyveDataTableModel tableModel = new HyveDataTableModel();
    private JTextField txthost;
    private JTextField txtPort;
    protected HyveNetworking networking;
    private JButton btnSynchsession;
    private HyveApplication app;
    private JButton btnCreatehost;
    private JTextField txtMyPort;
    private JTextPane textPane;
    private JList sessionList;
    private JPanel localSessionPanel;
    private JLabel lblLocalSession;
    private JPanel remoteSessionsPanel;
    private JLabel lblJoinableSessions;
    private JButton btnJoinSelected;
    private JComboBox comboBoxSessions;
    private SessionRepoComboBoxAdapter sessionRepoAdapter;
    private JButton btnLetHyveJoin;
    private JCheckBox chckbxUseUdp;
    private JCheckBox chckbxAutoJoin;

    public XUIWindow(HyveApplication app) {
        this.app = app;
        this.hyve = app.getLocalHyve();
        this.networking = app.getNetworking();
        JSplitPane splitPaneMain = new JSplitPane();
        splitPaneMain.setResizeWeight(0.3);
        this.getContentPane().add((Component)splitPaneMain, "Center");
        JSplitPane splitPaneLeftSide = new JSplitPane();
        splitPaneLeftSide.setResizeWeight(0.5);
        splitPaneLeftSide.setOrientation(0);
        splitPaneMain.setLeftComponent(splitPaneLeftSide);
        JPanel panelActions = new JPanel();
        splitPaneLeftSide.setTopComponent(panelActions);
        this.table = new JTable(this.tableModel);
        splitPaneLeftSide.setBottomComponent(this.table);
        this.canvas = new Canvas();
        this.canvas.connectStrokeCreationAdapter(app.getTestStrokeCreationAdapter());
        splitPaneMain.setRightComponent(this.canvas);
        this.canvas.setLayout(null);
        GridBagLayout gbl_panelActions = new GridBagLayout();
        gbl_panelActions.columnWidths = new int[]{155, 0};
        gbl_panelActions.rowHeights = new int[]{29, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        gbl_panelActions.columnWeights = new double[]{1.0, Double.MIN_VALUE};
        gbl_panelActions.rowWeights = new double[]{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0, 0.0, 0.0, Double.MIN_VALUE};
        panelActions.setLayout(gbl_panelActions);
        this.localSessionPanel = new JPanel();
        GridBagConstraints gbc_localSessionPanel = new GridBagConstraints();
        gbc_localSessionPanel.insets = new Insets(0, 0, 5, 0);
        gbc_localSessionPanel.fill = 1;
        gbc_localSessionPanel.gridx = 0;
        gbc_localSessionPanel.gridy = 0;
        panelActions.add((Component)this.localSessionPanel, gbc_localSessionPanel);
        GridBagLayout gbl_localSessionPanel = new GridBagLayout();
        gbl_localSessionPanel.columnWidths = new int[]{0, 0, 0};
        gbl_localSessionPanel.rowHeights = new int[]{0, 0, 0, 0};
        gbl_localSessionPanel.columnWeights = new double[]{0.0, 1.0, Double.MIN_VALUE};
        gbl_localSessionPanel.rowWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};
        this.localSessionPanel.setLayout(gbl_localSessionPanel);
        this.lblLocalSession = new JLabel("local Session:");
        GridBagConstraints gbc_lblLocalSession = new GridBagConstraints();
        gbc_lblLocalSession.insets = new Insets(0, 0, 5, 5);
        gbc_lblLocalSession.gridx = 0;
        gbc_lblLocalSession.gridy = 0;
        this.localSessionPanel.add((Component)this.lblLocalSession, gbc_lblLocalSession);
        this.lblSession = new JLabel("<session-id>");
        this.lblSession.setHorizontalAlignment(0);
        GridBagConstraints gbc_lblSession = new GridBagConstraints();
        gbc_lblSession.insets = new Insets(0, 0, 5, 0);
        gbc_lblSession.fill = 2;
        gbc_lblSession.gridx = 1;
        gbc_lblSession.gridy = 0;
        this.localSessionPanel.add((Component)this.lblSession, gbc_lblSession);
        this.btnSynchsession = new JButton("share Session");
        GridBagConstraints gbc_btnSynchsession = new GridBagConstraints();
        gbc_btnSynchsession.insets = new Insets(0, 0, 5, 0);
        gbc_btnSynchsession.gridx = 1;
        gbc_btnSynchsession.gridy = 1;
        this.localSessionPanel.add((Component)this.btnSynchsession, gbc_btnSynchsession);
        this.btnLetHyveJoin = new JButton("let hyve join visualized session");
        this.btnLetHyveJoin.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                XUIWindow.this.app.letHyveJoinSession();
            }
        });
        GridBagConstraints gbc_btnLetHyveJoin = new GridBagConstraints();
        gbc_btnLetHyveJoin.gridx = 1;
        gbc_btnLetHyveJoin.gridy = 2;
        this.localSessionPanel.add((Component)this.btnLetHyveJoin, gbc_btnLetHyveJoin);
        this.btnSynchsession.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                UUID sid = UUID.fromString(XUIWindow.this.lblSession.getText().trim());
                XUIWindow.this.app.getNetworking().shareSession(sid, true);
            }
        });
        this.txtMyPort = new JTextField();
        this.txtMyPort.setText("44440");
        GridBagConstraints gbc_txtMyPort = new GridBagConstraints();
        gbc_txtMyPort.insets = new Insets(0, 0, 5, 0);
        gbc_txtMyPort.fill = 2;
        gbc_txtMyPort.gridx = 0;
        gbc_txtMyPort.gridy = 1;
        panelActions.add((Component)this.txtMyPort, gbc_txtMyPort);
        this.txtMyPort.setColumns(10);
        this.btnCreatehost = new JButton("createHost");
        this.btnCreatehost.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int port = Integer.parseInt(XUIWindow.this.txtMyPort.getText());
                try {
                    XUIWindow.this.networking.createHost(port, new HyveNetworking.HostingEstablishListener(){

                        @Override
                        public void onHostCreationFailed(Exception e) {
                        }

                        @Override
                        public void onHostCreated(HubNodeHost hnh) {
                        }

                        @Override
                        public void onHostShutdown() {
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        GridBagConstraints gbc_btnCreatehost = new GridBagConstraints();
        gbc_btnCreatehost.insets = new Insets(0, 0, 5, 0);
        gbc_btnCreatehost.gridx = 0;
        gbc_btnCreatehost.gridy = 2;
        panelActions.add((Component)this.btnCreatehost, gbc_btnCreatehost);
        this.txthost = new JTextField();
        this.txthost.setText("localhost");
        GridBagConstraints gbc_txthost = new GridBagConstraints();
        gbc_txthost.insets = new Insets(0, 0, 5, 0);
        gbc_txthost.fill = 2;
        gbc_txthost.gridx = 0;
        gbc_txthost.gridy = 3;
        panelActions.add((Component)this.txthost, gbc_txthost);
        this.txthost.setColumns(10);
        JButton btnConnect = new JButton("connect");
        btnConnect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    String host = XUIWindow.this.txthost.getText().trim();
                    int port = Integer.parseInt(XUIWindow.this.txtPort.getText().trim());
                    XUIWindow.this.networking.asynchConnectToHubNode(host, port, new HyveNetworking.ConnectionEstablishListener(){

                        @Override
                        public void onConnectionFailed(String message, String string) {
                            MessageBox.show(message + "\n" + string);
                        }

                        @Override
                        public void onConnectionEstablished(HubNodeAddress targetHubNodeAdress) {
                            System.out.println("onConnectionEstablished:" + targetHubNodeAdress.describe());
                        }

                        @Override
                        public void onConnectionLost(HubConnection removed) {
                            System.out.println("onConnectionLost:" + removed);
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.txtPort = new JTextField();
        this.txtPort.setText("44441");
        GridBagConstraints gbc_txtPort = new GridBagConstraints();
        gbc_txtPort.insets = new Insets(0, 0, 5, 0);
        gbc_txtPort.fill = 2;
        gbc_txtPort.gridx = 0;
        gbc_txtPort.gridy = 4;
        panelActions.add((Component)this.txtPort, gbc_txtPort);
        this.txtPort.setColumns(10);
        GridBagConstraints gbc_btnConnect = new GridBagConstraints();
        gbc_btnConnect.insets = new Insets(0, 0, 5, 0);
        gbc_btnConnect.gridx = 0;
        gbc_btnConnect.gridy = 5;
        panelActions.add((Component)btnConnect, gbc_btnConnect);
        this.remoteSessionsPanel = new JPanel();
        GridBagConstraints gbc_remoteSessionsPanel = new GridBagConstraints();
        gbc_remoteSessionsPanel.insets = new Insets(0, 0, 5, 0);
        gbc_remoteSessionsPanel.fill = 1;
        gbc_remoteSessionsPanel.gridx = 0;
        gbc_remoteSessionsPanel.gridy = 6;
        panelActions.add((Component)this.remoteSessionsPanel, gbc_remoteSessionsPanel);
        GridBagLayout gbl_remoteSessionsPanel = new GridBagLayout();
        gbl_remoteSessionsPanel.columnWidths = new int[]{0, 0, 0};
        gbl_remoteSessionsPanel.rowHeights = new int[]{0, 0, 0, 0};
        gbl_remoteSessionsPanel.columnWeights = new double[]{1.0, 0.0, Double.MIN_VALUE};
        gbl_remoteSessionsPanel.rowWeights = new double[]{0.0, 1.0, 0.0, Double.MIN_VALUE};
        this.remoteSessionsPanel.setLayout(gbl_remoteSessionsPanel);
        this.lblJoinableSessions = new JLabel("available Sessions in Network");
        GridBagConstraints gbc_lblJoinableSessions = new GridBagConstraints();
        gbc_lblJoinableSessions.insets = new Insets(0, 0, 5, 5);
        gbc_lblJoinableSessions.gridx = 0;
        gbc_lblJoinableSessions.gridy = 0;
        this.remoteSessionsPanel.add((Component)this.lblJoinableSessions, gbc_lblJoinableSessions);
        this.sessionList = new JList();
        GridBagConstraints gbc_sessionList = new GridBagConstraints();
        gbc_sessionList.gridwidth = 2;
        gbc_sessionList.fill = 1;
        gbc_sessionList.insets = new Insets(0, 0, 5, 0);
        gbc_sessionList.gridx = 0;
        gbc_sessionList.gridy = 1;
        this.remoteSessionsPanel.add((Component)this.sessionList, gbc_sessionList);
        this.sessionList.setVisibleRowCount(4);
        this.sessionList.setSelectionMode(0);
        this.btnJoinSelected = new JButton("join selected");
        this.btnJoinSelected.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SessionInfo i = (SessionInfo)XUIWindow.this.sessionList.getSelectedValue();
                if (i != null) {
                    try {
                        XUIWindow.this.app.getNetworking().synchWithRemoteSession(i.id);
                    }
                    catch (Exception e) {
                        MessageBox.show(e.getLocalizedMessage());
                    }
                }
                XUIWindow.this.sessionList.clearSelection();
            }
        });
        GridBagConstraints gbc_btnJoinSelected = new GridBagConstraints();
        gbc_btnJoinSelected.insets = new Insets(0, 0, 0, 5);
        gbc_btnJoinSelected.gridx = 0;
        gbc_btnJoinSelected.gridy = 2;
        this.remoteSessionsPanel.add((Component)this.btnJoinSelected, gbc_btnJoinSelected);
        this.chckbxUseUdp = new JCheckBox("use UDP");
        this.chckbxUseUdp.setSelected(true);
        this.chckbxUseUdp.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getSource() == XUIWindow.this.chckbxUseUdp) {
                    boolean useUDP = XUIWindow.this.chckbxUseUdp.isSelected();
                    XUIWindow.this.app.getNetworking().getHubNode().setUseUDP(useUDP);
                }
            }
        });
        GridBagConstraints gbc_chckbxUseUdp = new GridBagConstraints();
        gbc_chckbxUseUdp.insets = new Insets(0, 0, 5, 0);
        gbc_chckbxUseUdp.gridx = 0;
        gbc_chckbxUseUdp.gridy = 7;
        panelActions.add((Component)this.chckbxUseUdp, gbc_chckbxUseUdp);
        JPanel panel = new JPanel();
        GridBagConstraints gbc_panel = new GridBagConstraints();
        gbc_panel.insets = new Insets(0, 0, 5, 0);
        gbc_panel.fill = 3;
        gbc_panel.gridx = 0;
        gbc_panel.gridy = 8;
        panelActions.add((Component)panel, gbc_panel);
        GridBagLayout gbl_panel = new GridBagLayout();
        gbl_panel.columnWidths = new int[]{67, 52, 0};
        gbl_panel.rowHeights = new int[]{27, 0, 0};
        gbl_panel.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        gbl_panel.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        panel.setLayout(gbl_panel);
        JLabel lblVisualized = new JLabel("visualized:");
        GridBagConstraints gbc_lblVisualized = new GridBagConstraints();
        gbc_lblVisualized.anchor = 17;
        gbc_lblVisualized.insets = new Insets(0, 0, 5, 5);
        gbc_lblVisualized.gridx = 0;
        gbc_lblVisualized.gridy = 0;
        panel.add((Component)lblVisualized, gbc_lblVisualized);
        this.comboBoxSessions = new JComboBox();
        GridBagConstraints gbc_comboBoxSessions = new GridBagConstraints();
        gbc_comboBoxSessions.fill = 2;
        gbc_comboBoxSessions.anchor = 11;
        gbc_comboBoxSessions.insets = new Insets(0, 0, 5, 0);
        gbc_comboBoxSessions.gridx = 1;
        gbc_comboBoxSessions.gridy = 0;
        panel.add((Component)this.comboBoxSessions, gbc_comboBoxSessions);
        this.sessionRepoAdapter = new SessionRepoComboBoxAdapter(this.comboBoxSessions, this.app.getSessionRepository());
        this.chckbxAutoJoin = new JCheckBox("local hyve auto joins visualized");
        this.chckbxAutoJoin.setSelected(true);
        GridBagConstraints gbc_chckbxAutoJoin = new GridBagConstraints();
        gbc_chckbxAutoJoin.anchor = 17;
        gbc_chckbxAutoJoin.gridx = 1;
        gbc_chckbxAutoJoin.gridy = 1;
        panel.add((Component)this.chckbxAutoJoin, gbc_chckbxAutoJoin);
        this.textPane = new JTextPane();
        this.textPane.setFont(new Font("Lucida Grande", 0, 9));
        GridBagConstraints gbc_textPane = new GridBagConstraints();
        gbc_textPane.insets = new Insets(0, 0, 5, 0);
        gbc_textPane.fill = 1;
        gbc_textPane.gridx = 0;
        gbc_textPane.gridy = 9;
        panelActions.add((Component)this.textPane, gbc_textPane);
        JButton btnNewButton = new JButton("New DrawingArea");
        btnNewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                XUIWindow.this.hyve.createNewDrawingAreaAndAddToSession();
            }
        });
        GridBagConstraints gbc_btnNewButton = new GridBagConstraints();
        gbc_btnNewButton.anchor = 18;
        gbc_btnNewButton.gridx = 0;
        gbc_btnNewButton.gridy = 11;
        panelActions.add((Component)btnNewButton, gbc_btnNewButton);
    }

    public Canvas getCanvas() {
        return this.canvas;
    }

    public JLabel getSessionLabel() {
        return this.lblSession;
    }

    public HyveDataTableModel getTableModel() {
        return this.tableModel;
    }

    public JList getSessionList() {
        return this.sessionList;
    }

    public JTextPane getInterConnectivityTextField() {
        return this.textPane;
    }

    public void setPorts(int hostport, int connectport) {
        this.txtMyPort.setText(String.valueOf(hostport));
        this.txtPort.setText(String.valueOf(connectport));
    }

    public JComboBox getSessionComboBox() {
        return this.comboBoxSessions;
    }

    private class SessionRepoComboBoxAdapter
    implements SessionRepository.SessionRepositoryObserver,
    ItemListener {
        private JComboBox sessionComboBox;
        private SessionRepository sessionRepository;

        public SessionRepoComboBoxAdapter(JComboBox sessionComboBox, SessionRepository sessionRepository) {
            this.sessionComboBox = sessionComboBox;
            this.sessionRepository = sessionRepository;
            sessionRepository.addObserver(this);
            this.update();
            this.sessionComboBox.addItemListener(this);
        }

        private void update() {
            List<SessionDescriptor> sessions = this.sessionRepository.getKnownAvailableSessions();
            DefaultComboBoxModel<String> mdl = new DefaultComboBoxModel<String>();
            for (SessionDescriptor sd : sessions) {
                mdl.addElement(new String(sd.sessionId.toString()));
            }
            this.sessionComboBox.setModel(mdl);
        }

        @Override
        public void onAvailableSessionsChanged(SessionRepository repo) {
            if (this.sessionRepository == repo) {
                this.update();
            }
        }

        @Override
        public void itemStateChanged(ItemEvent ie) {
            if (ie.getSource() == this.sessionComboBox && ie.getStateChange() == 1) {
                String selected = (String)ie.getItem();
                XUIWindow.this.app.showSession(UUID.fromString(selected));
                if (XUIWindow.this.chckbxAutoJoin.isSelected()) {
                    XUIWindow.this.app.letHyveJoinSession();
                }
            }
        }
    }
}

