/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.licensing;

import com.hybridlab.licensing.EncryptDecrypt;
import com.hybridlab.licensing.Feature;
import com.hybridlab.utils.ByteUtils;
import com.hybridlab.utils.MD5Hash;
import java.util.Date;
import java.util.Set;
import java.util.UUID;

public final class Algorithms {

    public static final class LICENSEKEY_ALGORITHM_20150210 {
        public static String createWithHardwareIdentifierAndValidUntilDate(String hardwareIdentifierAnyStyle, Date validUntil) throws Exception {
            String encryptedTail;
            if (hardwareIdentifierAnyStyle == null) {
                throw new RuntimeException("illegal hardware identifier");
            }
            if (hardwareIdentifierAnyStyle.isEmpty()) {
                throw new RuntimeException("illegal hardware identifier");
            }
            String cleaned = hardwareIdentifierAnyStyle.replaceAll("[^A-Za-z0-9\\s]", "");
            if (cleaned.isEmpty()) {
                throw new RuntimeException("illegal hardware identifier");
            }
            String uppercaseMac = cleaned.toUpperCase();
            long milliseconds = validUntil.getTime();
            String hextime = ByteUtils.fromLong(milliseconds);
            String randomtail = MD5Hash.md5Java(UUID.randomUUID().toString()).toUpperCase();
            String tail = hextime + randomtail.substring(16, 32);
            byte[] tailbytes = ByteUtils.hexToBytes(tail);
            try {
                byte[] encryptedtailbytes = EncryptDecrypt.encode(tailbytes);
                encryptedTail = ByteUtils.bytesToHex(encryptedtailbytes);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
            String body = MD5Hash.md5Java("1").substring(0, 4).toUpperCase();
            String head = MD5Hash.md5Java(uppercaseMac + encryptedTail).toUpperCase();
            return head + body + encryptedTail;
        }

        public static String createWithHardwareIdentifier(String hardwareIdentifierAnyStyle) {
            if (hardwareIdentifierAnyStyle == null) {
                throw new RuntimeException("illegal hardware identifier");
            }
            if (hardwareIdentifierAnyStyle.isEmpty()) {
                throw new RuntimeException("illegal hardware identifier");
            }
            String cleaned = hardwareIdentifierAnyStyle.replaceAll("[^A-Za-z0-9\\s]", "");
            if (cleaned.isEmpty()) {
                throw new RuntimeException("illegal hardware identifier");
            }
            String uppercaseMac = cleaned.toUpperCase();
            String randomtail = MD5Hash.md5Java(UUID.randomUUID().toString()).toUpperCase();
            String body = MD5Hash.md5Java("0").substring(0, 4).toUpperCase();
            String head = MD5Hash.md5Java(uppercaseMac + randomtail).toUpperCase();
            return head + body + randomtail;
        }

        public static boolean isValidForHardwareIdentifierAndTimeStamp(String key, String hardwareIdentifierAnyStyle, long timeMillis) throws Exception {
            if (LICENSEKEY_ALGORITHM_20150210.isKeyType(key, 0)) {
                String cleaned = hardwareIdentifierAnyStyle.replaceAll("[^A-Za-z0-9\\s]", "");
                String uppercaseMac = cleaned.toUpperCase();
                String tail = key.substring(36, 68);
                String head = MD5Hash.md5Java(uppercaseMac + tail).toUpperCase();
                boolean valid = head.equals(key.substring(0, 32));
                return valid;
            }
            if (LICENSEKEY_ALGORITHM_20150210.isKeyType(key, 1)) {
                String decryptedTail2;
                String encryptedtail;
                String cleaned = hardwareIdentifierAnyStyle.replaceAll("[^A-Za-z0-9\\s]", "");
                String uppercaseMac = cleaned.toUpperCase();
                String expectedhead = MD5Hash.md5Java(uppercaseMac + (encryptedtail = key.substring(36, key.length()))).toUpperCase();
                boolean validMac = expectedhead.equals(key.substring(0, 32));
                if (!validMac) {
                    return false;
                }
                byte[] encryptedTailBytes = ByteUtils.hexToBytes(encryptedtail);
                try {
                    byte[] decryptedTail = EncryptDecrypt.decode(encryptedTailBytes);
                    decryptedTail2 = ByteUtils.bytesToHex(decryptedTail);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    throw e1;
                }
                String timehex = decryptedTail2.substring(0, 16);
                try {
                    long milliseconds = ByteUtils.toLong(timehex);
                    boolean valid = timeMillis <= milliseconds;
                    return valid;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return false;
                }
            }
            return false;
        }

        private static boolean isKeyType(String key, int type) {
            if (key == null) {
                return false;
            }
            if (key.length() < 68) {
                return false;
            }
            if (type == 0 || type == 1) {
                return key.substring(32, 36).toUpperCase().equals(MD5Hash.md5Java(String.valueOf(type)).substring(0, 4).toUpperCase());
            }
            return false;
        }
    }

    public static final class LICENSEKEY_ALGORITHM_20170203 {
        public static final byte featureSalt = 23;

        public static String createWithHardwareIdentifierAndFeatures(String hardwareuuid, Set<Feature> features) throws Exception {
            Date d = new Date(199, 12, 31);
            return LICENSEKEY_ALGORITHM_20170203.createWithHardwareIdentifierAndValidUntilDateAndFeatures(hardwareuuid, d, features);
        }

        public static String createWithValidUntilDateAndFeatures(Date validUntil, Set<Feature> features) {
            return null;
        }

        public static String createWithHardwareIdentifierAndValidUntilDateAndFeatures(String hardwareIdentifierAnyStyle, Date validUntil, Set<Feature> features) throws Exception {
            String encryptedTail;
            if (hardwareIdentifierAnyStyle == null) {
                throw new RuntimeException("illegal hardware identifier");
            }
            if (hardwareIdentifierAnyStyle.isEmpty()) {
                throw new RuntimeException("illegal hardware identifier");
            }
            String cleaned = hardwareIdentifierAnyStyle.replaceAll("[^A-Za-z0-9\\s]", "");
            if (cleaned.isEmpty()) {
                throw new RuntimeException("illegal hardware identifier");
            }
            String uppercaseMac = cleaned.toUpperCase();
            long milliseconds = validUntil.getTime();
            String hextime = ByteUtils.fromLong(milliseconds);
            byte fb = Feature.toByte(features);
            byte saltedFB = (byte)(fb + 23);
            String hexfb = ByteUtils.bytesToHex(new byte[]{saltedFB});
            String randomtail = MD5Hash.md5Java(UUID.randomUUID().toString()).toUpperCase();
            String tail = hextime + hexfb + randomtail.substring(18, 32);
            byte[] tailbytes = ByteUtils.hexToBytes(tail);
            try {
                byte[] encryptedtailbytes = EncryptDecrypt.encode(tailbytes);
                encryptedTail = ByteUtils.bytesToHex(encryptedtailbytes);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
            String body = MD5Hash.md5Java("1").substring(0, 4).toUpperCase();
            String head = MD5Hash.md5Java(uppercaseMac + encryptedTail).toUpperCase();
            return head + body + encryptedTail;
        }

        public static String createWithHardwareIdentifierAndValidUntilDate(String hardwareIdentifierAnyStyle, Date validUntil) throws Exception {
            String encryptedTail;
            if (hardwareIdentifierAnyStyle == null) {
                throw new RuntimeException("illegal hardware identifier");
            }
            if (hardwareIdentifierAnyStyle.isEmpty()) {
                throw new RuntimeException("illegal hardware identifier");
            }
            String cleaned = hardwareIdentifierAnyStyle.replaceAll("[^A-Za-z0-9\\s]", "");
            if (cleaned.isEmpty()) {
                throw new RuntimeException("illegal hardware identifier");
            }
            String uppercaseMac = cleaned.toUpperCase();
            long milliseconds = validUntil.getTime();
            String hextime = ByteUtils.fromLong(milliseconds);
            String randomtail = MD5Hash.md5Java(UUID.randomUUID().toString()).toUpperCase();
            String tail = hextime + randomtail.substring(16, 32);
            byte[] tailbytes = ByteUtils.hexToBytes(tail);
            try {
                byte[] encryptedtailbytes = EncryptDecrypt.encode(tailbytes);
                encryptedTail = ByteUtils.bytesToHex(encryptedtailbytes);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
            String body = MD5Hash.md5Java("1").substring(0, 4).toUpperCase();
            String head = MD5Hash.md5Java(uppercaseMac + encryptedTail).toUpperCase();
            return head + body + encryptedTail;
        }

        public static String createWithHardwareIdentifier(String hardwareIdentifierAnyStyle) {
            if (hardwareIdentifierAnyStyle == null) {
                throw new RuntimeException("illegal hardware identifier");
            }
            if (hardwareIdentifierAnyStyle.isEmpty()) {
                throw new RuntimeException("illegal hardware identifier");
            }
            String cleaned = hardwareIdentifierAnyStyle.replaceAll("[^A-Za-z0-9\\s]", "");
            if (cleaned.isEmpty()) {
                throw new RuntimeException("illegal hardware identifier");
            }
            String uppercaseMac = cleaned.toUpperCase();
            String randomtail = MD5Hash.md5Java(UUID.randomUUID().toString()).toUpperCase();
            String body = MD5Hash.md5Java("0").substring(0, 4).toUpperCase();
            String head = MD5Hash.md5Java(uppercaseMac + randomtail).toUpperCase();
            return head + body + randomtail;
        }

        public static boolean isValidForHardwareIdentifierAndTimeStamp(String key, String hardwareIdentifierAnyStyle, long timeMillis) throws Exception {
            if (LICENSEKEY_ALGORITHM_20170203.isKeyType(key, 0)) {
                String cleaned = hardwareIdentifierAnyStyle.replaceAll("[^A-Za-z0-9\\s]", "");
                String uppercaseMac = cleaned.toUpperCase();
                String tail = key.substring(36, 68);
                String head = MD5Hash.md5Java(uppercaseMac + tail).toUpperCase();
                boolean valid = head.equals(key.substring(0, 32));
                return valid;
            }
            if (LICENSEKEY_ALGORITHM_20170203.isKeyType(key, 1)) {
                String decryptedTail2;
                String encryptedtail;
                String cleaned = hardwareIdentifierAnyStyle.replaceAll("[^A-Za-z0-9\\s]", "");
                String uppercaseMac = cleaned.toUpperCase();
                String expectedhead = MD5Hash.md5Java(uppercaseMac + (encryptedtail = key.substring(36, key.length()))).toUpperCase();
                boolean validMac = expectedhead.equals(key.substring(0, 32));
                if (!validMac) {
                    return false;
                }
                byte[] encryptedTailBytes = ByteUtils.hexToBytes(encryptedtail);
                try {
                    byte[] decryptedTail = EncryptDecrypt.decode(encryptedTailBytes);
                    decryptedTail2 = ByteUtils.bytesToHex(decryptedTail);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    throw e1;
                }
                String timehex = decryptedTail2.substring(0, 16);
                try {
                    long milliseconds = ByteUtils.toLong(timehex);
                    boolean valid = timeMillis <= milliseconds;
                    return valid;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return false;
                }
            }
            return false;
        }

        public static long getTimeStamp(String key) throws Exception {
            if (LICENSEKEY_ALGORITHM_20170203.isKeyType(key, 0)) {
                return -1L;
            }
            if (LICENSEKEY_ALGORITHM_20170203.isKeyType(key, 1)) {
                String decryptedTail2;
                String encryptedtail = key.substring(36, key.length());
                byte[] encryptedTailBytes = ByteUtils.hexToBytes(encryptedtail);
                try {
                    byte[] decryptedTail = EncryptDecrypt.decode(encryptedTailBytes);
                    decryptedTail2 = ByteUtils.bytesToHex(decryptedTail);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    throw e1;
                }
                String timehex = decryptedTail2.substring(0, 16);
                try {
                    long milliseconds = ByteUtils.toLong(timehex);
                    return milliseconds;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return -1L;
                }
            }
            return -1L;
        }

        private static boolean isKeyType(String key, int type) {
            if (key == null) {
                return false;
            }
            if (key.length() < 68) {
                return false;
            }
            if (type == 0 || type == 1) {
                return key.substring(32, 36).toUpperCase().equals(MD5Hash.md5Java(String.valueOf(type)).substring(0, 4).toUpperCase());
            }
            return false;
        }

        public static Set<Feature> getFeatures(String key) throws Exception {
            if (LICENSEKEY_ALGORITHM_20170203.isKeyType(key, 1)) {
                String encryptedtail = key.substring(36, key.length());
                byte[] encryptedTailBytes = ByteUtils.hexToBytes(encryptedtail);
                try {
                    byte[] decryptedTail = EncryptDecrypt.decode(encryptedTailBytes);
                    String decryptedTail2 = ByteUtils.bytesToHex(decryptedTail);
                    String fbhex = decryptedTail2.substring(16, 18);
                    byte[] bb = ByteUtils.hexToBytes(fbhex);
                    byte fb = (byte)(bb[0] - 23);
                    return Feature.fromByte(fb);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    throw new Exception("Features could not be obtained from license key");
                }
            }
            throw new Exception("Features could not be obtained from license key");
        }
    }
}

