/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.licensing;

import com.hybridlab.licensing.Algorithms;
import com.hybridlab.licensing.Feature;
import java.io.File;
import java.util.Collections;
import java.util.Date;
import java.util.Set;
import org.joda.time.DateTime;

public class LicenseKey {
    public static String DevelopmentKey = "DevelopmentKey-gji\u00fc30j2g54phgiongi541pg895jngio\u00f61g";
    public static String UnlicensedKey = "Unlicensed";
    public static LicenseKey Unlicensed = new LicenseKey(UnlicensedKey);
    private String completeKeyString;
    private final LicensingKeyAlgorithm algorithm = LicensingKeyAlgorithm.LICENSEKEY_ALGORITHM_20170203;
    private boolean valid = false;
    private Set<Feature> features = null;

    @Deprecated
    public static File getStorageFolder() {
        String homeDir = System.getProperty("user.home");
        File dir = new File(homeDir + "/.hyve3D");
        return dir;
    }

    public boolean isDevelopmentKey() {
        return this.completeKeyString.toUpperCase().equals(DevelopmentKey.toUpperCase());
    }

    public LicenseKey(String completekey) {
        this.completeKeyString = completekey;
    }

    private LicenseKey() {
    }

    public static LicenseKey createFromMacAddressAndDateAndFeatures(String hardwareuuid, Date validUntil, Set<Feature> features) throws Exception {
        LicenseKey newkey = new LicenseKey();
        switch (newkey.algorithm) {
            default: {
                throw new Exception("Features not supported for key with type " + newkey.algorithm);
            }
            case LICENSEKEY_ALGORITHM_20170203: 
        }
        newkey.completeKeyString = Algorithms.LICENSEKEY_ALGORITHM_20170203.createWithHardwareIdentifierAndValidUntilDateAndFeatures(hardwareuuid, validUntil, features);
        return newkey;
    }

    public static LicenseKey createFromMacAddressAndFeatures(String hardwareuuid, Set<Feature> features) throws Exception {
        LicenseKey newkey = new LicenseKey();
        switch (newkey.algorithm) {
            default: {
                throw new Exception("Features not supported for key with type " + newkey.algorithm);
            }
            case LICENSEKEY_ALGORITHM_20170203: 
        }
        newkey.completeKeyString = Algorithms.LICENSEKEY_ALGORITHM_20170203.createWithHardwareIdentifierAndFeatures(hardwareuuid, features);
        return newkey;
    }

    public static LicenseKey createFromMacAddressAndDate(String mac, Date validUntil) throws Exception {
        LicenseKey newkey = new LicenseKey();
        switch (newkey.algorithm) {
            default: {
                newkey.completeKeyString = Algorithms.LICENSEKEY_ALGORITHM_20150210.createWithHardwareIdentifierAndValidUntilDate(mac, validUntil);
            }
            case LICENSEKEY_ALGORITHM_20170203: 
        }
        newkey.completeKeyString = Algorithms.LICENSEKEY_ALGORITHM_20170203.createWithHardwareIdentifierAndValidUntilDate(mac, validUntil);
        return newkey;
    }

    public static LicenseKey createFromMacAddress(String mac) {
        LicenseKey newkey = new LicenseKey();
        switch (newkey.algorithm) {
            default: {
                newkey.completeKeyString = Algorithms.LICENSEKEY_ALGORITHM_20150210.createWithHardwareIdentifier(mac);
            }
            case LICENSEKEY_ALGORITHM_20170203: 
        }
        newkey.completeKeyString = Algorithms.LICENSEKEY_ALGORITHM_20170203.createWithHardwareIdentifier(mac);
        return newkey;
    }

    public boolean isValidForHardwareIDAtThisMoment(String mac) throws Exception {
        if (this.completeKeyString.toUpperCase().equals(DevelopmentKey.toUpperCase())) {
            return true;
        }
        if (this.completeKeyString.equalsIgnoreCase(UnlicensedKey)) {
            return false;
        }
        switch (this.algorithm) {
            case LICENSEKEY_ALGORITHM_20150210: {
                boolean isValid = Algorithms.LICENSEKEY_ALGORITHM_20150210.isValidForHardwareIdentifierAndTimeStamp(this.completeKeyString, mac, System.currentTimeMillis());
                return isValid;
            }
            case LICENSEKEY_ALGORITHM_20170203: {
                boolean isValid = Algorithms.LICENSEKEY_ALGORITHM_20170203.isValidForHardwareIdentifierAndTimeStamp(this.completeKeyString, mac, System.currentTimeMillis());
                return isValid;
            }
        }
        return false;
    }

    public DateTime getValidUntil() {
        switch (this.algorithm) {
            case LICENSEKEY_ALGORITHM_20150210: {
                return null;
            }
            case LICENSEKEY_ALGORITHM_20170203: {
                try {
                    long validUntil = Algorithms.LICENSEKEY_ALGORITHM_20170203.getTimeStamp(this.completeKeyString);
                    DateTime d = new DateTime(validUntil);
                    return d;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
        }
        return null;
    }

    public String toLicenseKeyString() {
        return this.completeKeyString;
    }

    public String toString() {
        return String.format("LicenseKey %s", this.completeKeyString != null ? this.completeKeyString : "null");
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public boolean hasBeenMarkedValid() {
        return this.valid;
    }

    public Set<Feature> getEnabledFeatures() {
        if (this.features != null) {
            return this.features;
        }
        if (this.completeKeyString.toUpperCase().equals(DevelopmentKey.toUpperCase())) {
            return Feature.ALL;
        }
        if (this.completeKeyString.equalsIgnoreCase(UnlicensedKey)) {
            return Feature.NONE;
        }
        switch (this.algorithm) {
            case LICENSEKEY_ALGORITHM_20150210: {
                return Feature.ALL;
            }
            case LICENSEKEY_ALGORITHM_20170203: {
                try {
                    this.features = Algorithms.LICENSEKEY_ALGORITHM_20170203.getFeatures(this.completeKeyString);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.features = Collections.emptySet();
                }
                return this.features;
            }
        }
        this.features = Collections.emptySet();
        return this.features;
    }

    private static enum LicensingKeyAlgorithm {
        LICENSEKEY_ALGORITHM_20150210,
        LICENSEKEY_ALGORITHM_20170203;

    }

    public static interface LicenceValidator {
        public boolean isValidKey(String var1);
    }
}

