/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.misc.tryouts;

import com.jme3.app.SimpleApplication;
import com.jme3.input.controls.ActionListener;
import com.jme3.input.controls.InputListener;
import com.jme3.input.controls.KeyTrigger;
import com.jme3.input.controls.Trigger;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Box;
import com.jme3.system.AppSettings;
import com.jme3.texture.FrameBuffer;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.texture.Texture2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import jme3tools.converters.ImageToAwt;

public class TestRenderToTexture
extends SimpleApplication
implements ActionListener {
    private static final String TOGGLE_UPDATE = "Toggle Update";
    private static final String SAVE = "Save";
    private Geometry offBox;
    private float angle = 0.0f;
    private ViewPort offView;
    private Texture offTex;

    public static void main(String[] args) {
        TestRenderToTexture app = new TestRenderToTexture();
        AppSettings settings = new AppSettings(true);
        settings.setTitle("TestRenderToTexture");
        settings.setVSync(true);
        settings.setSamples(2);
        settings.setResizable(true);
        settings.setRenderer("LWJGL-OpenGL2");
        settings.setDepthBits(32);
        settings.setUseInput(true);
        settings.setFullscreen(false);
        settings.setUseRetinaFrameBuffer(true);
        settings.setCenterWindow(true);
        app.setShowSettings(false);
        app.setSettings(settings);
        app.start();
    }

    public Texture setupOffscreenView() {
        Camera offCamera = new Camera(512, 512);
        this.offView = this.renderManager.createPreView("Offscreen View", offCamera);
        this.offView.setClearFlags(true, true, true);
        this.offView.setBackgroundColor(ColorRGBA.DarkGray);
        FrameBuffer offBuffer = new FrameBuffer(512, 512, 1);
        offCamera.setFrustumPerspective(45.0f, 1.0f, 1.0f, 1000.0f);
        offCamera.setLocation(new Vector3f(0.0f, 0.0f, -5.0f));
        offCamera.lookAt(new Vector3f(0.0f, 0.0f, 0.0f), Vector3f.UNIT_Y);
        Texture2D offTex = new Texture2D(512, 512, Image.Format.RGBA8);
        offTex.setMinFilter(Texture.MinFilter.Trilinear);
        offTex.setMagFilter(Texture.MagFilter.Bilinear);
        offBuffer.setDepthBuffer(Image.Format.Depth);
        offBuffer.setColorTexture(offTex);
        this.offView.setOutputFrameBuffer(offBuffer);
        Box boxMesh = new Box(Vector3f.ZERO, 1.0f, 1.0f, 1.0f);
        Material material = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        material.setColor("Color", ColorRGBA.randomColor());
        this.offBox = new Geometry("box", (Mesh)boxMesh);
        this.offBox.setMaterial(material);
        this.offView.attachScene((Spatial)this.offBox);
        return offTex;
    }

    public void simpleInitApp() {
        this.cam.setLocation(new Vector3f(3.0f, 3.0f, 3.0f));
        this.cam.lookAt(Vector3f.ZERO, Vector3f.UNIT_Y);
        Geometry quad = new Geometry("box", (Mesh)new Box(Vector3f.ZERO, 1.0f, 1.0f, 1.0f));
        this.offTex = this.setupOffscreenView();
        Material mat = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        mat.setTexture("ColorMap", this.offTex);
        quad.setMaterial(mat);
        this.rootNode.attachChild((Spatial)quad);
        this.inputManager.addMapping(TOGGLE_UPDATE, new Trigger[]{new KeyTrigger(57)});
        this.inputManager.addMapping(SAVE, new Trigger[]{new KeyTrigger(31)});
        this.inputManager.addListener((InputListener)this, new String[]{TOGGLE_UPDATE, SAVE});
    }

    public void simpleUpdate(float tpf) {
        Quaternion q = new Quaternion();
        if (this.offView.isEnabled()) {
            this.angle += tpf;
            this.angle %= (float)Math.PI * 2;
            q.fromAngles(this.angle, 0.0f, this.angle);
            this.offBox.setLocalRotation(q);
            this.offBox.updateLogicalState(tpf);
            this.offBox.updateGeometricState();
        }
    }

    public void onAction(String name, boolean isPressed, float tpf) {
        if (name.equals(TOGGLE_UPDATE) && isPressed) {
            this.offView.setEnabled(!this.offView.isEnabled());
        } else if (name.equals(SAVE) && isPressed) {
            Image img = this.offTex.getImage();
            BufferedImage bi = ImageToAwt.convert((Image)img, (boolean)false, (boolean)false, (int)0);
            File outputfile = new File("/tmp/saved.png");
            try {
                ImageIO.write((RenderedImage)bi, "png", outputfile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

