/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.utils;

public class ByteUtils {
    protected static final char[] hexArray = "0123456789ABCDEF".toCharArray();

    public static byte[] hexToBytes(String hex) {
        return ByteUtils.hexToBytes(hex.toCharArray());
    }

    public static byte[] hexToBytes(char[] hex) {
        int length = hex.length / 2;
        byte[] raw = new byte[length];
        for (int i = 0; i < length; ++i) {
            int low;
            int high = Character.digit(hex[i * 2], 16);
            int value = high << 4 | (low = Character.digit(hex[i * 2 + 1], 16));
            if (value > 127) {
                value -= 256;
            }
            raw[i] = (byte)value;
        }
        return raw;
    }

    public static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    public static int unsignedToBytes(byte b) {
        return b & 0xFF;
    }

    public static long toLong(String hexadecimal) throws NumberFormatException {
        if (hexadecimal == null) {
            throw new IllegalArgumentException();
        }
        char[] chars = hexadecimal.toUpperCase().toCharArray();
        if (chars.length != 16) {
            throw new IllegalArgumentException("Incomplete hex value");
        }
        long value = 0L;
        for (int i = 0; i < 16; ++i) {
            char c = chars[i];
            if (c >= '0' && c <= '9') {
                value = value << 4 | (long)(0xFF & c - 48);
                continue;
            }
            if (c >= 'A' && c <= 'F') {
                value = value << 4 | (long)(0xFF & c - 65 + 10);
                continue;
            }
            throw new NumberFormatException("Invalid hex character: " + c);
        }
        return value;
    }

    public static String fromLong(long value) {
        char[] hexs = new char[16];
        for (int i = 0; i < 16; ++i) {
            int c = (int)(value & 0xFL);
            hexs[16 - i - 1] = hexArray[c];
            value >>= 4;
        }
        return new String(hexs);
    }
}

