/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.utils;

import com.jme3.math.FastMath;

public class Interpolation {
    public static float inttrf(float value, float sourceIntervalBorderA, float sourceIntervalBorderB, float targetIntervalBorderA, float targetIntervalBorderB) {
        if (sourceIntervalBorderB - sourceIntervalBorderA == 0.0f) {
            return targetIntervalBorderA;
        }
        return targetIntervalBorderA + (value - sourceIntervalBorderA) * (targetIntervalBorderB - targetIntervalBorderA) / (sourceIntervalBorderB - sourceIntervalBorderA);
    }

    public static float linearTransform(float a, float b, float t) {
        return (1.0f - t) * a + t * b;
    }

    public static float fastInSlowOut_Polynomial(float t, int strength) {
        t = Math.max(0.0f, Math.min(t, 1.0f));
        if (strength < 1) {
            strength = 1;
        }
        float exponent = strength * 2 - 1;
        float interpolation = FastMath.pow((float)(t - 1.0f), (float)exponent) + 1.0f;
        return interpolation;
    }

    public static float slowInFastOut_Polynomial(float t, int strength) {
        t = Math.max(0.0f, Math.min(t, 1.0f));
        if (strength < 1) {
            strength = 1;
        }
        float exponent = strength * 2;
        float interpolation = FastMath.pow((float)t, (float)exponent);
        return interpolation;
    }

    public static float slowInFastOut_smoothTrigonometrical(float t, int strength) {
        t = Math.max(0.0f, Math.min(t, 1.0f));
        if (strength < 1) {
            strength = 1;
        }
        return 0.5f - 0.5f * FastMath.cos((float)(FastMath.pow((float)t, (float)strength) * (float)Math.PI));
    }

    public static float slowInSlowOut_smoothTrigonometrical(float t) {
        return 0.5f - 0.5f * FastMath.cos((float)(t * (float)Math.PI));
    }

    public static float fastInSlowOut_smoothTrigonometrical(float t, int strength) {
        t = Math.max(0.0f, Math.min(t, 1.0f));
        if (strength < 1) {
            strength = 1;
        }
        return 0.5f + 0.5f * FastMath.cos((float)(FastMath.pow((float)(t - 1.0f), (float)strength) * (float)Math.PI));
    }
}

